/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamOfDbl;
import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Envelope1D;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.core.geometry.MathUtils;
import com.esri.core.geometry.MultiPathImpl;
import com.esri.core.geometry.MultiVertexGeometryImpl;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.Operator;
import com.esri.core.geometry.OperatorFactoryLocal;
import com.esri.core.geometry.OperatorProjectLocal;
import com.esri.core.geometry.OperatorSimplify;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.ProgressTracker;
import com.esri.core.geometry.ProjectionTransformation;
import com.esri.core.geometry.ProjectionUtils;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.SpatialReferenceImpl;
import com.esri.core.geometry.SpatialReferencePrecisionDescriptor;
import com.esri.core.geometry.Transformation2D;
import com.esri.sde.sdk.pe.engine.PeAngunit;
import com.esri.sde.sdk.pe.engine.PeCSTransformations;
import com.esri.sde.sdk.pe.engine.PeCoordsys;
import com.esri.sde.sdk.pe.engine.PeDouble;
import com.esri.sde.sdk.pe.engine.PeGeogcs;
import com.esri.sde.sdk.pe.engine.PeLineType;
import com.esri.sde.sdk.pe.engine.PeLinunit;
import com.esri.sde.sdk.pe.engine.PeParameter;
import com.esri.sde.sdk.pe.engine.PeProjcs;
import com.esri.sde.sdk.pe.engine.PeProjection;
import com.esri.sde.sdk.pe.engine.PeSpheroid;
import com.esri.sde.sdk.pe.factory.PeFactory;
import java.util.ArrayList;

@HadoopSDKExcluded
class GeodeticAreaCalculator {
    private double m_a;
    private double m_eSquared;
    private LoxodromeAreaConstants m_c;
    private SpatialReferenceImpl m_inputSR;
    private SpatialReference m_inputGCS;
    private ProjectionTransformation m_transformPcs2Gcs;
    private int m_curveType;
    private ProgressTracker m_progressTracker;
    private Transformation2D m_scaleToRadians;
    private Transformation2D m_scaleToDegrees;

    private double executePolygonGeodeticArea_(Polygon polygonIn) {
        double diff;
        double area;
        if (polygonIn.hasNonLinearSegments()) {
            throw new GeometryException("invalid argument");
        }
        OperatorSimplify simplifyOp = (OperatorSimplify)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.Simplify);
        OperatorProjectLocal projectOp = (OperatorProjectLocal)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.Project);
        Polygon polygonInCopy = (Polygon)polygonIn.copy();
        polygonInCopy.dropAllAttributes();
        if (this.m_inputSR.isPannable()) {
            Envelope2D geomEnv = new Envelope2D();
            polygonInCopy.queryEnvelope2D(geomEnv);
            Envelope2D pannableExtent = this.m_inputSR.getPannableExtent();
            if (!pannableExtent.contains(geomEnv)) {
                double xShift = pannableExtent.getCenterX() - geomEnv.getCenterX();
                Transformation2D trans = new Transformation2D();
                trans.setShift(xShift, 0.0);
                polygonInCopy.applyTransformation(trans);
                geomEnv.move(xShift, 0.0);
                Envelope1D Pe1D = new Envelope1D();
                pannableExtent.queryIntervalX(Pe1D);
                Envelope1D ge1D = new Envelope1D();
                geomEnv.queryIntervalX(ge1D);
                polygonInCopy = !Pe1D.contains(ge1D) ? (Polygon)projectOp.foldInto360RangeGeodetic(polygonInCopy, this.m_inputSR, this.m_curveType) : (Polygon)ProjectionUtils.clipGeometryFromTopAndBottom(polygonInCopy, this.m_inputSR);
            }
        }
        Polygon polygonGCS = new Polygon();
        if (this.m_transformPcs2Gcs != null) {
            if (!ProjectionUtils.projectMultiPathVerticesPCSToGCS(this.m_transformPcs2Gcs, polygonInCopy = (Polygon)simplifyOp.execute(polygonInCopy, (SpatialReference)this.m_inputSR, false, this.m_progressTracker), polygonGCS = (Polygon)polygonInCopy.createInstance(), this.m_progressTracker)) {
                polygonGCS = (Polygon)projectOp.execute(polygonInCopy, this.m_transformPcs2Gcs, this.m_progressTracker);
            }
        } else {
            polygonGCS = (Polygon)simplifyOp.execute(polygonInCopy, this.m_inputGCS, false, this.m_progressTracker);
        }
        if (polygonGCS.isEmpty()) {
            return 0.0;
        }
        if (this.m_curveType == 1) {
            return this.loxodromeArea_(polygonGCS);
        }
        MultiPathImpl mpImplGCS = (MultiPathImpl)polygonGCS._getImpl();
        double rpu = ((SpatialReferenceImpl)this.m_inputGCS).getUnit().getUnitToBaseFactor();
        PeAngunit peAngunit = PeFactory.angunit((int)9101);
        PeGeogcs peGeogcs = (PeGeogcs)((SpatialReferenceImpl)this.m_inputGCS).getPECoordSys();
        PeCoordsys[] peGeogcsCloned = new PeCoordsys[]{peGeogcs.cloneAlterUnits(peAngunit)};
        SpatialReferenceImpl gcs = SpatialReferenceImpl.createImpl(peGeogcsCloned[0], null, SpatialReferencePrecisionDescriptor.Precision.Integer64);
        this.m_scaleToRadians.setScale(rpu);
        mpImplGCS.applyTransformation(this.m_scaleToRadians);
        this.m_scaleToDegrees = this.m_scaleToRadians;
        this.m_scaleToDegrees.inverse();
        PeGeogcs pegeogcs = (PeGeogcs)gcs.getPECoordSys();
        PeSpheroid spheroid = pegeogcs.getDatum().getSpheroid();
        double flattening = spheroid.getFlattening();
        this.m_a = spheroid.getAxis();
        this.m_eSquared = flattening * (2.0 - flattening);
        Envelope2D envelope = new Envelope2D();
        polygonGCS.queryEnvelope2D(envelope);
        double area2 = this.executeClippedPolygonGeodeticArea_(polygonGCS, gcs, 0);
        int cExtraSplits = 0;
        do {
            area = this.executeClippedPolygonGeodeticArea_(polygonGCS, gcs, ++cExtraSplits);
            diff = Math.abs(area - area2);
            area2 = area;
        } while (Math.abs(area) > 1.0 && diff > 1.0E-8 * Math.abs(area) && cExtraSplits < 7);
        return area;
    }

    private double executeClippedPolygonGeodeticArea_(Polygon polygonGCS, SpatialReference gcs, int cExtraSplits) {
        Envelope2D envelope = new Envelope2D();
        polygonGCS.queryEnvelope2D(envelope);
        SpatialReference equalAreaPCS = this.getEqualAreaPcsInstance_(gcs, envelope);
        Polygon polygonPCS = (Polygon)polygonGCS.copy();
        double[][] bufferOfPoints = new double[Math.min(100, polygonPCS.getPointCount())][2];
        ProjectionUtils.PEgeogToProj((SpatialReferenceImpl)equalAreaPCS, polygonPCS, bufferOfPoints);
        double minSegmentLengthMeters = 50.0;
        MultiVertexGeometryImpl vertexGeometryImplPCS = (MultiVertexGeometryImpl)polygonPCS._getImpl();
        AttributeStreamOfDbl xyStreamPCS = (AttributeStreamOfDbl)vertexGeometryImplPCS.getAttributeStreamRef(0);
        MultiVertexGeometryImpl vertexGeometryImplGCS = (MultiVertexGeometryImpl)polygonGCS._getImpl();
        AttributeStreamOfDbl xyStreamGCS = (AttributeStreamOfDbl)vertexGeometryImplGCS.getAttributeStreamRef(0);
        PeDouble param1 = new PeDouble();
        PeDouble param2 = new PeDouble();
        int progressCounter = 0;
        int maxTopStack = 40;
        double[][] points = bufferOfPoints;
        int[] stackExtraSplits = new int[maxTopStack];
        ArrayList<StackStruct> stackStructArray = new ArrayList<StackStruct>();
        for (int i = 0; i < maxTopStack; ++i) {
            stackStructArray.add(new StackStruct());
        }
        StackStruct stack1 = new StackStruct();
        StackStruct stack2 = new StackStruct();
        SpatialReferenceImpl equalAreaPcsImpl = (SpatialReferenceImpl)equalAreaPCS;
        PeProjcs peProjcs = (PeProjcs)equalAreaPcsImpl.getPECoordSys();
        double totalArea = polygonPCS.calculateArea2D();
        double addedArea = 0.0;
        double pi2 = 1.5707963267948966;
        assert (totalArea >= 0.0);
        double criticalArea = Math.abs(totalArea) * 1.0E-10 + 1.0E-6;
        int cParts = polygonGCS.getPathCount();
        Point2D pGcs1 = new Point2D();
        Point2D pGcs2 = new Point2D();
        Point2D pPcs1 = new Point2D();
        Point2D pPcs2 = new Point2D();
        Point2D pGCS = new Point2D();
        Point2D pPCS = new Point2D();
        int i1 = polygonGCS.getPathStart(0);
        for (int iPart = 0; iPart < cParts; ++iPart) {
            int i2 = polygonGCS.getPathEnd(iPart);
            assert (i2 == polygonPCS.getPathEnd(iPart));
            xyStreamPCS.read(i2 - 1 << 1, pPcs1);
            xyStreamGCS.read(i2 - 1 << 1, pGcs1);
            if (Math.abs(pGcs1.y) > pi2) {
                pGcs1.y = MathUtils.copySign(pi2, pGcs1.y);
            }
            for (int i = i1; i < i2; ++i) {
                double segLengthPCS;
                xyStreamPCS.read(i << 1, pPcs2);
                xyStreamGCS.read(i << 1, pGcs2);
                if (Math.abs(pGcs2.y) > pi2) {
                    pGcs2.y = MathUtils.copySign(pi2, pGcs2.y);
                }
                if (!((segLengthPCS = Point2D.distance(pPcs1, pPcs2)) < minSegmentLengthMeters || pGcs1.y == 0.0 && pGcs2.y == 0.0)) {
                    PeLineType.geodetic_distance((double)this.m_a, (double)this.m_eSquared, (double)pGcs1.x, (double)pGcs1.y, (double)pGcs2.x, (double)pGcs2.y, (PeDouble)param1, (PeDouble)param2, null, (int)this.m_curveType);
                    double segLengthGCS = param1.val;
                    double az12 = param2.val;
                    stack1.setValues(0.0, pPcs1);
                    stack2.setValues(1.0, pPcs2);
                    int extraSplits = cExtraSplits;
                    ((StackStruct)stackStructArray.get(0)).set(stack2);
                    stackExtraSplits[0] = cExtraSplits;
                    int stackTop = 0;
                    while (stackTop >= 0) {
                        if (progressCounter % 1000 == 0 && this.m_progressTracker != null && !this.m_progressTracker.progress(-1, -1)) {
                            throw new RuntimeException("user_canceled");
                        }
                        ++progressCounter;
                        double factor = (stack1.m_factor + stack2.m_factor) * 0.5;
                        PeLineType.geodetic_coordinate((double)this.m_a, (double)this.m_eSquared, (double)pGcs1.x, (double)pGcs1.y, (double)(segLengthGCS * factor), (double)az12, (PeDouble)param1, (PeDouble)param2, (int)this.m_curveType);
                        pGCS.x = param1.val;
                        pGCS.y = param2.val;
                        points[0][0] = pGCS.x;
                        points[0][1] = pGCS.y;
                        int cPointsOut = PeCSTransformations.geogToProj((PeProjcs)peProjcs, (int)1, (double[][])points);
                        assert (cPointsOut == 1);
                        pPCS.x = points[0][0];
                        pPCS.y = points[0][1];
                        double offset = -pPCS.offset(stack1.m_pPCS, stack2.m_pPCS);
                        double distance = Point2D.distance(stack1.m_pPCS, stack2.m_pPCS);
                        double area = 0.5 * offset * distance;
                        assert (!NumberUtils.isNaN(area));
                        addedArea += area;
                        if (Math.abs(area) > criticalArea || Math.abs(area) > 0.0 && extraSplits > 0) {
                            stack2.setValues(factor, pPCS);
                            ((StackStruct)stackStructArray.get(++stackTop)).set(stack2);
                            assert (stackTop < maxTopStack);
                            if (Math.abs(area) <= criticalArea) {
                                stackExtraSplits[stackTop - 1] = --extraSplits;
                                stackExtraSplits[stackTop] = extraSplits;
                                continue;
                            }
                            stackExtraSplits[stackTop] = extraSplits = stackExtraSplits[stackTop - 1];
                            continue;
                        }
                        if (stackTop == 0) break;
                        stack1.set(stack2);
                        stack2.set((StackStruct)stackStructArray.get(--stackTop));
                        extraSplits = stackExtraSplits[stackTop];
                    }
                }
                pPcs1.setCoords(pPcs2);
                pGcs1.setCoords(pGcs2);
            }
            i1 = i2;
        }
        return Math.abs(totalArea += addedArea);
    }

    private SpatialReference getEqualAreaPcsInstance_(SpatialReference gcs, Envelope2D envelope) {
        PeParameter[] PeParamArr = new PeParameter[16];
        for (int i = 0; i < 16; ++i) {
            PeParamArr[i] = null;
        }
        PeParamArr[2] = PeParameter.fromArgs((String)"CentralMeridian", (double)envelope.getCenterX());
        PeParamArr[6] = PeParameter.fromArgs((String)"LatitudeOfOrigin", (double)envelope.getCenterY());
        PeParamArr[0] = PeParameter.fromArgs((String)"FalseEasting", (double)0.0);
        PeParamArr[1] = PeParameter.fromArgs((String)"FalseNorthing", (double)0.0);
        double envHeight = envelope.getHeight();
        PeProjection[] PeProjPtr = new PeProjection[1];
        if (envelope.ymin > 0.7853981633974483 || envelope.ymax < -0.7853981633974483) {
            PeParamArr[6] = PeParameter.fromArgs((String)"LatitudeOfOrigin", (double)MathUtils.copySign(1.5707963267948966, envelope.getCenterY()));
            PeProjPtr[0] = PeFactory.projection((int)43033);
        } else {
            PeParamArr[3] = PeParameter.fromArgs((String)"StandardParallel1", (double)(envelope.ymin + envHeight * 0.6666666666666666));
            PeProjPtr[0] = PeFactory.projection((int)43034);
        }
        PeLinunit[] PeLinunitPtr = new PeLinunit[]{PeFactory.linunit((int)9001)};
        PeGeogcs[] PeGeogcsPtr = new PeGeogcs[]{(PeGeogcs)((SpatialReferenceImpl)gcs).getPECoordSys().clone()};
        PeCoordsys[] peCoordSys = new PeCoordsys[]{PeProjcs.fromArgs((String)"EqualAreaPCS", (PeGeogcs)PeGeogcsPtr[0], (PeProjection)PeProjPtr[0], (PeParameter[])PeParamArr, (PeLinunit)PeLinunitPtr[0])};
        SpatialReferenceImpl equalAreaPCS = SpatialReferenceImpl.createImpl(peCoordSys[0], null, SpatialReferencePrecisionDescriptor.Precision.Integer64);
        return equalAreaPCS;
    }

    private double loxodromeArea_(double lam1, LoxodromeAreaVariables pt1, double lam2, LoxodromeAreaVariables pt2) {
        double term1;
        double slopeDividedByOnemE2;
        double term4;
        boolean bFirstPtSwitched = false;
        boolean bSecondPtSwitched = false;
        if (pt1.makeNegative) {
            pt1.changeSign();
            bFirstPtSwitched = true;
        }
        if (pt2.makeNegative) {
            pt2.changeSign();
            bSecondPtSwitched = true;
        }
        double dlam = lam2 - lam1;
        if (Math.abs(pt1.sinPhi) == 1.0 || Math.abs(pt2.sinPhi) == 1.0) {
            if (bFirstPtSwitched) {
                pt1.changeSign();
            }
            if (bSecondPtSwitched) {
                pt2.changeSign();
            }
            return this.m_c.halfQp * dlam;
        }
        if (pt1.sinPhi == pt2.sinPhi) {
            double rtnval = this.m_c.oneme2 * 0.5 * pt1.sinPhi * (1.0 / pt1.oneme2Sin2Phi + MathUtils.atanhUOverU(this.m_c.e * pt1.sinPhi)) * dlam;
            if (bFirstPtSwitched) {
                pt1.changeSign();
            }
            if (bSecondPtSwitched) {
                pt2.changeSign();
            }
            return rtnval;
        }
        double atanhSinPhi2mAtanhSinPhi1 = Math.log(pt2.sinHalfPhiPf * pt1.sinHalfPhiPz / (pt2.sinHalfPhiPz * pt1.sinHalfPhiPf));
        double atanhEsinPhi2mAtanhEsinPhi1 = Math.log(pt2.sinHalfAsinESinPhiPf * pt1.sinHalfAsineSinPhiPz / (pt2.sinHalfAsineSinPhiPz * pt1.sinHalfAsinESinPhiPf));
        if (this.m_eSquared == 1.0) {
            term4 = 0.0;
            slopeDividedByOnemE2 = 0.5 * (atanhSinPhi2mAtanhSinPhi1 + pt2.sinPhi / pt2.oneme2Sin2Phi - pt1.sinPhi / pt1.oneme2Sin2Phi);
            term1 = 0.0;
        } else {
            term4 = -2.0 * this.m_c.atanhEOverE * (Math.log(pt2.onepSinPhi / pt1.onepSinPhi) - this.m_c.e * atanhEsinPhi2mAtanhEsinPhi1);
            slopeDividedByOnemE2 = (atanhSinPhi2mAtanhSinPhi1 - this.m_c.e * atanhEsinPhi2mAtanhEsinPhi1) / this.m_c.oneme2;
            term1 = (Math.log(pt2.oneme2Sin2Phi / pt1.oneme2Sin2Phi) + term4 / this.m_c.atanhEOverE) / this.m_c.oneme2;
        }
        double term2 = -atanhEsinPhi2mAtanhEsinPhi1 * (pt1.atanhEsinPhi + pt2.atanhEsinPhi);
        double term3 = 1.0 / pt1.oneme2Sin2Phi - 1.0 / pt2.oneme2Sin2Phi;
        double term5 = MathUtils.dilogarithmEzOverE(pt2.onemSinPhi / this.m_c.onepE, this.m_c.e) - MathUtils.dilogarithmEzOverE(pt1.onemSinPhi / this.m_c.onepE, this.m_c.e);
        double term6 = MathUtils.dilogarithmEzOverE(pt2.onepSinPhi / this.m_c.onepE, this.m_c.e) - MathUtils.dilogarithmEzOverE(pt1.onepSinPhi / this.m_c.onepE, this.m_c.e);
        double term7 = MathUtils.dilogarithmEzOverE(pt1.onemSinPhi / -this.m_c.onemE, this.m_c.e) - MathUtils.dilogarithmEzOverE(pt2.onemSinPhi / -this.m_c.onemE, this.m_c.e);
        double term8 = MathUtils.dilogarithmEzOverE(pt1.onepSinPhi / -this.m_c.onemE, this.m_c.e) - MathUtils.dilogarithmEzOverE(pt2.onepSinPhi / -this.m_c.onemE, this.m_c.e);
        double rtnval = 0.25 / slopeDividedByOnemE2 * (term1 + term2 + term3 + term4 + 0.5 * (term5 + term6 + term7 + term8));
        rtnval += this.m_c.halfQp;
        double lowerLim = this.m_c.oneme2 * 0.5 * pt1.sinPhi * (1.0 / pt1.oneme2Sin2Phi + MathUtils.atanhUOverU(this.m_c.e * pt1.sinPhi));
        double upperLim = this.m_c.oneme2 * 0.5 * pt2.sinPhi * (1.0 / pt2.oneme2Sin2Phi + MathUtils.atanhUOverU(this.m_c.e * pt2.sinPhi));
        if (upperLim < lowerLim) {
            double temp = lowerLim;
            lowerLim = upperLim;
            upperLim = temp;
        }
        if (rtnval < lowerLim) {
            rtnval = lowerLim;
        }
        if (rtnval > upperLim) {
            rtnval = upperLim;
        }
        rtnval *= dlam;
        if (bFirstPtSwitched) {
            pt1.changeSign();
        }
        if (bSecondPtSwitched) {
            pt2.changeSign();
        }
        return rtnval;
    }

    private double loxodromeArea_(Polygon polygonGCS) {
        this.m_c = new LoxodromeAreaConstants();
        double area = 0.0;
        LoxodromeAreaVariables pt1 = new LoxodromeAreaVariables();
        LoxodromeAreaVariables pt2 = new LoxodromeAreaVariables();
        int cParts = polygonGCS.getPathCount();
        Point2D pGcs1 = new Point2D();
        Point2D pGcs2 = new Point2D();
        MultiVertexGeometryImpl vertexGeometryImplGCS = (MultiVertexGeometryImpl)polygonGCS._getImpl();
        AttributeStreamOfDbl xyStreamGCS = (AttributeStreamOfDbl)vertexGeometryImplGCS.getAttributeStreamRef(0);
        int i1 = polygonGCS.getPathStart(0);
        for (int iPart = 0; iPart < cParts; ++iPart) {
            int i2 = polygonGCS.getPathEnd(iPart);
            xyStreamGCS.read(i2 - 1 << 1, pGcs1);
            for (int i = i1; i < i2; ++i) {
                xyStreamGCS.read(i << 1, pGcs2);
                double phi1Rad = pGcs1.y * this.m_c.radFactor;
                double phi2Rad = pGcs2.y * this.m_c.radFactor;
                if (i == i1) {
                    pt1.set(phi1Rad, this.m_c.e, false);
                } else {
                    pt1.set(pt2);
                }
                pt2.set(phi2Rad, this.m_c.e, false);
                if (pGcs1.y * pGcs2.y < 0.0) {
                    LoxodromeAreaVariables ptEquator = new LoxodromeAreaVariables();
                    ptEquator.makeNegative = false;
                    double f1 = pt1.atanhSinPhi - this.m_c.e * pt1.atanhEsinPhi;
                    double f2 = pt2.atanhSinPhi - this.m_c.e * pt2.atanhEsinPhi;
                    double lamAtEquatorDeg = (f2 * pGcs1.x - f1 * pGcs2.x) / (f2 - f1);
                    if (phi1Rad < 0.0) {
                        pt1.makeNegative = true;
                        area -= this.loxodromeArea_(pGcs1.x * this.m_c.radFactor, pt1, lamAtEquatorDeg * this.m_c.radFactor, ptEquator);
                        pt1.makeNegative = false;
                        area += this.loxodromeArea_(lamAtEquatorDeg * this.m_c.radFactor, ptEquator, pGcs2.x * this.m_c.radFactor, pt2);
                    } else {
                        area += this.loxodromeArea_(pGcs1.x * this.m_c.radFactor, pt1, lamAtEquatorDeg * this.m_c.radFactor, ptEquator);
                        pt2.makeNegative = true;
                        area -= this.loxodromeArea_(lamAtEquatorDeg * this.m_c.radFactor, ptEquator, pGcs2.x * this.m_c.radFactor, pt2);
                        pt2.makeNegative = false;
                    }
                } else if (pGcs1.y >= 0.0) {
                    area += this.loxodromeArea_(pGcs1.x * this.m_c.radFactor, pt1, pGcs2.x * this.m_c.radFactor, pt2);
                } else {
                    pt1.makeNegative = true;
                    pt2.makeNegative = true;
                    area -= this.loxodromeArea_(pGcs1.x * this.m_c.radFactor, pt1, pGcs2.x * this.m_c.radFactor, pt2);
                    pt1.makeNegative = false;
                    pt1.makeNegative = false;
                }
                pGcs1.setCoords(pGcs2);
            }
            i1 = i2;
        }
        return this.m_a * area * this.m_a;
    }

    GeodeticAreaCalculator(SpatialReference sr, int curveType, ProgressTracker progressTracker) {
        this.m_curveType = curveType;
        this.m_progressTracker = progressTracker;
        this.m_inputSR = (SpatialReferenceImpl)sr;
        this.m_inputGCS = sr.getGCS();
        PeGeogcs peGeogcs_ = (PeGeogcs)((SpatialReferenceImpl)this.m_inputGCS).getPECoordSys();
        PeSpheroid spheroid = peGeogcs_.getDatum().getSpheroid();
        double flattening = spheroid.getFlattening();
        this.m_a = spheroid.getAxis();
        this.m_eSquared = flattening * (2.0 - flattening);
        this.m_scaleToRadians = new Transformation2D();
        this.m_scaleToDegrees = new Transformation2D();
    }

    double calculate(Geometry geometry) {
        if (geometry.isEmpty() || geometry.getDimension() < 2) {
            return 0.0;
        }
        if (geometry.getType().equals((Object)Geometry.Type.Envelope)) {
            Polygon polygon = new Polygon();
            polygon.addEnvelope((Envelope)geometry, false);
            return this.calculate(polygon);
        }
        if (!this.m_inputSR.equals(this.m_inputGCS) && this.m_transformPcs2Gcs == null) {
            this.m_transformPcs2Gcs = ProjectionTransformation.createEx(this.m_inputSR, this.m_inputGCS, null);
        }
        assert (geometry.getType().equals((Object)Geometry.Type.Polygon));
        return this.executePolygonGeodeticArea_((Polygon)geometry);
    }

    private class LoxodromeAreaVariables {
        double sinPhi = 0.0;
        double onepSinPhi = 1.0;
        double onemSinPhi = 1.0;
        double oneme2Sin2Phi = 1.0;
        double sinHalfPhiPf = 0.7071067811865476;
        double sinHalfPhiPz = 0.7071067811865476;
        double sinHalfAsinESinPhiPf = this.sinHalfPhiPf;
        double sinHalfAsineSinPhiPz = this.sinHalfPhiPz;
        double atanhSinPhi = 0.0;
        double atanhEsinPhi = 0.0;
        boolean makeNegative = true;

        LoxodromeAreaVariables() {
        }

        void set(double phi, double e, boolean makeNegative_) {
            double halfPhi = 0.5 * phi;
            this.sinPhi = Math.sin(phi);
            double esinPhi = e * this.sinPhi;
            double halfAsineSinPhi = 0.5 * Math.asin(esinPhi);
            this.onepSinPhi = 1.0 + this.sinPhi;
            this.onemSinPhi = 1.0 - this.sinPhi;
            this.oneme2Sin2Phi = (1.0 + esinPhi) * (1.0 - esinPhi);
            this.sinHalfPhiPf = Math.sin(halfPhi + 0.7853981633974483);
            this.sinHalfPhiPz = Math.sin(halfPhi + 2.356194490192345);
            this.sinHalfAsinESinPhiPf = Math.sin(halfAsineSinPhi + 0.7853981633974483);
            this.sinHalfAsineSinPhiPz = Math.sin(halfAsineSinPhi + 2.356194490192345);
            this.atanhSinPhi = Math.log(this.sinHalfPhiPf / this.sinHalfPhiPz);
            this.atanhEsinPhi = Math.log(this.sinHalfAsinESinPhiPf / this.sinHalfAsineSinPhiPz);
            this.makeNegative = makeNegative_;
        }

        void set(LoxodromeAreaVariables other) {
            this.sinPhi = other.sinPhi;
            this.onepSinPhi = other.onepSinPhi;
            this.onemSinPhi = other.onemSinPhi;
            this.oneme2Sin2Phi = other.oneme2Sin2Phi;
            this.sinHalfPhiPf = other.sinHalfPhiPf;
            this.sinHalfPhiPz = other.sinHalfPhiPz;
            this.sinHalfAsinESinPhiPf = other.sinHalfAsinESinPhiPf;
            this.sinHalfAsineSinPhiPz = other.sinHalfAsineSinPhiPz;
            this.atanhSinPhi = other.atanhSinPhi;
            this.atanhEsinPhi = other.atanhEsinPhi;
            this.makeNegative = other.makeNegative;
        }

        void changeSign() {
            this.sinPhi = -this.sinPhi;
            double temp = this.onepSinPhi;
            this.onepSinPhi = this.onemSinPhi;
            this.onemSinPhi = temp;
            temp = this.sinHalfPhiPf;
            this.sinHalfPhiPf = this.sinHalfPhiPz;
            this.sinHalfPhiPz = temp;
            temp = this.sinHalfAsinESinPhiPf;
            this.sinHalfAsinESinPhiPf = this.sinHalfAsineSinPhiPz;
            this.sinHalfAsineSinPhiPz = temp;
            this.atanhSinPhi = -this.atanhSinPhi;
            this.atanhEsinPhi = -this.atanhEsinPhi;
        }
    }

    private class LoxodromeAreaConstants {
        double radFactor = Math.PI / 180;
        double e;
        double onepE;
        double onemE;
        double oneme2;
        double atanhEOverE;
        double halfQp;

        LoxodromeAreaConstants() {
            this.e = Math.sqrt(GeodeticAreaCalculator.this.m_eSquared);
            this.onepE = 1.0 + this.e;
            this.onemE = 1.0 - this.e;
            this.oneme2 = 1.0 - GeodeticAreaCalculator.this.m_eSquared;
            this.atanhEOverE = MathUtils.atanhUOverU(this.e);
            this.halfQp = GeodeticAreaCalculator.this.m_eSquared >= 1.0 ? 1.0 : 0.5 * (1.0 + this.atanhEOverE * this.oneme2);
        }
    }

    private class StackStruct {
        Point2D m_pPCS = new Point2D();
        double m_factor;

        StackStruct() {
        }

        void setValues(double factor, Point2D pPCS) {
            this.m_factor = factor;
            this.m_pPCS.setCoords(pPCS);
        }

        void set(StackStruct other) {
            this.m_factor = other.m_factor;
            this.m_pPCS.setCoords(other.m_pPCS);
        }
    }
}

