/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamOfInt32;
import com.esri.core.geometry.Clipper;
import com.esri.core.geometry.EditShape;
import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.GeodeticDensify;
import com.esri.core.geometry.Geohash;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryCursor;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.Gnomonic;
import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.core.geometry.InternalUtils;
import com.esri.core.geometry.ListeningGeometryCursor;
import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.MultiPathImpl;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.MultiVertexGeometry;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.OperatorDifference;
import com.esri.core.geometry.OperatorProject;
import com.esri.core.geometry.OperatorSimplify;
import com.esri.core.geometry.OperatorUnion;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.ProgressTracker;
import com.esri.core.geometry.ProjectionTransformation;
import com.esri.core.geometry.ProjectionUtils;
import com.esri.core.geometry.Segment;
import com.esri.core.geometry.SegmentIteratorImpl;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.SpatialReferenceImpl;
import com.esri.core.geometry.TopologicalOperations;
import com.esri.core.geometry.Transformation2D;
import com.esri.core.geometry.Unit;
import com.esri.sde.sdk.pe.engine.PeDouble;
import com.esri.sde.sdk.pe.engine.PeGeogcs;
import com.esri.sde.sdk.pe.engine.PeLineType;
import com.esri.sde.sdk.pe.engine.PeMacros;
import com.esri.sde.sdk.pe.engine.PeMath;
import com.esri.sde.sdk.pe.engine.PeSpheroid;
import java.util.ArrayList;

@HadoopSDKExcluded
final class GeodesicBufferer {
    private SpatialReference m_sr;
    private SpatialReference m_gcs;
    private ProjectionTransformation m_transform;
    private ProgressTracker m_progress_tracker;
    private double m_a;
    private double m_e_squared;
    private double m_rpu;
    private double m_tolerance;
    private double m_gcs_tolerance;
    private double m_rad_tolerance;
    private double m_q_90;
    private double m_gcs_90;
    private double m_gcs_180;
    private double m_gcs_360;
    private double m_gcs_60;
    private double m_elliptic_to_geodesic_max_ratio;
    private int m_curve_type;
    private boolean m_b_shape_preserving;
    private double m_distance;
    private double m_abs_distance;
    private double m_convergence_offset;
    private double m_corner_step;
    private double m_segment_step;
    private SpatialReference m_local_meters_sr;

    GeodesicBufferer() {
    }

    static void geodesic_coordinate_(double a, double e_squared, double geodetic_point_x, double geodetic_point_y, double distance, double az_perp, PeDouble pe_buffered_point_0, PeDouble pe_buffered_point_1) {
        PeLineType.geodesic_coordinate((double)a, (double)e_squared, (double)geodetic_point_x, (double)geodetic_point_y, (double)distance, (double)az_perp, (PeDouble)pe_buffered_point_0, (PeDouble)pe_buffered_point_1);
        if (pe_buffered_point_0.val < -Math.PI) {
            pe_buffered_point_0.val += Math.PI * 2;
        } else if (pe_buffered_point_0.val >= Math.PI) {
            pe_buffered_point_0.val -= Math.PI * 2;
        }
    }

    static Polygon buffer(Geometry geometry, SpatialReference sr, int curve_type, double distance, double convergence_offset, ProgressTracker progress_tracker) {
        if (!(distance < Double.MAX_VALUE) || !(distance > -1.7976931348623157E308)) {
            throw new IllegalArgumentException("geodesic buffer - bad distance");
        }
        Geometry.Type type = geometry.getType();
        if (Geometry.isMultiVertex(type.value())) {
            int point_count = ((MultiVertexGeometry)geometry).getPointCount();
            double max_d = 8000000.0;
            if (Math.abs(distance) > max_d && (point_count > 50 || type != Geometry.Type.MultiPoint && curve_type == 4 && point_count > 2)) {
                Geometry buffer = geometry;
                double sign = distance > 0.0 ? 1.0 : -1.0;
                double increment_d = 7000000.0;
                double d = distance;
                int levels = 1;
                do {
                    ++levels;
                } while (Math.abs(d = (Math.abs(d) - increment_d) * sign) > max_d);
                d = distance;
                for (int i = 0; i < levels - 1; ++i) {
                    buffer = GeodesicBufferer.buffer_(buffer, sr, curve_type, increment_d * sign, convergence_offset, levels, progress_tracker);
                    d = (Math.abs(d) - increment_d) * sign;
                }
                buffer = GeodesicBufferer.buffer_(buffer, sr, curve_type, d, convergence_offset, levels, progress_tracker);
                return (Polygon)buffer;
            }
        }
        return GeodesicBufferer.buffer_(geometry, sr, curve_type, distance, convergence_offset, 1, progress_tracker);
    }

    private static Polygon buffer_(Geometry geometry, SpatialReference sr, int curve_type, double distance, double convergence_offset, int levels, ProgressTracker progress_tracker) {
        Polygon gcs_buffer;
        Geometry g;
        if (geometry == null) {
            throw new IllegalArgumentException("");
        }
        if (geometry.isEmpty()) {
            return new Polygon(geometry.getDescription());
        }
        GeodesicBufferer bufferer = new GeodesicBufferer();
        bufferer.m_sr = sr;
        bufferer.m_gcs = sr.getGCS();
        bufferer.m_transform = ProjectionTransformation.createEx(sr, bufferer.m_gcs, null);
        PeGeogcs PE_geogcs = (PeGeogcs)((SpatialReferenceImpl)bufferer.m_gcs).getPECoordSys();
        PeSpheroid spheroid = PE_geogcs.getDatum().getSpheroid();
        double flattening = spheroid.getFlattening();
        bufferer.m_progress_tracker = progress_tracker;
        bufferer.m_a = spheroid.getAxis();
        bufferer.m_e_squared = flattening * (2.0 - flattening);
        bufferer.m_rpu = bufferer.m_gcs.getUnit().getUnitToBaseFactor();
        bufferer.m_tolerance = bufferer.m_sr.getTolerance(0);
        bufferer.m_gcs_tolerance = bufferer.m_gcs.getTolerance(0);
        bufferer.m_rad_tolerance = bufferer.m_gcs_tolerance * bufferer.m_rpu;
        bufferer.m_gcs_90 = 1.5707963267948966 / bufferer.m_rpu;
        bufferer.m_gcs_180 = Math.PI / bufferer.m_rpu;
        bufferer.m_gcs_360 = Math.PI * 2 / bufferer.m_rpu;
        bufferer.m_gcs_60 = bufferer.m_gcs_360 / 6.0;
        bufferer.m_q_90 = PeMath.q90((double)bufferer.m_a, (double)bufferer.m_e_squared);
        bufferer.m_elliptic_to_geodesic_max_ratio = 0.5 * bufferer.m_a * Math.PI / bufferer.m_q_90;
        if (curve_type == 4) {
            bufferer.m_curve_type = 2;
            bufferer.m_b_shape_preserving = true;
        } else {
            bufferer.m_curve_type = curve_type;
            bufferer.m_b_shape_preserving = false;
        }
        bufferer.m_distance = distance;
        bufferer.m_abs_distance = Math.abs(distance);
        if (NumberUtils.isNaN(convergence_offset) || convergence_offset < 0.001) {
            bufferer.set_convergence_offset_();
        } else {
            bufferer.m_convergence_offset = convergence_offset;
        }
        bufferer.m_convergence_offset /= (double)levels;
        Geometry.Type geometry_type = geometry.getType();
        if (Geometry.isSegment(geometry_type.value())) {
            Polyline polyline = new Polyline(geometry.getDescription());
            polyline.addSegment((Segment)geometry, true);
            g = polyline;
            geometry_type = Geometry.Type.Polyline;
        } else if (geometry_type == Geometry.Type.Envelope) {
            boolean b_is_degenerate_envelope;
            Envelope envelope = (Envelope)geometry;
            Envelope2D env = new Envelope2D();
            envelope.queryEnvelope2D(env);
            boolean bl = b_is_degenerate_envelope = env.getWidth() <= bufferer.m_tolerance || env.getHeight() <= bufferer.m_tolerance;
            if (!b_is_degenerate_envelope) {
                Polygon polygon = new Polygon(geometry.getDescription());
                polygon.addEnvelope(envelope, false);
                g = polygon;
                geometry_type = Geometry.Type.Polygon;
            } else {
                Polyline polyline = new Polyline(geometry.getDescription());
                polyline.addEnvelope(envelope, false);
                g = polyline;
                geometry_type = Geometry.Type.Polyline;
            }
        } else {
            g = geometry;
        }
        bufferer.set_min_corner_step_();
        if (!Geometry.isPoint(geometry_type.value())) {
            bufferer.set_min_segment_step_();
        }
        if (bufferer.m_abs_distance <= 0.5 * bufferer.m_convergence_offset) {
            if (geometry_type != Geometry.Type.Polygon) {
                return new Polygon(g.getDescription());
            }
            if (!bufferer.m_b_shape_preserving) {
                return (Polygon)GeodeticDensify.densify(g, bufferer.m_sr, bufferer.m_curve_type, bufferer.m_segment_step, -1.0, progress_tracker);
            }
            return (Polygon)g;
        }
        if (bufferer.m_distance < 0.0 && geometry_type != Geometry.Type.Polygon) {
            return new Polygon(g.getDescription());
        }
        if (!bufferer.m_b_shape_preserving || !Geometry.isMultiPath(geometry_type.value())) {
            g = OperatorProject.local().execute(g, bufferer.m_transform, progress_tracker);
        } else {
            Geometry shape_preserved = GeodeticDensify.densify(g, sr, 4, NumberUtils.NaN(), bufferer.m_convergence_offset, progress_tracker);
            g = OperatorProject.local().execute(shape_preserved, bufferer.m_transform, progress_tracker);
        }
        g = ProjectionUtils.clipGeometryFromTopAndBottom(g, bufferer.m_gcs);
        if (g.isEmpty()) {
            return new Polygon(g.getDescription());
        }
        if (!bufferer.m_b_shape_preserving && Geometry.isMultiPath(geometry_type.value())) {
            g = GeodeticDensify.normalizeMultiPathGCS(bufferer.m_rpu, (MultiPath)g);
        }
        g = GeodesicBufferer.sort_parts_by_geohash_(g, bufferer.m_gcs);
        switch (geometry_type.value()) {
            case 1736: {
                gcs_buffer = bufferer.buffer_polygon_((Polygon)g);
                break;
            }
            case 1607: {
                gcs_buffer = bufferer.buffer_polyline_((Polyline)g);
                break;
            }
            case 550: {
                gcs_buffer = bufferer.buffer_multi_point_((MultiPoint)g);
                break;
            }
            case 33: {
                gcs_buffer = bufferer.buffer_point_((Point)g);
                break;
            }
            default: {
                throw new GeometryException("corrupted_geometry");
            }
        }
        Polygon buffer = (Polygon)OperatorProject.local().execute(gcs_buffer, bufferer.m_transform.getInverse(), bufferer.m_progress_tracker);
        buffer.mergeVertexDescription(g.getDescription());
        return buffer;
    }

    private Polygon buffer_polygon_(Polygon polygon) {
        Polygon densified = new Polygon();
        Geometry_cursor_for_multi_path cursor = new Geometry_cursor_for_multi_path(this, polygon, densified);
        Polygon buffer = this.process_gnomonic_buffer_pieces_cursor(true, cursor);
        return buffer;
    }

    private Polygon buffer_polyline_(Polyline polyline) {
        Geometry_cursor_for_multi_path cursor = new Geometry_cursor_for_multi_path(this, polyline, null);
        Polygon buffer = this.process_gnomonic_buffer_pieces_cursor(true, cursor);
        return buffer;
    }

    private Polygon buffer_multi_point_(MultiPoint multi_point) {
        Geometry_cursor_for_multi_point cursor = new Geometry_cursor_for_multi_point(this, multi_point);
        Polygon buffer = this.process_gnomonic_buffer_pieces_cursor(false, cursor);
        return buffer;
    }

    private Polygon buffer_point_(Point point) {
        Point2D pt = point.getXY();
        pt.scale(this.m_rpu);
        Polygon buffer = new Polygon();
        boolean b_wraps_pole = this.buffer_point_(pt, false, buffer);
        if (b_wraps_pole) {
            double tolerance = InternalUtils.calculateToleranceFromGeometryForOp(null, buffer, true);
            buffer = (Polygon)TopologicalOperations.planarSimplify(buffer, tolerance, true, true, -1, this.m_progress_tracker, false);
        }
        OperatorProject project = OperatorProject.local();
        buffer = (Polygon)project.foldInto360RangeGeodetic(buffer, this.m_gcs, 2);
        return buffer;
    }

    private static Polygon set_weak_simple_conditional_(Polygon poly) {
        if (!InternalUtils.isAtLeastWeakSimple(poly, 0.0)) {
            InternalUtils.setWeakSsimple(poly, 0.0);
        }
        return poly;
    }

    private Polygon process_gnomonic_buffer_pieces_cursor(boolean b_multi_path, Geometry_cursor_for_gnomonic_buffer_pieces gnomonic_buffer_pieces_cursor) {
        boolean b_do_difference;
        Geometry_cursor_for_gnomonic_buffer_pieces cursor = gnomonic_buffer_pieces_cursor;
        Gnomonic prev_gnomonic = cursor.get_gnomonic();
        this.m_local_meters_sr = SpatialReference.createLocal(Unit.create(9001));
        ((SpatialReferenceImpl)this.m_local_meters_sr).setTolerance(0, 0.001);
        ListeningGeometryCursor listening_cursor_gnomonic = new ListeningGeometryCursor();
        GeometryCursor union_cursor_gnomonic = OperatorUnion.local().execute(listening_cursor_gnomonic, this.m_local_meters_sr, this.m_progress_tracker);
        boolean[] b_grid_full = new boolean[6];
        Envelope2D[] grid = new Envelope2D[6];
        this.initialize_grid_(b_grid_full, grid);
        Gnomonic[] grid_gnomonics = new Gnomonic[6];
        ListeningGeometryCursor[] grid_listening_cursors_gnomonic = new ListeningGeometryCursor[6];
        GeometryCursor[] grid_union_cursors_gnomonic = new GeometryCursor[6];
        Polygon buffer_piece = null;
        Gnomonic gnomonic = null;
        while ((buffer_piece = cursor.next()) != null) {
            gnomonic = cursor.get_gnomonic();
            if (gnomonic != prev_gnomonic) {
                if (prev_gnomonic != null) {
                    Polygon unioned_buffer_pieces = (Polygon)union_cursor_gnomonic.next();
                    listening_cursor_gnomonic = null;
                    union_cursor_gnomonic = null;
                    if (unioned_buffer_pieces != null) {
                        double pole_tolerance_meters = InternalUtils.calculateToleranceFromGeometryForOp(this.m_local_meters_sr, unioned_buffer_pieces, true);
                        pole_tolerance_meters = InternalUtils.adjust_tolerance_for_TE_clustering(pole_tolerance_meters);
                        unioned_buffer_pieces = (Polygon)prev_gnomonic.unproject(unioned_buffer_pieces, pole_tolerance_meters, this.m_progress_tracker);
                        this.put_in_grid_cursors_(b_multi_path, unioned_buffer_pieces, true, b_grid_full, grid, grid_gnomonics, grid_listening_cursors_gnomonic, grid_union_cursors_gnomonic);
                    }
                }
                if (gnomonic != null) {
                    assert (cursor.is_running_in_gnomonic());
                    listening_cursor_gnomonic = new ListeningGeometryCursor();
                    union_cursor_gnomonic = OperatorUnion.local().execute(listening_cursor_gnomonic, this.m_local_meters_sr, this.m_progress_tracker);
                } else assert (!cursor.is_running_in_gnomonic());
                prev_gnomonic = gnomonic;
            }
            if (cursor.is_running_in_gnomonic()) {
                assert (gnomonic != null);
                gnomonic.project(buffer_piece);
                if (cursor.needs_simplify()) {
                    double tolerance = InternalUtils.calculateToleranceFromGeometryForOp(null, buffer_piece, true);
                    buffer_piece = (Polygon)TopologicalOperations.planarSimplify(buffer_piece, tolerance, true, true, -1, this.m_progress_tracker, false);
                }
                listening_cursor_gnomonic.tick(GeodesicBufferer.set_weak_simple_conditional_(buffer_piece));
                union_cursor_gnomonic.tock();
                continue;
            }
            assert (gnomonic == null);
            this.put_in_grid_cursors_(b_multi_path, buffer_piece, true, b_grid_full, grid, grid_gnomonics, grid_listening_cursors_gnomonic, grid_union_cursors_gnomonic);
        }
        Polygon unioned_buffer_gcs = null;
        boolean b_buffer_pieces_in_grid = false;
        for (int i = 0; i < 6; ++i) {
            if (grid_union_cursors_gnomonic[i] == null) continue;
            b_buffer_pieces_in_grid = true;
            break;
        }
        if (b_buffer_pieces_in_grid) {
            b_do_difference = false;
            Geometry[] grid_densified = null;
            if (b_multi_path) {
                Polygon densified = (Polygon)((Geometry_cursor_for_multi_path)cursor).m_densified;
                ((Geometry_cursor_for_multi_path)cursor).m_densified = null;
                if (densified != null) {
                    Transformation2D transform = new Transformation2D();
                    transform.scale(1.0 / this.m_rpu, 1.0 / this.m_rpu);
                    densified.applyTransformation(transform);
                    if (this.m_distance > 0.0) {
                        this.put_in_grid_cursors_(b_multi_path, densified, false, b_grid_full, grid, grid_gnomonics, grid_listening_cursors_gnomonic, grid_union_cursors_gnomonic);
                    } else {
                        grid_densified = new Geometry[6];
                        this.process_in_grid_(b_multi_path, densified, false, b_grid_full, grid, grid_gnomonics, grid_densified);
                        b_do_difference = true;
                    }
                }
            }
            ListeningGeometryCursor listening_cursor_gcs = new ListeningGeometryCursor();
            GeometryCursor union_cursor_gcs = OperatorUnion.local().execute(listening_cursor_gcs, this.m_gcs, this.m_progress_tracker);
            if (union_cursor_gnomonic != null) {
                Polygon unioned_buffer_pieces = (Polygon)union_cursor_gnomonic.next();
                listening_cursor_gnomonic = null;
                union_cursor_gnomonic = null;
                assert (unioned_buffer_pieces != null);
                double pole_tolerance_meters = InternalUtils.calculateToleranceFromGeometryForOp(this.m_local_meters_sr, unioned_buffer_pieces, true);
                pole_tolerance_meters = InternalUtils.adjust_tolerance_for_TE_clustering(pole_tolerance_meters);
                unioned_buffer_pieces = (Polygon)prev_gnomonic.unproject(unioned_buffer_pieces, pole_tolerance_meters, this.m_progress_tracker);
                this.put_in_grid_cursors_(b_multi_path, unioned_buffer_pieces, true, b_grid_full, grid, grid_gnomonics, grid_listening_cursors_gnomonic, grid_union_cursors_gnomonic);
            }
            for (int i = 0; i < 6; ++i) {
                if (grid_union_cursors_gnomonic[i] == null) continue;
                Polygon unioned_buffer_pieces = (Polygon)grid_union_cursors_gnomonic[i].next();
                grid_union_cursors_gnomonic[i] = null;
                grid_listening_cursors_gnomonic[i] = null;
                assert (unioned_buffer_pieces != null);
                if (b_do_difference && grid_densified[i] != null) {
                    unioned_buffer_pieces = (Polygon)OperatorDifference.local().execute(grid_densified[i], unioned_buffer_pieces, this.m_local_meters_sr, this.m_progress_tracker);
                }
                double pole_tolerance_meters = InternalUtils.calculateToleranceFromGeometryForOp(this.m_local_meters_sr, unioned_buffer_pieces, true);
                pole_tolerance_meters = InternalUtils.adjust_tolerance_for_TE_clustering(pole_tolerance_meters);
                unioned_buffer_pieces = (Polygon)grid_gnomonics[i].unproject(unioned_buffer_pieces, pole_tolerance_meters, this.m_progress_tracker);
                unioned_buffer_pieces = (Polygon)OperatorSimplify.local().execute(unioned_buffer_pieces, this.m_gcs, true, this.m_progress_tracker);
                listening_cursor_gcs.tick(GeodesicBufferer.set_weak_simple_conditional_(unioned_buffer_pieces));
                union_cursor_gcs.tock();
            }
            unioned_buffer_gcs = (Polygon)union_cursor_gcs.next();
        } else {
            b_do_difference = false;
            Polygon gnomonic_densified = null;
            if (b_multi_path) {
                Polygon densified = (Polygon)((Geometry_cursor_for_multi_path)cursor).m_densified;
                ((Geometry_cursor_for_multi_path)cursor).m_densified = null;
                if (densified != null) {
                    Transformation2D transform = new Transformation2D();
                    transform.scale(1.0 / this.m_rpu, 1.0 / this.m_rpu);
                    densified.applyTransformation(transform);
                    assert (gnomonic != null);
                    gnomonic.project(densified);
                    double tolerance = InternalUtils.calculateToleranceFromGeometryForOp(null, densified, true);
                    densified = (Polygon)TopologicalOperations.planarSimplify(densified, tolerance, false, true, -1, this.m_progress_tracker, false);
                    if (this.m_distance > 0.0) {
                        listening_cursor_gnomonic.tick(GeodesicBufferer.set_weak_simple_conditional_(densified));
                        union_cursor_gnomonic.tock();
                    } else {
                        gnomonic_densified = densified;
                        b_do_difference = true;
                    }
                }
            }
            assert (union_cursor_gnomonic != null);
            Polygon unioned_buffer_pieces = (Polygon)union_cursor_gnomonic.next();
            listening_cursor_gnomonic = null;
            union_cursor_gnomonic = null;
            if (b_do_difference) {
                unioned_buffer_pieces = (Polygon)OperatorDifference.local().execute(gnomonic_densified, unioned_buffer_pieces, this.m_local_meters_sr, this.m_progress_tracker);
            }
            double pole_tolerance_meters = InternalUtils.calculateToleranceFromGeometryForOp(this.m_local_meters_sr, unioned_buffer_pieces, true);
            pole_tolerance_meters = InternalUtils.adjust_tolerance_for_TE_clustering(pole_tolerance_meters);
            unioned_buffer_gcs = (Polygon)prev_gnomonic.unproject(unioned_buffer_pieces, pole_tolerance_meters, this.m_progress_tracker);
            unioned_buffer_gcs = (Polygon)OperatorSimplify.local().execute(unioned_buffer_gcs, this.m_gcs, true, this.m_progress_tracker);
        }
        assert (unioned_buffer_gcs != null);
        unioned_buffer_gcs = (Polygon)OperatorProject.local().foldInto360RangeGeodetic(unioned_buffer_gcs, this.m_gcs, 2);
        return unioned_buffer_gcs;
    }

    private void put_in_grid_cursors_(boolean b_multi_path, Polygon buffer, boolean b_winding_simplify, boolean[] b_grid_full, Envelope2D[] grid, Gnomonic[] grid_gnomonics, ListeningGeometryCursor[] grid_listening_cursors_gnomonic, GeometryCursor[] grid_union_cursors_gnomonic) {
        Geometry[] grid_geometries = new Geometry[6];
        this.process_in_grid_(b_multi_path, buffer, b_winding_simplify, b_grid_full, grid, grid_gnomonics, grid_geometries);
        for (int i = 0; i < 6; ++i) {
            if (grid_geometries[i] == null) continue;
            if (grid_listening_cursors_gnomonic[i] == null) {
                grid_listening_cursors_gnomonic[i] = new ListeningGeometryCursor();
                grid_union_cursors_gnomonic[i] = OperatorUnion.local().execute(grid_listening_cursors_gnomonic[i], this.m_local_meters_sr, this.m_progress_tracker);
            }
            grid_listening_cursors_gnomonic[i].tick(GeodesicBufferer.set_weak_simple_conditional_((Polygon)grid_geometries[i]));
            grid_union_cursors_gnomonic[i].tock();
        }
    }

    private void process_in_grid_(boolean b_multi_path, Polygon polygon, boolean b_winding_simplify, boolean[] b_grid_full, Envelope2D[] grid, Gnomonic[] grid_gnomonics, Geometry[] out_grid_geometries) {
        double fuzzy = 0.01;
        Polygon polygon_inserted_points_along_grid = (Polygon)this.insert_geodetic_points_along_grid_(polygon, grid, fuzzy);
        for (int i = 0; i < 6; ++i) {
            if (b_grid_full[i]) continue;
            Envelope2D grid_i_expanded = new Envelope2D();
            grid_i_expanded.setCoords(grid[i]);
            grid_i_expanded.inflate(fuzzy, fuzzy);
            Envelope2D common_extent = InternalUtils.getMergedExtent(polygon, grid_i_expanded);
            double tolerance = InternalUtils.calculateToleranceFromGeometryForOp(null, common_extent, true);
            Polygon clipped = (Polygon)Clipper.clip(polygon_inserted_points_along_grid, grid_i_expanded, tolerance, NumberUtils.NaN(), this.m_progress_tracker);
            if (clipped == null || clipped.isEmpty()) continue;
            if (clipped == polygon_inserted_points_along_grid) {
                clipped = new Polygon();
                polygon_inserted_points_along_grid.copyTo(clipped);
            }
            if (grid_gnomonics[i] == null) {
                Point2D center = new Point2D();
                if (i < 3) {
                    center.setCoords(0.0, 1.0);
                } else {
                    center.setCoords(0.0, -1.0);
                }
                center.add(grid[i].getCenter());
                grid_gnomonics[i] = GeodesicBufferer.get_gnomonic_(this.m_gcs, center);
            }
            grid_gnomonics[i].project(clipped);
            double pcs_tolerance = InternalUtils.calculateToleranceFromGeometryForOp(null, clipped, true);
            clipped = (Polygon)TopologicalOperations.planarSimplify(clipped, pcs_tolerance, b_winding_simplify, true, -1, this.m_progress_tracker, false);
            out_grid_geometries[i] = clipped;
        }
    }

    private MultiPath insert_geodetic_points_along_grid_(MultiPath multi_path, Envelope2D[] grid, double fuzzy) {
        Envelope2D pannable_extent = new Envelope2D(grid[3].xmin, grid[3].ymin, grid[2].xmax, grid[2].ymax);
        MultiPath poly = Gnomonic.fold_into_360_no_union(this.m_gcs, pannable_extent, multi_path, true, this.m_progress_tracker);
        EditShape shape = new EditShape();
        int geometry = shape.addGeometry(poly);
        ProjectionUtils.insertGeodeticPoints(shape, geometry, (SpatialReferenceImpl)this.m_gcs, 0.0, 2, true, grid[0].xmax + fuzzy);
        ProjectionUtils.insertGeodeticPoints(shape, geometry, (SpatialReferenceImpl)this.m_gcs, 0.0, 2, true, grid[1].xmax + fuzzy);
        ProjectionUtils.insertGeodeticPoints(shape, geometry, (SpatialReferenceImpl)this.m_gcs, 0.0, 2, false, grid[1].ymin + fuzzy);
        if (fuzzy != 0.0) {
            ProjectionUtils.insertGeodeticPoints(shape, geometry, (SpatialReferenceImpl)this.m_gcs, 0.0, 2, true, grid[0].xmax - fuzzy);
            ProjectionUtils.insertGeodeticPoints(shape, geometry, (SpatialReferenceImpl)this.m_gcs, 0.0, 2, true, grid[1].xmax - fuzzy);
            ProjectionUtils.insertGeodeticPoints(shape, geometry, (SpatialReferenceImpl)this.m_gcs, 0.0, 2, false, grid[1].ymin - fuzzy);
        }
        return (MultiPath)shape.getGeometry(geometry);
    }

    private void initialize_grid_(boolean[] b_grid_full, Envelope2D[] grid) {
        for (int i = 0; i < 6; ++i) {
            b_grid_full[i] = false;
            grid[i] = new Envelope2D();
        }
        grid[0].setCoords(-this.m_gcs_180, 0.0, -this.m_gcs_60, this.m_gcs_90);
        grid[1].setCoords(-this.m_gcs_60, 0.0, this.m_gcs_60, this.m_gcs_90);
        grid[2].setCoords(this.m_gcs_60, 0.0, this.m_gcs_180, this.m_gcs_90);
        grid[3].setCoords(-this.m_gcs_180, -this.m_gcs_90, -this.m_gcs_60, 0.0);
        grid[4].setCoords(-this.m_gcs_60, -this.m_gcs_90, this.m_gcs_60, 0.0);
        grid[5].setCoords(this.m_gcs_60, -this.m_gcs_90, this.m_gcs_180, 0.0);
    }

    private boolean check_and_prep_segment_for_crossing_azimuths_or_pole_wrap_(ArrayList<Point2D> densified_points, double geodetic_length, double start_azimuth, double end_azimuth, boolean b_running_in_gnomonic, Polygon buffer) {
        Point2D pt_start = densified_points.get(0);
        Point2D pt_end = densified_points.get(densified_points.size() - 1);
        assert (!GeodeticDensify.checkForWithinPole(pt_start, pt_end));
        double max_latitude = pt_start.y < pt_end.y ? pt_start.y : pt_end.y;
        double min_latitude = pt_start.y > pt_end.y ? pt_start.y : pt_end.y;
        double q_max = PeMath.q((double)this.m_a, (double)this.m_e_squared, (double)max_latitude);
        double q_min = PeMath.q((double)this.m_a, (double)this.m_e_squared, (double)min_latitude);
        if (this.m_q_90 - (q_max + geodetic_length + this.m_abs_distance) > 0.001 && this.m_q_90 + (q_min - geodetic_length - this.m_abs_distance) > 0.001) {
            return false;
        }
        double start_perp = start_azimuth - 1.5707963267948966;
        double end_perp = end_azimuth + 1.5707963267948966;
        double start_perp_minus_pi = start_perp - Math.PI;
        double start_perp_plus_pi = start_perp + Math.PI;
        double end_perp_plus_pi = end_perp + Math.PI;
        double[] crossing_azimuth_end1 = new double[1];
        double[] crossing_azimuth_end2 = new double[1];
        double[] crossing_azimuth_start1 = new double[1];
        double[] crossing_azimuth_start2 = new double[1];
        crossing_azimuth_end1[0] = NumberUtils.NaN();
        crossing_azimuth_end2[0] = NumberUtils.NaN();
        crossing_azimuth_start1[0] = NumberUtils.NaN();
        crossing_azimuth_start2[0] = NumberUtils.NaN();
        boolean b_crossing_azimuths = false;
        GeodesicBufferer.query_crossing_azimuths_(this.m_a, this.m_e_squared, this.m_rpu, this.m_abs_distance, pt_start, start_perp, start_perp_minus_pi, pt_end, end_perp, crossing_azimuth_end1, crossing_azimuth_end2);
        GeodesicBufferer.query_crossing_azimuths_(this.m_a, this.m_e_squared, this.m_rpu, this.m_abs_distance, pt_end, end_perp_plus_pi, end_perp, pt_start, start_perp_minus_pi, crossing_azimuth_start1, crossing_azimuth_start2);
        if (end_perp < crossing_azimuth_end1[0] && crossing_azimuth_end1[0] < end_perp_plus_pi) {
            b_crossing_azimuths = true;
        } else if (end_perp < crossing_azimuth_end2[0] && crossing_azimuth_end2[0] < end_perp_plus_pi) {
            b_crossing_azimuths = true;
        }
        if (!b_crossing_azimuths) {
            if (start_perp_minus_pi < crossing_azimuth_start1[0] && crossing_azimuth_start1[0] < start_perp) {
                b_crossing_azimuths = true;
            } else if (start_perp_minus_pi < crossing_azimuth_start2[0] && crossing_azimuth_start2[0] < start_perp) {
                b_crossing_azimuths = true;
            }
        }
        if (!b_crossing_azimuths && b_running_in_gnomonic) {
            return false;
        }
        ArrayList<Point2D> reversed_points = new ArrayList<Point2D>(0);
        reversed_points.ensureCapacity(densified_points.size());
        for (int i = densified_points.size() - 1; i >= 0; --i) {
            reversed_points.add(densified_points.get(i));
        }
        buffer.setEmpty();
        buffer.addPath((Point2D[])null, 0, true);
        double[] current_buffered_delta = new double[]{0.0};
        GeodesicBufferer.buffer_left_side_(this.m_a, this.m_e_squared, this.m_rpu, this.m_abs_distance, this.m_curve_type, densified_points, start_perp, end_perp, b_running_in_gnomonic, current_buffered_delta, buffer);
        GeodesicBufferer.buffer_corner_(this.m_a, this.m_e_squared, this.m_rpu, this.m_abs_distance, pt_end, end_perp, end_perp_plus_pi, this.m_corner_step, b_running_in_gnomonic, current_buffered_delta, buffer, crossing_azimuth_end1[0], crossing_azimuth_end2[0]);
        GeodesicBufferer.buffer_left_side_(this.m_a, this.m_e_squared, this.m_rpu, this.m_abs_distance, this.m_curve_type, reversed_points, end_perp_plus_pi, start_perp_plus_pi, b_running_in_gnomonic, current_buffered_delta, buffer);
        GeodesicBufferer.buffer_corner_(this.m_a, this.m_e_squared, this.m_rpu, this.m_abs_distance, pt_start, start_perp_minus_pi, start_perp, this.m_corner_step, b_running_in_gnomonic, current_buffered_delta, buffer, crossing_azimuth_start1[0], crossing_azimuth_start2[0]);
        boolean b_wraps_pole = false;
        if (!b_running_in_gnomonic) {
            b_wraps_pole = this.check_and_prep_for_pole_(buffer);
        }
        return b_crossing_azimuths || b_wraps_pole;
    }

    private boolean buffer_point_(Point2D point, boolean b_running_in_gnomonic, Polygon buffer) {
        buffer.setEmpty();
        buffer.addPath((Point2D[])null, 0, true);
        double[] current_buffered_delta = new double[]{0.0};
        GeodesicBufferer.buffer_corner_(this.m_a, this.m_e_squared, this.m_rpu, this.m_abs_distance, point, -this.m_corner_step, Math.PI * 2, this.m_corner_step, b_running_in_gnomonic, current_buffered_delta, buffer, NumberUtils.NaN(), NumberUtils.NaN());
        boolean b_wraps_pole = false;
        if (!b_running_in_gnomonic) {
            b_wraps_pole = this.check_and_prep_for_pole_(buffer);
        }
        return b_wraps_pole;
    }

    private boolean check_and_prep_for_pole_(Polygon polygon) {
        boolean b_pole_touch = this.check_and_prep_for_pole_touch_(polygon);
        boolean b_pole_wrap = this.check_and_prep_for_pole_wrap_(polygon);
        return b_pole_touch || b_pole_wrap;
    }

    private boolean check_and_prep_for_pole_touch_(Polygon polygon) {
        Envelope2D env = new Envelope2D();
        polygon.queryEnvelope2D(env);
        if (!PeMacros.PE_EQ((double)env.ymax, (double)this.m_gcs_90) && !PeMacros.PE_EQ((double)env.ymin, (double)(-this.m_gcs_90))) {
            return false;
        }
        this.prep_pole_touch_(polygon);
        return true;
    }

    private boolean check_and_prep_for_pole_wrap_(Polygon polygon) {
        Point2D start = new Point2D();
        Point2D end = new Point2D();
        polygon.getXY(0, start);
        polygon.getXY(polygon.getPointCount() - 1, end);
        if (Math.abs(start.x - end.x) > this.m_gcs_180) {
            this.prep_single_pole_wrap_(polygon);
            return true;
        }
        return this.check_and_prep_for_double_pole_wrap_(polygon);
    }

    private boolean check_and_prep_for_double_pole_wrap_(Polygon polygon) {
        double area = polygon.calculateArea2D();
        if (area < 0.0) {
            this.prep_double_pole_wrap_(polygon);
            return true;
        }
        return false;
    }

    private void prep_pole_touch_(Polygon polygon) {
        int k_next;
        Polygon polygon_pole_touch = new Polygon();
        Point2D pt = new Point2D();
        Point2D pt_k = new Point2D();
        Point2D pole_pt = new Point2D();
        Point2D pt_k_next = new Point2D();
        polygon_pole_touch.insertPath(-1, null, 0, 0, true);
        int istart = polygon.getPathStart(0);
        int iend = polygon.getPathEnd(0);
        int n = iend - istart;
        int i = -1;
        for (i = istart; i < iend; ++i) {
            polygon.getXY(i, pt);
            boolean b_touches_north = PeMacros.PE_EQ((double)pt.y, (double)this.m_gcs_90);
            boolean b_touches_south = PeMacros.PE_EQ((double)pt.y, (double)(-this.m_gcs_90));
            if (!b_touches_north && !b_touches_south) break;
        }
        assert (i != iend);
        int k = i;
        boolean b_prev_touches_pole = false;
        double last_longitude = NumberUtils.NaN();
        do {
            polygon.getXY(k, pt_k);
            boolean b_touches_north = PeMacros.PE_EQ((double)pt_k.y, (double)this.m_gcs_90);
            boolean b_touches_south = PeMacros.PE_EQ((double)pt_k.y, (double)(-this.m_gcs_90));
            k_next = istart + (k + 1 - istart) % n;
            if (!b_touches_north && !b_touches_south) {
                polygon_pole_touch.insertPoint(0, -1, pt_k);
                last_longitude = pt_k.x;
                b_prev_touches_pole = false;
                continue;
            }
            pole_pt.setCoords(last_longitude, pt_k.y);
            polygon_pole_touch.insertPoint(0, -1, pole_pt);
            polygon.getXY(k_next, pt_k_next);
            boolean b_next_touches_north = PeMacros.PE_EQ((double)pt_k_next.y, (double)this.m_gcs_90);
            boolean b_next_touches_south = PeMacros.PE_EQ((double)pt_k_next.y, (double)(-this.m_gcs_90));
            if (!b_next_touches_north && !b_next_touches_south) {
                pole_pt = new Point2D(pt_k_next.x, pt_k.y);
                if (!b_prev_touches_pole) {
                    polygon_pole_touch.insertPoint(0, -1, pole_pt);
                } else {
                    polygon_pole_touch.setXY(polygon_pole_touch.getPointCount() - 1, pole_pt);
                }
            }
            b_prev_touches_pole = true;
        } while ((k = k_next) != i);
        polygon.setEmpty();
        polygon.add(polygon_pole_touch, false);
    }

    private void prep_single_pole_wrap_(Polygon polygon) {
        double pole;
        double repeat_shift;
        Polygon polygon_duplicated = new Polygon();
        Polygon polygon_shifted = new Polygon();
        Transformation2D transform = new Transformation2D();
        Point2D start = new Point2D();
        Point2D end = new Point2D();
        polygon.getXY(polygon.getPathStart(0), start);
        polygon.getXY(polygon.getPathEnd(0) - 1, end);
        double pannable_360 = this.m_gcs_360;
        double pannable_180 = this.m_gcs_180;
        Envelope2D pannable_extent = new Envelope2D();
        pannable_extent.setCoords(-this.m_gcs_180, -this.m_gcs_90, this.m_gcs_180, this.m_gcs_90);
        Envelope2D polygon_env = new Envelope2D();
        polygon.queryEnvelope2D(polygon_env);
        int num_repeats = (int)Math.ceil(polygon_env.getWidth() / pannable_360);
        if (start.x > end.x) {
            repeat_shift = -pannable_360;
            pole = this.m_gcs_90;
        } else {
            repeat_shift = pannable_360;
            pole = -this.m_gcs_90;
        }
        transform.setShift(repeat_shift, 0.0);
        polygon_duplicated.addPath(polygon, 0, true);
        polygon_shifted.add(polygon_duplicated, false);
        Point connecting_point = new Point();
        for (int i = 0; i < num_repeats; ++i) {
            polygon_shifted.applyTransformation(transform);
            polygon_shifted.getPointByVal(0, connecting_point);
            polygon_duplicated.lineTo(connecting_point);
            polygon_duplicated.addSegmentsFromPath(polygon_shifted, 0, 0, polygon_shifted.getSegmentCount() - 1, false);
        }
        Point2D start_duplicated = new Point2D();
        Point2D end_duplicated = new Point2D();
        polygon_duplicated.getXY(0, start_duplicated);
        polygon_duplicated.getXY(polygon_duplicated.getPointCount() - 1, end_duplicated);
        start_duplicated.y = pole;
        end_duplicated.y = pole;
        polygon_duplicated.lineTo(end_duplicated);
        Point2D pt = new Point2D();
        pt.setCoords(end_duplicated);
        pt.x -= 0.5 * repeat_shift;
        while (Math.abs(pt.x - start_duplicated.x) > pannable_180) {
            polygon_duplicated.lineTo(pt);
            pt.x -= 0.5 * repeat_shift;
        }
        polygon_duplicated.lineTo(start_duplicated);
        double central_longitude = pannable_extent.getCenterX();
        Envelope2D polygon_duplicated_env = new Envelope2D();
        polygon_duplicated.queryEnvelope2D(polygon_duplicated_env);
        double shift_factor = 0.0;
        double center = polygon_duplicated_env.getCenter().x;
        if (center - central_longitude > pannable_180) {
            shift_factor = -Math.ceil((center - central_longitude - pannable_180) / pannable_360);
        } else if (central_longitude - center > pannable_180) {
            shift_factor = Math.ceil((central_longitude - center - pannable_180) / pannable_360);
        }
        if (shift_factor != 0.0) {
            transform.setShift(shift_factor * pannable_360, 0.0);
            polygon_duplicated.applyTransformation(transform);
        }
        EditShape shape = new EditShape();
        int geometry = shape.addGeometry(polygon_duplicated);
        ProjectionUtils.insertGeodeticPoints(shape, geometry, (SpatialReferenceImpl)this.m_gcs, 0.0, 2, true, pannable_extent.xmin);
        ProjectionUtils.insertGeodeticPoints(shape, geometry, (SpatialReferenceImpl)this.m_gcs, 0.0, 2, true, pannable_extent.xmax);
        Polygon poly = (Polygon)shape.getGeometry(geometry);
        Envelope2D common_extent = InternalUtils.getMergedExtent(poly, pannable_extent);
        common_extent.inflate(0.0, 1.0);
        double tolerance = InternalUtils.calculateToleranceFromGeometryForOp(null, common_extent, true);
        Polygon polygon_clipped = (Polygon)Clipper.clip(poly, pannable_extent, tolerance, NumberUtils.NaN(), this.m_progress_tracker);
        polygon.setEmpty();
        polygon.add(polygon_clipped, false);
    }

    private void prep_double_pole_wrap_(Polygon polygon) {
        boolean b_straddles_date_line;
        double pannable_360 = this.m_gcs_360;
        double pannable_180 = this.m_gcs_180;
        Envelope2D pannable_extent = new Envelope2D();
        pannable_extent.setCoords(-this.m_gcs_180, -this.m_gcs_90, this.m_gcs_180, this.m_gcs_90);
        double central_longitude = pannable_extent.getCenter().x;
        Envelope2D path_envelope = new Envelope2D();
        polygon.queryPathEnvelope2D(0, path_envelope);
        double shift_factor = 0.0;
        double center = path_envelope.getCenter().x;
        if (center - central_longitude > pannable_180) {
            shift_factor = -Math.ceil((center - central_longitude - pannable_180) / pannable_360);
        } else if (central_longitude - center > pannable_180) {
            shift_factor = Math.ceil((central_longitude - center - pannable_180) / pannable_360);
        }
        if (shift_factor != 0.0) {
            Transformation2D transform = new Transformation2D();
            transform.setShift(shift_factor * pannable_360, 0.0);
            ((MultiPathImpl)polygon._getImpl()).applyTransformation(transform, 0);
            polygon.queryPathEnvelope2D(0, path_envelope);
            center = path_envelope.getCenter().x;
        }
        Envelope2D full_world = new Envelope2D();
        if (pannable_extent.containsExclusive(path_envelope)) {
            b_straddles_date_line = false;
            full_world.setCoords(pannable_extent);
        } else {
            b_straddles_date_line = true;
            full_world.setCoords(pannable_extent);
            full_world.xmin -= pannable_360;
            full_world.xmax += pannable_360;
        }
        Polygon pole_wrapper = (Polygon)polygon.createInstance();
        pole_wrapper.addPath((Point2D[])null, 0, true);
        Point2D point = new Point2D();
        point.setCoords(full_world.xmin, full_world.ymin);
        pole_wrapper.insertPoint(0, -1, point);
        point.setCoords(full_world.xmin, full_world.ymax);
        pole_wrapper.insertPoint(0, -1, point);
        point.setCoords(0.5 * (full_world.xmin + full_world.xmax), full_world.ymax);
        pole_wrapper.insertPoint(0, -1, point);
        point.setCoords(full_world.xmax, full_world.ymax);
        pole_wrapper.insertPoint(0, -1, point);
        point.setCoords(full_world.xmax, full_world.ymin);
        pole_wrapper.insertPoint(0, -1, point);
        point.setCoords(0.5 * (full_world.xmin + full_world.xmax), full_world.ymin);
        pole_wrapper.insertPoint(0, -1, point);
        if (!b_straddles_date_line) {
            pole_wrapper.addPath(polygon, 0, true);
        } else {
            pole_wrapper.addPath(polygon, 0, true);
            Transformation2D transform = new Transformation2D();
            if (center < central_longitude) {
                transform.setShift(pannable_360, 0.0);
            } else {
                transform.setShift(-pannable_360, 0.0);
            }
            ((MultiPathImpl)polygon._getImpl()).applyTransformation(transform, 0);
            pole_wrapper.addPath(polygon, 0, true);
            EditShape shape = new EditShape();
            int geometry = shape.addGeometry(pole_wrapper);
            ProjectionUtils.insertGeodeticPoints(shape, geometry, (SpatialReferenceImpl)this.m_gcs, 0.0, 2, true, pannable_extent.xmin);
            ProjectionUtils.insertGeodeticPoints(shape, geometry, (SpatialReferenceImpl)this.m_gcs, 0.0, 2, true, pannable_extent.xmax);
            pole_wrapper = (Polygon)shape.getGeometry(geometry);
            Envelope2D common_extent = InternalUtils.getMergedExtent(pole_wrapper, pannable_extent);
            common_extent.inflate(0.0, 1.0);
            double tolerance = InternalUtils.calculateToleranceFromGeometryForOp(null, common_extent, true);
            pole_wrapper = (Polygon)Clipper.clip(pole_wrapper, pannable_extent, tolerance, NumberUtils.NaN(), this.m_progress_tracker);
        }
        polygon.setEmpty();
        polygon.add(pole_wrapper, false);
    }

    private static void buffer_left_side_(double a, double e_squared, double rpu, double distance, int curve_type, ArrayList<Point2D> densified_points, double start_perp, double end_perp, boolean b_running_in_gnomonic, double[] current_buffered_delta, Polygon running_buffer) {
        Point2D last_buffered_point = null;
        if (!b_running_in_gnomonic) {
            last_buffered_point = new Point2D();
            last_buffered_point.setNaN();
            if (running_buffer.getPointCount() > 0) {
                last_buffered_point.setCoords(running_buffer.getXY(running_buffer.getPointCount() - 1));
                last_buffered_point.scale(rpu);
            }
        }
        PeDouble pe_az = new PeDouble();
        PeDouble pe_buffered_point_0 = new PeDouble();
        PeDouble pe_buffered_point_1 = new PeDouble();
        Point2D buffered_point = new Point2D();
        Point2D point = new Point2D();
        Point2D pt_end = densified_points.get(densified_points.size() - 1);
        double upr = 1.0 / rpu;
        for (int i = 0; i < densified_points.size(); ++i) {
            double az_perp;
            Point2D geodetic_point = densified_points.get(i);
            if (i == 0) {
                az_perp = start_perp;
            } else if (i == densified_points.size() - 1) {
                az_perp = end_perp;
            } else {
                PeLineType.geodetic_distance((double)a, (double)e_squared, (double)pt_end.x, (double)pt_end.y, (double)geodetic_point.x, (double)geodetic_point.y, null, null, (PeDouble)pe_az, (int)curve_type);
                az_perp = pe_az.val - 1.5707963267948966;
            }
            GeodesicBufferer.geodesic_coordinate_(a, e_squared, geodetic_point.x, geodetic_point.y, distance, az_perp, pe_buffered_point_0, pe_buffered_point_1);
            if (!b_running_in_gnomonic) {
                buffered_point.setCoords(pe_buffered_point_0.val, pe_buffered_point_1.val);
                GeodesicBufferer.rectify_buffered_delta_(geodetic_point.x, buffered_point.x, last_buffered_point.x, current_buffered_delta);
                point.setCoords(current_buffered_delta[0] + buffered_point.x, buffered_point.y);
                last_buffered_point.setCoords(point);
            } else {
                point.setCoords(pe_buffered_point_0.val, pe_buffered_point_1.val);
            }
            point.scale(upr);
            running_buffer.insertPoint(0, -1, point);
        }
    }

    private static void buffer_corner_(double a, double e_squared, double rpu, double distance, Point2D pt_corner, double start_azimuth, double end_azimuth, double corner_step, boolean b_running_in_gnomonic, double[] current_buffered_delta, Polygon running_buffer, double crossing_azimuth1, double crossing_azimuth2) {
        double azimuth;
        assert (end_azimuth >= start_azimuth);
        if (end_azimuth - start_azimuth < corner_step) {
            return;
        }
        PeDouble pe_buffered_point_0 = new PeDouble();
        PeDouble pe_buffered_point_1 = new PeDouble();
        Point2D buffered_point = new Point2D();
        Point2D point = new Point2D();
        Point2D last_buffered_point = null;
        if (!b_running_in_gnomonic) {
            last_buffered_point = new Point2D();
            last_buffered_point.setNaN();
            if (running_buffer.getPointCount() > 0) {
                last_buffered_point.setCoords(running_buffer.getXY(running_buffer.getPointCount() - 1));
                last_buffered_point.scale(rpu);
            }
        }
        int factor = (int)Math.ceil(start_azimuth / corner_step);
        if ((azimuth = (double)factor++ * corner_step) == start_azimuth) {
            azimuth = (double)factor++ * corner_step;
        }
        double last_azimuth = start_azimuth;
        double upr = 1.0 / rpu;
        while (azimuth < end_azimuth + corner_step) {
            if (last_azimuth < crossing_azimuth1 && crossing_azimuth1 < azimuth) {
                azimuth = crossing_azimuth1;
                --factor;
            } else if (last_azimuth < crossing_azimuth2 && crossing_azimuth2 < azimuth) {
                azimuth = crossing_azimuth2;
                --factor;
            }
            if (azimuth >= end_azimuth) break;
            GeodesicBufferer.geodesic_coordinate_(a, e_squared, pt_corner.x, pt_corner.y, distance, azimuth, pe_buffered_point_0, pe_buffered_point_1);
            if (!b_running_in_gnomonic) {
                buffered_point.setCoords(pe_buffered_point_0.val, pe_buffered_point_1.val);
                GeodesicBufferer.rectify_buffered_delta_(pt_corner.x, buffered_point.x, last_buffered_point.x, current_buffered_delta);
                point.setCoords(current_buffered_delta[0] + buffered_point.x, buffered_point.y);
                last_buffered_point.setCoords(point);
                assert (point.y <= 1.5707963267948966 && point.y >= -1.5707963267948966);
            } else {
                point.setCoords(pe_buffered_point_0.val, pe_buffered_point_1.val);
            }
            point.scale(upr);
            running_buffer.insertPoint(0, -1, point);
            last_azimuth = azimuth;
            azimuth = (double)factor++ * corner_step;
        }
    }

    private static void query_crossing_azimuths_(double a, double e_squared, double rpu, double distance, Point2D pt, double perp1, double perp2, Point2D pt_corner, double pt_corner_perp, double[] crossing_azimuth1, double[] crossing_azimuth2) {
        Point2D first_buffered_point = new Point2D();
        Point2D second_buffered_point = new Point2D();
        PeDouble pe_buffered_point_0 = new PeDouble();
        PeDouble pe_buffered_point_1 = new PeDouble();
        GeodesicBufferer.geodesic_coordinate_(a, e_squared, pt.x, pt.y, distance, perp1, pe_buffered_point_0, pe_buffered_point_1);
        first_buffered_point.setCoords(pe_buffered_point_0.val, pe_buffered_point_1.val);
        GeodesicBufferer.geodesic_coordinate_(a, e_squared, pt.x, pt.y, distance, perp2, pe_buffered_point_0, pe_buffered_point_1);
        second_buffered_point.setCoords(pe_buffered_point_0.val, pe_buffered_point_1.val);
        PeDouble pe_az = new PeDouble();
        PeLineType.geodesic_distance((double)a, (double)e_squared, (double)pt_corner.x, (double)pt_corner.y, (double)first_buffered_point.x, (double)first_buffered_point.y, null, (PeDouble)pe_az, null);
        crossing_azimuth1[0] = pe_az.val;
        PeLineType.geodesic_distance((double)a, (double)e_squared, (double)pt_corner.x, (double)pt_corner.y, (double)second_buffered_point.x, (double)second_buffered_point.y, null, (PeDouble)pe_az, null);
        crossing_azimuth2[0] = pe_az.val;
        while (crossing_azimuth1[0] <= crossing_azimuth2[0]) {
            crossing_azimuth1[0] = crossing_azimuth1[0] + Math.PI * 2;
        }
        while (crossing_azimuth1[0] > crossing_azimuth2[0]) {
            crossing_azimuth1[0] = crossing_azimuth1[0] - Math.PI * 2;
        }
        while (crossing_azimuth1[0] >= pt_corner_perp) {
            crossing_azimuth1[0] = crossing_azimuth1[0] - Math.PI * 2;
            crossing_azimuth2[0] = crossing_azimuth2[0] - Math.PI * 2;
        }
        while (crossing_azimuth1[0] < pt_corner_perp) {
            crossing_azimuth1[0] = crossing_azimuth1[0] + Math.PI * 2;
            crossing_azimuth2[0] = crossing_azimuth2[0] + Math.PI * 2;
        }
    }

    private static void rectify_buffered_delta_(double geodetic_point_x, double buffered_point_x, double last_buffered_point_x, double[] current_buffered_delta) {
        if (NumberUtils.isNaN(last_buffered_point_x)) {
            while (current_buffered_delta[0] + buffered_point_x - geodetic_point_x > Math.PI) {
                current_buffered_delta[0] = current_buffered_delta[0] - Math.PI * 2;
            }
            while (geodetic_point_x - (current_buffered_delta[0] + buffered_point_x) > Math.PI) {
                current_buffered_delta[0] = current_buffered_delta[0] + Math.PI * 2;
            }
            return;
        }
        if (current_buffered_delta[0] + buffered_point_x - last_buffered_point_x > Math.PI) {
            current_buffered_delta[0] = current_buffered_delta[0] - Math.PI * 2;
        } else if (last_buffered_point_x - (current_buffered_delta[0] + buffered_point_x) > Math.PI) {
            current_buffered_delta[0] = current_buffered_delta[0] + Math.PI * 2;
        }
    }

    private static Geometry sort_parts_by_geohash_(Geometry geometry, SpatialReference gcs) {
        Geometry.Type geometry_type = geometry.getType();
        int part_count = Geometry.isMultiPath(geometry_type.value()) ? ((MultiPath)geometry).getPathCount() : (geometry_type == Geometry.Type.MultiPoint ? ((MultiPoint)geometry).getPointCount() : 1);
        if (part_count == 1) {
            return geometry;
        }
        assert (Geometry.isMultiVertex(geometry_type.value()));
        AttributeStreamOfInt32 part_indices = new AttributeStreamOfInt32(0);
        part_indices.resize(part_count);
        String[] geohashes = new String[part_count];
        Envelope2D path_envelope = new Envelope2D();
        Point2D center_point = new Point2D();
        for (int i = 0; i < part_count; ++i) {
            String geohash;
            part_indices.write(i, i);
            if (Geometry.isMultiPath(geometry_type.value())) {
                ((MultiPath)geometry).queryPathEnvelope2D(i, path_envelope);
                path_envelope.queryCenter(center_point);
            } else {
                ((MultiPoint)geometry).getXY(i, center_point);
            }
            geohashes[i] = geohash = Geohash.toGeohash(gcs, center_point, 8);
        }
        part_indices.Sort(0, part_indices.size(), new Parts_comparer(geohashes));
        Geometry sorted_geometry = geometry.createInstance();
        for (int i = 0; i < part_count; ++i) {
            int part = part_indices.read(i);
            if (Geometry.isMultiPath(geometry_type.value())) {
                ((MultiPath)sorted_geometry).addPath((MultiPath)geometry, part, true);
                continue;
            }
            ((MultiPoint)sorted_geometry).add((MultiPoint)geometry, part, part + 1);
        }
        return sorted_geometry;
    }

    private static boolean is_segment_buffer_in_gnomonic_(double a, double e_squared, ArrayList<Point2D> densified_points, double great_elliptic_buffer_distance, Point2D gnomonic_center_rad, double min_gnomonic_radius) {
        if (great_elliptic_buffer_distance >= min_gnomonic_radius) {
            return false;
        }
        Point2D pt_start_rad = densified_points.get(0);
        Point2D pt_end_rad = densified_points.get(densified_points.size() - 1);
        PeDouble pe_great_elliptic_dist_to_start = new PeDouble();
        PeDouble pe_great_elliptic_dist_to_end = new PeDouble();
        PeDouble pe_great_elliptic_length = new PeDouble();
        PeLineType.great_elliptic_distance((double)a, (double)e_squared, (double)gnomonic_center_rad.x, (double)gnomonic_center_rad.y, (double)pt_start_rad.x, (double)pt_start_rad.y, (PeDouble)pe_great_elliptic_dist_to_start, null, null);
        PeLineType.great_elliptic_distance((double)a, (double)e_squared, (double)gnomonic_center_rad.x, (double)gnomonic_center_rad.y, (double)pt_end_rad.x, (double)pt_end_rad.y, (PeDouble)pe_great_elliptic_dist_to_end, null, null);
        PeLineType.great_elliptic_distance((double)a, (double)e_squared, (double)pt_start_rad.x, (double)pt_start_rad.y, (double)pt_end_rad.x, (double)pt_end_rad.y, (PeDouble)pe_great_elliptic_length, null, null);
        double min_dist_to_end_point = Math.min(pe_great_elliptic_dist_to_start.val, pe_great_elliptic_dist_to_end.val);
        double max_dist_to_point = min_dist_to_end_point + pe_great_elliptic_length.val;
        double max_buffer_distance_from_center = max_dist_to_point + great_elliptic_buffer_distance;
        if (max_buffer_distance_from_center < min_gnomonic_radius) {
            return true;
        }
        PeDouble pe_great_elliptic_dist = new PeDouble();
        max_dist_to_point = Math.max(pe_great_elliptic_dist_to_start.val, pe_great_elliptic_dist_to_end.val);
        for (int i = 1; i < densified_points.size() - 1; ++i) {
            Point2D pt_i_rad = densified_points.get(i);
            PeLineType.great_elliptic_distance((double)a, (double)e_squared, (double)gnomonic_center_rad.x, (double)gnomonic_center_rad.y, (double)pt_i_rad.x, (double)pt_i_rad.y, (PeDouble)pe_great_elliptic_dist, null, null);
            if (!(pe_great_elliptic_dist.val > max_dist_to_point)) continue;
            max_dist_to_point = pe_great_elliptic_dist.val;
        }
        max_buffer_distance_from_center = max_dist_to_point + great_elliptic_buffer_distance;
        return max_buffer_distance_from_center < min_gnomonic_radius;
    }

    private static boolean can_segment_buffer_fit_in_a_gnomonic_(double a, double e_squared, double rpu, ArrayList<Point2D> densified_points, double great_elliptic_buffer_distance, Point2D p_center_in_gcs_units, Point2D p_gnomonic_center_rad, double[] p_min_gnomonic_radius) {
        Point2D c;
        int i;
        if (densified_points.size() % 2 == 0) {
            i = densified_points.size() >> 1;
            Point2D pt_i = densified_points.get(i);
            Point2D pt_j = densified_points.get(i - 1);
            c = new Point2D();
            c.interpolate(pt_i, pt_j, 0.5);
        } else {
            i = densified_points.size() - 1 >> 1;
            c = densified_points.get(i);
        }
        Point2D gnomonic_center_rad = c;
        double min_gnomonic_radius = Gnomonic.calculate_tight_radius_in_meters(a, e_squared, gnomonic_center_rad);
        if (!GeodesicBufferer.is_segment_buffer_in_gnomonic_(a, e_squared, densified_points, great_elliptic_buffer_distance, gnomonic_center_rad, min_gnomonic_radius)) {
            return false;
        }
        if (p_center_in_gcs_units != null) {
            p_center_in_gcs_units.setCoords(gnomonic_center_rad);
            p_center_in_gcs_units.scale(1.0 / rpu);
        }
        if (p_gnomonic_center_rad != null) {
            p_gnomonic_center_rad.setCoords(gnomonic_center_rad);
        }
        if (p_min_gnomonic_radius != null) {
            p_min_gnomonic_radius[0] = min_gnomonic_radius;
        }
        return true;
    }

    private static boolean is_point_buffer_in_gnomonic_(double a, double e_squared, Point2D point_rad, double great_elliptic_buffer_distance, Point2D gnomonic_center_rad, double min_gnomonic_radius) {
        if (great_elliptic_buffer_distance >= min_gnomonic_radius) {
            return false;
        }
        PeDouble pe_great_elliptic_dist_to_point = new PeDouble();
        PeLineType.great_elliptic_distance((double)a, (double)e_squared, (double)gnomonic_center_rad.x, (double)gnomonic_center_rad.y, (double)point_rad.x, (double)point_rad.y, (PeDouble)pe_great_elliptic_dist_to_point, null, null);
        double max_buffer_distance_from_center = pe_great_elliptic_dist_to_point.val + great_elliptic_buffer_distance;
        return max_buffer_distance_from_center < min_gnomonic_radius;
    }

    private static boolean can_point_buffer_fit_in_a_gnomonic_(double a, double e_squared, double rpu, Point2D point_rad, double great_elliptic_buffer_distance, Point2D p_center_in_gcs_units, Point2D p_gnomonic_center_rad, double[] p_min_gnomonic_radius) {
        double min_gnomonic_radius = Gnomonic.calculate_tight_radius_in_meters(a, e_squared, point_rad);
        if (!GeodesicBufferer.is_point_buffer_in_gnomonic_(a, e_squared, point_rad, great_elliptic_buffer_distance, point_rad, min_gnomonic_radius)) {
            return false;
        }
        if (p_center_in_gcs_units != null) {
            p_center_in_gcs_units.setCoords(point_rad);
            p_center_in_gcs_units.scale(1.0 / rpu);
        }
        if (p_gnomonic_center_rad != null) {
            p_gnomonic_center_rad.setCoords(point_rad);
        }
        if (p_min_gnomonic_radius != null) {
            p_min_gnomonic_radius[0] = min_gnomonic_radius;
        }
        return true;
    }

    private static Gnomonic get_gnomonic_(SpatialReference gcs, Point2D center_in_gcs_units) {
        Gnomonic gnomonic = new Gnomonic(gcs, center_in_gcs_units);
        return gnomonic;
    }

    private void set_min_corner_step_() {
        double step;
        double d = Math.min(Math.PI * this.m_a - this.m_abs_distance, this.m_abs_distance);
        d = Math.min(d, this.m_a * 0.125 * Math.PI);
        Point2D corner = new Point2D();
        corner.setCoords(0.0, 10.0 * this.m_rpu);
        double left_azimuth = 0.0;
        double right_azimuth = 45.0 * this.m_rpu;
        PeDouble pe_left_buffered_point_0 = new PeDouble();
        PeDouble pe_left_buffered_point_1 = new PeDouble();
        PeDouble pe_right_buffered_point_0 = new PeDouble();
        PeDouble pe_right_buffered_point_1 = new PeDouble();
        PeDouble pe_mid_buffered_point_0 = new PeDouble();
        PeDouble pe_mid_buffered_point_1 = new PeDouble();
        PeDouble pe_interpolated_buffered_point_0 = new PeDouble();
        PeDouble pe_interpolated_buffered_point_1 = new PeDouble();
        Point2D left_buffered_point = new Point2D();
        Point2D right_buffered_point = new Point2D();
        Point2D mid_buffered_point = new Point2D();
        Point2D interpolated_buffered_point = new Point2D();
        GeodesicBufferer.geodesic_coordinate_(this.m_a, this.m_e_squared, corner.x, corner.y, d, left_azimuth, pe_left_buffered_point_0, pe_left_buffered_point_1);
        left_buffered_point.setCoords(pe_left_buffered_point_0.val, pe_left_buffered_point_1.val);
        GeodesicBufferer.geodesic_coordinate_(this.m_a, this.m_e_squared, corner.x, corner.y, d, right_azimuth, pe_right_buffered_point_0, pe_right_buffered_point_1);
        right_buffered_point.setCoords(pe_right_buffered_point_0.val, pe_right_buffered_point_1.val);
        PeDouble pe_left_right_length = new PeDouble();
        PeDouble pe_azimuth = new PeDouble();
        PeDouble pe_offset = new PeDouble();
        while (true) {
            double mid_azimuth = 0.5 * (left_azimuth + right_azimuth);
            GeodesicBufferer.geodesic_coordinate_(this.m_a, this.m_e_squared, corner.x, corner.y, d, mid_azimuth, pe_mid_buffered_point_0, pe_mid_buffered_point_1);
            mid_buffered_point.setCoords(pe_mid_buffered_point_0.val, pe_mid_buffered_point_1.val);
            PeLineType.geodetic_distance((double)this.m_a, (double)this.m_e_squared, (double)left_buffered_point.x, (double)left_buffered_point.y, (double)right_buffered_point.x, (double)right_buffered_point.y, (PeDouble)pe_left_right_length, (PeDouble)pe_azimuth, null, (int)2);
            PeLineType.geodetic_coordinate((double)this.m_a, (double)this.m_e_squared, (double)left_buffered_point.x, (double)left_buffered_point.y, (double)(0.5 * pe_left_right_length.val), (double)pe_azimuth.val, (PeDouble)pe_interpolated_buffered_point_0, (PeDouble)pe_interpolated_buffered_point_1, (int)2);
            interpolated_buffered_point.setCoords(pe_interpolated_buffered_point_0.val, pe_interpolated_buffered_point_1.val);
            PeLineType.geodetic_distance((double)this.m_a, (double)this.m_e_squared, (double)mid_buffered_point.x, (double)mid_buffered_point.y, (double)interpolated_buffered_point.x, (double)interpolated_buffered_point.y, (PeDouble)pe_offset, null, null, (int)2);
            double offset = pe_offset.val;
            if (offset <= this.m_convergence_offset) break;
            right_azimuth = 0.9 * right_azimuth;
            GeodesicBufferer.geodesic_coordinate_(this.m_a, this.m_e_squared, corner.x, corner.y, d, right_azimuth, pe_right_buffered_point_0, pe_right_buffered_point_1);
            right_buffered_point.setCoords(pe_right_buffered_point_0.val, pe_right_buffered_point_1.val);
        }
        double azimuth = right_azimuth - left_azimuth;
        this.m_corner_step = step = Math.PI * 2 / Math.ceil(Math.PI * 2 / azimuth);
    }

    private void set_min_segment_step_() {
        double d = Math.min(Math.PI * this.m_a - this.m_abs_distance, this.m_abs_distance);
        d = Math.min(d, this.m_a * 0.125 * Math.PI);
        Point2D left_geodetic_point = new Point2D();
        Point2D right_geodetic_point = new Point2D();
        left_geodetic_point.setCoords(0.0, 10.0 * this.m_rpu);
        right_geodetic_point.setCoords(10.0 * this.m_rpu, 10.0 * this.m_rpu);
        PeDouble pe_az_s_e = new PeDouble();
        PeDouble pe_az_e_s = new PeDouble();
        PeDouble pe_geodetic_distance = new PeDouble();
        PeLineType.geodetic_distance((double)this.m_a, (double)this.m_e_squared, (double)left_geodetic_point.x, (double)left_geodetic_point.y, (double)right_geodetic_point.x, (double)right_geodetic_point.y, (PeDouble)pe_geodetic_distance, (PeDouble)pe_az_s_e, (PeDouble)pe_az_e_s, (int)this.m_curve_type);
        PeDouble pe_mid_geodetic_point_0 = new PeDouble();
        PeDouble pe_mid_geodetic_point_1 = new PeDouble();
        PeDouble pe_right_geodetic_point_0 = new PeDouble();
        PeDouble pe_right_geodetic_point_1 = new PeDouble();
        Point2D mid_geodetic_point = new Point2D();
        PeDouble pe_mid_az = new PeDouble();
        PeDouble pe_left_buffered_point_0 = new PeDouble();
        PeDouble pe_left_buffered_point_1 = new PeDouble();
        PeDouble pe_right_buffered_point_0 = new PeDouble();
        PeDouble pe_right_buffered_point_1 = new PeDouble();
        PeDouble pe_mid_buffered_point_0 = new PeDouble();
        PeDouble pe_mid_buffered_point_1 = new PeDouble();
        PeDouble pe_interpolated_buffered_point_0 = new PeDouble();
        PeDouble pe_interpolated_buffered_point_1 = new PeDouble();
        Point2D left_buffered_point = new Point2D();
        Point2D right_buffered_point = new Point2D();
        Point2D mid_buffered_point = new Point2D();
        Point2D interpolated_buffered_point = new Point2D();
        double left_factor = 0.0;
        double right_factor = 1.0;
        double az_s_e = pe_az_s_e.val;
        double az_e_s = pe_az_e_s.val;
        double az_start_perp = az_s_e - 1.5707963267948966;
        double az_end_perp = az_e_s + 1.5707963267948966;
        double geodetic_length = pe_geodetic_distance.val;
        GeodesicBufferer.geodesic_coordinate_(this.m_a, this.m_e_squared, left_geodetic_point.x, left_geodetic_point.y, d, az_start_perp, pe_left_buffered_point_0, pe_left_buffered_point_1);
        left_buffered_point.setCoords(pe_left_buffered_point_0.val, pe_left_buffered_point_1.val);
        GeodesicBufferer.geodesic_coordinate_(this.m_a, this.m_e_squared, right_geodetic_point.x, right_geodetic_point.y, d, az_end_perp, pe_right_buffered_point_0, pe_right_buffered_point_1);
        right_buffered_point.setCoords(pe_right_buffered_point_0.val, pe_right_buffered_point_1.val);
        PeDouble pe_left_right_length = new PeDouble();
        PeDouble pe_left_right_azimuth = new PeDouble();
        PeDouble pe_offset = new PeDouble();
        PeDouble pe_right_az = new PeDouble();
        while (true) {
            double mid_factor = 0.5 * (left_factor + right_factor);
            PeLineType.geodetic_coordinate((double)this.m_a, (double)this.m_e_squared, (double)left_geodetic_point.x, (double)left_geodetic_point.y, (double)(mid_factor * geodetic_length), (double)az_s_e, (PeDouble)pe_mid_geodetic_point_0, (PeDouble)pe_mid_geodetic_point_1, (int)this.m_curve_type);
            mid_geodetic_point.setCoords(pe_mid_geodetic_point_0.val, pe_mid_geodetic_point_1.val);
            PeLineType.geodetic_distance((double)this.m_a, (double)this.m_e_squared, (double)left_geodetic_point.x, (double)left_geodetic_point.y, (double)mid_geodetic_point.x, (double)mid_geodetic_point.y, null, null, (PeDouble)pe_mid_az, (int)this.m_curve_type);
            double mid_az_perp = pe_mid_az.val + 1.5707963267948966;
            GeodesicBufferer.geodesic_coordinate_(this.m_a, this.m_e_squared, mid_geodetic_point.x, mid_geodetic_point.y, d, mid_az_perp, pe_mid_buffered_point_0, pe_mid_buffered_point_1);
            mid_buffered_point.setCoords(pe_mid_buffered_point_0.val, pe_mid_buffered_point_1.val);
            PeLineType.geodetic_distance((double)this.m_a, (double)this.m_e_squared, (double)left_buffered_point.x, (double)left_buffered_point.y, (double)right_buffered_point.x, (double)right_buffered_point.y, (PeDouble)pe_left_right_length, (PeDouble)pe_left_right_azimuth, null, (int)2);
            PeLineType.geodetic_coordinate((double)this.m_a, (double)this.m_e_squared, (double)left_buffered_point.x, (double)left_buffered_point.y, (double)(0.5 * pe_left_right_length.val), (double)pe_left_right_azimuth.val, (PeDouble)pe_interpolated_buffered_point_0, (PeDouble)pe_interpolated_buffered_point_1, (int)2);
            interpolated_buffered_point.setCoords(pe_interpolated_buffered_point_0.val, pe_interpolated_buffered_point_1.val);
            PeLineType.geodetic_distance((double)this.m_a, (double)this.m_e_squared, (double)mid_buffered_point.x, (double)mid_buffered_point.y, (double)interpolated_buffered_point.x, (double)interpolated_buffered_point.y, (PeDouble)pe_offset, null, null, (int)2);
            double offset = pe_offset.val;
            if (offset <= this.m_convergence_offset) break;
            right_factor = 0.9 * right_factor;
            PeLineType.geodetic_coordinate((double)this.m_a, (double)this.m_e_squared, (double)left_geodetic_point.x, (double)left_geodetic_point.y, (double)(right_factor * geodetic_length), (double)az_s_e, (PeDouble)pe_right_geodetic_point_0, (PeDouble)pe_right_geodetic_point_1, (int)this.m_curve_type);
            right_geodetic_point.setCoords(pe_right_geodetic_point_0.val, pe_right_geodetic_point_1.val);
            PeLineType.geodetic_distance((double)this.m_a, (double)this.m_e_squared, (double)left_geodetic_point.x, (double)left_geodetic_point.y, (double)right_geodetic_point.x, (double)right_geodetic_point.y, null, null, (PeDouble)pe_right_az, (int)this.m_curve_type);
            double right_az_perp = pe_right_az.val + 1.5707963267948966;
            GeodesicBufferer.geodesic_coordinate_(this.m_a, this.m_e_squared, right_geodetic_point.x, right_geodetic_point.y, d, right_az_perp, pe_right_buffered_point_0, pe_right_buffered_point_1);
            right_buffered_point.setCoords(pe_right_buffered_point_0.val, pe_right_buffered_point_1.val);
        }
        double segment_step = right_factor * geodetic_length;
        if (segment_step > 100000.0) {
            segment_step = 100000.0;
        }
        this.m_segment_step = segment_step;
    }

    private void set_convergence_offset_() {
        double convergence_offset = this.m_abs_distance > 50000.0 ? 100.0 : (this.m_abs_distance > 10000.0 ? 10.0 : 1.0);
        if (this.m_abs_distance / convergence_offset < 500.0) {
            convergence_offset = this.m_abs_distance / 500.0;
        }
        if (convergence_offset < 0.01) {
            convergence_offset = 0.01;
        }
        this.m_convergence_offset = convergence_offset;
    }

    public static class Parts_comparer
    extends AttributeStreamOfInt32.IntComparator {
        private String[] m_geohashes;

        Parts_comparer(String[] geohashes) {
            this.m_geohashes = geohashes;
        }

        @Override
        public int compare(int i, int j) {
            return this.m_geohashes[i].compareTo(this.m_geohashes[j]);
        }
    }

    private static class Geometry_cursor_for_multi_point
    extends Geometry_cursor_for_gnomonic_buffer_pieces {
        private GeodesicBufferer m_bufferer;
        private MultiPoint m_multi_point;
        private int m_point_index;

        Geometry_cursor_for_multi_point(GeodesicBufferer bufferer, MultiPoint multi_point) {
            this.m_bufferer = bufferer;
            this.m_multi_point = multi_point;
            this.m_point_index = -1;
            this.m_b_needs_simplify = false;
            Envelope2D env = new Envelope2D();
            this.m_multi_point.queryEnvelope2D(env);
            Point2D center_in_gcs_units = env.getCenter();
            Point2D center_in_rad_units = new Point2D();
            center_in_rad_units.scale(this.m_bufferer.m_rpu, center_in_gcs_units);
            this.m_gnomonic = GeodesicBufferer.get_gnomonic_(this.m_bufferer.m_gcs, center_in_gcs_units);
            this.m_gnomonic_center_rad = center_in_rad_units;
            this.m_min_gnomonic_radius = Gnomonic.calculate_tight_radius_in_meters(this.m_bufferer.m_a, this.m_bufferer.m_e_squared, center_in_rad_units);
        }

        @Override
        public Polygon next() {
            boolean b_wraps_pole;
            this.m_b_needs_simplify = false;
            if (++this.m_point_index == this.m_multi_point.getPointCount()) {
                return null;
            }
            Point2D pt = new Point2D();
            this.m_multi_point.getXY(this.m_point_index, pt);
            pt.scale(this.m_bufferer.m_rpu);
            this.m_b_running_in_gnomonic = this.is_point_buffer_in_current_gnomonic_(pt);
            if (!this.m_b_running_in_gnomonic) {
                this.m_b_running_in_gnomonic = this.try_update_gnomonic_(pt);
            }
            Polygon buffer = new Polygon();
            this.m_b_needs_simplify = b_wraps_pole = this.m_bufferer.buffer_point_(pt, this.m_b_running_in_gnomonic, buffer);
            return buffer;
        }

        private boolean is_point_buffer_in_current_gnomonic_(Point2D point_rad) {
            if (this.m_gnomonic == null) {
                return false;
            }
            return GeodesicBufferer.is_point_buffer_in_gnomonic_(this.m_bufferer.m_a, this.m_bufferer.m_e_squared, point_rad, this.m_bufferer.m_abs_distance * this.m_bufferer.m_elliptic_to_geodesic_max_ratio, this.m_gnomonic_center_rad, this.m_min_gnomonic_radius);
        }

        private boolean try_update_gnomonic_(Point2D point) {
            Point2D center_in_gcs_units = new Point2D();
            Point2D gnomonic_center_rad = new Point2D();
            double[] min_gnomonic_radius = new double[]{NumberUtils.NaN()};
            if (!GeodesicBufferer.can_point_buffer_fit_in_a_gnomonic_(this.m_bufferer.m_a, this.m_bufferer.m_e_squared, this.m_bufferer.m_rpu, point, this.m_bufferer.m_abs_distance * this.m_bufferer.m_elliptic_to_geodesic_max_ratio, center_in_gcs_units, gnomonic_center_rad, min_gnomonic_radius)) {
                this.m_gnomonic = null;
                return false;
            }
            this.m_gnomonic_center_rad.setCoords(gnomonic_center_rad);
            this.m_min_gnomonic_radius = min_gnomonic_radius[0];
            this.m_gnomonic = GeodesicBufferer.get_gnomonic_(this.m_bufferer.m_gcs, center_in_gcs_units);
            return true;
        }
    }

    private static class Geometry_cursor_for_multi_path
    extends Geometry_cursor_for_gnomonic_buffer_pieces {
        private GeodesicBufferer m_bufferer;
        private MultiPath m_multi_path;
        private SegmentIteratorImpl m_seg_iter;
        private boolean m_b_next_segment_cannot_join;
        private double[] m_current_densified_delta;
        private double[] m_current_buffered_delta;
        private double m_last_azimuth;
        private double[] m_start_azimuth;
        private double[] m_end_azimuth;
        private int m_num_winds;
        private Polygon m_buffer_helper;
        private ArrayList<Point2D> m_densified_points;
        MultiPath m_densified;

        Geometry_cursor_for_multi_path(GeodesicBufferer bufferer, MultiPath multi_path, MultiPath densified) {
            this.m_bufferer = bufferer;
            this.m_multi_path = multi_path;
            this.m_b_next_segment_cannot_join = false;
            this.m_densified = densified;
            this.m_b_needs_simplify = true;
            this.m_current_densified_delta = new double[1];
            this.m_current_buffered_delta = new double[1];
            this.m_start_azimuth = new double[1];
            this.m_end_azimuth = new double[1];
            this.m_buffer_helper = new Polygon();
            this.m_densified_points = new ArrayList(0);
            Envelope2D env = new Envelope2D();
            this.m_multi_path.queryEnvelope2D(env);
            Point2D center_in_gcs_units = env.getCenter();
            Point2D center_in_rad_units = new Point2D();
            center_in_rad_units.scale(this.m_bufferer.m_rpu, center_in_gcs_units);
            this.m_gnomonic = GeodesicBufferer.get_gnomonic_(this.m_bufferer.m_gcs, center_in_gcs_units);
            this.m_gnomonic_center_rad = center_in_rad_units;
            this.m_min_gnomonic_radius = Gnomonic.calculate_tight_radius_in_meters(this.m_bufferer.m_a, this.m_bufferer.m_e_squared, center_in_rad_units);
        }

        @Override
        public Polygon next() {
            Polygon buffer_piece = null;
            if (this.m_b_next_segment_cannot_join) {
                this.m_b_next_segment_cannot_join = false;
                this.m_seg_iter.nextSegment();
                buffer_piece = (Polygon)Geometry._clone(this.m_buffer_helper);
                return buffer_piece;
            }
            if (this.m_seg_iter == null) {
                this.m_seg_iter = ((MultiPathImpl)this.m_multi_path._getImpl()).querySegmentIterator();
                this.m_seg_iter.nextPath();
                if (this.m_densified != null) {
                    this.m_densified.addPath((Point2D[])null, 0, true);
                }
            }
            if (!this.m_seg_iter.hasNextSegment()) {
                if (!this.m_seg_iter.nextPath()) {
                    return null;
                }
                if (this.m_densified != null) {
                    this.m_densified.addPath((Point2D[])null, 0, true);
                }
            }
            Polygon running_buffer = null;
            this.m_current_buffered_delta[0] = 0.0;
            this.m_current_densified_delta[0] = 0.0;
            this.m_num_winds = 0;
            this.m_last_azimuth = NumberUtils.NaN();
            this.m_b_next_segment_cannot_join = false;
            this.m_densified_points.clear();
            int max_winds = 16;
            int i = 0;
            Point2D pt_start = new Point2D();
            Point2D pt_end = new Point2D();
            double[] geodetic_length = new double[1];
            while (this.m_seg_iter.hasNextSegment() && this.m_num_winds < 16) {
                Segment segment = this.m_seg_iter.nextSegment();
                segment.getStartXY(pt_start);
                segment.getEndXY(pt_end);
                pt_start.scale(this.m_bufferer.m_rpu);
                pt_end.scale(this.m_bufferer.m_rpu);
                if (GeodeticDensify.checkStartForPoleTouch(pt_start, pt_end)) {
                    pt_start.x = pt_end.x;
                } else if (GeodeticDensify.checkEndForPoleTouch(pt_start, pt_end)) {
                    pt_end.x = pt_start.x;
                } else {
                    int prev_index = -1;
                    int next_index = -1;
                    int path_index = this.m_seg_iter.getPathIndex();
                    int path_start = this.m_multi_path.getPathStart(path_index);
                    int path_end = this.m_multi_path.getPathEnd(path_index);
                    int start_point_index = this.m_seg_iter.getStartPointIndex();
                    int end_point_index = this.m_seg_iter.getEndPointIndex();
                    prev_index = start_point_index - 1;
                    next_index = end_point_index + 1;
                    if (prev_index < path_start) {
                        prev_index = !this.m_multi_path.isClosedPath(path_index) ? -1 : path_end - 1;
                    }
                    if (next_index > path_end - 1) {
                        next_index = !this.m_multi_path.isClosedPath(path_index) ? -1 : path_start;
                    }
                    if (prev_index != -1) {
                        Point2D pt_prev = this.m_multi_path.getXY(prev_index);
                        pt_prev.scale(this.m_bufferer.m_rpu);
                        if (GeodeticDensify.checkEndForPoleTouch(pt_prev, pt_start)) {
                            pt_start.x = pt_prev.x;
                        }
                    }
                    if (next_index != -1) {
                        Point2D pt_next = this.m_multi_path.getXY(next_index);
                        pt_next.scale(this.m_bufferer.m_rpu);
                        if (GeodeticDensify.checkStartForPoleTouch(pt_end, pt_next)) {
                            pt_end.x = pt_next.x;
                        }
                    }
                }
                this.m_densified_points.clear();
                GeodeticDensify.geodeticDensifySegment(this.m_bufferer.m_a, this.m_bufferer.m_e_squared, this.m_bufferer.m_curve_type, pt_start, pt_end, this.m_bufferer.m_segment_step, NumberUtils.NaN(), this.m_bufferer.m_rad_tolerance, geodetic_length, this.m_start_azimuth, this.m_end_azimuth, this.m_densified_points, this.m_current_densified_delta);
                if (i == 0) {
                    this.m_b_running_in_gnomonic = this.is_segment_buffer_in_current_gnomonic_(this.m_densified_points);
                    if (!this.m_b_running_in_gnomonic) {
                        this.m_b_running_in_gnomonic = this.try_update_gnomonic_(this.m_densified_points);
                    }
                } else if (this.m_b_running_in_gnomonic) {
                    boolean b_in_gnomonic = this.is_segment_buffer_in_current_gnomonic_(this.m_densified_points);
                    if (!b_in_gnomonic) {
                        this.m_seg_iter.previousSegment();
                        this.m_seg_iter.previousSegment();
                        this.m_seg_iter.nextSegment();
                        break;
                    }
                } else {
                    boolean b_can_fit_in_gnomonic = GeodesicBufferer.can_segment_buffer_fit_in_a_gnomonic_(this.m_bufferer.m_a, this.m_bufferer.m_e_squared, this.m_bufferer.m_rpu, this.m_densified_points, this.m_bufferer.m_abs_distance * this.m_bufferer.m_elliptic_to_geodesic_max_ratio, null, null, null);
                    if (b_can_fit_in_gnomonic) {
                        this.m_seg_iter.previousSegment();
                        this.m_seg_iter.previousSegment();
                        this.m_seg_iter.nextSegment();
                        break;
                    }
                }
                if (geodetic_length[0] == 0.0 || GeodeticDensify.checkForWithinPole(pt_start, pt_end)) {
                    this.m_buffer_helper.setEmpty();
                    this.m_bufferer.buffer_point_(pt_start, this.m_b_running_in_gnomonic, this.m_buffer_helper);
                    this.m_b_next_segment_cannot_join = true;
                    assert (this.m_b_next_segment_cannot_join);
                } else {
                    this.m_buffer_helper.setEmpty();
                    this.m_b_next_segment_cannot_join = this.check_and_prep_segment_for_crossing_azimuths_or_pole_wrap_(geodetic_length[0], this.m_buffer_helper);
                }
                if (this.m_b_next_segment_cannot_join) {
                    this.m_seg_iter.previousSegment();
                    if (this.m_seg_iter.hasPreviousSegment()) {
                        this.m_seg_iter.previousSegment();
                        this.m_seg_iter.nextSegment();
                    } else {
                        assert (i == 0);
                        this.m_seg_iter.resetToFirstSegment();
                    }
                    if (this.m_densified == null) break;
                    Point2D[] densified_points = this.m_densified_points.toArray(new Point2D[this.m_densified_points.size()]);
                    this.m_densified.insertPoints(this.m_densified.getPathCount() - 1, -1, densified_points, 0, densified_points.length - 1, true);
                    break;
                }
                if (this.m_densified != null) {
                    Point2D[] densified_points = this.m_densified_points.toArray(new Point2D[this.m_densified_points.size()]);
                    this.m_densified.insertPoints(this.m_densified.getPathCount() - 1, -1, densified_points, 0, densified_points.length - 1, true);
                }
                if (running_buffer == null) {
                    running_buffer = new Polygon();
                    running_buffer.addPath((Point2D[])null, 0, true);
                }
                this.add_join_and_buffer_left_side_(running_buffer);
                ++i;
            }
            this.m_current_densified_delta[0] = 0.0;
            if (i > 0) {
                int last_segment = this.m_seg_iter.getStartPointIndex();
                int last_path = this.m_seg_iter.getPathIndex();
                while (i > 0) {
                    this.m_seg_iter.previousSegment();
                    pt_start.setCoords(this.m_multi_path.getXY(this.m_seg_iter.getStartPointIndex()));
                    pt_end.setCoords(this.m_multi_path.getXY(this.m_seg_iter.getEndPointIndex()));
                    pt_start.scale(this.m_bufferer.m_rpu);
                    pt_end.scale(this.m_bufferer.m_rpu);
                    if (this.m_b_running_in_gnomonic) {
                        if (GeodeticDensify.checkStartForPoleTouch(pt_start, pt_end)) {
                            pt_start.x = pt_end.x;
                        } else if (GeodeticDensify.checkEndForPoleTouch(pt_start, pt_end)) {
                            pt_end.x = pt_start.x;
                        } else {
                            int prev_index = -1;
                            int next_index = -1;
                            int path_index = this.m_seg_iter.getPathIndex();
                            int path_start = this.m_multi_path.getPathStart(path_index);
                            int path_end = this.m_multi_path.getPathEnd(path_index);
                            int start_point_index = this.m_seg_iter.getStartPointIndex();
                            int end_point_index = this.m_seg_iter.getEndPointIndex();
                            prev_index = start_point_index - 1;
                            next_index = end_point_index + 1;
                            if (prev_index < path_start) {
                                prev_index = !this.m_multi_path.isClosedPath(path_index) ? -1 : path_end - 1;
                            }
                            if (next_index > path_end - 1) {
                                next_index = !this.m_multi_path.isClosedPath(path_index) ? -1 : path_start;
                            }
                            if (prev_index != -1) {
                                Point2D pt_prev = this.m_multi_path.getXY(prev_index);
                                pt_prev.scale(this.m_bufferer.m_rpu);
                                if (GeodeticDensify.checkEndForPoleTouch(pt_prev, pt_start)) {
                                    pt_start.x = pt_prev.x;
                                }
                            }
                            if (next_index != -1) {
                                Point2D pt_next = this.m_multi_path.getXY(next_index);
                                pt_next.scale(this.m_bufferer.m_rpu);
                                if (GeodeticDensify.checkStartForPoleTouch(pt_end, pt_next)) {
                                    pt_end.x = pt_next.x;
                                }
                            }
                        }
                    }
                    this.m_densified_points.clear();
                    GeodeticDensify.geodeticDensifySegment(this.m_bufferer.m_a, this.m_bufferer.m_e_squared, this.m_bufferer.m_curve_type, pt_end, pt_start, this.m_bufferer.m_segment_step, NumberUtils.NaN(), this.m_bufferer.m_rad_tolerance, null, this.m_start_azimuth, this.m_end_azimuth, this.m_densified_points, this.m_current_densified_delta);
                    this.add_join_and_buffer_left_side_(running_buffer);
                    --i;
                }
                pt_start.setCoords(this.m_multi_path.getXY(this.m_seg_iter.getStartPointIndex()));
                pt_start.scale(this.m_bufferer.m_rpu);
                GeodesicBufferer.buffer_corner_(this.m_bufferer.m_a, this.m_bufferer.m_e_squared, this.m_bufferer.m_rpu, this.m_bufferer.m_abs_distance, pt_start, this.m_last_azimuth + 1.5707963267948966, this.m_last_azimuth + 4.71238898038469, this.m_bufferer.m_corner_step, this.m_b_running_in_gnomonic, this.m_current_buffered_delta, running_buffer, NumberUtils.NaN(), NumberUtils.NaN());
                this.m_seg_iter.resetToVertex(last_segment, last_path);
                this.m_seg_iter.nextSegment();
                return running_buffer;
            }
            assert (this.m_b_next_segment_cannot_join);
            this.m_b_next_segment_cannot_join = false;
            this.m_seg_iter.nextSegment();
            buffer_piece = (Polygon)Geometry._clone(this.m_buffer_helper);
            return buffer_piece;
        }

        private boolean is_segment_buffer_in_current_gnomonic_(ArrayList<Point2D> densified_points) {
            if (this.m_gnomonic == null) {
                return false;
            }
            return GeodesicBufferer.is_segment_buffer_in_gnomonic_(this.m_bufferer.m_a, this.m_bufferer.m_e_squared, densified_points, this.m_bufferer.m_abs_distance * this.m_bufferer.m_elliptic_to_geodesic_max_ratio, this.m_gnomonic_center_rad, this.m_min_gnomonic_radius);
        }

        private boolean try_update_gnomonic_(ArrayList<Point2D> densified_points) {
            Point2D center_in_gcs_units = new Point2D();
            Point2D gnomonic_center_rad = new Point2D();
            double[] min_gnomonic_radius = new double[]{NumberUtils.NaN()};
            if (!GeodesicBufferer.can_segment_buffer_fit_in_a_gnomonic_(this.m_bufferer.m_a, this.m_bufferer.m_e_squared, this.m_bufferer.m_rpu, densified_points, this.m_bufferer.m_abs_distance * this.m_bufferer.m_elliptic_to_geodesic_max_ratio, center_in_gcs_units, gnomonic_center_rad, min_gnomonic_radius)) {
                this.m_gnomonic = null;
                return false;
            }
            this.m_gnomonic_center_rad.setCoords(gnomonic_center_rad);
            this.m_min_gnomonic_radius = min_gnomonic_radius[0];
            this.m_gnomonic = GeodesicBufferer.get_gnomonic_(this.m_bufferer.m_gcs, center_in_gcs_units);
            return true;
        }

        private void add_join_and_buffer_left_side_(Polygon running_buffer) {
            Point2D pt_start = this.m_densified_points.get(0);
            double last_perp = NumberUtils.NaN();
            double start_perp = this.m_start_azimuth[0] - 1.5707963267948966;
            double end_perp = this.m_end_azimuth[0] + 1.5707963267948966;
            boolean b_wind = false;
            if (!NumberUtils.isNaN(this.m_last_azimuth)) {
                if (this.m_last_azimuth >= this.m_start_azimuth[0]) {
                    last_perp = this.m_last_azimuth + 1.5707963267948966;
                    start_perp = last_perp + Math.PI - (this.m_last_azimuth - this.m_start_azimuth[0]);
                } else {
                    last_perp = this.m_last_azimuth + 1.5707963267948966;
                    start_perp = last_perp + Math.PI - (Math.PI * 2 - (this.m_start_azimuth[0] - this.m_last_azimuth));
                }
                b_wind = this.m_last_azimuth >= this.m_start_azimuth[0] && this.m_last_azimuth - this.m_start_azimuth[0] <= Math.PI ? false : !(this.m_last_azimuth < this.m_start_azimuth[0]) || !(this.m_start_azimuth[0] - this.m_last_azimuth >= Math.PI);
                boolean b_remove_last_point = false;
                if (Math.abs(start_perp - last_perp) <= 0.5 * this.m_bufferer.m_corner_step && !b_wind) {
                    b_remove_last_point = true;
                }
                if (b_remove_last_point) {
                    running_buffer.removePoint(0, running_buffer.getPointCount() - 1);
                    if (!this.m_b_running_in_gnomonic) {
                        Point2D buffered_point = new Point2D();
                        buffered_point.setCoords(running_buffer.getXY(running_buffer.getPointCount() - 1));
                        buffered_point.scale(this.m_bufferer.m_rpu);
                        if (buffered_point.x - this.m_current_buffered_delta[0] < -Math.PI) {
                            this.m_current_buffered_delta[0] = this.m_current_buffered_delta[0] - Math.PI * 2;
                        } else if (buffered_point.x - this.m_current_buffered_delta[0] > Math.PI) {
                            this.m_current_buffered_delta[0] = this.m_current_buffered_delta[0] + Math.PI * 2;
                        }
                    }
                    assert (!b_wind);
                    start_perp = 0.5 * (start_perp + last_perp);
                } else {
                    assert (!b_remove_last_point);
                    if (b_wind) {
                        assert (running_buffer.getPointCount() > 0);
                        Point2D point = new Point2D();
                        point.setCoords(pt_start);
                        point.scale(1.0 / this.m_bufferer.m_rpu);
                        running_buffer.insertPoint(0, -1, point);
                    } else {
                        GeodesicBufferer.buffer_corner_(this.m_bufferer.m_a, this.m_bufferer.m_e_squared, this.m_bufferer.m_rpu, this.m_bufferer.m_abs_distance, this.m_densified_points.get(0), last_perp, start_perp, this.m_bufferer.m_corner_step, this.m_b_running_in_gnomonic, this.m_current_buffered_delta, running_buffer, NumberUtils.NaN(), NumberUtils.NaN());
                    }
                }
            }
            if (this.m_start_azimuth[0] != this.m_last_azimuth) {
                ++this.m_num_winds;
            }
            GeodesicBufferer.buffer_left_side_(this.m_bufferer.m_a, this.m_bufferer.m_e_squared, this.m_bufferer.m_rpu, this.m_bufferer.m_abs_distance, this.m_bufferer.m_curve_type, this.m_densified_points, start_perp, end_perp, this.m_b_running_in_gnomonic, this.m_current_buffered_delta, running_buffer);
            this.m_last_azimuth = this.m_end_azimuth[0];
        }

        private boolean check_and_prep_segment_for_crossing_azimuths_or_pole_wrap_(double geodetic_length, Polygon buffer) {
            return this.m_bufferer.check_and_prep_segment_for_crossing_azimuths_or_pole_wrap_(this.m_densified_points, geodetic_length, this.m_start_azimuth[0], this.m_end_azimuth[0], this.m_b_running_in_gnomonic, buffer);
        }
    }

    private static abstract class Geometry_cursor_for_gnomonic_buffer_pieces {
        protected boolean m_b_running_in_gnomonic = false;
        protected boolean m_b_needs_simplify;
        protected Gnomonic m_gnomonic = null;
        protected Point2D m_gnomonic_center_rad;
        protected double m_min_gnomonic_radius = NumberUtils.NaN();

        Geometry_cursor_for_gnomonic_buffer_pieces() {
            this.m_gnomonic_center_rad = new Point2D();
            this.m_gnomonic_center_rad.setNaN();
        }

        abstract Polygon next();

        boolean is_running_in_gnomonic() {
            return this.m_b_running_in_gnomonic;
        }

        boolean needs_simplify() {
            return this.m_b_needs_simplify;
        }

        Gnomonic get_gnomonic() {
            return this.m_gnomonic;
        }
    }
}

