/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamOfInt32;
import com.esri.core.geometry.Clusterer;
import com.esri.core.geometry.EditShape;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.ProgressTracker;
import java.util.ArrayList;
import java.util.Comparator;

final class EdgeDissolver {
    private EditShape m_shape = null;
    private ProgressTracker m_progress_tracker;
    private AttributeStreamOfInt32 m_points;
    private int m_points_index = -1;
    private int m_dissolved_edges = 0;
    private int m_progress_counter = 0;

    public static void execute(EditShape shape, int geometry, double cluster_tolerance, ProgressTracker progress_tracker) {
        if (cluster_tolerance > 0.0) {
            Clusterer.executeNonReciprocal(shape, cluster_tolerance, geometry, progress_tracker);
        }
        new EdgeDissolver(progress_tracker).execute_impl_(shape, geometry);
    }

    private void progress_() {
        this.progress_(false);
    }

    private void progress_(boolean bnow) {
        ++this.m_progress_counter;
        if (bnow || (this.m_progress_counter & 0xFFF) == 0) {
            this.m_progress_counter = 0;
            ProgressTracker.checkAndThrow(this.m_progress_tracker);
        }
    }

    EdgeDissolver(ProgressTracker progress_tracker) {
        this.m_progress_tracker = progress_tracker;
    }

    void execute_impl_(EditShape shape, int geometry) {
        int path;
        this.m_shape = shape;
        if (shape.getPathCount(geometry) < 2 && shape.getPointCount(geometry) < 6) {
            return;
        }
        this.m_points = new AttributeStreamOfInt32(0);
        this.m_points.reserve(shape.getPointCount(geometry));
        int path2 = shape.getFirstPath(geometry);
        while (path2 != -1) {
            int vertex = shape.getFirstVertex(path2);
            int nvert = shape.getPathSize(path2);
            for (int ivert = 0; ivert < nvert; ++ivert) {
                this.m_points.add(vertex);
                vertex = shape.getNextVertex(vertex);
            }
            path2 = shape.getNextPath(path2);
        }
        this.m_points_index = shape.createUserIndex();
        int n = this.m_points.size();
        for (int i = 0; i < n; ++i) {
            shape.setUserIndex(this.m_points.get(i), this.m_points_index, i);
        }
        shape.sortVerticesSimpleByY_(this.m_points, 0, this.m_points.size());
        int vertex1 = this.m_points.get(0);
        Point2D pt1 = shape.getXY(vertex1);
        int cluster_size = 1;
        int index0 = 0;
        ArrayList<Edge> bunch = new ArrayList<Edge>();
        Point2D pt = new Point2D();
        for (int index = 1; index < this.m_points.size(); ++index) {
            this.progress_();
            int vertex = this.m_points.get(index);
            if (vertex == -1 || shape.getUserIndex(vertex, this.m_points_index) == -1) continue;
            shape.getXY(vertex, pt);
            if (!pt.isEqual(pt1)) {
                if (cluster_size > 1) {
                    for (int i = index0; i < index; ++i) {
                        Edge edge;
                        int v0 = this.m_points.get(i);
                        if (shape.getUserIndex(v0, this.m_points_index) == -1) continue;
                        int v1 = shape.getNextVertex(v0);
                        int v2 = shape.getPrevVertex(v0);
                        if (v0 != v1 && !shape.isEqualXY(v1, pt1)) {
                            edge = new Edge(v0, v1, 1);
                            bunch.add(edge);
                        }
                        if (v0 == v2 || v2 == v1 || shape.isEqualXY(v2, pt1)) continue;
                        edge = new Edge(v0, v2, -1);
                        bunch.add(edge);
                    }
                    if (bunch.size() > 0) {
                        this.process_bunch_(bunch, pt1);
                    }
                }
                vertex1 = vertex;
                pt1.setCoords(pt);
                cluster_size = 1;
                index0 = index;
                continue;
            }
            ++cluster_size;
        }
        if (this.m_dissolved_edges == 0) {
            shape.removeUserIndex(this.m_points_index);
            this.m_points_index = -1;
            return;
        }
        int geometry_vertex_count = shape.getPointCount(geometry);
        for (int index = 0; index < this.m_points.size(); ++index) {
            int vertex = this.m_points.get(index);
            if (vertex == -1) continue;
            if (shape.getUserIndex(vertex, this.m_points_index) != -1) {
                shape.setUserIndex(vertex, this.m_points_index, -1);
                continue;
            }
            path = shape.getPathFromVertex(vertex);
            int path_vert = shape.getFirstVertex(path);
            if (path_vert == vertex) {
                shape.setFirstVertex_(path, -1);
            }
            shape.freeVertex_(vertex);
            this.m_points.set(index, -1);
            --geometry_vertex_count;
        }
        int path_index = shape.createPathUserIndex();
        int geometry_path_count = shape.getPathCount(geometry);
        int n2 = this.m_points.size();
        for (int i = 0; i < n2; ++i) {
            int first_vertex;
            if (this.m_points.get(i) == -1 || shape.getUserIndex(first_vertex = this.m_points.get(i), this.m_points_index) != -1) continue;
            int path3 = shape.getPathFromVertex(first_vertex);
            int path_vert = -1;
            if (shape.getPathUserIndex(path3, path_index) == 2) {
                path3 = -1;
                int vertex = shape.getNextVertex(first_vertex);
                while (vertex != first_vertex) {
                    int vpath = shape.getPathFromVertex(vertex);
                    if (shape.getPathUserIndex(vpath, path_index) != 2) {
                        path3 = vpath;
                        first_vertex = vertex;
                        break;
                    }
                    vertex = shape.getNextVertex(vertex);
                }
                if (path3 == -1) {
                    path3 = shape.insertPath(geometry, -1);
                    shape.setClosedPath(path3, true);
                    ++geometry_path_count;
                }
                GeometryException.releaseAssert(path3 != -1);
            }
            shape.setPathUserIndex(path3, path_index, 2);
            path_vert = shape.getFirstVertex(path3);
            int path_vertex_count = 0;
            boolean found_first = false;
            int vertex = first_vertex;
            do {
                if (path_vert == vertex) {
                    found_first = true;
                }
                shape.setUserIndex(vertex, this.m_points_index, 1);
                int vpath = shape.getPathFromVertex(vertex);
                if (vpath != path3) {
                    if (shape.getPathUserIndex(vpath, path_index) != 2) {
                        shape.setPathUserIndex(vpath, path_index, 1);
                        shape.setFirstVertex_(vpath, -1);
                    }
                    shape.setPathToVertex_(vertex, path3);
                }
                ++path_vertex_count;
            } while ((vertex = shape.getNextVertex(vertex)) != first_vertex);
            if (!found_first) {
                shape.setFirstVertex_(path3, first_vertex);
            }
            shape.setPathSize_(path3, path_vertex_count);
        }
        path = shape.getFirstPath(geometry);
        while (path != -1) {
            int next_path = shape.getNextPath(path);
            if (shape.getPathUserIndex(path, path_index) == 1 || shape.getFirstVertex(path) == -1) {
                shape.removePathOnly_(path);
                --geometry_path_count;
            }
            path = next_path;
        }
        shape.setGeometryVertexCount_(geometry, geometry_vertex_count);
        shape.setGeometryPathCount_(geometry, geometry_path_count);
        shape.removePathUserIndex(path_index);
        shape.removeUserIndex(this.m_points_index);
        this.m_points_index = -1;
        shape.filterClosePoints(0.0, true, false, geometry);
    }

    private void process_bunch_(ArrayList<Edge> bunch, Point2D p0) {
        assert (bunch.size() > 0);
        bunch.sort(new EdgeComparator(p0, this));
        int is = 0;
        Point2D ps = this.m_shape.getXY(bunch.get((int)0).vertex1);
        Point2D pt = new Point2D();
        int cnt = 1;
        int n = bunch.size();
        for (int i = 1; i < n; ++i) {
            Edge e = bunch.get(i);
            this.m_shape.getXY(e.vertex1, pt);
            assert (this.m_shape.getUserIndex(e.vertex0, this.m_points_index) != -1);
            assert (this.m_shape.getUserIndex(e.vertex1, this.m_points_index) != -1);
            if (pt.isEqual(ps)) {
                ++cnt;
                if (i + 1 < n) continue;
            }
            if (cnt == 2) {
                Edge e_is = bunch.get(is);
                Edge e_is_1 = bunch.get(is + 1);
                int dir1 = e_is.dir;
                int dir2 = e_is_1.dir;
                if (dir1 != dir2) {
                    int v12;
                    int v02;
                    int v11;
                    int v01;
                    if (dir1 == 1) {
                        v01 = e_is.vertex0;
                        v11 = e_is_1.vertex0;
                        this.m_shape.setNextVertex_(v01, v11);
                        this.m_shape.setPrevVertex_(v11, v01);
                        if (this.m_shape.getPrevVertex(v01) == v11) {
                            this.m_shape.setUserIndex(v01, this.m_points_index, -1);
                            this.m_shape.setUserIndex(v11, this.m_points_index, -1);
                        }
                        v02 = e_is.vertex1;
                        v12 = e_is_1.vertex1;
                        this.m_shape.setPrevVertex_(v02, v12);
                        this.m_shape.setNextVertex_(v12, v02);
                        if (this.m_shape.getNextVertex(v02) == v12) {
                            this.m_shape.setUserIndex(v02, this.m_points_index, -1);
                            this.m_shape.setUserIndex(v12, this.m_points_index, -1);
                        }
                    } else {
                        v01 = e_is.vertex0;
                        v11 = e_is_1.vertex0;
                        this.m_shape.setPrevVertex_(v01, v11);
                        this.m_shape.setNextVertex_(v11, v01);
                        if (this.m_shape.getNextVertex(v01) == v11) {
                            this.m_shape.setUserIndex(v01, this.m_points_index, -1);
                            this.m_shape.setUserIndex(v11, this.m_points_index, -1);
                        }
                        v02 = e_is.vertex1;
                        v12 = e_is_1.vertex1;
                        this.m_shape.setNextVertex_(v02, v12);
                        this.m_shape.setPrevVertex_(v12, v02);
                        if (this.m_shape.getPrevVertex(v02) == v12) {
                            this.m_shape.setUserIndex(v02, this.m_points_index, -1);
                            this.m_shape.setUserIndex(v12, this.m_points_index, -1);
                        }
                    }
                    this.m_dissolved_edges += 2;
                }
            }
            ps = pt;
            is = i;
            cnt = 1;
        }
        bunch.clear();
    }

    static class EdgeComparator
    implements Comparator<Edge> {
        private Point2D pt0;
        private Point2D p1 = new Point2D();
        private Point2D p2 = new Point2D();
        private EdgeDissolver parent_;

        EdgeComparator(Point2D p, EdgeDissolver parent) {
            this.pt0 = p;
            this.parent_ = parent;
        }

        @Override
        public int compare(Edge e1, Edge e2) {
            this.parent_.m_shape.getXY(e1.vertex1, this.p1);
            this.p1.sub(this.pt0);
            this.parent_.m_shape.getXY(e2.vertex1, this.p2);
            this.p2.sub(this.pt0);
            int res = Point2D._compareVectors(this.p1, this.p2);
            if (res == 0) {
                return e1.dir < e2.dir ? -1 : (e1.dir > e2.dir ? 1 : 0);
            }
            return res;
        }
    }

    static class Edge {
        int vertex0;
        int vertex1;
        int dir;

        Edge(int v0, int v1, int d) {
            this.vertex0 = v0;
            this.vertex1 = v1;
            this.dir = d;
        }
    }
}

