/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamOfInt32;
import com.esri.core.geometry.EditShape;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryAccelerators;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.InternalUtils;
import com.esri.core.geometry.Line;
import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.MultiPathImpl;
import com.esri.core.geometry.NonSimpleResult;
import com.esri.core.geometry.PlaneSweepCrackerHelper;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.ProgressTracker;
import com.esri.core.geometry.QuadTreeImpl;
import com.esri.core.geometry.Segment;
import com.esri.core.geometry.SegmentBuffer;
import com.esri.core.geometry.SegmentIntersector;
import com.esri.core.geometry.SegmentIterator;
import com.esri.core.geometry.SweepComparator;
import com.esri.core.geometry.Transformation2D;
import com.esri.core.geometry.Treap;
import java.util.ArrayList;
import java.util.Collections;

final class Cracker {
    private EditShape m_shape;
    private ProgressTracker m_progress_tracker;
    private NonSimpleResult m_non_simple_result;
    private double m_tolerance;
    private Treap m_sweep_structure;
    private SweepComparator m_sweep_comparator;
    private int m_progress_counter = 0;
    private boolean m_bAllowCoincident;

    private Segment getSegment_(int vertex, Line lineHelper) {
        Segment seg = this.m_shape.getSegment(vertex);
        if (seg == null) {
            if (!this.m_shape.queryLineConnector(vertex, lineHelper)) {
                return null;
            }
            seg = lineHelper;
        }
        return seg;
    }

    private void progress_() {
        this.progress_(false);
    }

    private void progress_(boolean bnow) {
        ++this.m_progress_counter;
        if (bnow || (this.m_progress_counter & 0xFFF) == 0) {
            this.m_progress_counter = 0;
            ProgressTracker.checkAndThrow(this.m_progress_tracker);
        }
    }

    private boolean crackBruteForce_() {
        EditShape.VertexIterator iter_1 = this.m_shape.queryVertexIterator(false);
        boolean b_cracked = false;
        Line line_1 = new Line();
        Line line_2 = new Line();
        Envelope2D seg_1_env = new Envelope2D();
        seg_1_env.setEmpty();
        Envelope2D seg_2_env = new Envelope2D();
        seg_2_env.setEmpty();
        boolean assume_intersecting = false;
        Point helper_point = new Point();
        SegmentIntersector segment_intersector = new SegmentIntersector();
        int vertex_1 = iter_1.next();
        while (vertex_1 != -1) {
            block22: {
                EditShape.VertexIterator iter_2;
                int vertex_2;
                boolean seg_1_zero;
                Segment seg_1;
                block21: {
                    int GT_1 = this.m_shape.getGeometryType(iter_1.currentGeometry());
                    seg_1 = null;
                    seg_1_zero = false;
                    if (Geometry.isPoint(GT_1)) break block21;
                    seg_1 = this.getSegment_(vertex_1, line_1);
                    if (seg_1 == null) break block22;
                    seg_1.queryEnvelope2D(seg_1_env);
                    seg_1_env.inflate(this.m_tolerance, this.m_tolerance);
                    if (!seg_1.isDegenerate(this.m_tolerance)) break block21;
                    if (!seg_1.isDegenerate(0.0)) break block22;
                    seg_1_zero = true;
                    seg_1 = null;
                }
                if ((vertex_2 = (iter_2 = this.m_shape.queryVertexIterator(iter_1)).next()) != -1) {
                    vertex_2 = iter_2.next();
                }
                while (vertex_2 != -1) {
                    block24: {
                        block28: {
                            block30: {
                                block29: {
                                    int split_count_2;
                                    int split_count_1;
                                    block26: {
                                        int v;
                                        int v_to;
                                        Point2D pt;
                                        Segment seg_2;
                                        block27: {
                                            boolean seg_2_zero;
                                            block25: {
                                                block23: {
                                                    this.progress_();
                                                    int GT_2 = this.m_shape.getGeometryType(iter_2.currentGeometry());
                                                    seg_2 = null;
                                                    seg_2_zero = false;
                                                    if (Geometry.isPoint(GT_2)) break block23;
                                                    seg_2 = this.getSegment_(vertex_2, line_2);
                                                    if (seg_2 == null) break block24;
                                                    seg_2.queryEnvelope2D(seg_2_env);
                                                    if (!seg_2.isDegenerate(this.m_tolerance)) break block23;
                                                    if (!seg_2.isDegenerate(0.0)) break block24;
                                                    seg_2_zero = true;
                                                    seg_2 = null;
                                                }
                                                split_count_1 = 0;
                                                split_count_2 = 0;
                                                if (seg_1 == null || seg_2 == null) break block25;
                                                if (seg_1_env.isIntersectingNE(seg_2_env)) {
                                                    segment_intersector.pushSegment(seg_1);
                                                    segment_intersector.pushSegment(seg_2);
                                                    segment_intersector.intersect(this.m_tolerance, assume_intersecting);
                                                    split_count_1 = segment_intersector.getResultSegmentCount(0);
                                                    split_count_2 = segment_intersector.getResultSegmentCount(1);
                                                    if (split_count_1 + split_count_2 > 0) {
                                                        this.m_shape.splitSegmentWithIntersector(vertex_1, segment_intersector, 0, true);
                                                        this.m_shape.splitSegmentWithIntersector(vertex_2, segment_intersector, 1, true);
                                                    }
                                                    segment_intersector.clear();
                                                }
                                                break block26;
                                            }
                                            if (seg_1 == null) break block27;
                                            pt = new Point2D();
                                            this.m_shape.getXY(vertex_2, pt);
                                            if (seg_1_env.contains(pt)) {
                                                segment_intersector.pushSegment(seg_1);
                                                this.m_shape.queryPoint(vertex_2, helper_point);
                                                segment_intersector.intersect(this.m_tolerance, helper_point, 0, 1.0, assume_intersecting);
                                                split_count_1 = segment_intersector.getResultSegmentCount(0);
                                                if (split_count_1 > 0) {
                                                    this.m_shape.splitSegmentWithIntersector(vertex_1, segment_intersector, 0, true);
                                                    if (seg_2_zero) {
                                                        v_to = -1;
                                                        v = this.m_shape.getNextVertex(vertex_2);
                                                        while (v != -1 && v != vertex_2) {
                                                            seg_2 = this.getSegment_(v, line_2);
                                                            v_to = v;
                                                            if (seg_2 == null || !seg_2.isDegenerate(0.0)) break;
                                                            v = this.m_shape.getNextVertex(v);
                                                        }
                                                        v = vertex_2;
                                                        while (v != -1) {
                                                            this.m_shape.setPoint(v, segment_intersector.getResultPoint());
                                                            if (v != v_to) {
                                                                v = this.m_shape.getNextVertex(v);
                                                                continue;
                                                            }
                                                            break;
                                                        }
                                                    } else {
                                                        this.m_shape.setPoint(vertex_2, segment_intersector.getResultPoint());
                                                    }
                                                }
                                                segment_intersector.clear();
                                            }
                                            break block26;
                                        }
                                        if (seg_2 == null) break block24;
                                        pt = new Point2D();
                                        this.m_shape.getXY(vertex_1, pt);
                                        seg_2_env.inflate(this.m_tolerance, this.m_tolerance);
                                        if (seg_2_env.contains(pt)) {
                                            segment_intersector.pushSegment(seg_2);
                                            this.m_shape.queryPoint(vertex_1, helper_point);
                                            segment_intersector.intersect(this.m_tolerance, helper_point, 0, 1.0, assume_intersecting);
                                            split_count_2 = segment_intersector.getResultSegmentCount(0);
                                            if (split_count_2 > 0) {
                                                this.m_shape.splitSegmentWithIntersector(vertex_2, segment_intersector, 0, true);
                                                if (seg_1_zero) {
                                                    v_to = -1;
                                                    v = this.m_shape.getNextVertex(vertex_1);
                                                    while (v != -1 && v != vertex_1) {
                                                        seg_2 = this.getSegment_(v, line_2);
                                                        v_to = v;
                                                        if (seg_2 == null || !seg_2.isDegenerate(0.0)) break;
                                                        v = this.m_shape.getNextVertex(v);
                                                    }
                                                    v = vertex_1;
                                                    while (v != -1) {
                                                        this.m_shape.setPoint(v, segment_intersector.getResultPoint());
                                                        if (v != v_to) {
                                                            v = this.m_shape.getNextVertex(v);
                                                            continue;
                                                        }
                                                        break;
                                                    }
                                                } else {
                                                    this.m_shape.setPoint(vertex_1, segment_intersector.getResultPoint());
                                                }
                                            }
                                            segment_intersector.clear();
                                        }
                                    }
                                    if (split_count_1 + split_count_2 == 0) break block24;
                                    if (split_count_1 == 0) break block28;
                                    seg_1 = this.m_shape.getSegment(vertex_1);
                                    if (seg_1 != null) break block29;
                                    if (!this.m_shape.queryLineConnector(vertex_1, line_1)) break block24;
                                    seg_1 = line_1;
                                    line_1.queryEnvelope2D(seg_1_env);
                                    break block30;
                                }
                                seg_1.queryEnvelope2D(seg_1_env);
                            }
                            if (seg_1.isDegenerate(this.m_tolerance)) break;
                        }
                        b_cracked = true;
                    }
                    vertex_2 = iter_2.next();
                }
            }
            vertex_1 = iter_1.next();
        }
        return b_cracked;
    }

    boolean crackerPlaneSweep_() {
        boolean b_cracked = this.planeSweep_();
        return b_cracked;
    }

    boolean planeSweep_() {
        PlaneSweepCrackerHelper plane_sweep = new PlaneSweepCrackerHelper(this.m_progress_tracker);
        boolean b_cracked = plane_sweep.sweep(this.m_shape, this.m_tolerance);
        return b_cracked;
    }

    boolean needsCrackingImpl_() {
        boolean b_needs_cracking = false;
        if (this.m_sweep_structure == null) {
            this.m_sweep_structure = new Treap();
        }
        AttributeStreamOfInt32 event_q = new AttributeStreamOfInt32(0);
        event_q.reserve(this.m_shape.getTotalPointCount() + 1);
        EditShape.VertexIterator iter = this.m_shape.queryVertexIterator();
        int vert = iter.next();
        while (vert != -1) {
            event_q.add(vert);
            vert = iter.next();
        }
        assert (this.m_shape.getTotalPointCount() == event_q.size());
        this.m_shape.sortVerticesSimpleByY_(event_q, 0, event_q.size());
        event_q.add(-1);
        int edge_index_1 = this.m_shape.createUserIndex();
        int edge_index_2 = this.m_shape.createUserIndex();
        this.m_sweep_comparator = new SweepComparator(this.m_shape, this.m_tolerance, !this.m_bAllowCoincident);
        this.m_sweep_structure.setComparator(this.m_sweep_comparator);
        AttributeStreamOfInt32 swept_edges_to_delete = new AttributeStreamOfInt32(0);
        AttributeStreamOfInt32 edges_to_insert = new AttributeStreamOfInt32(0);
        int event_q_index = 0;
        Point2D cluster_pt = new Point2D();
        int vertex = event_q.get(event_q_index++);
        while (vertex != -1) {
            int edge;
            int i;
            this.m_shape.getXY(vertex, cluster_pt);
            do {
                int attached_edge_2;
                int attached_edge_1;
                this.progress_();
                int next_vertex = this.m_shape.getNextVertex(vertex);
                int prev_vertex = this.m_shape.getPrevVertex(vertex);
                if (next_vertex != -1 && this.m_shape.compareVerticesSimpleY_(vertex, next_vertex) < 0) {
                    edges_to_insert.add(vertex);
                    edges_to_insert.add(next_vertex);
                }
                if (prev_vertex != -1 && this.m_shape.compareVerticesSimpleY_(vertex, prev_vertex) < 0) {
                    edges_to_insert.add(prev_vertex);
                    edges_to_insert.add(prev_vertex);
                }
                if ((attached_edge_1 = this.m_shape.getUserIndex(vertex, edge_index_1)) != -1) {
                    swept_edges_to_delete.add(attached_edge_1);
                    this.m_shape.setUserIndex(vertex, edge_index_1, -1);
                }
                if ((attached_edge_2 = this.m_shape.getUserIndex(vertex, edge_index_2)) == -1) continue;
                swept_edges_to_delete.add(attached_edge_2);
                this.m_shape.setUserIndex(vertex, edge_index_2, -1);
            } while ((vertex = event_q.get(event_q_index++)) != -1 && this.m_shape.isEqualXY(vertex, cluster_pt));
            boolean b_continuing_segment_chain_optimization = swept_edges_to_delete.size() == 1 && edges_to_insert.size() == 2;
            int new_left = -1;
            int new_right = -1;
            int n = swept_edges_to_delete.size();
            for (i = 0; i < n; ++i) {
                int right;
                edge = swept_edges_to_delete.get(i);
                int left = this.m_sweep_structure.getPrev(edge);
                if (left != -1 && !swept_edges_to_delete.hasElement(left)) {
                    assert (new_left == -1);
                    new_left = left;
                }
                if ((right = this.m_sweep_structure.getNext(edge)) != -1 && !swept_edges_to_delete.hasElement(right)) {
                    assert (new_right == -1);
                    new_right = right;
                }
                if (new_left != -1 && new_right != -1) break;
            }
            assert (new_left == -1 || new_left != new_right);
            this.m_sweep_comparator.setSweepY(cluster_pt.y, cluster_pt.x);
            n = swept_edges_to_delete.size();
            for (i = 0; i < n; ++i) {
                edge = swept_edges_to_delete.get(i);
                this.m_sweep_structure.deleteNode(edge, -1);
            }
            swept_edges_to_delete.clear(false);
            if (!b_continuing_segment_chain_optimization && new_left != -1 && new_right != -1 && this.checkForIntersections_(new_left, new_right)) {
                b_needs_cracking = true;
                this.m_non_simple_result = this.m_sweep_comparator.getResult();
                break;
            }
            n = edges_to_insert.size();
            for (i = 0; i < n; i += 2) {
                int v = edges_to_insert.get(i);
                int otherv = edges_to_insert.get(i + 1);
                int new_edge_1 = -1;
                if (b_continuing_segment_chain_optimization) {
                    new_edge_1 = this.m_sweep_structure.addElementAtPosition(new_left, new_right, v, true, true, -1);
                    b_continuing_segment_chain_optimization = false;
                } else {
                    new_edge_1 = this.m_sweep_structure.addElement(v, -1);
                }
                if (this.m_sweep_comparator.intersectionDetected()) {
                    this.m_non_simple_result = this.m_sweep_comparator.getResult();
                    b_needs_cracking = true;
                    break;
                }
                int e_1 = this.m_shape.getUserIndex(otherv, edge_index_1);
                if (e_1 == -1) {
                    this.m_shape.setUserIndex(otherv, edge_index_1, new_edge_1);
                    continue;
                }
                assert (this.m_shape.getUserIndex(otherv, edge_index_2) == -1);
                this.m_shape.setUserIndex(otherv, edge_index_2, new_edge_1);
            }
            if (b_needs_cracking) break;
            edges_to_insert.resizePreserveCapacity(0);
        }
        this.m_shape.removeUserIndex(edge_index_1);
        this.m_shape.removeUserIndex(edge_index_2);
        return b_needs_cracking;
    }

    boolean checkForIntersections_(int sweep_edge_1, int sweep_edge_2) {
        assert (sweep_edge_1 != sweep_edge_2);
        int left = this.m_sweep_structure.getElement(sweep_edge_1);
        assert (left != this.m_sweep_structure.getElement(sweep_edge_2));
        this.m_sweep_comparator.compare(this.m_sweep_structure, left, sweep_edge_2);
        boolean b_intersects = this.m_sweep_comparator.intersectionDetected();
        this.m_sweep_comparator.clearIntersectionDetectedFlag();
        return b_intersects;
    }

    Cracker(ProgressTracker progress_tracker) {
        this.m_progress_tracker = progress_tracker;
        this.m_bAllowCoincident = true;
    }

    static boolean canBeCracked(EditShape shape) {
        int geometry = shape.getFirstGeometry();
        while (geometry != -1) {
            if (Geometry.isMultiPath(shape.getGeometryType(geometry))) {
                return true;
            }
            geometry = shape.getNextGeometry(geometry);
        }
        return false;
    }

    static boolean execute(EditShape shape, Envelope2D extent, double tolerance, ProgressTracker progress_tracker) {
        if (!Cracker.canBeCracked(shape)) {
            return false;
        }
        Cracker cracker = new Cracker(progress_tracker);
        cracker.m_shape = shape;
        cracker.m_tolerance = tolerance;
        boolean b_cracked = false;
        if (shape.getTotalPointCount() >= 15) {
            boolean b_cracked_1 = cracker.crackerPlaneSweep_();
            return b_cracked_1;
        }
        b_cracked = cracker.crackBruteForce_();
        return b_cracked;
    }

    static boolean execute(EditShape shape, double tolerance, ProgressTracker progress_tracker) {
        return Cracker.execute(shape, shape.getEnvelope2D(), tolerance, progress_tracker);
    }

    static boolean needsCracking(boolean allowCoincident, EditShape shape, double tolerance, NonSimpleResult result, ProgressTracker progress_tracker) {
        if (!Cracker.canBeCracked(shape)) {
            return false;
        }
        Cracker cracker = new Cracker(progress_tracker);
        cracker.m_shape = shape;
        cracker.m_tolerance = tolerance;
        cracker.m_bAllowCoincident = allowCoincident;
        if (cracker.needsCrackingImpl_()) {
            if (result != null) {
                result.Assign(cracker.m_non_simple_result);
            }
            return true;
        }
        Transformation2D transform = new Transformation2D();
        transform.setSwapCoordinates();
        shape.applyTransformation(transform);
        cracker = new Cracker(progress_tracker);
        cracker.m_shape = shape;
        cracker.m_tolerance = tolerance;
        cracker.m_bAllowCoincident = allowCoincident;
        boolean b_res = cracker.needsCrackingImpl_();
        transform.setSwapCoordinates();
        shape.applyTransformation(transform);
        if (b_res) {
            if (result != null) {
                result.Assign(cracker.m_non_simple_result);
            }
            return true;
        }
        return false;
    }

    static boolean quadTreeWillHelp(MultiPath geom, int crackerCount) {
        double cBruteForce;
        int n = geom.getPointCount();
        if (n < 16) {
            return false;
        }
        double cBuildQuadTree = 2.0;
        double cQueryQuadTree = 1.0;
        double cCrackingBruteForce = 1.0;
        double cQuadTree = cBuildQuadTree * (double)n + cQueryQuadTree * (Math.log10(n) / Math.log(2.0)) * (double)crackerCount;
        return cQuadTree < (cBruteForce = cCrackingBruteForce * (double)n * (double)crackerCount);
    }

    static MultiPath crackAWithB(MultiPath geometryA, Geometry geometryB, double tolerance, ProgressTracker progress_tracker) {
        int gtB = geometryB.getType().value();
        if (Geometry.isMultiPath(gtB)) {
            Cracker impl = new Cracker(progress_tracker);
            return impl.crackAWithBMultiPath_(geometryA, (MultiPath)geometryB, tolerance);
        }
        throw new GeometryException("crack_A_with_B");
    }

    private MultiPath crackAWithBMultiPath_(MultiPath geometryA, MultiPath geometryB, double tolerance) {
        Envelope2D envA = new Envelope2D();
        geometryA.queryLooseEnvelope(envA);
        Envelope2D envBInflated = new Envelope2D();
        geometryB.queryLooseEnvelope(envBInflated);
        envBInflated.inflate(tolerance, tolerance);
        if (!envBInflated.isIntersecting(envA)) {
            return geometryA;
        }
        MultiPathImpl mpImpl = (MultiPathImpl)geometryA._getImpl();
        GeometryAccelerators accel = mpImpl._getAccelerators();
        QuadTreeImpl qtree = null;
        if (accel != null) {
            qtree = accel.getQuadTree();
        }
        if (Cracker.quadTreeWillHelp(geometryA, Geometry.vertexCount(geometryA))) {
            qtree = InternalUtils.buildQuadTree(mpImpl, envBInflated);
        }
        QuadTreeImpl.QuadTreeIteratorImpl qtIter = qtree != null ? qtree.getIterator() : null;
        SegmentIterator segIterB = geometryB.querySegmentIterator();
        SegmentIterator segIterA = geometryA.querySegmentIterator();
        double[] ts = new double[15];
        class Intersection
        implements Comparable<Intersection> {
            double t;
            int index;

            Intersection() {
            }

            @Override
            public int compareTo(Intersection o) {
                if (this.index == o.index) {
                    if (this.t > o.t) {
                        return 1;
                    }
                    if (this.t < o.t) {
                        return -1;
                    }
                    return 0;
                }
                if (this.index > o.index) {
                    return 1;
                }
                return -1;
            }
        }
        ArrayList<Intersection> intersections = new ArrayList<Intersection>(150);
        while (segIterB.nextPath()) {
            while (segIterB.hasNextSegment()) {
                Intersection n;
                int vertex1;
                double t;
                int i;
                int count;
                Segment segB = segIterB.nextSegment();
                if (qtree != null) {
                    qtIter.resetIterator(segB, tolerance);
                    int qtHandle = qtIter.next();
                    while (qtHandle != -1) {
                        this.progress_();
                        int vertex = qtree.getElement(qtHandle);
                        segIterA.resetToVertex(vertex, -1);
                        if (segIterA.hasNextSegment()) {
                            Segment segA = segIterA.nextSegment();
                            count = segA.intersect(segB, null, ts, null, tolerance);
                            for (i = 0; i < count; ++i) {
                                t = ts[i];
                                if (t == 0.0 || t == 1.0) continue;
                                vertex1 = segIterA.getStartPointIndex();
                                n = new Intersection();
                                n.t = t;
                                n.index = vertex1;
                                intersections.add(n);
                            }
                        }
                        qtHandle = qtIter.next();
                    }
                    continue;
                }
                Envelope2D segBEnvInflated = new Envelope2D();
                segB.queryLooseEnvelope2D(segBEnvInflated);
                segBEnvInflated.inflate(tolerance, tolerance);
                if (!envA.isIntersecting(segBEnvInflated)) continue;
                segIterA.resetToFirstPath();
                while (segIterA.nextPath()) {
                    while (segIterA.hasNextSegment()) {
                        this.progress_();
                        Segment segA = segIterA.nextSegment();
                        Envelope2D segAEnv = new Envelope2D();
                        segA.queryLooseEnvelope2D(segAEnv);
                        if (!segAEnv.isIntersecting(segBEnvInflated)) continue;
                        count = segA.intersect(segB, null, ts, null, tolerance);
                        for (i = 0; i < count; ++i) {
                            t = ts[i];
                            if (t == 0.0 || t == 1.0) continue;
                            vertex1 = segIterA.getStartPointIndex();
                            n = new Intersection();
                            n.t = t;
                            n.index = vertex1;
                            intersections.add(n);
                        }
                    }
                }
            }
        }
        if (intersections.size() == 0) {
            return geometryA;
        }
        Collections.sort(intersections);
        MultiPath resultGeomA = (MultiPath)geometryA.createInstance();
        segIterA.resetToFirstPath();
        while (segIterA.nextPath() && !segIterA.hasNextSegment()) {
        }
        assert (segIterA.hasNextSegment());
        Segment seg = segIterA.nextSegment();
        SegmentBuffer segBuf = new SegmentBuffer();
        int prevPathIndex = -1;
        int i = 0;
        int n = intersections.size();
        while (i < n) {
            boolean addSeg;
            int j;
            int index = ((Intersection)intersections.get((int)i)).index;
            for (j = i + 1; j < n && ((Intersection)intersections.get((int)j)).index == index; ++j) {
            }
            while (segIterA.getStartPointIndex() < index) {
                boolean addSeg2;
                this.progress_();
                boolean hasNextSeg = segIterA.hasNextSegment();
                int currentPath = segIterA.getPathIndex();
                boolean bl = addSeg2 = hasNextSeg || !segIterA.isClosingSegment() || segIterA.isCurve();
                if (addSeg2) {
                    resultGeomA.addSegment(seg, prevPathIndex != currentPath);
                }
                prevPathIndex = currentPath;
                if (!hasNextSeg) {
                    if (segIterA.isPathClosed()) {
                        // empty if block
                    }
                    while (segIterA.nextPath() && !segIterA.hasNextSegment()) {
                    }
                }
                seg = segIterA.nextSegment();
            }
            assert (segIterA.getStartPointIndex() == index);
            double t0 = 0.0;
            for (int k = i; k < j; ++k) {
                double t = ((Intersection)intersections.get((int)k)).t;
                assert (t != 0.0 && t != 1.0);
                if (t == t0) continue;
                seg.cut(t0, t, segBuf);
                t0 = t;
                int currentPath = segIterA.getPathIndex();
                resultGeomA.addSegment(segBuf.get(), prevPathIndex != currentPath);
                prevPathIndex = currentPath;
            }
            boolean hasNextSeg = segIterA.hasNextSegment();
            boolean bl = addSeg = hasNextSeg || !segIterA.isClosingSegment() || segIterA.isCurve();
            if (addSeg) {
                seg.cut(t0, 1.0, segBuf);
                resultGeomA.addSegment(segBuf.get(), false);
            }
            if (hasNextSeg) {
                seg = segIterA.nextSegment();
            } else {
                while (segIterA.nextPath() && !segIterA.hasNextSegment()) {
                }
                seg = segIterA.hasNextSegment() ? segIterA.nextSegment() : null;
            }
            i = j;
        }
        if (seg != null) {
            boolean addSeg;
            int currentPath = segIterA.getPathIndex();
            boolean hasNextSeg = segIterA.hasNextSegment();
            boolean bl = addSeg = hasNextSeg || !segIterA.isClosingSegment() || segIterA.isCurve();
            if (addSeg) {
                resultGeomA.addSegment(seg, prevPathIndex != currentPath);
            }
            prevPathIndex = currentPath;
        }
        boolean hasNextSeg = segIterA.hasNextSegment();
        while (true) {
            boolean addSeg;
            if (!hasNextSeg) {
                while (segIterA.nextPath() && !(hasNextSeg = segIterA.hasNextSegment())) {
                }
                if (!hasNextSeg) break;
            }
            seg = segIterA.nextSegment();
            int currentPath = segIterA.getPathIndex();
            hasNextSeg = segIterA.hasNextSegment();
            boolean bl = addSeg = hasNextSeg || !segIterA.isClosingSegment() || segIterA.isCurve();
            if (addSeg) {
                resultGeomA.addSegment(seg, prevPathIndex != currentPath);
            }
            prevPathIndex = currentPath;
        }
        return resultGeomA;
    }
}

