/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AndroidSDKPublic;
import com.esri.core.geometry.CGTSrlz;
import com.esri.core.geometry.CompositeGeographicTransformationImpl;
import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.GeographicTransformation;
import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.core.geometry.OperatorProject;
import com.esri.core.geometry.ProjectionTransformation;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.SpatialReferenceImpl;
import com.esri.sde.sdk.pe.engine.PeCoordsys;
import com.esri.sde.sdk.pe.engine.PeGCSExtent;
import com.esri.sde.sdk.pe.engine.PeGeogcs;
import com.esri.sde.sdk.pe.engine.PeInteger;
import com.esri.sde.sdk.pe.factory.PeGTlistExtended;
import com.esri.sde.sdk.pe.factory.PeGTlistExtendedEntry;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@AndroidSDKPublic
@HadoopSDKExcluded
public abstract class CompositeGeographicTransformation
implements Serializable {
    private static final long serialVersionUID = 1L;

    @AndroidSDKPublic
    public static CompositeGeographicTransformation create() {
        CompositeGeographicTransformationImpl o = new CompositeGeographicTransformationImpl();
        return o;
    }

    @AndroidSDKPublic
    public static CompositeGeographicTransformation create(int wkid, boolean inverted) {
        CompositeGeographicTransformationImpl o = new CompositeGeographicTransformationImpl();
        o.add(GeographicTransformation.create(wkid, inverted));
        return o;
    }

    @AndroidSDKPublic
    public static CompositeGeographicTransformation create(String wkt, boolean inverted) {
        CompositeGeographicTransformationImpl o = new CompositeGeographicTransformationImpl();
        o.add(GeographicTransformation.create(wkt, inverted));
        return o;
    }

    public abstract String getName();

    @AndroidSDKPublic
    public abstract int count();

    @AndroidSDKPublic
    public abstract GeographicTransformation getGeogTran(int var1);

    @AndroidSDKPublic
    public abstract void setGeogTran(int var1, GeographicTransformation var2);

    @AndroidSDKPublic
    public abstract void add(GeographicTransformation var1);

    @AndroidSDKPublic
    public abstract void clear();

    @AndroidSDKPublic
    public abstract void remove(int var1);

    public abstract boolean isMutable();

    @AndroidSDKPublic
    public abstract void copyTo(CompositeGeographicTransformation var1);

    @AndroidSDKPublic
    public abstract CompositeGeographicTransformation copy();

    @AndroidSDKPublic
    public abstract CompositeGeographicTransformation getInverse();

    public abstract boolean referencesMissingData();

    public static List<CompositeGeographicTransformation> queryGTList(SpatialReference srSrc, SpatialReference srDst, Envelope2D extent_of_interest, int max_entries, boolean skip_unusable_entries) {
        int count;
        SpatialReference gcsIn = srSrc.getGCS();
        SpatialReference gcsOut = srDst.getGCS();
        SpatialReferenceImpl gcsInImpl = (SpatialReferenceImpl)gcsIn;
        SpatialReferenceImpl gcsOutImpl = (SpatialReferenceImpl)gcsOut;
        PeCoordsys peGeogcsIn = gcsInImpl.getPECoordSys();
        PeCoordsys peGeogcsOut = gcsOutImpl.getPECoordSys();
        PeGCSExtent ppeGCSExtent = null;
        if (extent_of_interest != null && !extent_of_interest.isEmpty()) {
            Envelope2D envelope2D = extent_of_interest;
            if (!envelope2D.isEmpty() && srSrc.getCoordinateSystemType() == SpatialReference.Type.Projected) {
                Envelope envelope = new Envelope(envelope2D);
                ProjectionTransformation proj_transform = ProjectionTransformation.createEx(srSrc, gcsIn, null);
                envelope = (Envelope)OperatorProject.local().execute(envelope, proj_transform, null);
                envelope.queryEnvelope2D(envelope2D);
            }
            if (!envelope2D.isEmpty()) {
                double pmLongitude = ((PeGeogcs)peGeogcsIn).getPrimem().getLongitude();
                double conversionFactor = ((PeGeogcs)peGeogcsIn).getUnit().getUnitFactor();
                ppeGCSExtent = new PeGCSExtent(envelope2D.xmin, envelope2D.ymin, envelope2D.xmax, envelope2D.ymax, pmLongitude, conversionFactor);
            }
        }
        if ((count = max_entries) < 0) {
            count = 0;
        }
        ArrayList<CompositeGeographicTransformation> result_array = new ArrayList<CompositeGeographicTransformation>();
        for (int iter = 0; iter < 2; ++iter) {
            result_array.clear();
            PeInteger numEntries = new PeInteger(count);
            PeGTlistExtendedEntry[] gtTransformEx = PeGTlistExtended.getGTlist((PeCoordsys)peGeogcsIn, (PeCoordsys)peGeogcsOut, (int)2, (int)11, ppeGCSExtent, (PeInteger)numEntries);
            boolean skipped = false;
            if (gtTransformEx != null && numEntries.val > 0) {
                result_array.ensureCapacity(max_entries > 0 ? Math.min(max_entries, numEntries.val) : numEntries.val);
                int n = numEntries.val;
                for (int i = 0; i < n; ++i) {
                    CompositeGeographicTransformationImpl compositeGT = CompositeGeographicTransformationImpl.createImpl(gtTransformEx[i]);
                    if (skip_unusable_entries && ((CompositeGeographicTransformation)compositeGT).referencesMissingData()) {
                        skipped = true;
                        continue;
                    }
                    result_array.add(compositeGT);
                    if (max_entries > 0 && result_array.size() == max_entries) break;
                }
            }
            if (!skipped) break;
            if (count == 0) continue;
            count = 0;
        }
        return result_array;
    }

    Object writeReplace() throws ObjectStreamException {
        CGTSrlz gt = new CGTSrlz();
        gt.setGTByValue(this);
        return gt;
    }
}

