/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamOfDbl;
import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.core.geometry.MathUtils;
import com.esri.core.geometry.MultiPathImpl;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.MultiVertexGeometryImpl;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.ProgressTracker;
import com.esri.core.geometry.Segment;
import com.esri.core.geometry.SegmentIteratorImpl;

@HadoopSDKExcluded
public class Centroid {
    public static Point2D calculateCentroid2D(Geometry geometry, ProgressTracker progressTracker) {
        if (!geometry.isEmpty()) {
            int type = geometry.getType().value();
            switch (type) {
                case 1736: {
                    return Centroid.calc_polygon_centroid_2D_((Polygon)geometry, -1);
                }
                case 1607: {
                    return Centroid.calc_polyline_centroid_2D_((Polyline)geometry);
                }
                case 322: {
                    return Centroid.calc_segment_centroid_2D_((Segment)geometry);
                }
                case 550: {
                    return Centroid.calc_multi_point_centroid_2D_((MultiPoint)geometry);
                }
                case 197: {
                    return ((Envelope)geometry).getCenterXY();
                }
                case 33: {
                    return ((Point)geometry).getXY();
                }
            }
        }
        Point2D pt = new Point2D();
        pt.setNaN();
        return pt;
    }

    static Point2D calculatePolygonCentroid2D(Polygon polygon, int ipath) {
        return Centroid.calc_polygon_centroid_2D_(polygon, ipath);
    }

    private static Point2D calc_polygon_centroid_2D_(Polygon polygon, int ipath) {
        assert (!polygon.isEmpty());
        MathUtils.KahanSummator wc_x = new MathUtils.KahanSummator(0.0);
        MathUtils.KahanSummator wc_y = new MathUtils.KahanSummator(0.0);
        MultiPathImpl mp_impl = (MultiPathImpl)polygon._getImpl();
        double area = 0.0;
        Point2D first_point = mp_impl.getXY(0);
        if (ipath == -1) {
            int n = mp_impl.getPathCount();
            for (int i = 0; i < n; ++i) {
                Centroid.add_weighted_area_path_centroid_2D_linear_(first_point, mp_impl, i, wc_x, wc_y);
            }
            area = mp_impl.calculateArea2D();
        } else {
            Centroid.add_weighted_area_path_centroid_2D_linear_(first_point, mp_impl, ipath, wc_x, wc_y);
            area = mp_impl.calculateRingArea2D(ipath);
        }
        Point2D weighted_centroid = new Point2D();
        Point2D centroid = new Point2D();
        weighted_centroid.setCoords(wc_x.getResult(), wc_y.getResult());
        centroid.scaleAdd(1.0 / area, weighted_centroid, first_point);
        return centroid;
    }

    private static void add_weighted_area_path_centroid_2D_linear_(Point2D first_point, MultiPathImpl mp_impl, int ipath, MathUtils.KahanSummator wc_x, MathUtils.KahanSummator wc_y) {
        int istart = mp_impl.getPathStart(ipath);
        int iend = mp_impl.getPathEnd(ipath);
        if (iend - istart < 3) {
            return;
        }
        AttributeStreamOfDbl position = (AttributeStreamOfDbl)mp_impl.getAttributeStreamRef(0);
        Point2D origin = new Point2D();
        position.read(2 * istart, origin);
        Point2D pt = new Point2D();
        position.read(2 * (istart + 1), pt);
        pt.sub(origin);
        MathUtils.KahanSummator total_linear_area_ks = new MathUtils.KahanSummator(0.0);
        boolean b_has_non_linear_segments = mp_impl.hasNonLinearSegments();
        double c_third = 0.3333333333333333;
        Point2D pt_next = new Point2D();
        for (int i = istart + 2; i < iend; ++i) {
            position.read(2 * i, pt_next);
            pt_next.sub(origin);
            double triangle_area = pt_next.crossProduct(pt) * 0.5;
            if (b_has_non_linear_segments) {
                total_linear_area_ks.add(triangle_area);
            }
            double one_third_area = c_third * triangle_area;
            wc_x.add((pt.x + pt_next.x) * one_third_area);
            wc_y.add((pt.y + pt_next.y) * one_third_area);
            pt.setCoords(pt_next);
        }
        double total_linear_area = b_has_non_linear_segments ? total_linear_area_ks.getResult() : mp_impl.calculateRingArea2D(ipath);
        Point2D weighted_origin = new Point2D();
        weighted_origin.sub(origin, first_point);
        weighted_origin.scale(total_linear_area);
        wc_x.add(weighted_origin.x);
        wc_y.add(weighted_origin.y);
    }

    private static Point2D calc_polyline_centroid_2D_(Polyline polyline) {
        MultiPathImpl mp_impl = (MultiPathImpl)polyline._getImpl();
        SegmentIteratorImpl seg_iter = mp_impl.querySegmentIterator();
        MathUtils.KahanSummator wc_x = new MathUtils.KahanSummator(0.0);
        MathUtils.KahanSummator wc_y = new MathUtils.KahanSummator(0.0);
        Point2D weighted_centroid_segment = new Point2D();
        Point2D segment_weighted_centroid_segment = new Point2D();
        while (seg_iter.nextPath()) {
            int path_index = seg_iter.getPathIndex();
            Point2D origin = mp_impl.getXY(mp_impl.getPathStart(path_index));
            while (seg_iter.hasNextSegment()) {
                Segment seg = seg_iter.nextSegment();
                seg.calculateWeightedCentroid2D(segment_weighted_centroid_segment);
                weighted_centroid_segment.scaleAdd(-seg.calculateLength2D(), origin, segment_weighted_centroid_segment);
                wc_x.add(weighted_centroid_segment.x);
                wc_y.add(weighted_centroid_segment.y);
            }
            Point2D weighted_origin = new Point2D();
            weighted_origin.scale(mp_impl.calculatePathLength2D(path_index), origin);
            wc_x.add(weighted_origin.x);
            wc_y.add(weighted_origin.y);
        }
        Point2D weighted_centroid = new Point2D();
        weighted_centroid.setCoords(wc_x.getResult(), wc_y.getResult());
        Point2D centroid = new Point2D();
        centroid.scale(1.0 / polyline.calculateLength2D(), weighted_centroid);
        return centroid;
    }

    private static Point2D calc_segment_centroid_2D_(Segment segment) {
        Point2D weighted_centroid = new Point2D();
        segment.calculateWeightedCentroid2D(weighted_centroid);
        weighted_centroid.scale(1.0 / segment.calculateLength2D());
        return weighted_centroid;
    }

    private static Point2D calc_multi_point_centroid_2D_(MultiPoint multi_point) {
        MathUtils.KahanSummator wc_x = new MathUtils.KahanSummator(0.0);
        MathUtils.KahanSummator wc_y = new MathUtils.KahanSummator(0.0);
        MultiVertexGeometryImpl mvg_impl = (MultiVertexGeometryImpl)multi_point._getImpl();
        AttributeStreamOfDbl position = (AttributeStreamOfDbl)mvg_impl.getAttributeStreamRef(0);
        int n = mvg_impl.getPointCount();
        Point2D pt = new Point2D();
        for (int i = 0; i < n; ++i) {
            position.read(2 * i, pt);
            wc_x.add(pt.x);
            wc_y.add(pt.y);
        }
        pt.setCoords(wc_x.getResult() / (double)n, wc_y.getResult() / (double)n);
        return pt;
    }
}

