/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.ConvexHull;
import com.esri.core.geometry.EditShape;
import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryCursor;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.InternalUtils;
import com.esri.core.geometry.Line;
import com.esri.core.geometry.MathUtils;
import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.MultiPathImpl;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.MultiVertexGeometry;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.Operator;
import com.esri.core.geometry.OperatorFactoryLocal;
import com.esri.core.geometry.OperatorGeneralize;
import com.esri.core.geometry.OperatorSimplify;
import com.esri.core.geometry.OperatorSimplifyOGC;
import com.esri.core.geometry.OperatorUnion;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.ProgressTracker;
import com.esri.core.geometry.Segment;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.TopologicalOperations;
import com.esri.core.geometry.Transformation2D;
import java.util.ArrayList;

class Bufferer {
    private Geometry m_geometry;
    private ArrayList<BufferCommand> m_buffer_commands;
    private int m_original_geom_type;
    private ProgressTracker m_progress_tracker;
    private int m_max_vertex_in_complete_circle;
    private int m_circle_template_size;
    private int m_old_circle_template_size;
    private SpatialReference m_spatialReference;
    private double m_tolerance;
    private double m_small_tolerance;
    private double m_filter_tolerance;
    private double m_densify_dist;
    private double m_distance;
    private double m_abs_distance;
    private double m_abs_distance_reversed;
    private double m_dA;
    private double m_miter_limit;
    private int m_joins;
    private int m_caps;
    private boolean m_round_buffer;
    private boolean m_bfilter;
    private ArrayList<Point2D> m_circle_template = new ArrayList(0);
    private Line m_helper_line_1;
    private Line m_helper_line_2;
    private Point2D[] m_helper_array;
    private int m_progress_counter;

    Bufferer(ProgressTracker progress_tracker) {
        this.m_progress_tracker = progress_tracker;
        this.m_buffer_commands = new ArrayList(128);
        this.m_tolerance = 0.0;
        this.m_small_tolerance = 0.0;
        this.m_filter_tolerance = 0.0;
        this.m_distance = 0.0;
        this.m_original_geom_type = 0;
        this.m_abs_distance_reversed = 0.0;
        this.m_abs_distance = 0.0;
        this.m_densify_dist = -1.0;
        this.m_dA = -1.0;
        this.m_bfilter = true;
        this.m_old_circle_template_size = 0;
        this.m_miter_limit = 4.0;
        this.m_joins = 0;
        this.m_caps = 0;
        this.m_round_buffer = true;
        this.m_progress_counter = 0;
        this.m_max_vertex_in_complete_circle = -1;
        this.m_circle_template_size = -1;
    }

    Geometry buffer(Geometry geometry, double distance, SpatialReference sr, int joins, int caps, double miterLimit, double densify_dist, int max_vertex_in_complete_circle) {
        double max_dd;
        if (geometry == null) {
            throw new IllegalArgumentException();
        }
        if (densify_dist < 0.0) {
            throw new IllegalArgumentException();
        }
        if (geometry.isEmpty()) {
            return new Polygon(geometry.getDescription());
        }
        Envelope2D env2D = new Envelope2D();
        geometry.queryLooseEnvelope2D(env2D);
        if (distance > 0.0) {
            env2D.inflate(distance, distance);
        }
        this.m_caps = caps;
        this.m_joins = joins;
        this.m_miter_limit = miterLimit;
        this.m_original_geom_type = geometry.getType().value();
        if (Geometry.isArea(this.m_original_geom_type)) {
            this.m_round_buffer = this.m_joins == 0;
        } else if (Geometry.isPoint(this.m_original_geom_type)) {
            this.m_round_buffer = this.m_caps == 0;
        } else if (Geometry.isLinear(this.m_original_geom_type)) {
            this.m_round_buffer = this.m_joins == 0 && this.m_caps == 0;
        }
        this.m_bfilter = this.m_round_buffer;
        this.m_geometry = geometry;
        this.m_tolerance = InternalUtils.calculateToleranceFromGeometryForOp(sr, env2D, true);
        this.m_small_tolerance = InternalUtils.calculateToleranceFromGeometryForOp(null, env2D, true);
        if (max_vertex_in_complete_circle <= 0) {
            max_vertex_in_complete_circle = 96;
        }
        this.m_spatialReference = sr;
        this.m_distance = distance;
        this.m_abs_distance = Math.abs(this.m_distance);
        double d = this.m_abs_distance_reversed = this.m_abs_distance != 0.0 ? 1.0 / this.m_abs_distance : 0.0;
        if (NumberUtils.isNaN(densify_dist) || densify_dist == 0.0) {
            densify_dist = this.m_abs_distance * 1.0E-5;
        } else if (densify_dist > this.m_abs_distance * 0.5) {
            densify_dist = this.m_abs_distance * 0.5;
        }
        if (max_vertex_in_complete_circle < 12) {
            max_vertex_in_complete_circle = 12;
        }
        if ((max_dd = Math.abs(distance) * (1.0 - Math.cos(Math.PI / (double)max_vertex_in_complete_circle))) > densify_dist) {
            densify_dist = max_dd;
        } else {
            double vertex_count = Math.PI / Math.acos(1.0 - densify_dist / Math.abs(distance));
            if (vertex_count < (double)max_vertex_in_complete_circle - 1.0 && (max_vertex_in_complete_circle = (int)vertex_count) < 12) {
                max_vertex_in_complete_circle = 12;
                densify_dist = Math.abs(distance) * (1.0 - Math.cos(Math.PI / (double)max_vertex_in_complete_circle));
            }
        }
        this.m_densify_dist = densify_dist;
        this.m_max_vertex_in_complete_circle = max_vertex_in_complete_circle;
        this.m_filter_tolerance = this.m_round_buffer ? Math.min(this.m_small_tolerance, densify_dist * 0.25) : 0.0;
        this.m_circle_template_size = this.calcN_();
        if (this.m_circle_template_size != this.m_old_circle_template_size) {
            this.m_circle_template.clear();
            this.m_old_circle_template_size = this.m_circle_template_size;
        }
        Geometry result_geom = this.buffer_();
        this.m_geometry = null;
        return result_geom;
    }

    private void generateCircleTemplate_() {
        double dA;
        if (!this.m_circle_template.isEmpty()) {
            return;
        }
        int N = this.m_circle_template_size;
        assert (N >= 4);
        int real_size = (N + 3) / 4;
        this.m_dA = dA = 1.5707963267948966 / (double)real_size;
        for (int i = 0; i < real_size * 4; ++i) {
            this.m_circle_template.add(null);
        }
        double dcos = Math.cos(dA);
        double dsin = Math.sin(dA);
        Point2D pt = new Point2D(0.0, 1.0);
        for (int i = 0; i < real_size; ++i) {
            this.m_circle_template.set(i + real_size * 0, new Point2D(pt.y, -pt.x));
            this.m_circle_template.set(i + real_size * 1, new Point2D(-pt.x, -pt.y));
            this.m_circle_template.set(i + real_size * 2, new Point2D(-pt.y, pt.x));
            this.m_circle_template.set(i + real_size * 3, pt);
            pt = new Point2D(pt.x, pt.y);
            pt.rotateReverse(dcos, dsin);
        }
    }

    private Geometry buffer_() {
        int gt = this.m_geometry.getType().value();
        if (Geometry.isSegment(gt)) {
            Polyline polyline = new Polyline(this.m_geometry.getDescription());
            polyline.addSegment((Segment)this.m_geometry, true);
            this.m_geometry = polyline;
            return this.buffer_();
        }
        if (this.m_distance <= this.m_tolerance) {
            if (Geometry.isArea(gt)) {
                if (this.m_distance <= 0.0) {
                    Envelope2D env = new Envelope2D();
                    this.m_geometry.queryEnvelope2D(env);
                    if (env.getWidth() <= -this.m_distance * 2.0 || env.getHeight() <= this.m_distance * 2.0) {
                        return new Polygon(this.m_geometry.getDescription());
                    }
                }
            } else {
                return new Polygon(this.m_geometry.getDescription());
            }
        }
        switch (this.m_geometry.getType().value()) {
            case 33: {
                return this.bufferPoint_();
            }
            case 550: {
                return this.bufferMultiPoint_();
            }
            case 1607: {
                return this.bufferPolyline_();
            }
            case 1736: {
                return this.bufferPolygon_();
            }
            case 197: {
                return this.bufferEnvelope_();
            }
        }
        throw GeometryException.GeometryInternalError();
    }

    Polygon bufferDegeneratePath_(Point point, boolean closed) {
        assert (this.m_distance > 0.0);
        Polygon resultPolygon = new Polygon(point.getDescription());
        if (closed && this.m_joins == 0 || !closed && this.m_caps == 0) {
            this.addCircle_((MultiPathImpl)resultPolygon._getImpl(), point);
            return this.setStrongSimple_(resultPolygon);
        }
        if (!closed && this.m_caps == 2) {
            this.addSquare_((MultiPathImpl)resultPolygon._getImpl(), point);
            return this.setStrongSimple_(resultPolygon);
        }
        return resultPolygon;
    }

    private Geometry bufferPolyline_() {
        if (this.isDegenerateGeometry_(this.m_geometry)) {
            Point point = new Point();
            ((MultiVertexGeometry)this.m_geometry).getPointByVal(0, point);
            Envelope2D env2D = new Envelope2D();
            this.m_geometry.queryEnvelope2D(env2D);
            point.setXY(env2D.getCenter());
            return this.bufferDegeneratePath_(point, true);
        }
        assert (this.m_distance > 0.0);
        Polyline poly = (Polyline)this.m_geometry;
        this.m_geometry = null;
        GlueingCursorForPolyline glueing_cursor = new GlueingCursorForPolyline(poly);
        poly = null;
        GeometryCursor generalized_paths = null;
        generalized_paths = this.m_joins == 0 ? OperatorGeneralize.local().execute(glueing_cursor, this.m_densify_dist * 0.25, false, this.m_progress_tracker) : glueing_cursor;
        GeometryCursor simple_paths = this.m_round_buffer ? OperatorSimplifyOGC.local().execute(generalized_paths, null, true, this.m_progress_tracker) : generalized_paths;
        generalized_paths = null;
        GeometryCursorForPolyline path_buffering_cursor = new GeometryCursorForPolyline(this, simple_paths, this.m_bfilter);
        simple_paths = null;
        GeometryCursor union_cursor = OperatorUnion.local().execute(path_buffering_cursor, this.m_spatialReference, this.m_progress_tracker, 2);
        Geometry result = union_cursor.next();
        return result;
    }

    private Geometry bufferPolygon_() {
        if (this.m_distance == 0.0) {
            return this.m_geometry;
        }
        OperatorSimplify simplify = (OperatorSimplify)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.Simplify);
        this.generateCircleTemplate_();
        this.m_geometry = simplify.execute(this.m_geometry, null, false, this.m_progress_tracker);
        if (this.m_distance < 0.0) {
            Polygon poly = (Polygon)this.m_geometry;
            Polygon buffered_result = this.bufferPolygonImpl_(poly, 0, poly.getPathCount());
            return simplify.execute(buffered_result, this.m_spatialReference, false, this.m_progress_tracker);
        }
        if (this.isDegenerateGeometry_(this.m_geometry)) {
            Point point = new Point();
            ((MultiVertexGeometry)this.m_geometry).getPointByVal(0, point);
            Envelope2D env2D = new Envelope2D();
            this.m_geometry.queryEnvelope2D(env2D);
            point.setXY(env2D.getCenter());
            return this.bufferDegeneratePath_(point, true);
        }
        GeometryCursorForPolygon cursor = new GeometryCursorForPolygon(this);
        GeometryCursor union_cursor = ((OperatorUnion)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.Union)).execute(cursor, this.m_spatialReference, this.m_progress_tracker);
        Geometry result = union_cursor.next();
        return result;
    }

    static void addRingsSkipEnvelope_(Polygon src_polygon, Polygon dst_polygon, Envelope2D env_to_skip, boolean forward) {
        Point2D pt = new Point2D();
        int n = src_polygon.getPathCount();
        for (int i = 0; i < n; ++i) {
            src_polygon.getXY(src_polygon.getPathStart(i), pt);
            if (pt.x == env_to_skip.xmin || pt.x == env_to_skip.xmax) {
                assert (pt.y == env_to_skip.ymin || pt.y == env_to_skip.ymax);
                continue;
            }
            dst_polygon.addPath(src_polygon, i, forward);
        }
    }

    private Polygon bufferPolygonImpl_(Polygon input_geom, int ipath_begin, int ipath_end) {
        Polygon input_mp = input_geom;
        MultiPathImpl mp_impl = (MultiPathImpl)input_mp._getImpl();
        Polygon intermediate_polygon = new Polygon(input_geom.getDescription());
        for (int ipath = ipath_begin; ipath < ipath_end; ++ipath) {
            Polygon buffered_path;
            MultiPathImpl result_mp;
            Polyline result_polyline;
            if (mp_impl.getPathSize(ipath) < 1) continue;
            double path_area = mp_impl.calculateRingArea2D(ipath);
            Envelope2D env2D = new Envelope2D();
            mp_impl.queryPathEnvelope2D(ipath, env2D);
            if (this.m_distance > 0.0) {
                if (path_area > 0.0) {
                    Polygon buffered_path2;
                    if (this.isDegeneratePath_(mp_impl, ipath)) {
                        Point point = new Point();
                        mp_impl.getPointByVal(mp_impl.getPathStart(ipath), point);
                        point.setXY(env2D.getCenter());
                        intermediate_polygon.add(this.bufferDegeneratePath_(point, true), false);
                        continue;
                    }
                    result_polyline = new Polyline(input_geom.getDescription());
                    result_mp = (MultiPathImpl)result_polyline._getImpl();
                    boolean bConvex = ConvexHull.isPathConvex((Polygon)this.m_geometry, ipath, this.m_progress_tracker);
                    if (bConvex) {
                        buffered_path2 = this.bufferConvexPath_(input_mp, ipath);
                        intermediate_polygon.add(buffered_path2, false);
                        continue;
                    }
                    this.bufferClosedPath_(this.m_geometry, ipath, result_mp, this.m_round_buffer, 1);
                    buffered_path2 = this.bufferCleanup_(result_polyline, false);
                    intermediate_polygon.add(buffered_path2, false);
                    continue;
                }
                if (env2D.getWidth() + this.m_tolerance <= 2.0 * this.m_abs_distance || env2D.getHeight() + this.m_tolerance <= 2.0 * this.m_abs_distance) continue;
                result_polyline = new Polyline(input_geom.getDescription());
                result_mp = (MultiPathImpl)result_polyline._getImpl();
                this.bufferClosedPath_(this.m_geometry, ipath, result_mp, this.m_round_buffer, 1);
                if (result_polyline.isEmpty()) continue;
                Envelope2D env = new Envelope2D();
                env.setCoords(env2D);
                double d = Math.max(1.0, this.m_abs_distance);
                env.inflate(d, d);
                result_mp.addEnvelope(env, false);
                buffered_path = this.bufferCleanup_(result_polyline, false);
                intermediate_polygon.reserve(intermediate_polygon.getPointCount() + buffered_path.getPointCount() - 4);
                Bufferer.addRingsSkipEnvelope_(buffered_path, intermediate_polygon, env, true);
                continue;
            }
            if (path_area > 0.0) {
                if (env2D.getWidth() + this.m_tolerance <= 2.0 * this.m_abs_distance || env2D.getHeight() + this.m_tolerance <= 2.0 * this.m_abs_distance) continue;
                result_polyline = new Polyline(input_geom.getDescription());
                result_mp = (MultiPathImpl)result_polyline._getImpl();
                this.bufferClosedPath_(this.m_geometry, ipath, result_mp, this.m_round_buffer, -1);
                if (result_polyline.isEmpty()) continue;
                Envelope2D env = new Envelope2D();
                result_mp.queryLooseEnvelope2D(env);
                double d = Math.max(1.0, this.m_abs_distance);
                env.inflate(d, d);
                result_mp.addEnvelope(env, false);
                buffered_path = this.bufferCleanup_(result_polyline, false);
                Bufferer.addRingsSkipEnvelope_(buffered_path, intermediate_polygon, env, true);
                continue;
            }
            result_polyline = new Polyline(input_geom.getDescription());
            result_mp = (MultiPathImpl)result_polyline._getImpl();
            this.bufferClosedPath_(this.m_geometry, ipath, result_mp, this.m_round_buffer, -1);
            Polygon buffered_path3 = this.bufferCleanup_(result_polyline, false);
            int npaths = buffered_path3.getPathCount();
            for (int i = 0; i < npaths; ++i) {
                intermediate_polygon.addPath(buffered_path3, i, true);
            }
        }
        if (this.m_distance > 0.0) {
            if (intermediate_polygon.getPathCount() > 1) {
                Polygon cleaned_polygon = this.bufferCleanup_(intermediate_polygon, false);
                return cleaned_polygon;
            }
            return Bufferer.setWeakSimple_(intermediate_polygon);
        }
        Envelope2D polyenv = new Envelope2D();
        intermediate_polygon.queryLooseEnvelope2D(polyenv);
        if (!intermediate_polygon.isEmpty()) {
            double d = Math.max(1.0, this.m_abs_distance);
            polyenv.inflate(d, d);
            intermediate_polygon.addEnvelope(polyenv, false);
            Polygon cleaned_polygon = this.bufferCleanup_(intermediate_polygon, false);
            Polygon result_polygon = new Polygon(cleaned_polygon.getDescription());
            Bufferer.addRingsSkipEnvelope_(cleaned_polygon, result_polygon, polyenv, false);
            return Bufferer.setWeakSimple_(result_polygon);
        }
        return Bufferer.setWeakSimple_(intermediate_polygon);
    }

    private Geometry bufferPoint_() {
        return this.bufferPoint_((Point)this.m_geometry);
    }

    private Geometry bufferPoint_(Point point) {
        assert (this.m_distance > 0.0);
        Polygon resultPolygon = new Polygon(this.m_geometry.getDescription());
        if (this.m_caps == 0) {
            this.addCircle_((MultiPathImpl)resultPolygon._getImpl(), point);
            return this.setStrongSimple_(resultPolygon);
        }
        if (this.m_caps == 2) {
            this.addSquare_((MultiPathImpl)resultPolygon._getImpl(), point);
            return this.setStrongSimple_(resultPolygon);
        }
        return resultPolygon;
    }

    private Geometry bufferMultiPoint_() {
        assert (this.m_distance > 0.0);
        GeometryCursorForMultiPoint mpCursor = new GeometryCursorForMultiPoint(this, (MultiPoint)this.m_geometry, this.m_distance, this.m_spatialReference, this.m_joins, this.m_caps, this.m_miter_limit, this.m_densify_dist, this.m_max_vertex_in_complete_circle, this.m_progress_tracker);
        GeometryCursor c = ((OperatorUnion)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.Union)).execute(mpCursor, this.m_spatialReference, this.m_progress_tracker);
        return c.next();
    }

    private Geometry bufferEnvelope_() {
        Polygon polygon = new Polygon(this.m_geometry.getDescription());
        if (this.m_distance <= 0.0) {
            if (this.m_distance == 0.0) {
                polygon.addEnvelope((Envelope)this.m_geometry, false);
            } else {
                Envelope env = new Envelope();
                this.m_geometry.queryEnvelope(env);
                env.inflate(this.m_distance, this.m_distance);
                polygon.addEnvelope(env, false);
            }
            return polygon;
        }
        if (this.m_joins == 1) {
            Envelope e = (Envelope)this.m_geometry;
            e.inflate(this.m_abs_distance, this.m_abs_distance);
            polygon.addEnvelope(e, false);
            return polygon;
        }
        polygon.addEnvelope((Envelope)this.m_geometry, false);
        this.m_geometry = polygon;
        return this.bufferConvexPath_(polygon, 0);
    }

    private Polygon bufferConvexPath_(MultiPath src, int ipath) {
        this.generateCircleTemplate_();
        Polygon resultPolygon = new Polygon(src.getDescription());
        MultiPathImpl result_mp = (MultiPathImpl)resultPolygon._getImpl();
        Point2D v_before = new Point2D();
        Point2D v_after = new Point2D();
        Point2D pt_1_tmp = new Point2D();
        Point2D pt_1 = new Point2D();
        Point2D pt_2_tmp = new Point2D();
        Point2D pt_2 = new Point2D();
        Point2D pt_3_tmp = new Point2D();
        Point2D pt_3 = new Point2D();
        Point2D miter_point = new Point2D(0.0, 0.0);
        Point2D v_1 = new Point2D();
        Point2D v_2 = new Point2D();
        MultiPathImpl src_mp = (MultiPathImpl)src._getImpl();
        int path_size = src.getPathSize(ipath);
        int path_start = src.getPathStart(ipath);
        int n = src.getPathSize(ipath);
        for (int i = 0; i < n; ++i) {
            src_mp.getXY(path_start + i, pt_1);
            src_mp.getXY(path_start + (i + 1) % path_size, pt_2);
            src_mp.getXY(path_start + (i + 2) % path_size, pt_3);
            v_1.sub(pt_2, pt_1);
            if (v_1.length() == 0.0) {
                throw GeometryException.GeometryInternalError();
            }
            boolean round_join_override = false;
            v_1.normalize();
            v_before.setCoords(v_1);
            v_1.leftPerpendicular();
            v_1.scale(this.m_abs_distance);
            pt_1_tmp.add(v_1, pt_1);
            pt_2_tmp.add(v_1, pt_2);
            if (i == 0) {
                result_mp.startPath(pt_1_tmp);
            } else {
                result_mp.lineTo(pt_1_tmp);
            }
            result_mp.lineTo(pt_2_tmp);
            v_2.sub(pt_3, pt_2);
            if (v_2.length() == 0.0) {
                throw GeometryException.GeometryInternalError();
            }
            v_2.normalize();
            v_after.setCoords(v_2);
            v_2.leftPerpendicular();
            v_2.scale(this.m_abs_distance);
            pt_3_tmp.add(v_2, pt_2);
            int command = 2;
            int joins = this.m_joins;
            if (joins == 2) {
                command = 16;
            } else if (joins == 1) {
                double cross = v_before.crossProduct(v_after);
                double sin_alpha = -cross;
                miter_point.sub(v_before, v_after);
                miter_point.scale(this.m_abs_distance / sin_alpha);
                if (miter_point.length() < this.m_miter_limit * this.m_abs_distance) {
                    miter_point.add(pt_2);
                    command = 8;
                } else {
                    command = 16;
                }
            } else {
                miter_point.setCoords(pt_2);
            }
            this.addJoin_(command, result_mp, miter_point, pt_2_tmp, pt_3_tmp, false, false);
        }
        return Bufferer.setWeakSimple_(resultPolygon);
    }

    private Polygon bufferPolylinePath_(Polyline polyline, int ipath, boolean bfilter) {
        assert (this.m_distance != 0.0);
        this.generateCircleTemplate_();
        Polyline input_multi_path = polyline;
        MultiPathImpl mp_impl = (MultiPathImpl)input_multi_path._getImpl();
        if (mp_impl.getPathSize(ipath) < 1) {
            return null;
        }
        boolean b_closed = this.m_round_buffer ? mp_impl.isClosedPathInXYPlane(ipath) : mp_impl.isClosedPath(ipath);
        if (this.isDegeneratePath_(mp_impl, ipath) && this.m_distance > 0.0) {
            Point point = new Point();
            mp_impl.getPointByVal(mp_impl.getPathStart(ipath), point);
            Envelope2D env2D = new Envelope2D();
            mp_impl.queryPathEnvelope2D(ipath, env2D);
            point.setXY(env2D.getCenter());
            return this.bufferDegeneratePath_(point, b_closed);
        }
        Polyline result_polyline = new Polyline(polyline.getDescription());
        result_polyline.reserve((this.m_circle_template.size() / 10 + 4) * mp_impl.getPathSize(ipath));
        MultiPathImpl result_mp = (MultiPathImpl)result_polyline._getImpl();
        if (b_closed) {
            if (this.bufferClosedPath_(input_multi_path, ipath, result_mp, bfilter, 1) != 2) {
                this.bufferClosedPath_(input_multi_path, ipath, result_mp, bfilter, -1);
            }
        } else {
            this.bufferOpenPath_(input_multi_path, ipath, result_mp, bfilter);
        }
        return this.bufferCleanup_(result_polyline, false);
    }

    private void progress_() {
        ++this.m_progress_counter;
        if ((this.m_progress_counter & 0xFFF) == 0 && this.m_progress_tracker != null && !this.m_progress_tracker.progress(-1, -1)) {
            throw new RuntimeException("user_canceled");
        }
    }

    private Polygon bufferCleanup_(MultiPath multi_path, boolean simplify_result) {
        double tol = simplify_result ? this.m_tolerance : this.m_small_tolerance;
        Polygon resultPolygon = (Polygon)TopologicalOperations.planarSimplify(multi_path, tol, true, !simplify_result, -1, this.m_progress_tracker, false);
        assert (InternalUtils.isAtLeastWeakSimple(resultPolygon, 0.0));
        return resultPolygon;
    }

    private int calcN_() {
        int minN = 4;
        if (this.m_densify_dist == 0.0) {
            return this.m_max_vertex_in_complete_circle;
        }
        double r = this.m_densify_dist * Math.abs(this.m_abs_distance_reversed);
        double cos_a = 1.0 - r;
        double N = cos_a < -1.0 ? 4.0 : Math.PI * 2 / Math.acos(cos_a) + 0.5;
        if (N < 4.0) {
            N = 4.0;
        } else if (N > (double)this.m_max_vertex_in_complete_circle) {
            N = this.m_max_vertex_in_complete_circle;
        }
        return (int)N;
    }

    private void addJoin_(int command, MultiPathImpl dst, Point2D center, Point2D fromPt, Point2D toPt, boolean bStartPath, boolean bFinishAtToPt) {
        this.generateCircleTemplate_();
        if (bStartPath) {
            dst.startPath(fromPt);
            bStartPath = false;
        }
        if (command == 16) {
            if (bFinishAtToPt) {
                dst.lineTo(toPt);
            }
            return;
        }
        if (command == 8) {
            dst.lineTo(center);
            if (bFinishAtToPt) {
                dst.lineTo(toPt);
            }
            return;
        }
        assert (command == 2);
        Point2D v_1 = new Point2D();
        v_1.sub(fromPt, center);
        v_1.scale(this.m_abs_distance_reversed);
        Point2D v_2 = new Point2D();
        v_2.sub(toPt, center);
        v_2.scale(this.m_abs_distance_reversed);
        double angle_from = Math.atan2(v_1.y, v_1.x);
        double dindex_from = angle_from / this.m_dA;
        if (dindex_from < 0.0) {
            dindex_from = (double)this.m_circle_template.size() + dindex_from;
        }
        dindex_from = (double)this.m_circle_template.size() - dindex_from;
        double angle_to = Math.atan2(v_2.y, v_2.x);
        double dindex_to = angle_to / this.m_dA;
        if (dindex_to < 0.0) {
            dindex_to = (double)this.m_circle_template.size() + dindex_to;
        }
        if ((dindex_to = (double)this.m_circle_template.size() - dindex_to) < dindex_from) {
            dindex_to += (double)this.m_circle_template.size();
        }
        assert (dindex_to >= dindex_from);
        int index_to = (int)dindex_to;
        int index_from = (int)Math.ceil(dindex_from);
        if (bStartPath) {
            dst.startPath(fromPt);
            bStartPath = false;
        }
        Point2D p = new Point2D();
        p.setCoords(this.m_circle_template.get(index_from % this.m_circle_template.size()));
        p.scaleAdd(this.m_abs_distance, center);
        double ddd = this.m_tolerance * 10.0;
        p.sub(fromPt);
        if (p.length() < ddd) {
            ++index_from;
        }
        p.setCoords(this.m_circle_template.get(index_to % this.m_circle_template.size()));
        p.scaleAdd(this.m_abs_distance, center);
        p.sub(toPt);
        if (p.length() < ddd) {
            --index_to;
        }
        int count = index_to - index_from;
        ++count;
        int j = index_from % this.m_circle_template.size();
        for (int i = 0; i < count; ++i) {
            p.setCoords(this.m_circle_template.get(j));
            p.scaleAdd(this.m_abs_distance, center);
            dst.lineTo(p);
            this.progress_();
            j = (j + 1) % this.m_circle_template.size();
        }
        if (bFinishAtToPt) {
            dst.lineTo(toPt);
        }
    }

    private int bufferOpenPath_(MultiPath input_multi_path, int ipath, MultiPathImpl result_mp, boolean bfilter) {
        if (this.m_round_buffer) {
            Polyline tmpPoly = new Polyline(input_multi_path.getDescription());
            tmpPoly.addPath(input_multi_path, ipath, false);
            tmpPoly.addSegmentsFromPath(input_multi_path, ipath, 0, input_multi_path.getSegmentCount(ipath), false);
            return this.bufferClosedPath_(tmpPoly, 0, result_mp, bfilter, 1);
        }
        int half_points = 0;
        Polyline tmpPoly = new Polyline(input_multi_path.getDescription());
        Point2D origin = new Point2D(0.0, 0.0);
        EditShape edit_shape = new EditShape();
        int geom = edit_shape.addPathFromMultiPath(input_multi_path, ipath, false);
        int vertex = edit_shape.getFirstVertex(edit_shape.getFirstPath(geom));
        Point firstPoint = new Point();
        edit_shape.queryPoint(vertex, firstPoint);
        firstPoint.getXY(origin);
        edit_shape.filterClosePoints(0.0, false, false);
        int total_point_count = edit_shape.getPointCount(geom);
        if (total_point_count < 2) {
            if (this.m_round_buffer) {
                this.addCircle_(result_mp, firstPoint);
            }
            return 2;
        }
        Geometry filtered_geom = edit_shape.getGeometry(edit_shape.getFirstGeometry());
        tmpPoly.addPath((MultiPath)filtered_geom, 0, false);
        half_points = tmpPoly.getPointCount() - 1;
        tmpPoly.addSegmentsFromPath((MultiPath)filtered_geom, 0, 0, ((MultiPath)filtered_geom).getSegmentCount(0) - 1, false);
        edit_shape = new EditShape();
        geom = edit_shape.addPathFromMultiPath(tmpPoly, 0, true);
        GeometryException.releaseAssert(edit_shape.getFirstPath(geom) != -1);
        GeometryException.releaseAssert(edit_shape.getFirstVertex(edit_shape.getFirstPath(geom)) != -1);
        Transformation2D tr = new Transformation2D();
        tr.setShift(-origin.x, -origin.y);
        edit_shape.applyTransformation(tr);
        this.m_buffer_commands.clear();
        int path = edit_shape.getFirstPath(geom);
        boolean has_dense_flags = this.m_joins != 0 && edit_shape.getVertexDescription().hasAttribute(10);
        int ivert = edit_shape.getFirstVertex(path);
        int iprev = edit_shape.getPrevVertex(ivert);
        int inext = edit_shape.getNextVertex(ivert);
        boolean b_first = true;
        Point2D pt_current = new Point2D();
        Point2D pt_after = new Point2D();
        Point2D pt_before = new Point2D();
        Point2D pt_left_prev = new Point2D();
        Point2D v_after = new Point2D();
        Point2D v_before = new Point2D();
        Point2D v_left = new Point2D();
        Point2D v_left_prev = new Point2D();
        double abs_d = this.m_abs_distance;
        int ncount = edit_shape.getPathSize(path);
        Point2D miter_point = new Point2D(0.0, 0.0);
        Point2D pt = new Point2D();
        Point2D pt1 = new Point2D();
        Point2D c1 = new Point2D();
        Point2D c2 = new Point2D();
        for (int index = 0; index < ncount; ++index) {
            boolean bDoJoin;
            boolean cap = false;
            if (index == 0 || index == half_points) {
                cap = true;
            }
            edit_shape.getXY(inext, pt_after);
            if (b_first) {
                edit_shape.getXY(ivert, pt_current);
                edit_shape.getXY(iprev, pt_before);
                v_before.sub(pt_current, pt_before);
                v_before.normalize();
                v_left_prev.leftPerpendicular(v_before);
                v_left_prev.scale(abs_d);
                pt_left_prev.add(v_left_prev, pt_current);
            }
            boolean round_join_override = has_dense_flags && ((int)edit_shape.getAttributeAsDbl(10, ivert, 0) & 1) != 0;
            v_after.sub(pt_after, pt_current);
            v_after.normalize();
            v_left.leftPerpendicular(v_after);
            v_left.scale(abs_d);
            pt.add(pt_current, v_left);
            double cross = v_before.crossProduct(v_after);
            double dot = v_before.dotProduct(v_after);
            boolean bl = bDoJoin = cross < 0.0 || dot < 0.0 && cross < Math.abs(dot) * NumberUtils.doubleEps() * 8.0;
            assert (!cap || bDoJoin);
            if (bDoJoin) {
                if (cap) {
                    if (this.m_caps == 0) {
                        this.m_buffer_commands.add(new BufferCommand(pt_left_prev, pt, pt_current, 2, this.m_buffer_commands.size() + 1, this.m_buffer_commands.size() - 1));
                    } else if (this.m_caps == 1) {
                        this.m_buffer_commands.add(new BufferCommand(pt_left_prev, pt, pt_current, 1, this.m_buffer_commands.size() + 1, this.m_buffer_commands.size() - 1));
                    } else {
                        assert (this.m_caps == 2);
                        c1.setCoords(v_after);
                        c1.scale(-this.m_abs_distance);
                        c2.setCoords(c1);
                        c1.add(pt_left_prev);
                        c2.add(pt);
                        this.m_buffer_commands.add(new BufferCommand(pt_left_prev, c1, pt_current, 1, this.m_buffer_commands.size() + 1, this.m_buffer_commands.size() - 1));
                        this.m_buffer_commands.add(new BufferCommand(c1, c2, pt_current, 1, this.m_buffer_commands.size() + 1, this.m_buffer_commands.size() - 1));
                        this.m_buffer_commands.add(new BufferCommand(c2, pt, pt_current, 1, this.m_buffer_commands.size() + 1, this.m_buffer_commands.size() - 1));
                    }
                } else {
                    int joins;
                    boolean miter = false;
                    int n = joins = round_join_override ? 0 : this.m_joins;
                    if (joins == 1) {
                        double sin_alpha = -cross;
                        miter_point.sub(v_before, v_after);
                        miter_point.scale(this.m_abs_distance / sin_alpha);
                        if (miter_point.length() < this.m_miter_limit * this.m_abs_distance) {
                            miter_point.add(pt_current);
                            miter = true;
                        }
                        this.m_buffer_commands.add(new BufferCommand(pt_left_prev, pt, miter_point, miter ? 8 : 16, this.m_buffer_commands.size() + 1, this.m_buffer_commands.size() - 1));
                    } else {
                        assert (joins == 0 || joins == 2);
                        this.m_buffer_commands.add(new BufferCommand(pt_left_prev, pt, pt_current, joins == 0 ? 2 : 16, this.m_buffer_commands.size() + 1, this.m_buffer_commands.size() - 1));
                    }
                }
            } else if (!pt_left_prev.equals(pt)) {
                this.m_buffer_commands.add(new BufferCommand(pt_left_prev, pt_current, this.m_buffer_commands.size() + 1, this.m_buffer_commands.size() - 1, "dummy"));
                this.m_buffer_commands.add(new BufferCommand(pt_current, pt, this.m_buffer_commands.size() + 1, this.m_buffer_commands.size() - 1, "dummy"));
            }
            pt1.add(pt_after, v_left);
            this.m_buffer_commands.add(new BufferCommand(pt, pt1, pt_current, 1, this.m_buffer_commands.size() + 1, this.m_buffer_commands.size() - 1));
            pt_left_prev.setCoords(pt1);
            v_left_prev.setCoords(v_left);
            pt_before.setCoords(pt_current);
            pt_current.setCoords(pt_after);
            v_before.setCoords(v_after);
            iprev = ivert;
            ivert = inext;
            b_first = false;
            inext = edit_shape.getNextVertex(ivert);
        }
        this.m_buffer_commands.get(this.m_buffer_commands.size() - 1).m_next = 0;
        this.processBufferCommands_(result_mp);
        tr.setShift(origin.x, origin.y);
        result_mp.applyTransformation(tr, result_mp.getPathCount() - 1);
        return 1;
    }

    private int bufferClosedPath_(Geometry input_geom, int ipath, MultiPathImpl result_mp, boolean bfilter, int dir) {
        EditShape edit_shape = new EditShape();
        int geom = edit_shape.addPathFromMultiPath((MultiPath)input_geom, ipath, true);
        return this.bufferClosedPath_(edit_shape, geom, result_mp, bfilter, dir);
    }

    private int bufferClosedPath_(EditShape edit_shape, int geom, MultiPathImpl result_mp, boolean bfilter, int dir) {
        int vertex = edit_shape.getFirstVertex(edit_shape.getFirstPath(geom));
        Point firstPoint = new Point();
        edit_shape.queryPoint(vertex, firstPoint);
        edit_shape.filterClosePoints(this.m_filter_tolerance, false, false);
        int total_point_count = edit_shape.getPointCount(geom);
        if (total_point_count < 2) {
            if (dir < 0) {
                return 0;
            }
            if (this.m_round_buffer) {
                this.addCircle_(result_mp, firstPoint);
            }
            return 2;
        }
        assert (edit_shape.getFirstPath(geom) != -1);
        assert (edit_shape.getFirstVertex(edit_shape.getFirstPath(geom)) != -1);
        Point2D origin = edit_shape.getXY(edit_shape.getFirstVertex(edit_shape.getFirstPath(geom)));
        Transformation2D tr = new Transformation2D();
        tr.setShift(-origin.x, -origin.y);
        edit_shape.applyTransformation(tr);
        if (bfilter) {
            assert (this.m_round_buffer);
            int res_filter = Bufferer.filterPath_(edit_shape, geom, dir, true, this.m_abs_distance, this.m_filter_tolerance, this.m_densify_dist);
            assert (res_filter == 1);
            if (edit_shape.getPointCount(geom) < 2) {
                if (dir < 0) {
                    return 0;
                }
                this.addCircle_(result_mp, firstPoint);
                return 2;
            }
        }
        boolean has_dense_flags = this.m_joins != 0 && edit_shape.getVertexDescription().hasAttribute(10);
        this.m_buffer_commands.clear();
        int path = edit_shape.getFirstPath(geom);
        int ivert = edit_shape.getFirstVertex(path);
        int iprev = dir == 1 ? edit_shape.getPrevVertex(ivert) : edit_shape.getNextVertex(ivert);
        int inext = dir == 1 ? edit_shape.getNextVertex(ivert) : edit_shape.getPrevVertex(ivert);
        boolean b_first = true;
        Point2D pt_current = new Point2D();
        Point2D pt_after = new Point2D();
        Point2D pt_before = new Point2D();
        Point2D pt_left_prev = new Point2D();
        Point2D pt = new Point2D();
        Point2D pt1 = new Point2D();
        Point2D v_after = new Point2D();
        Point2D v_before = new Point2D();
        Point2D v_left = new Point2D();
        Point2D v_left_prev = new Point2D();
        double abs_d = this.m_abs_distance;
        int ncount = edit_shape.getPathSize(path);
        Point2D miter_point = new Point2D();
        for (int index = 0; index < ncount; ++index) {
            boolean bDoJoin;
            edit_shape.getXY(inext, pt_after);
            if (b_first) {
                edit_shape.getXY(ivert, pt_current);
                edit_shape.getXY(iprev, pt_before);
                v_before.sub(pt_current, pt_before);
                v_before.normalize();
                v_left_prev.leftPerpendicular(v_before);
                v_left_prev.scale(abs_d);
                pt_left_prev.add(v_left_prev, pt_current);
            }
            boolean round_join_override = has_dense_flags && ((int)edit_shape.getAttributeAsDbl(10, ivert, 0) & 1) != 0;
            v_after.sub(pt_after, pt_current);
            v_after.normalize();
            v_left.leftPerpendicular(v_after);
            v_left.scale(abs_d);
            pt.add(pt_current, v_left);
            double cross = v_before.crossProduct(v_after);
            double dot = v_before.dotProduct(v_after);
            boolean bl = bDoJoin = cross < 0.0 || dot < 0.0 && cross < Math.abs(dot) * NumberUtils.doubleEps() * 8.0;
            if (bDoJoin) {
                int joins;
                boolean miter = false;
                int n = joins = round_join_override ? 0 : this.m_joins;
                if (joins == 1) {
                    double sin_alpha = -cross;
                    miter_point.sub(v_before, v_after);
                    miter_point.scale(this.m_abs_distance / sin_alpha);
                    if (miter_point.length() < this.m_miter_limit * this.m_abs_distance) {
                        miter_point.add(pt_current);
                        miter = true;
                    }
                    this.m_buffer_commands.add(new BufferCommand(pt_left_prev, pt, miter_point, miter ? 8 : 16, this.m_buffer_commands.size() + 1, this.m_buffer_commands.size() - 1));
                } else {
                    this.m_buffer_commands.add(new BufferCommand(pt_left_prev, pt, pt_current, joins == 0 ? 2 : 16, this.m_buffer_commands.size() + 1, this.m_buffer_commands.size() - 1));
                }
            } else if (!pt_left_prev.isEqual(pt)) {
                this.m_buffer_commands.add(new BufferCommand(pt_left_prev, pt_current, this.m_buffer_commands.size() + 1, this.m_buffer_commands.size() - 1, "dummy"));
                this.m_buffer_commands.add(new BufferCommand(pt_current, pt, this.m_buffer_commands.size() + 1, this.m_buffer_commands.size() - 1, "dummy"));
            }
            pt1.add(pt_after, v_left);
            this.m_buffer_commands.add(new BufferCommand(pt, pt1, pt_current, 1, this.m_buffer_commands.size() + 1, this.m_buffer_commands.size() - 1));
            pt_left_prev.setCoords(pt1);
            v_left_prev.setCoords(v_left);
            pt_before.setCoords(pt_current);
            pt_current.setCoords(pt_after);
            v_before.setCoords(v_after);
            iprev = ivert;
            ivert = inext;
            b_first = false;
            inext = dir == 1 ? edit_shape.getNextVertex(ivert) : edit_shape.getPrevVertex(ivert);
        }
        this.m_buffer_commands.get(this.m_buffer_commands.size() - 1).m_next = 0;
        this.processBufferCommands_(result_mp);
        tr.setShift(origin.x, origin.y);
        result_mp.applyTransformation(tr, result_mp.getPathCount() - 1);
        return 1;
    }

    private void processBufferCommands_(MultiPathImpl result_mp) {
        int ifirst_seg = this.cleanupBufferCommands_();
        boolean first = true;
        int iseg_next = ifirst_seg + 1;
        int iseg = ifirst_seg;
        while (iseg_next != ifirst_seg) {
            BufferCommand command = this.m_buffer_commands.get(iseg);
            int n = iseg_next = command.m_next != -1 ? command.m_next : (iseg + 1) % this.m_buffer_commands.size();
            if (command.m_type != 0) {
                if (first) {
                    result_mp.startPath(command.m_from);
                    first = false;
                }
                if ((command.m_type & 0x1A) != 0) {
                    this.addJoin_(command.m_type, result_mp, command.m_center, command.m_from, command.m_to, false, true);
                } else {
                    result_mp.lineTo(command.m_to);
                }
                first = false;
            }
            iseg = iseg_next;
        }
    }

    private int cleanupBufferCommands_() {
        BufferCommand command;
        if (this.m_helper_array == null) {
            this.m_helper_array = new Point2D[9];
        }
        int istart = 0;
        int iseg = 0;
        int nseg = this.m_buffer_commands.size();
        while (iseg < nseg) {
            command = this.m_buffer_commands.get(iseg);
            if ((command.m_type & 0x1B) != 0) {
                istart = iseg;
                break;
            }
            iseg = command.m_next;
        }
        int iseg_next = istart + 1;
        int iseg2 = istart;
        while (iseg_next != istart) {
            command = this.m_buffer_commands.get(iseg2);
            iseg_next = command.m_next;
            int count = 1;
            BufferCommand command_next = null;
            while (iseg_next != iseg2 && ((command_next = this.m_buffer_commands.get(iseg_next)).m_type & 0x1B) == 0) {
                iseg_next = command_next.m_next;
                ++count;
            }
            if (count == 1) {
                assert (command.m_to.isEqual(command_next.m_from));
            } else if ((command.m_type & command_next.m_type) == 1) {
                if (this.m_helper_line_1 == null) {
                    this.m_helper_line_1 = new Line();
                    this.m_helper_line_2 = new Line();
                }
                this.m_helper_line_1.setStartXY(command.m_from);
                this.m_helper_line_1.setEndXY(command.m_to);
                this.m_helper_line_2.setStartXY(command_next.m_from);
                this.m_helper_line_2.setEndXY(command_next.m_to);
                int count_ = this.m_helper_line_1.intersect(this.m_helper_line_2, this.m_helper_array, null, null, this.m_small_tolerance);
                if (count_ == 1) {
                    command.m_to.setCoords(this.m_helper_array[0]);
                    command_next.m_from.setCoords(this.m_helper_array[0]);
                    command.m_next = iseg_next;
                } else if (count_ == 2) {
                    // empty if block
                }
            }
            iseg2 = iseg_next;
        }
        return istart;
    }

    private static void protectExtremeVertices_(EditShape edit_shape, int protection_index, int geom, int path) {
        int vprev = -1;
        Point2D pt_prev = new Point2D();
        pt_prev.setNaN();
        Point2D pt = new Point2D();
        pt.setNaN();
        Point2D v_before = new Point2D();
        v_before.setNaN();
        Point2D pt_next = new Point2D();
        Point2D v_after = new Point2D();
        int n = edit_shape.getPathSize(path);
        int v = edit_shape.getFirstVertex(path);
        for (int i = 0; i < n; ++i) {
            double d;
            int vnext;
            if (vprev == -1) {
                edit_shape.getXY(v, pt);
                vprev = edit_shape.getPrevVertex(v);
                if (vprev != -1) {
                    edit_shape.getXY(vprev, pt_prev);
                    v_before.sub(pt, pt_prev);
                    v_before.normalize();
                }
            }
            if ((vnext = edit_shape.getNextVertex(v)) == -1) break;
            edit_shape.getXY(vnext, pt_next);
            v_after.sub(pt_next, pt);
            v_after.normalize();
            if (vprev != -1 && (d = v_after.dotProduct(v_before)) < -0.99 && Math.abs(v_after.crossProduct(v_before)) < 1.0E-7) {
                edit_shape.setUserIndex(v, protection_index, 1);
            }
            vprev = v;
            v = vnext;
            pt_prev.setCoords(pt);
            pt.setCoords(pt_next);
            v_before.setCoords(v_after);
        }
    }

    private static int filterPath_(EditShape edit_shape, int geom, int dir, boolean closed, double abs_distance, double filter_tolerance, double densify_distance) {
        int path = edit_shape.getFirstPath(geom);
        int fixed_vertices_index = edit_shape.createUserIndex();
        Bufferer.protectExtremeVertices_(edit_shape, fixed_vertices_index, geom, path);
        for (int iter = 0; iter < 100; ++iter) {
            int isize = edit_shape.getPathSize(path);
            if (isize == 0) {
                edit_shape.removeUserIndex(fixed_vertices_index);
                return 1;
            }
            int ivert = edit_shape.getFirstVertex(path);
            int nvertices = edit_shape.getPathSize(path);
            if (nvertices < 3) {
                edit_shape.removeUserIndex(fixed_vertices_index);
                return 1;
            }
            if (closed && !edit_shape.isClosedPath(path)) {
                --nvertices;
            }
            int nfilter = 64;
            int filtered_in_pass = 0;
            boolean go_back = false;
            for (int i = 0; i < nvertices && ivert != -1; ++i) {
                int prev;
                int filtered_now = 0;
                int v = ivert;
                int n = Math.min(64, nvertices - i);
                for (int filter = 1; filter < n; ++filter) {
                    v = edit_shape.getNextVertex(v, dir);
                    if (filter <= 1) continue;
                    int num = Bufferer.clipFilter_(edit_shape, fixed_vertices_index, ivert, v, dir, abs_distance, densify_distance, 64);
                    if (num == -1) break;
                    filtered_now += num;
                    nvertices -= num;
                }
                filtered_in_pass += filtered_now;
                boolean bl = go_back = filtered_now > 0;
                if (go_back && (prev = edit_shape.getPrevVertex(ivert, dir)) != -1) {
                    ivert = prev;
                    ++nvertices;
                    continue;
                }
                ivert = edit_shape.getNextVertex(ivert, dir);
            }
            if (filtered_in_pass == 0) break;
        }
        edit_shape.removeUserIndex(fixed_vertices_index);
        edit_shape.filterClosePoints(filter_tolerance, false, false);
        return 1;
    }

    private static int clipFilter_(EditShape edit_shape, int fixed_vertices_index, int from_vertex, int to_vertex, int dir, double abs_distance, double densify_distance, int max_filter) {
        Point2D pt2;
        Point2D pt1 = edit_shape.getXY(from_vertex);
        if (pt1.equals(pt2 = edit_shape.getXY(to_vertex))) {
            return -1;
        }
        double densify_distance_delta = densify_distance * 0.25;
        double erase_distance_delta = densify_distance * 0.25;
        Point2D v_gap = new Point2D();
        v_gap.sub(pt2, pt1);
        double gap_length = v_gap.length();
        double h2_4 = gap_length * gap_length * 0.25;
        double sqr_center_to_chord = abs_distance * abs_distance - h2_4;
        if (sqr_center_to_chord <= h2_4) {
            return -1;
        }
        double center_to_chord = Math.sqrt(sqr_center_to_chord);
        v_gap.normalize();
        Point2D v_gap_norm = new Point2D(v_gap);
        v_gap_norm.rightPerpendicular();
        double chord_to_corner = h2_4 / center_to_chord;
        boolean can_erase_corner_point = chord_to_corner <= erase_distance_delta;
        Point2D chord_midpoint = new Point2D();
        MathUtils.lerp(pt2, pt1, 0.5, chord_midpoint);
        Point2D corner = new Point2D(v_gap_norm);
        double corrected_chord_to_corner = chord_to_corner - densify_distance_delta;
        corner.scaleAdd(Math.max(0.0, corrected_chord_to_corner), chord_midpoint);
        Point2D center = new Point2D(v_gap_norm);
        center.negate();
        center.scaleAdd(center_to_chord, chord_midpoint);
        double allowed_distance = abs_distance - erase_distance_delta;
        double sqr_allowed_distance = MathUtils.sqr(allowed_distance);
        double sqr_large_distance = sqr_allowed_distance * 3.61;
        Point2D co_p1 = new Point2D();
        co_p1.sub(corner, pt1);
        Point2D co_p2 = new Point2D();
        co_p2.sub(corner, pt2);
        boolean large_distance = false;
        int cnt = 0;
        char[] locations = new char[64];
        Point2D pt = new Point2D();
        int v = edit_shape.getPrevVertex(to_vertex, dir);
        while (v != from_vertex) {
            if (edit_shape.getUserIndex(v, fixed_vertices_index) == 1) {
                return -1;
            }
            edit_shape.getXY(v, pt);
            if (!pt.equals(pt2)) break;
            int v1 = edit_shape.getPrevVertex(v, dir);
            edit_shape.removeVertex(v, false);
            v = v1;
        }
        Point2D prev_prev_pt = new Point2D();
        prev_prev_pt.setNaN();
        Point2D prev_pt = new Point2D();
        prev_pt.setCoords(pt1);
        locations[cnt++] = '\u0001';
        Point2D dummyPt = new Point2D();
        int v2 = edit_shape.getNextVertex(from_vertex, dir);
        while (v2 != to_vertex) {
            if (edit_shape.getUserIndex(v2, fixed_vertices_index) == 1) {
                return -1;
            }
            edit_shape.getXY(v2, pt);
            if (pt.equals(prev_pt)) {
                int v1 = edit_shape.getNextVertex(v2, dir);
                edit_shape.removeVertex(v2, false);
                v2 = v1;
                continue;
            }
            locations[cnt++] = '\u0000';
            Point2D v1 = new Point2D();
            v1.sub(pt, pt1);
            if (v1.dotProduct(v_gap_norm) < 0.0) {
                return 0;
            }
            if (Point2D.sqrDistance(pt, pt1) > sqr_large_distance || Point2D.sqrDistance(pt, pt2) > sqr_large_distance) {
                large_distance = true;
            }
            int next_location = 0;
            dummyPt.sub(pt, pt1);
            double cs1 = dummyPt.crossProduct(co_p1);
            if (cs1 >= 0.0) {
                next_location = 1;
            }
            dummyPt.sub(pt, pt2);
            double cs2 = dummyPt.crossProduct(co_p2);
            if (cs2 <= 0.0) {
                next_location = (char)(next_location | 2);
            }
            if (next_location == 0) {
                return 0;
            }
            locations[cnt - 1] = next_location;
            prev_prev_pt.setCoords(prev_pt);
            prev_pt.setCoords(pt);
            v2 = edit_shape.getNextVertex(v2, dir);
        }
        if (cnt == 1) {
            return 0;
        }
        assert (!pt2.equals(prev_pt));
        locations[cnt++] = 2;
        boolean can_clip_all = true;
        int k = 0;
        for (int i = 1; i < cnt; ++i) {
            if (locations[i] == locations[i - 1]) continue;
            boolean bl = can_clip_all = ++k < 3 && (k == 1 && locations[i] == '\u0003' || k == 2 && locations[i] == '\u0002');
            if (can_clip_all) continue;
            return 0;
        }
        if (cnt > 2 && can_clip_all && (cnt == 3 || !large_distance)) {
            int clip_count = 0;
            int v3 = edit_shape.getNextVertex(from_vertex, dir);
            if (!can_erase_corner_point) {
                edit_shape.setXY(v3, corner);
                v3 = edit_shape.getNextVertex(v3, dir);
            }
            while (v3 != to_vertex) {
                int v1 = edit_shape.getNextVertex(v3, dir);
                edit_shape.removeVertex(v3, false);
                v3 = v1;
                ++clip_count;
            }
            return clip_count;
        }
        if (cnt == 3) {
            boolean case2;
            boolean case1 = locations[0] == '\u0001' && locations[1] == '\u0002' && locations[2] == '\u0002';
            boolean bl = case2 = locations[0] == '\u0001' && locations[1] == '\u0001' && locations[2] == '\u0002';
            if (case1 || case2) {
                Point2D p1 = edit_shape.getXY(from_vertex);
                v2 = edit_shape.getNextVertex(from_vertex, dir);
                Point2D p2 = edit_shape.getXY(v2);
                Point2D p3 = edit_shape.getXY(edit_shape.getNextVertex(v2, dir));
                if (case2) {
                    Point2D temp = p1;
                    p1 = p3;
                    p3 = temp;
                }
                Point2D vec = new Point2D();
                vec.sub(p1, p2);
                p3.sub(p2);
                double veclen = vec.length();
                double wcosa = vec.dotProduct(p3) / veclen;
                double wsina = Math.abs(p3.crossProduct(vec) / veclen);
                double z = 2.0 * abs_distance - wsina;
                if (z < 0.0) {
                    return 0;
                }
                double x = wcosa + Math.sqrt(wsina * z);
                if (x > veclen) {
                    return 0;
                }
                Point2D hvec = new Point2D();
                hvec.scaleAdd(-x / veclen, vec, p3);
                double h = hvec.length();
                double y = -(h * h * veclen) / (2.0 * hvec.dotProduct(vec));
                double t = (x - y) / veclen;
                MathUtils.lerp(p2, p1, t, p2);
                edit_shape.setXY(v2, p2);
                return 0;
            }
        }
        if (large_distance && cnt > 3) {
            return 0;
        }
        Point2D pt_prev = new Point2D();
        int v_cur = from_vertex;
        Point2D pt_cur = new Point2D(pt1);
        int cur_location = 1;
        int prev_location = -1;
        int v_next = v_cur;
        int clip_count = 0;
        cnt = 1;
        while (v_next != to_vertex) {
            int next_location;
            v_next = edit_shape.getNextVertex(v_next, dir);
            if ((next_location = locations[cnt++]) == 0) {
                if (v_next != to_vertex) continue;
                break;
            }
            Point2D pt_next = edit_shape.getXY(v_next);
            if (prev_location != -1) {
                int common_location = prev_location & cur_location & next_location;
                if ((common_location & 3) != 0) {
                    edit_shape.removeVertex(v_cur, true);
                    ++clip_count;
                    v_cur = v_next;
                    pt_cur.setCoords(pt_next);
                    cur_location = next_location;
                    continue;
                }
                if (cur_location == 3 && prev_location != 0 && next_location != 0) {
                    assert ((prev_location & next_location) == 0);
                    pt_cur.setCoords(corner);
                    if (can_erase_corner_point || pt_cur.equals(pt_prev)) {
                        edit_shape.removeVertex(v_cur, true);
                        ++clip_count;
                        v_cur = v_next;
                        pt_cur.setCoords(pt_next);
                        cur_location = next_location;
                        continue;
                    }
                    edit_shape.setXY(v_cur, pt_cur);
                } else if (next_location == 0 && cur_location != 0 || next_location != 0 && cur_location == 0 || (next_location | cur_location) != 3 || next_location == 3 || cur_location != 3) {
                    // empty if block
                }
            }
            prev_location = cur_location;
            pt_prev.setCoords(pt_cur);
            v_cur = v_next;
            cur_location = next_location;
            pt_cur.setCoords(pt_next);
        }
        return clip_count;
    }

    private boolean isDegeneratePath_(MultiPathImpl mp_impl, int ipath) {
        if (mp_impl.getPathSize(ipath) == 1) {
            return true;
        }
        Envelope2D env = new Envelope2D();
        mp_impl.queryPathEnvelope2D(ipath, env);
        return Math.max(env.getWidth(), env.getHeight()) < this.m_densify_dist * 0.5;
    }

    private boolean isDegenerateGeometry_(Geometry geom) {
        Envelope2D env = new Envelope2D();
        geom.queryEnvelope2D(env);
        return Math.max(env.getWidth(), env.getHeight()) < this.m_densify_dist * 0.5;
    }

    private void addSquare_(MultiPathImpl result_mp, Point point) {
        Envelope env = new Envelope(point.getDescription());
        env.setCoords(point.getX(), point.getY(), point.getX(), point.getY());
        env.inflate(this.m_abs_distance, this.m_abs_distance);
        result_mp.addEnvelope(env, false);
    }

    private void addCircle_(MultiPathImpl result_mp, Point point) {
        Point2D center = point.getXY();
        if (this.m_circle_template != null && !this.m_circle_template.isEmpty()) {
            Point2D p = new Point2D();
            p.setCoords(this.m_circle_template.get(0));
            p.scaleAdd(this.m_abs_distance, center);
            result_mp.startPath(p);
            int n = this.m_circle_template.size();
            for (int i = 1; i < n; ++i) {
                p.setCoords(this.m_circle_template.get(i));
                p.scaleAdd(this.m_abs_distance, center);
                result_mp.lineTo(p);
            }
            return;
        }
        int N = this.m_circle_template_size;
        int real_size = (N + 3) / 4;
        double dA = 1.5707963267948966 / (double)real_size;
        double dcos = Math.cos(dA);
        double dsin = Math.sin(dA);
        Point2D pt = new Point2D();
        for (int quadrant = 3; quadrant >= 0; --quadrant) {
            pt.setCoords(0.0, this.m_abs_distance);
            switch (quadrant) {
                case 0: {
                    int i;
                    for (i = 0; i < real_size; ++i) {
                        result_mp.lineTo(pt.x + center.x, pt.y + center.y);
                        pt.rotateReverse(dcos, dsin);
                    }
                    break;
                }
                case 1: {
                    int i;
                    for (i = 0; i < real_size; ++i) {
                        result_mp.lineTo(-pt.y + center.x, pt.x + center.y);
                        pt.rotateReverse(dcos, dsin);
                    }
                    break;
                }
                case 2: {
                    int i;
                    for (i = 0; i < real_size; ++i) {
                        result_mp.lineTo(-pt.x + center.x, -pt.y + center.y);
                        pt.rotateReverse(dcos, dsin);
                    }
                    break;
                }
                default: {
                    int i;
                    result_mp.startPath(pt.y + center.x, -pt.x + center.y);
                    for (i = 1; i < real_size; ++i) {
                        pt.rotateReverse(dcos, dsin);
                        result_mp.lineTo(pt.y + center.x, -pt.x + center.y);
                    }
                }
            }
            this.progress_();
        }
    }

    private static Polygon setWeakSimple_(Polygon poly) {
        ((MultiPathImpl)poly._getImpl()).setIsSimple(3, 0.0, false);
        return poly;
    }

    private Polygon setStrongSimple_(Polygon poly) {
        ((MultiPathImpl)poly._getImpl()).setIsSimple(4, this.m_tolerance, false);
        ((MultiPathImpl)poly._getImpl())._updateOGCFlags();
        return poly;
    }

    private static final class GeometryCursorForPolygon
    extends GeometryCursor {
        private Bufferer m_bufferer;
        private int m_index;

        GeometryCursorForPolygon(Bufferer bufferer) {
            this.m_bufferer = bufferer;
            this.m_index = 0;
        }

        @Override
        public Geometry next() {
            Polygon input_polygon = (Polygon)this.m_bufferer.m_geometry;
            if (this.m_index < input_polygon.getPathCount()) {
                double hole_area;
                int ind = this.m_index;
                double area = input_polygon.calculateRingArea2D(this.m_index);
                assert (area > 0.0);
                ++this.m_index;
                while (this.m_index < input_polygon.getPathCount() && !((hole_area = input_polygon.calculateRingArea2D(this.m_index)) > 0.0)) {
                    ++this.m_index;
                }
                if (ind == 0 && this.m_index == input_polygon.getPathCount()) {
                    return this.m_bufferer.bufferPolygonImpl_(input_polygon, 0, input_polygon.getPathCount());
                }
                return this.m_bufferer.bufferPolygonImpl_(input_polygon, ind, this.m_index);
            }
            return null;
        }

        @Override
        public int getGeometryID() {
            return 0;
        }
    }

    private static final class GeometryCursorForPolyline
    extends GeometryCursor {
        private Bufferer m_bufferer;
        GeometryCursor m_geoms;
        Geometry m_geometry;
        private int m_index;
        private boolean m_bfilter;

        GeometryCursorForPolyline(Bufferer bufferer, GeometryCursor geoms, boolean bfilter) {
            this.m_bufferer = bufferer;
            this.m_geoms = geoms;
            this.m_index = 0;
            this.m_bfilter = bfilter;
        }

        @Override
        public Geometry next() {
            MultiPath mp;
            if (this.m_geometry == null) {
                this.m_index = 0;
                this.m_geometry = this.m_geoms.next();
                if (this.m_geometry == null) {
                    return null;
                }
            }
            if (this.m_index < (mp = (MultiPath)this.m_geometry).getPathCount()) {
                int ind = this.m_index++;
                Polygon res = this.m_bufferer.bufferPolylinePath_((Polyline)this.m_geometry, ind, this.m_bfilter);
                assert (InternalUtils.isAtLeastWeakSimple(res, 0.0));
                return res;
            }
            this.m_geometry = null;
            return this.next();
        }

        @Override
        public int getGeometryID() {
            return 0;
        }
    }

    private static final class GlueingCursorForPolyline
    extends GeometryCursor {
        private Polyline m_polyline;
        private int m_current_path_index;

        GlueingCursorForPolyline(Polyline polyline) {
            this.m_polyline = polyline;
            this.m_current_path_index = 0;
        }

        @Override
        public Geometry next() {
            if (this.m_polyline == null) {
                return null;
            }
            MultiPathImpl mp = (MultiPathImpl)this.m_polyline._getImpl();
            int npaths = mp.getPathCount();
            if (this.m_current_path_index < npaths) {
                int ind;
                if (!mp.isClosedPathInXYPlane(ind = this.m_current_path_index++)) {
                    Point2D prev_end = mp.getXY(mp.getPathEnd(ind) - 1);
                    while (this.m_current_path_index < mp.getPathCount()) {
                        Point2D start = mp.getXY(mp.getPathStart(this.m_current_path_index));
                        if (mp.isClosedPathInXYPlane(this.m_current_path_index) || !start.isEqual(prev_end)) break;
                        prev_end = mp.getXY(mp.getPathEnd(this.m_current_path_index) - 1);
                        ++this.m_current_path_index;
                    }
                }
                if (ind == 0 && this.m_current_path_index == this.m_polyline.getPathCount()) {
                    Polyline pol = this.m_polyline;
                    this.m_polyline = null;
                    return pol;
                }
                Polyline tmp_polyline = new Polyline(this.m_polyline.getDescription());
                tmp_polyline.addPath(this.m_polyline, ind, true);
                for (int i = ind + 1; i < this.m_current_path_index; ++i) {
                    tmp_polyline.addSegmentsFromPath(this.m_polyline, i, 0, mp.getSegmentCount(i), false);
                }
                if (this.m_current_path_index == this.m_polyline.getPathCount()) {
                    this.m_polyline = null;
                }
                return tmp_polyline;
            }
            return null;
        }

        @Override
        public int getGeometryID() {
            return 0;
        }
    }

    private static final class GeometryCursorForMultiPoint
    extends GeometryCursor {
        private Bufferer m_parent;
        private int m_index;
        private Geometry m_buffered_polygon;
        private MultiPoint m_mp;
        private SpatialReference m_spatialReference;
        private double m_distance;
        private double m_densify_dist;
        private double m_x;
        private double m_y;
        private int m_max_vertex_in_complete_circle;
        private int m_caps;
        private int m_joins;
        private double m_miter_limit;

        GeometryCursorForMultiPoint(Bufferer parent, MultiPoint mp, double distance, SpatialReference sr, int joins, int caps, double miter_limit, double densify_dist, int max_vertex_in_complete_circle, ProgressTracker progress_tracker) {
            this.m_parent = parent;
            this.m_index = 0;
            this.m_mp = mp;
            this.m_x = 0.0;
            this.m_y = 0.0;
            this.m_distance = distance;
            this.m_spatialReference = sr;
            this.m_densify_dist = densify_dist;
            this.m_max_vertex_in_complete_circle = max_vertex_in_complete_circle;
            this.m_joins = joins;
            this.m_caps = caps;
            this.m_miter_limit = miter_limit;
        }

        @Override
        public Geometry next() {
            Geometry res;
            Point point = new Point();
            do {
                if (this.m_index == this.m_mp.getPointCount()) {
                    return null;
                }
                if (this.m_caps == 1) {
                    this.m_index = this.m_mp.getPointCount();
                    return new Polygon(this.m_mp.getDescription());
                }
                this.m_mp.getPointByVal(this.m_index, point);
                ++this.m_index;
            } while (point.isEmpty());
            boolean b_first = false;
            if (this.m_buffered_polygon == null) {
                this.m_x = point.getX();
                this.m_y = point.getY();
                this.m_buffered_polygon = this.m_parent.buffer(point, this.m_distance, this.m_spatialReference, this.m_joins, this.m_caps, this.m_miter_limit, this.m_densify_dist, this.m_max_vertex_in_complete_circle);
                b_first = true;
            }
            if (this.m_index < this.m_mp.getPointCount()) {
                res = new Polygon();
                this.m_buffered_polygon.copyTo(res);
            } else {
                res = this.m_buffered_polygon;
            }
            if (!b_first) {
                Transformation2D transform = new Transformation2D();
                double dx = point.getX() - this.m_x;
                double dy = point.getY() - this.m_y;
                transform.setShift(dx, dy);
                res.applyTransformation(transform);
            }
            return res;
        }

        @Override
        public int getGeometryID() {
            return 0;
        }
    }

    private static final class BufferCommand {
        private Point2D m_from = new Point2D();
        private Point2D m_to = new Point2D();
        private Point2D m_center = new Point2D();
        private int m_next;
        private int m_type;

        private BufferCommand(Point2D from, Point2D to, Point2D center, int type, int next, int prev) {
            this.m_from.setCoords(from);
            this.m_to.setCoords(to);
            this.m_center.setCoords(center);
            this.m_type = type;
            this.m_next = next;
        }

        private BufferCommand(Point2D from, Point2D to, int next, int prev, String dummy) {
            this.m_from.setCoords(from);
            this.m_to.setCoords(to);
            this.m_center.setNaN();
            this.m_type = 4;
            this.m_next = next;
        }

        private static interface Flags {
            public static final int enum_line = 1;
            public static final int enum_arc = 2;
            public static final int enum_miter = 8;
            public static final int enum_bevel = 16;
            public static final int enum_join_mask = 26;
            public static final int enum_connection_mask = 27;
        }
    }
}

