/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Function;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Objects;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Predicate;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Predicates;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Collections2;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableList;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Iterators$1;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Iterators$11;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Iterators$12;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Iterators$2;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Iterators$3;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Iterators$5;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Iterators$7;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Iterators$8;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.UnmodifiableIterator;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.UnmodifiableListIterator;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nullable;

public final class Iterators {
    static final UnmodifiableListIterator EMPTY_LIST_ITERATOR = new Iterators$1();
    private static final Iterator EMPTY_MODIFIABLE_ITERATOR = new Iterators$2();

    public static UnmodifiableIterator emptyIterator() {
        return Iterators.emptyListIterator();
    }

    static UnmodifiableListIterator emptyListIterator() {
        return EMPTY_LIST_ITERATOR;
    }

    static Iterator emptyModifiableIterator() {
        return EMPTY_MODIFIABLE_ITERATOR;
    }

    public static UnmodifiableIterator unmodifiableIterator(Iterator iterator) {
        Preconditions.checkNotNull(iterator);
        if (iterator instanceof UnmodifiableIterator) {
            return (UnmodifiableIterator)iterator;
        }
        return new Iterators$3(iterator);
    }

    public static int size(Iterator iterator) {
        int n = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++n;
        }
        return n;
    }

    public static boolean contains(Iterator iterator, @Nullable Object object) {
        return Iterators.any(iterator, Predicates.equalTo(object));
    }

    public static boolean removeAll(Iterator iterator, Collection collection) {
        return Iterators.removeIf(iterator, Predicates.in(collection));
    }

    public static boolean removeIf(Iterator iterator, Predicate predicate) {
        Preconditions.checkNotNull(predicate);
        boolean bl = false;
        while (iterator.hasNext()) {
            if (!predicate.apply(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public static boolean elementsEqual(Iterator iterator, Iterator iterator2) {
        while (iterator.hasNext()) {
            Object e;
            if (!iterator2.hasNext()) {
                return false;
            }
            Object e2 = iterator.next();
            if (Objects.equal(e2, e = iterator2.next())) continue;
            return false;
        }
        return !iterator2.hasNext();
    }

    public static String toString(Iterator iterator) {
        return Collections2.STANDARD_JOINER.appendTo(new StringBuilder().append('['), iterator).append(']').toString();
    }

    public static Object getOnlyElement(Iterator iterator) {
        Object e = iterator.next();
        if (!iterator.hasNext()) {
            return e;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("expected one element but was: <" + e);
        for (int i = 0; i < 4 && iterator.hasNext(); ++i) {
            stringBuilder.append(", " + iterator.next());
        }
        if (iterator.hasNext()) {
            stringBuilder.append(", ...");
        }
        stringBuilder.append('>');
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public static boolean addAll(Collection collection, Iterator iterator) {
        Preconditions.checkNotNull(collection);
        Preconditions.checkNotNull(iterator);
        boolean bl = false;
        while (iterator.hasNext()) {
            bl |= collection.add(iterator.next());
        }
        return bl;
    }

    public static Iterator concat(Iterator iterator, Iterator iterator2) {
        return Iterators.concat(ImmutableList.of(iterator, iterator2).iterator());
    }

    public static Iterator concat(Iterator iterator) {
        Preconditions.checkNotNull(iterator);
        return new Iterators$5(iterator);
    }

    public static UnmodifiableIterator filter(Iterator iterator, Predicate predicate) {
        Preconditions.checkNotNull(iterator);
        Preconditions.checkNotNull(predicate);
        return new Iterators$7(iterator, predicate);
    }

    public static boolean any(Iterator iterator, Predicate predicate) {
        return Iterators.indexOf(iterator, predicate) != -1;
    }

    public static int indexOf(Iterator iterator, Predicate predicate) {
        Preconditions.checkNotNull(predicate, "predicate");
        int n = 0;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (predicate.apply(e)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static Iterator transform(Iterator iterator, Function function) {
        Preconditions.checkNotNull(function);
        return new Iterators$8(iterator, function);
    }

    @Nullable
    public static Object getNext(Iterator iterator, @Nullable Object object) {
        return iterator.hasNext() ? iterator.next() : object;
    }

    static void clear(Iterator iterator) {
        Preconditions.checkNotNull(iterator);
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    public static UnmodifiableIterator forArray(Object ... objectArray) {
        return Iterators.forArray(objectArray, 0, objectArray.length, 0);
    }

    static UnmodifiableListIterator forArray(Object[] objectArray, int n, int n2, int n3) {
        Preconditions.checkArgument(n2 >= 0);
        int n4 = n + n2;
        Preconditions.checkPositionIndexes(n, n4, objectArray.length);
        Preconditions.checkPositionIndex(n3, n2);
        if (n2 == 0) {
            return Iterators.emptyListIterator();
        }
        return new Iterators$11(n2, n3, objectArray, n);
    }

    public static UnmodifiableIterator singletonIterator(@Nullable Object object) {
        return new Iterators$12(object);
    }
}

