/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.toolkit;

import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.entity.GlobalConfiguration;
import com.baomidou.mybatisplus.entity.TableFieldInfo;
import com.baomidou.mybatisplus.entity.TableInfo;
import com.baomidou.mybatisplus.enums.FieldStrategy;
import com.baomidou.mybatisplus.enums.IdType;
import com.baomidou.mybatisplus.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.toolkit.StringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.builder.MapperBuilderAssistant;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableInfoHelper {
    private static final Log logger = LogFactory.getLog(TableInfoHelper.class);
    private static final Map<String, TableInfo> tableInfoCache = new ConcurrentHashMap<String, TableInfo>();
    private static final String DEFAULT_ID_NAME = "id";

    public static TableInfo getTableInfo(Class<?> clazz) {
        return tableInfoCache.get(clazz.getName());
    }

    public static TableInfo getRandomTableInfo() {
        Collection<TableInfo> tableInfos = tableInfoCache.values();
        if (CollectionUtils.isNotEmpty(tableInfos)) {
            Iterator<TableInfo> iterator = tableInfos.iterator();
            TableInfo tableInfo = iterator.next();
            return tableInfo;
        }
        return null;
    }

    public static synchronized TableInfo initTableInfo(MapperBuilderAssistant builderAssistant, Class<?> clazz) {
        TableInfo ti = tableInfoCache.get(clazz.getName());
        if (ti != null) {
            return ti;
        }
        TableInfo tableInfo = new TableInfo();
        GlobalConfiguration globalCache = null;
        if (null != builderAssistant) {
            tableInfo.setCurrentNamespace(builderAssistant.getCurrentNamespace());
            tableInfo.setConfigMark(builderAssistant.getConfiguration());
            globalCache = GlobalConfiguration.GlobalConfig(builderAssistant.getConfiguration());
        } else {
            globalCache = GlobalConfiguration.DEFAULT;
        }
        TableName table = clazz.getAnnotation(TableName.class);
        String tableName = clazz.getSimpleName();
        if (table != null && StringUtils.isNotEmpty(table.value())) {
            tableName = table.value();
        } else {
            if (globalCache.isDbColumnUnderline()) {
                tableName = StringUtils.camelToUnderline(tableName);
            }
            if (globalCache.isCapitalMode()) {
                tableName = tableName.toUpperCase();
            }
        }
        tableInfo.setTableName(tableName);
        if (table != null && StringUtils.isNotEmpty(table.resultMap())) {
            tableInfo.setResultMap(table.resultMap());
        }
        ArrayList<TableFieldInfo> fieldList = new ArrayList<TableFieldInfo>();
        List<Field> list = TableInfoHelper.getAllFields(clazz);
        boolean existTableId = TableInfoHelper.existTableId(list);
        for (Field field : list) {
            if ((!existTableId ? TableInfoHelper.initFieldId(globalCache, tableInfo, field, clazz) : TableInfoHelper.initTableId(globalCache, tableInfo, field, clazz)) || TableInfoHelper.initTableField(globalCache, fieldList, field, clazz)) continue;
            fieldList.add(new TableFieldInfo(globalCache, field.getName()));
        }
        tableInfo.setFieldList(fieldList);
        if (null == tableInfo.getKeyColumn()) {
            logger.warn(String.format("Warn: Could not find @TableId in Class: %s, initTableInfo Method Fail.", clazz.getName()));
            return null;
        }
        tableInfoCache.put(clazz.getName(), tableInfo);
        return tableInfo;
    }

    public static boolean existTableId(List<Field> list) {
        boolean exist = false;
        for (Field field : list) {
            TableId tableId = field.getAnnotation(TableId.class);
            if (tableId == null) continue;
            exist = true;
            break;
        }
        return exist;
    }

    private static boolean initTableId(GlobalConfiguration globalConfig, TableInfo tableInfo, Field field, Class<?> clazz) {
        TableId tableId = field.getAnnotation(TableId.class);
        if (tableId != null) {
            if (tableInfo.getKeyColumn() == null) {
                if (IdType.INPUT != tableId.type()) {
                    tableInfo.setIdType(tableId.type());
                } else {
                    tableInfo.setIdType(globalConfig.getIdType());
                }
                String column = field.getName();
                if (StringUtils.isNotEmpty(tableId.value())) {
                    column = tableId.value();
                    tableInfo.setKeyRelated(true);
                } else {
                    if (globalConfig.isDbColumnUnderline()) {
                        column = StringUtils.camelToUnderline(column);
                    }
                    if (globalConfig.isCapitalMode()) {
                        column = column.toUpperCase();
                    }
                }
                tableInfo.setKeyColumn(column);
                tableInfo.setKeyProperty(field.getName());
                return true;
            }
            TableInfoHelper.throwExceptionId(clazz);
        }
        return false;
    }

    private static boolean initFieldId(GlobalConfiguration globalConfig, TableInfo tableInfo, Field field, Class<?> clazz) {
        String column = field.getName();
        if (globalConfig.isCapitalMode()) {
            column = column.toUpperCase();
        }
        if (DEFAULT_ID_NAME.equalsIgnoreCase(column)) {
            if (tableInfo.getKeyColumn() == null) {
                tableInfo.setIdType(globalConfig.getIdType());
                tableInfo.setKeyColumn(column);
                tableInfo.setKeyProperty(field.getName());
                return true;
            }
            TableInfoHelper.throwExceptionId(clazz);
        }
        return false;
    }

    private static void throwExceptionId(Class<?> clazz) {
        StringBuffer errorMsg = new StringBuffer();
        errorMsg.append("There must be only one, Discover multiple @TableId annotation in ");
        errorMsg.append(clazz.getName());
        throw new MybatisPlusException(errorMsg.toString());
    }

    private static boolean initTableField(GlobalConfiguration globalCache, List<TableFieldInfo> fieldList, Field field, Class<?> clazz) {
        TableField tableField = field.getAnnotation(TableField.class);
        if (tableField != null) {
            String columnName = field.getName();
            if (StringUtils.isNotEmpty(tableField.value())) {
                columnName = tableField.value();
            }
            Class<?> fieldType = field.getType();
            FieldStrategy validate = tableField.validate();
            if (String.class.isAssignableFrom(fieldType) && FieldStrategy.NOT_NULL.equals((Object)validate)) {
                validate = FieldStrategy.NOT_EMPTY;
            }
            String el = field.getName();
            if (StringUtils.isNotEmpty(tableField.el())) {
                el = tableField.el();
            }
            String[] columns = columnName.split(";");
            String[] els = el.split(";");
            if (null != columns && null != els && columns.length == els.length) {
                for (int i = 0; i < columns.length; ++i) {
                    fieldList.add(new TableFieldInfo(globalCache, columns[i], field.getName(), els[i], validate));
                }
            } else {
                String errorMsg = "Class: %s, Field: %s, 'value' 'el' Length must be consistent.";
                throw new MybatisPlusException(String.format(errorMsg, clazz.getName(), field.getName()));
            }
            return true;
        }
        return false;
    }

    private static List<Field> getAllFields(Class<?> clazz) {
        Field[] fields;
        LinkedList<Field> result = new LinkedList<Field>();
        for (Field field : fields = clazz.getDeclaredFields()) {
            TableField tableField;
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers()) || (tableField = field.getAnnotation(TableField.class)) != null && !tableField.exist()) continue;
            result.add(field);
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass.equals(Object.class)) {
            return result;
        }
        result.addAll(TableInfoHelper.getAllFields(superClass));
        return result;
    }

    public static void initSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        Configuration configuration = sqlSessionFactory.getConfiguration();
        GlobalConfiguration globalCache = GlobalConfiguration.GlobalConfig(configuration);
        if (globalCache == null) {
            GlobalConfiguration defaultCache = GlobalConfiguration.defaults();
            defaultCache.setSqlSessionFactory(sqlSessionFactory);
            GlobalConfiguration.setGlobalConfig(configuration, defaultCache);
        } else {
            globalCache.setSqlSessionFactory(sqlSessionFactory);
        }
    }
}

