/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.toolkit;

import com.baomidou.mybatisplus.enums.SQLlikeType;
import com.baomidou.mybatisplus.toolkit.StringEscape;
import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtils {
    public static final String EMPTY = "";
    public static final char UNDERLINE = '_';
    public static final String PLACE_HOLDER = "{%s}";

    public static boolean isEmpty(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !StringUtils.isEmpty(cs);
    }

    public static String camelToUnderline(String param) {
        if (StringUtils.isEmpty(param)) {
            return EMPTY;
        }
        int len = param.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = param.charAt(i);
            if (Character.isUpperCase(c) && i > 0) {
                sb.append('_');
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static String underlineToCamel(String param) {
        if (StringUtils.isEmpty(param)) {
            return EMPTY;
        }
        String temp = param.toLowerCase();
        int len = temp.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = temp.charAt(i);
            if (c == '_') {
                if (++i >= len) continue;
                sb.append(Character.toUpperCase(temp.charAt(i)));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean isUpperCase(String str) {
        return StringUtils.match("^[A-Z]+$", str);
    }

    public static boolean match(String regex, String str) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(str);
        return matcher.matches();
    }

    public static String sqlArgsFill(String content, Object ... args) {
        int length;
        if (null == content) {
            return null;
        }
        if (args != null && (length = args.length) >= 1) {
            for (int i = 0; i < length; ++i) {
                content = Pattern.compile(String.format(PLACE_HOLDER, i), 16).matcher(content).replaceAll(StringUtils.sqlParam(args[i]));
            }
        }
        return content;
    }

    public static String sqlParam(Object obj) {
        String repStr = obj instanceof Collection ? StringUtils.quotaMarkList((Collection)obj) : StringUtils.quotaMark(obj);
        return repStr;
    }

    public static String quotaMark(Object obj) {
        String srcStr = String.valueOf(obj);
        if (obj instanceof String) {
            return StringEscape.escapeString(srcStr);
        }
        return srcStr;
    }

    public static String concatLike(String str, SQLlikeType type) {
        switch (type) {
            case LEFT: {
                str = "%" + str;
                break;
            }
            case RIGHT: {
                str = str + "%";
                break;
            }
            default: {
                str = "%" + str + "%";
            }
        }
        return StringEscape.escapeString(str);
    }

    public static String quotaMarkList(Collection<?> coll) {
        StringBuilder sqlBuild = new StringBuilder();
        sqlBuild.append("(");
        int _size = coll.size();
        int i = 0;
        Iterator<?> iterator = coll.iterator();
        while (iterator.hasNext()) {
            String tempVal = StringUtils.quotaMark(iterator.next());
            if (i + 1 == _size) {
                sqlBuild.append(tempVal);
            } else {
                sqlBuild.append(tempVal);
                sqlBuild.append(",");
            }
            ++i;
        }
        sqlBuild.append(")");
        return sqlBuild.toString();
    }

    public static String concatCapitalize(String concatStr, String str) {
        int strLen;
        if (StringUtils.isEmpty(concatStr)) {
            concatStr = EMPTY;
        }
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        char firstChar = str.charAt(0);
        if (Character.isTitleCase(firstChar)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(strLen);
        sb.append(concatStr);
        sb.append(Character.toTitleCase(firstChar));
        sb.append(str.substring(1));
        return sb.toString();
    }

    public static String capitalize(String str) {
        return StringUtils.concatCapitalize(null, str);
    }

    public static boolean checkValNotNull(Object object) {
        if (object instanceof CharSequence) {
            return StringUtils.isNotEmpty((CharSequence)object);
        }
        return object != null;
    }

    public static boolean checkValNull(Object object) {
        return !StringUtils.checkValNotNull(object);
    }

    public static boolean endsWith(String str, String suffix) {
        return StringUtils.endsWith(str, suffix, false);
    }

    public static boolean endsWithIgnoreCase(String str, String suffix) {
        return StringUtils.endsWith(str, suffix, true);
    }

    private static boolean endsWith(String str, String suffix, boolean ignoreCase) {
        if (str == null || suffix == null) {
            return str == null && suffix == null;
        }
        if (suffix.length() > str.length()) {
            return false;
        }
        int strOffset = str.length() - suffix.length();
        return str.regionMatches(ignoreCase, strOffset, suffix, 0, suffix.length());
    }
}

