/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.service.impl;

import com.baomidou.mybatisplus.entity.TableInfo;
import com.baomidou.mybatisplus.enums.IdType;
import com.baomidou.mybatisplus.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.baomidou.mybatisplus.mapper.SqlHelper;
import com.baomidou.mybatisplus.mapper.Wrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.IService;
import com.baomidou.mybatisplus.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.toolkit.MapUtils;
import com.baomidou.mybatisplus.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.toolkit.StringUtils;
import com.baomidou.mybatisplus.toolkit.TableInfoHelper;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.session.SqlSession;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceImpl<M extends BaseMapper<T>, T>
implements IService<T> {
    private static final Log logger = LogFactory.getLog(ServiceImpl.class);
    @Autowired
    protected M baseMapper;

    protected Class<T> currentModleClass() {
        return ReflectionKit.getSuperClassGenricType(this.getClass(), 1);
    }

    protected SqlSession sqlSessionBatch() {
        return SqlHelper.sqlSessionBatch(this.currentModleClass());
    }

    public boolean retBool(int result) {
        return result >= 1;
    }

    @Override
    public boolean insertOrUpdate(T entity) {
        if (null != entity) {
            Class<?> cls = entity.getClass();
            TableInfo tableInfo = TableInfoHelper.getTableInfo(cls);
            if (null != tableInfo) {
                Object idVal = ReflectionKit.getMethodValue(cls, entity, tableInfo.getKeyProperty());
                if (StringUtils.checkValNull(idVal)) {
                    return this.insert(entity);
                }
                if (IdType.INPUT == tableInfo.getIdType()) {
                    T entityValue = this.selectById((Serializable)idVal);
                    if (null != entityValue) {
                        return this.updateById(entity);
                    }
                    return this.insert(entity);
                }
                return this.updateById(entity);
            }
            throw new MybatisPlusException("Error:  Can not execute. Could not find @TableId.");
        }
        return false;
    }

    @Override
    public boolean insert(T entity) {
        return this.retBool(this.baseMapper.insert(entity));
    }

    @Override
    public boolean insertBatch(List<T> entityList) {
        return this.insertBatch(entityList, 30);
    }

    @Override
    public boolean insertOrUpdateBatch(List<T> entityList) {
        return this.insertOrUpdateBatch(entityList, 30);
    }

    @Override
    public boolean insertOrUpdateBatch(List<T> entityList, int batchSize) {
        if (CollectionUtils.isEmpty(entityList)) {
            throw new IllegalArgumentException("Error: entityList must not be empty");
        }
        try {
            SqlSession batchSqlSession = this.sqlSessionBatch();
            int size = entityList.size();
            for (int i = 0; i < size; ++i) {
                this.insertOrUpdate(entityList.get(i));
                if (i % batchSize != 0) continue;
                batchSqlSession.flushStatements();
            }
            batchSqlSession.flushStatements();
        }
        catch (Exception e) {
            logger.warn("Error: Cannot execute insertOrUpdateBatch Method. Cause:" + e);
            return false;
        }
        return true;
    }

    @Override
    public boolean insertBatch(List<T> entityList, int batchSize) {
        if (CollectionUtils.isEmpty(entityList)) {
            throw new IllegalArgumentException("Error: entityList must not be empty");
        }
        SqlSession batchSqlSession = this.sqlSessionBatch();
        try {
            int size = entityList.size();
            for (int i = 0; i < size; ++i) {
                this.baseMapper.insert(entityList.get(i));
                if (i % batchSize != 0) continue;
                batchSqlSession.flushStatements();
            }
            batchSqlSession.flushStatements();
        }
        catch (Exception e) {
            logger.warn("Error: Cannot execute insertBatch Method. Cause:" + e);
            return false;
        }
        return true;
    }

    @Override
    public boolean deleteById(Serializable id) {
        return this.retBool(this.baseMapper.deleteById(id));
    }

    @Override
    public boolean deleteByMap(Map<String, Object> columnMap) {
        if (MapUtils.isEmpty(columnMap)) {
            throw new MybatisPlusException("deleteByMap columnMap is empty.");
        }
        return this.retBool(this.baseMapper.deleteByMap(columnMap));
    }

    @Override
    public boolean delete(Wrapper<T> wrapper) {
        return this.retBool(this.baseMapper.delete(wrapper));
    }

    @Override
    public boolean deleteBatchIds(List<? extends Serializable> idList) {
        return this.retBool(this.baseMapper.deleteBatchIds(idList));
    }

    @Override
    public boolean updateById(T entity) {
        return this.retBool(this.baseMapper.updateById(entity));
    }

    @Override
    public boolean update(T entity, Wrapper<T> wrapper) {
        return this.retBool(this.baseMapper.update(entity, wrapper));
    }

    @Override
    public boolean updateBatchById(List<T> entityList) {
        if (CollectionUtils.isEmpty(entityList)) {
            throw new IllegalArgumentException("Error: entityList must not be empty");
        }
        SqlSession batchSqlSession = this.sqlSessionBatch();
        try {
            int size = entityList.size();
            for (int i = 0; i < size; ++i) {
                this.baseMapper.updateById(entityList.get(i));
                if (i % 30 != 0) continue;
                batchSqlSession.flushStatements();
            }
            batchSqlSession.flushStatements();
        }
        catch (Exception e) {
            logger.warn("Error: Cannot execute insertBatch Method. Cause:" + e);
            return false;
        }
        return true;
    }

    @Override
    public T selectById(Serializable id) {
        return this.baseMapper.selectById(id);
    }

    @Override
    public List<T> selectBatchIds(List<? extends Serializable> idList) {
        return this.baseMapper.selectBatchIds(idList);
    }

    @Override
    public List<T> selectByMap(Map<String, Object> columnMap) {
        return this.baseMapper.selectByMap(columnMap);
    }

    @Override
    public T selectOne(Wrapper<T> wrapper) {
        List<T> list = this.baseMapper.selectList(wrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            int size = list.size();
            if (size > 1) {
                logger.warn(String.format("Warn: selectOne Method There are  %s results.", size));
            }
            return list.get(0);
        }
        return null;
    }

    @Override
    public int selectCount(Wrapper<T> wrapper) {
        return this.baseMapper.selectCount(wrapper);
    }

    @Override
    public List<T> selectList(Wrapper<T> wrapper) {
        return this.baseMapper.selectList(wrapper);
    }

    @Override
    public Page<T> selectPage(Page<T> page) {
        page.setRecords(this.baseMapper.selectPage(page, null));
        return page;
    }

    @Override
    public Page<T> selectPage(Page<T> page, Wrapper<T> wrapper) {
        if (null != wrapper) {
            wrapper.orderBy(page.getOrderByField(), page.isAsc());
        }
        page.setRecords(this.baseMapper.selectPage(page, wrapper));
        return page;
    }
}

