/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.plugins;

import com.baomidou.mybatisplus.entity.CountOptimize;
import com.baomidou.mybatisplus.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.plugins.pagination.DialectFactory;
import com.baomidou.mybatisplus.plugins.pagination.IDialect;
import com.baomidou.mybatisplus.plugins.pagination.Pagination;
import com.baomidou.mybatisplus.toolkit.IOUtils;
import com.baomidou.mybatisplus.toolkit.SqlUtils;
import com.baomidou.mybatisplus.toolkit.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Properties;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class PaginationInterceptor
implements Interceptor {
    private boolean overflowCurrent = false;
    private String optimizeType = "default";
    private String dialectType;
    private String dialectClazz;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(Invocation invocation) throws Throwable {
        block10: {
            block9: {
                Object target = invocation.getTarget();
                if (!(target instanceof StatementHandler)) break block9;
                StatementHandler statementHandler = (StatementHandler)target;
                MetaObject metaStatementHandler = SystemMetaObject.forObject((Object)statementHandler);
                RowBounds rowBounds = (RowBounds)metaStatementHandler.getValue("delegate.rowBounds");
                if (rowBounds == null || rowBounds == RowBounds.DEFAULT) {
                    return invocation.proceed();
                }
                IDialect dialect = this.getiDialect();
                BoundSql boundSql = (BoundSql)metaStatementHandler.getValue("delegate.boundSql");
                String originalSql = boundSql.getSql();
                metaStatementHandler.setValue("delegate.rowBounds.offset", (Object)0);
                metaStatementHandler.setValue("delegate.rowBounds.limit", (Object)Integer.MAX_VALUE);
                if (rowBounds instanceof Pagination) {
                    Pagination page = (Pagination)rowBounds;
                    boolean orderBy = true;
                    if (page.isSearchCount()) {
                        CountOptimize countOptimize = SqlUtils.getCountOptimize(originalSql, this.optimizeType, this.dialectType, page.isOptimizeCount());
                        orderBy = countOptimize.isOrderBy();
                    }
                    String buildSql = SqlUtils.concatOrderBy(originalSql, page, orderBy);
                    originalSql = dialect.buildPaginationSql(buildSql, page.getOffsetCurrent(), page.getSize());
                }
                metaStatementHandler.setValue("delegate.boundSql.sql", (Object)originalSql);
                break block10;
            }
            MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
            Object parameterObject = null;
            RowBounds rowBounds = null;
            if (invocation.getArgs().length > 1) {
                parameterObject = invocation.getArgs()[1];
                rowBounds = (RowBounds)invocation.getArgs()[2];
            }
            if (rowBounds == null || rowBounds == RowBounds.DEFAULT) {
                return invocation.proceed();
            }
            BoundSql boundSql = mappedStatement.getBoundSql(parameterObject);
            String originalSql = boundSql.getSql();
            if (rowBounds instanceof Pagination) {
                Connection connection;
                block8: {
                    Object object;
                    connection = null;
                    try {
                        CountOptimize countOptimize;
                        connection = mappedStatement.getConfiguration().getEnvironment().getDataSource().getConnection();
                        Pagination page = (Pagination)rowBounds;
                        if (!page.isSearchCount() || (page = this.count((countOptimize = SqlUtils.getCountOptimize(originalSql, this.optimizeType, this.dialectType, page.isOptimizeCount())).getCountSQL(), connection, mappedStatement, boundSql, page)).getTotal() > 0) break block8;
                        object = invocation.proceed();
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(connection);
                        throw throwable;
                    }
                    IOUtils.closeQuietly(connection);
                    return object;
                }
                IOUtils.closeQuietly(connection);
            }
        }
        return invocation.proceed();
    }

    private IDialect getiDialect() throws Exception {
        IDialect dialect = null;
        if (StringUtils.isNotEmpty(this.dialectType)) {
            dialect = DialectFactory.getDialectByDbtype(this.dialectType);
        } else if (StringUtils.isNotEmpty(this.dialectClazz)) {
            try {
                Class<?> clazz = Class.forName(this.dialectClazz);
                if (IDialect.class.isAssignableFrom(clazz)) {
                    dialect = (IDialect)clazz.newInstance();
                }
            }
            catch (ClassNotFoundException e) {
                throw new MybatisPlusException("Class :" + this.dialectClazz + " is not found");
            }
        }
        if (dialect == null) {
            throw new MybatisPlusException("The value of the dialect property in mybatis configuration.xml is not defined.");
        }
        return dialect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Pagination count(String sql, Connection connection, MappedStatement mappedStatement, BoundSql boundSql, Pagination page) {
        ResultSet rs;
        PreparedStatement pstmt;
        block5: {
            pstmt = null;
            rs = null;
            try {
                pstmt = connection.prepareStatement(sql);
                BoundSql countBS = new BoundSql(mappedStatement.getConfiguration(), sql, boundSql.getParameterMappings(), boundSql.getParameterObject());
                DefaultParameterHandler parameterHandler = new DefaultParameterHandler(mappedStatement, boundSql.getParameterObject(), countBS);
                parameterHandler.setParameters(pstmt);
                rs = pstmt.executeQuery();
                int total = 0;
                if (rs.next()) {
                    total = rs.getInt(1);
                }
                page.setTotal(total);
                if (!this.overflowCurrent || page.getCurrent() <= page.getPages()) break block5;
                page = new Pagination(1, page.getSize());
                page.setTotal(total);
            }
            catch (Exception e) {
                IOUtils.closeQuietly(pstmt, rs);
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(pstmt, rs);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly(pstmt, rs);
        return page;
    }

    public Object plugin(Object target) {
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        if (target instanceof StatementHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties prop) {
        String dialectType = prop.getProperty("dialectType");
        String dialectClazz = prop.getProperty("dialectClazz");
        if (StringUtils.isNotEmpty(dialectType)) {
            this.dialectType = dialectType;
        }
        if (StringUtils.isNotEmpty(dialectClazz)) {
            this.dialectClazz = dialectClazz;
        }
    }

    public void setDialectType(String dialectType) {
        this.dialectType = dialectType;
    }

    public void setDialectClazz(String dialectClazz) {
        this.dialectClazz = dialectClazz;
    }

    public void setOverflowCurrent(boolean overflowCurrent) {
        this.overflowCurrent = overflowCurrent;
    }

    public void setOptimizeType(String optimizeType) {
        this.optimizeType = optimizeType;
    }
}

