/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.mapper;

import com.baomidou.mybatisplus.entity.GlobalConfiguration;
import com.baomidou.mybatisplus.entity.TableInfo;
import com.baomidou.mybatisplus.mapper.SqlHelper;
import com.baomidou.mybatisplus.plugins.pagination.Pagination;
import com.baomidou.mybatisplus.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.toolkit.StringUtils;
import com.baomidou.mybatisplus.toolkit.TableInfoHelper;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlQuery {
    private static final Log logger = LogFactory.getLog(SqlQuery.class);
    public static final SqlQuery SQL_QUERY = new SqlQuery();
    private SqlSessionFactory sqlSessionFactory;
    private TableInfo tableInfo;

    public SqlQuery() {
        this.tableInfo = TableInfoHelper.getRandomTableInfo();
        String configMark = this.tableInfo.getConfigMark();
        GlobalConfiguration globalConfiguration = GlobalConfiguration.GlobalConfig(configMark);
        this.sqlSessionFactory = globalConfiguration.getSqlSessionFactory();
    }

    public SqlQuery(Class<?> clazz) {
        this.tableInfo = SqlHelper.table(clazz);
        GlobalConfiguration globalConfiguration = GlobalConfiguration.GlobalConfig(this.tableInfo.getConfigMark());
        this.sqlSessionFactory = globalConfiguration.getSqlSessionFactory();
    }

    public boolean insert(String sql, Object ... args) {
        return SqlHelper.retBool(this.sqlSession().insert(this.sqlStatement("insertSql"), (Object)StringUtils.sqlArgsFill(sql, args)));
    }

    public boolean delete(String sql, Object ... args) {
        return SqlHelper.retBool(this.sqlSession().delete(this.sqlStatement("deleteSql"), (Object)StringUtils.sqlArgsFill(sql, args)));
    }

    public boolean update(String sql, Object ... args) {
        return SqlHelper.retBool(this.sqlSession().update(this.sqlStatement("updateSql"), (Object)StringUtils.sqlArgsFill(sql, args)));
    }

    public List<Map<String, Object>> selectList(String sql, Object ... args) {
        return this.sqlSession().selectList(this.sqlStatement("selectListSql"), (Object)StringUtils.sqlArgsFill(sql, args));
    }

    public int selectCount(String sql, Object ... args) {
        return (Integer)this.sqlSession().selectOne(this.sqlStatement("selectCountSql"), (Object)StringUtils.sqlArgsFill(sql, args));
    }

    public Map<String, Object> selectOne(String sql, Object ... args) {
        List<Map<String, Object>> list = this.selectList(sql, args);
        if (CollectionUtils.isNotEmpty(list)) {
            int size = list.size();
            if (size > 1) {
                logger.warn(String.format("Warn: selectOne Method There are  %s results.", size));
            }
            return list.get(0);
        }
        return Collections.emptyMap();
    }

    public List<Map<String, Object>> selectPage(Pagination page, String sql, Object ... args) {
        if (null == page) {
            return null;
        }
        return this.sqlSession().selectList(this.sqlStatement("selectPageSql"), (Object)StringUtils.sqlArgsFill(sql, args), (RowBounds)page);
    }

    public static SqlQuery db() {
        return SQL_QUERY;
    }

    public static SqlQuery db(Class<?> clazz) {
        return new SqlQuery(clazz);
    }

    private SqlSession sqlSession() {
        return this.sqlSessionFactory.openSession(true);
    }

    private String sqlStatement(String sqlMethod) {
        return this.tableInfo.getSqlStatement(sqlMethod);
    }
}

