/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.entity;

import com.baomidou.mybatisplus.entity.GlobalConfiguration;
import com.baomidou.mybatisplus.enums.FieldStrategy;
import com.baomidou.mybatisplus.toolkit.SqlReservedWords;
import com.baomidou.mybatisplus.toolkit.StringUtils;

public class TableFieldInfo {
    private boolean related = false;
    private String column;
    private String property;
    private String el;
    private FieldStrategy fieldStrategy = FieldStrategy.NOT_NULL;

    public TableFieldInfo(GlobalConfiguration globalConfig, String column, String property, String el, FieldStrategy fieldStrategy) {
        if (globalConfig.isDbColumnUnderline()) {
            this.related = true;
            this.setColumn(globalConfig, StringUtils.camelToUnderline(column));
        } else if (!column.equals(property)) {
            this.related = true;
            this.setColumn(globalConfig, column);
        } else {
            this.setColumn(globalConfig, column);
        }
        this.property = property;
        this.el = el;
        this.fieldStrategy = fieldStrategy != FieldStrategy.NOT_NULL ? fieldStrategy : globalConfig.getFieldStrategy();
    }

    public TableFieldInfo(GlobalConfiguration globalConfig, String column) {
        if (globalConfig.isDbColumnUnderline()) {
            this.related = true;
            this.setColumn(globalConfig, StringUtils.camelToUnderline(column));
        } else {
            this.setColumn(globalConfig, column);
        }
        this.property = column;
        this.el = column;
        this.fieldStrategy = globalConfig.getFieldStrategy();
    }

    public boolean isRelated() {
        return this.related;
    }

    public void setRelated(boolean related) {
        this.related = related;
    }

    public String getColumn() {
        return this.column;
    }

    public void setColumn(GlobalConfiguration globalConfig, String column) {
        String temp = SqlReservedWords.convert(globalConfig.getDbType(), column);
        if (globalConfig.isCapitalMode() && !this.isRelated()) {
            temp = temp.toUpperCase();
        }
        this.column = temp;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getEl() {
        return this.el;
    }

    public void setEl(String el) {
        this.el = el;
    }

    public FieldStrategy getFieldStrategy() {
        return this.fieldStrategy;
    }

    public void setFieldStrategy(FieldStrategy fieldStrategy) {
        this.fieldStrategy = fieldStrategy;
    }
}

