/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.entity;

import com.baomidou.mybatisplus.enums.DBType;
import com.baomidou.mybatisplus.enums.FieldStrategy;
import com.baomidou.mybatisplus.enums.IdType;
import com.baomidou.mybatisplus.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.mapper.AutoSqlInjector;
import com.baomidou.mybatisplus.mapper.IMetaObjectHandler;
import com.baomidou.mybatisplus.mapper.ISqlInjector;
import com.baomidou.mybatisplus.toolkit.JdbcUtils;
import com.baomidou.mybatisplus.toolkit.TableInfoHelper;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalConfiguration
implements Cloneable,
Serializable {
    private static final Log logger = LogFactory.getLog(GlobalConfiguration.class);
    private static final Map<String, GlobalConfiguration> GLOBAL_CONFIG = new ConcurrentHashMap<String, GlobalConfiguration>();
    public static final GlobalConfiguration DEFAULT = new GlobalConfiguration(new AutoSqlInjector());
    private DBType dbType = DBType.MYSQL;
    private IdType idType = IdType.ID_WORKER;
    private boolean dbColumnUnderline = false;
    private ISqlInjector sqlInjector;
    private IMetaObjectHandler metaObjectHandler = null;
    private FieldStrategy fieldStrategy = FieldStrategy.NOT_NULL;
    private boolean isRefresh = false;
    private boolean isAutoSetDbType = true;
    private boolean isCapitalMode = false;
    private SqlSessionFactory sqlSessionFactory;
    private Set<String> mapperRegistryCache = new ConcurrentSkipListSet<String>();

    public GlobalConfiguration() {
    }

    public GlobalConfiguration(ISqlInjector sqlInjector) {
        this.sqlInjector = sqlInjector;
    }

    public DBType getDbType() {
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = DBType.getDBType(dbType);
        this.isAutoSetDbType = false;
    }

    public void setDbTypeByJdbcUrl(String jdbcUrl) {
        this.dbType = JdbcUtils.getDbType(jdbcUrl);
    }

    public IdType getIdType() {
        return this.idType;
    }

    public void setIdType(int idType) {
        this.idType = IdType.getIdType(idType);
    }

    public boolean isDbColumnUnderline() {
        return this.dbColumnUnderline;
    }

    public void setDbColumnUnderline(boolean dbColumnUnderline) {
        this.dbColumnUnderline = dbColumnUnderline;
    }

    public ISqlInjector getSqlInjector() {
        return this.sqlInjector;
    }

    public void setSqlInjector(ISqlInjector sqlInjector) {
        this.sqlInjector = sqlInjector;
    }

    public IMetaObjectHandler getMetaObjectHandler() {
        return this.metaObjectHandler;
    }

    public void setMetaObjectHandler(IMetaObjectHandler metaObjectHandler) {
        this.metaObjectHandler = metaObjectHandler;
    }

    public FieldStrategy getFieldStrategy() {
        return this.fieldStrategy;
    }

    public void setFieldStrategy(int fieldStrategy) {
        this.fieldStrategy = FieldStrategy.getFieldStrategy(fieldStrategy);
    }

    public boolean isRefresh() {
        return this.isRefresh;
    }

    public void setRefresh(boolean refresh) {
        this.isRefresh = refresh;
    }

    public boolean isAutoSetDbType() {
        return this.isAutoSetDbType;
    }

    public void setAutoSetDbType(boolean autoSetDbType) {
        this.isAutoSetDbType = autoSetDbType;
    }

    public Set<String> getMapperRegistryCache() {
        return this.mapperRegistryCache;
    }

    public void setMapperRegistryCache(Set<String> mapperRegistryCache) {
        this.mapperRegistryCache = mapperRegistryCache;
    }

    public SqlSessionFactory getSqlSessionFactory() {
        return this.sqlSessionFactory;
    }

    public void setSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
    }

    protected GlobalConfiguration clone() throws CloneNotSupportedException {
        return (GlobalConfiguration)super.clone();
    }

    public static SqlSessionFactory currentSessionFactory(Class<?> clazz) {
        String configMark = TableInfoHelper.getTableInfo(clazz).getConfigMark();
        GlobalConfiguration mybatisGlobalConfig = GlobalConfiguration.GlobalConfig(configMark);
        return mybatisGlobalConfig.getSqlSessionFactory();
    }

    public static GlobalConfiguration defaults() {
        try {
            return DEFAULT.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new MybatisPlusException("ERROR: CLONE MybatisGlobalConfig DEFAULT FAIL !  Cause:" + e);
        }
    }

    public static void setGlobalConfig(Configuration configuration, GlobalConfiguration mybatisGlobalConfig) {
        if (configuration == null || mybatisGlobalConfig == null) {
            new MybatisPlusException("Error:  Could not setGlobalConfig");
        }
        GLOBAL_CONFIG.put(configuration.toString(), mybatisGlobalConfig);
    }

    public void setGlobalConfig(Configuration configuration) {
        GlobalConfiguration.setGlobalConfig(configuration, this);
    }

    public static GlobalConfiguration GlobalConfig(Configuration configuration) {
        if (configuration == null) {
            throw new MybatisPlusException("Error: You need Initialize MybatisConfiguration !");
        }
        return GlobalConfiguration.GlobalConfig(configuration.toString());
    }

    public static GlobalConfiguration GlobalConfig(String configMark) {
        GlobalConfiguration cache = GLOBAL_CONFIG.get(configMark);
        if (cache == null) {
            logger.warn("Warn: Not getting global configuration ! global configuration Initializing !");
            GLOBAL_CONFIG.put(configMark, DEFAULT);
            return DEFAULT;
        }
        return cache;
    }

    public static DBType getDbType(Configuration configuration) {
        return GlobalConfiguration.GlobalConfig(configuration).getDbType();
    }

    public static IdType getIdType(Configuration configuration) {
        return GlobalConfiguration.GlobalConfig(configuration).getIdType();
    }

    public static boolean isDbColumnUnderline(Configuration configuration) {
        return GlobalConfiguration.GlobalConfig(configuration).isDbColumnUnderline();
    }

    public static ISqlInjector getSqlInjector(Configuration configuration) {
        return GlobalConfiguration.GlobalConfig(configuration).getSqlInjector();
    }

    public static IMetaObjectHandler getMetaObjectHandler(Configuration configuration) {
        return GlobalConfiguration.GlobalConfig(configuration).getMetaObjectHandler();
    }

    public static FieldStrategy getFieldStrategy(Configuration configuration) {
        return GlobalConfiguration.GlobalConfig(configuration).getFieldStrategy();
    }

    public static boolean isRefresh(Configuration configuration) {
        return GlobalConfiguration.GlobalConfig(configuration).isRefresh();
    }

    public static boolean isAutoSetDbType(Configuration configuration) {
        return GlobalConfiguration.GlobalConfig(configuration).isAutoSetDbType();
    }

    public static Set<String> getMapperRegistryCache(Configuration configuration) {
        return GlobalConfiguration.GlobalConfig(configuration).getMapperRegistryCache();
    }

    public boolean isCapitalMode() {
        return this.isCapitalMode;
    }

    public void setCapitalMode(boolean isCapitalMode) {
        this.isCapitalMode = isCapitalMode;
    }
}

