/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus;

import com.baomidou.mybatisplus.MybatisXMLConfigBuilder;
import com.baomidou.mybatisplus.entity.GlobalConfiguration;
import com.baomidou.mybatisplus.toolkit.IOUtils;
import java.io.InputStream;
import java.io.Reader;
import java.util.Properties;
import org.apache.ibatis.exceptions.ExceptionFactory;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;

public class MybatisSessionFactoryBuilder
extends SqlSessionFactoryBuilder {
    private GlobalConfiguration globalConfig = GlobalConfiguration.defaults();

    public SqlSessionFactory build(Reader reader, String environment, Properties properties) {
        try {
            MybatisXMLConfigBuilder parser = new MybatisXMLConfigBuilder(reader, environment, properties);
            this.globalConfig.setGlobalConfig(parser.getConfiguration());
            SqlSessionFactory sqlSessionFactory = this.build(parser.parse());
            return sqlSessionFactory;
        }
        catch (Exception e) {
            throw ExceptionFactory.wrapException((String)"Error building SqlSession.", (Exception)e);
        }
        finally {
            ErrorContext.instance().reset();
            IOUtils.closeQuietly(reader);
        }
    }

    public SqlSessionFactory build(InputStream inputStream, String environment, Properties properties) {
        try {
            MybatisXMLConfigBuilder parser = new MybatisXMLConfigBuilder(inputStream, environment, properties);
            this.globalConfig.setGlobalConfig(parser.getConfiguration());
            SqlSessionFactory sqlSessionFactory = this.build(parser.parse());
            return sqlSessionFactory;
        }
        catch (Exception e) {
            throw ExceptionFactory.wrapException((String)"Error building SqlSession.", (Exception)e);
        }
        finally {
            ErrorContext.instance().reset();
            IOUtils.closeQuietly(inputStream);
        }
    }

    public void setGlobalConfig(GlobalConfiguration globalConfig) {
        this.globalConfig = globalConfig;
    }
}

