/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus;

import com.baomidou.mybatisplus.entity.GlobalConfiguration;
import com.baomidou.mybatisplus.entity.TableInfo;
import com.baomidou.mybatisplus.enums.IdType;
import com.baomidou.mybatisplus.mapper.IMetaObjectHandler;
import com.baomidou.mybatisplus.toolkit.IdWorker;
import com.baomidou.mybatisplus.toolkit.StringUtils;
import com.baomidou.mybatisplus.toolkit.TableInfoHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MybatisDefaultParameterHandler
extends DefaultParameterHandler {
    public MybatisDefaultParameterHandler(MappedStatement mappedStatement, Object parameterObject, BoundSql boundSql) {
        super(mappedStatement, MybatisDefaultParameterHandler.processBatch(mappedStatement, parameterObject), boundSql);
    }

    protected static Object processBatch(MappedStatement ms, Object parameterObject) {
        if (ms.getSqlCommandType() == SqlCommandType.INSERT) {
            Collection<Object> parameters = MybatisDefaultParameterHandler.getParameters(parameterObject);
            if (null != parameters) {
                ArrayList<Object> objList = new ArrayList<Object>();
                for (Object parameter : parameters) {
                    TableInfo tableInfo = TableInfoHelper.getTableInfo(parameter.getClass());
                    if (null != tableInfo) {
                        objList.add(MybatisDefaultParameterHandler.populateKeys(tableInfo, ms, parameter));
                        continue;
                    }
                    objList.add(parameter);
                }
                return objList;
            }
            TableInfo tableInfo = TableInfoHelper.getTableInfo(parameterObject.getClass());
            return MybatisDefaultParameterHandler.populateKeys(tableInfo, ms, parameterObject);
        }
        return parameterObject;
    }

    protected static Collection<Object> getParameters(Object parameter) {
        List<Object> parameters = null;
        if (parameter instanceof Collection) {
            parameters = (List<Object>)parameter;
        } else if (parameter instanceof Map) {
            Map parameterMap = (Map)parameter;
            if (parameterMap.containsKey("collection")) {
                parameters = (Collection)parameterMap.get("collection");
            } else if (parameterMap.containsKey("list")) {
                parameters = (List)parameterMap.get("list");
            } else if (parameterMap.containsKey("array")) {
                parameters = Arrays.asList((Object[])parameterMap.get("array"));
            }
        }
        return parameters;
    }

    protected static Object populateKeys(TableInfo tableInfo, MappedStatement ms, Object parameterObject) {
        if (null != tableInfo && null != tableInfo.getIdType() && tableInfo.getIdType().getKey() >= 2) {
            IMetaObjectHandler metaObjectHandler;
            MetaObject metaObject = ms.getConfiguration().newMetaObject(parameterObject);
            Object idValue = metaObject.getValue(tableInfo.getKeyProperty());
            if (StringUtils.checkValNull(idValue)) {
                if (tableInfo.getIdType() == IdType.ID_WORKER) {
                    metaObject.setValue(tableInfo.getKeyProperty(), (Object)IdWorker.getId());
                } else if (tableInfo.getIdType() == IdType.UUID) {
                    metaObject.setValue(tableInfo.getKeyProperty(), (Object)MybatisDefaultParameterHandler.get32UUID());
                }
            }
            if (null != (metaObjectHandler = GlobalConfiguration.getMetaObjectHandler(ms.getConfiguration()))) {
                metaObjectHandler.insertFill(metaObject);
            }
            return metaObject.getOriginalObject();
        }
        return parameterObject;
    }

    protected static synchronized String get32UUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }
}

