/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.toolkit;

import com.baomidou.mybatisplus.enums.SqlLike;
import com.baomidou.mybatisplus.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.plugins.pagination.Pagination;
import com.baomidou.mybatisplus.plugins.parser.ISqlParser;
import com.baomidou.mybatisplus.plugins.parser.SqlInfo;
import com.baomidou.mybatisplus.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.toolkit.SqlFormatter;
import com.baomidou.mybatisplus.toolkit.StringUtils;
import java.util.List;

public class SqlUtils {
    private static final SqlFormatter sqlFormatter = new SqlFormatter();
    public static final String SQL_BASE_COUNT = "SELECT COUNT(1) FROM ( %s ) TOTAL";
    public static ISqlParser COUNT_SQL_PARSER = null;
    private static Class<ISqlParser> DEFAULT_CLASS = null;

    public static SqlInfo getCountOptimize(ISqlParser sqlParser, String originalSql) {
        if (null == COUNT_SQL_PARSER) {
            if (null != sqlParser) {
                COUNT_SQL_PARSER = sqlParser;
            } else {
                try {
                    COUNT_SQL_PARSER = DEFAULT_CLASS.newInstance();
                }
                catch (Exception e) {
                    throw new MybatisPlusException(e);
                }
            }
        }
        return COUNT_SQL_PARSER.optimizeSql(null, originalSql);
    }

    public static String concatOrderBy(String originalSql, Pagination page, boolean orderBy) {
        if (orderBy && page.isOpenSort()) {
            StringBuilder buildSql = new StringBuilder(originalSql);
            String ascStr = SqlUtils.concatOrderBuilder(page.getAsc(), " ASC");
            String descStr = SqlUtils.concatOrderBuilder(page.getDesc(), " DESC");
            if (StringUtils.isNotEmpty(ascStr) && StringUtils.isNotEmpty(descStr)) {
                ascStr = ascStr + ", ";
            }
            if (StringUtils.isNotEmpty(ascStr) || StringUtils.isNotEmpty(descStr)) {
                buildSql.append(" ORDER BY ").append(ascStr).append(descStr);
            }
            return buildSql.toString();
        }
        return originalSql;
    }

    private static String concatOrderBuilder(List<String> columns, String orderWord) {
        if (CollectionUtils.isNotEmpty(columns)) {
            StringBuilder builder = new StringBuilder(16);
            int i = 0;
            while (i < columns.size()) {
                String cs = columns.get(i);
                if (StringUtils.isNotEmpty(cs)) {
                    builder.append(cs).append(orderWord);
                }
                if (++i == columns.size() || !StringUtils.isNotEmpty(cs)) continue;
                builder.append(", ");
            }
            return builder.toString();
        }
        return "";
    }

    public static String sqlFormat(String boundSql, boolean format) {
        if (format) {
            return sqlFormatter.format(boundSql);
        }
        return boundSql.replaceAll("[\\s]+", " ");
    }

    public static String concatLike(String str, SqlLike type) {
        StringBuilder builder = new StringBuilder(str.length() + 3);
        switch (type) {
            case LEFT: {
                builder.append("%").append(str);
                break;
            }
            case RIGHT: {
                builder.append(str).append("%");
                break;
            }
            case CUSTOM: {
                builder.append(str);
                break;
            }
            default: {
                builder.append("%").append(str).append("%");
            }
        }
        return builder.toString();
    }

    static {
        try {
            DEFAULT_CLASS = Class.forName("com.baomidou.mybatisplus.plugins.pagination.optimize.JsqlParserCountOptimize");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

