/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.plugins;

import com.baomidou.mybatisplus.plugins.parser.ISqlParser;
import com.baomidou.mybatisplus.plugins.parser.ISqlParserFilter;
import com.baomidou.mybatisplus.plugins.parser.SqlInfo;
import com.baomidou.mybatisplus.toolkit.CollectionUtils;
import java.util.List;
import org.apache.ibatis.reflection.MetaObject;

public abstract class SqlParserHandler {
    private List<ISqlParser> sqlParserList;
    private ISqlParserFilter sqlParserFilter;

    protected void sqlParser(MetaObject metaObject) {
        if (null != metaObject) {
            if (null != this.sqlParserFilter && this.sqlParserFilter.doFilter(metaObject)) {
                return;
            }
            if (CollectionUtils.isNotEmpty(this.sqlParserList)) {
                int flag = 0;
                String originalSql = (String)metaObject.getValue("delegate.boundSql.sql");
                for (ISqlParser sqlParser : this.sqlParserList) {
                    SqlInfo sqlInfo = sqlParser.optimizeSql(metaObject, originalSql);
                    if (null == sqlInfo) continue;
                    originalSql = sqlInfo.getSql();
                    ++flag;
                }
                if (flag >= 1) {
                    metaObject.setValue("delegate.boundSql.sql", (Object)originalSql);
                }
            }
        }
    }

    public List<ISqlParser> getSqlParserList() {
        return this.sqlParserList;
    }

    public SqlParserHandler setSqlParserList(List<ISqlParser> sqlParserList) {
        this.sqlParserList = sqlParserList;
        return this;
    }

    public ISqlParserFilter getSqlParserFilter() {
        return this.sqlParserFilter;
    }

    public void setSqlParserFilter(ISqlParserFilter sqlParserFilter) {
        this.sqlParserFilter = sqlParserFilter;
    }
}

