/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.RegionAdminServiceCallable;
import org.apache.hadoop.hbase.ipc.PayloadCarryingRpcController;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.mortbay.log.Log;

@InterfaceAudience.Private
public class FlushRegionCallable
extends RegionAdminServiceCallable<AdminProtos.FlushRegionResponse> {
    private final byte[] regionName;
    private final boolean writeFlushWalMarker;
    private boolean reload;

    public FlushRegionCallable(ClusterConnection connection, RpcControllerFactory rpcControllerFactory, TableName tableName, byte[] regionName, byte[] regionStartKey, boolean writeFlushWalMarker) {
        super(connection, rpcControllerFactory, tableName, regionStartKey);
        this.regionName = regionName;
        this.writeFlushWalMarker = writeFlushWalMarker;
    }

    public FlushRegionCallable(ClusterConnection connection, RpcControllerFactory rpcControllerFactory, HRegionInfo regionInfo, boolean writeFlushWalMarker) {
        this(connection, rpcControllerFactory, regionInfo.getTable(), regionInfo.getRegionName(), regionInfo.getStartKey(), writeFlushWalMarker);
    }

    @Override
    public AdminProtos.FlushRegionResponse call(int callTimeout) throws Exception {
        return this.flushRegion();
    }

    @Override
    public void prepare(boolean reload) throws IOException {
        super.prepare(reload);
        this.reload = reload;
    }

    private AdminProtos.FlushRegionResponse flushRegion() throws IOException {
        if (!Bytes.equals((byte[])this.location.getRegionInfo().getRegionName(), (byte[])this.regionName)) {
            if (!this.reload) {
                throw new IOException("Cached location seems to be different than requested region.");
            }
            Log.info((String)("Skipping flush region, because the located region " + Bytes.toStringBinary((byte[])this.location.getRegionInfo().getRegionName()) + " is different than  requested region " + Bytes.toStringBinary((byte[])this.regionName)));
            return AdminProtos.FlushRegionResponse.newBuilder().setLastFlushTime(EnvironmentEdgeManager.currentTime()).setFlushed(false).setWroteFlushWalMarker(false).build();
        }
        AdminProtos.FlushRegionRequest request = RequestConverter.buildFlushRegionRequest(this.regionName, this.writeFlushWalMarker);
        try {
            PayloadCarryingRpcController controller = this.rpcControllerFactory.newController();
            controller.setPriority(this.tableName);
            return this.stub.flushRegion((RpcController)controller, request);
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }
}

