/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.captcha;

import cn.dreampie.captcha.background.BackgroundFactory;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Random;

class SimpleBackgroundFactory
implements BackgroundFactory {
    private Random random = new Random();
    private Color bgColor = null;
    private int artifactNum = 50;
    private int lineNum = 0;
    private Color drawColor = new Color(102, 102, 102);

    SimpleBackgroundFactory() {
    }

    SimpleBackgroundFactory(Color bgColor) {
        this.bgColor = bgColor;
    }

    SimpleBackgroundFactory(Color bgColor, Color drawColor) {
        this.bgColor = bgColor;
        this.drawColor = drawColor;
    }

    SimpleBackgroundFactory(Color bgColor, Color drawColor, int artifactNum, int lineNum) {
        this.bgColor = bgColor;
        this.drawColor = drawColor;
        this.artifactNum = artifactNum;
        this.lineNum = lineNum;
    }

    public void fillBackground(BufferedImage image) {
        int i;
        int yInt;
        int xInt;
        int i2;
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        int imgWidth = image.getWidth();
        int imgHeight = image.getHeight();
        if (this.bgColor != null) {
            for (int x = 0; x < imgWidth; ++x) {
                for (int y = 0; y < imgHeight; ++y) {
                    image.setRGB(x, y, this.bgColor.getRGB());
                }
            }
        }
        if (this.drawColor == null) {
            this.drawColor = this.getRandomColor();
        }
        if (this.artifactNum > 0) {
            for (i2 = 0; i2 < this.artifactNum; ++i2) {
                graphics.setColor(this.drawColor);
                xInt = this.random.nextInt(imgWidth - 3);
                yInt = this.random.nextInt(imgHeight - 2);
                int sAngleInt = this.random.nextInt(360);
                int eAngleInt = this.random.nextInt(360);
                int wInt = this.random.nextInt(6);
                int hInt = this.random.nextInt(6);
                graphics.fillArc(xInt, yInt, wInt, hInt, sAngleInt, eAngleInt);
            }
        }
        if (this.lineNum > 0) {
            for (i2 = 0; i2 < this.lineNum; ++i2) {
                xInt = this.random.nextInt(imgWidth - 3);
                yInt = this.random.nextInt(imgHeight - 2);
                int xInt2 = this.random.nextInt(imgWidth);
                int yInt2 = this.random.nextInt(imgHeight);
                graphics.drawLine(xInt, yInt, xInt2, yInt2);
            }
        }
        graphics.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        int cp = 4 + this.random.nextInt(3);
        int[] xPoints = new int[cp];
        int[] yPoints = new int[cp];
        imgWidth -= 10;
        for (int i3 = 0; i3 < cp; ++i3) {
            xPoints[i3] = 5 + i3 * imgWidth / (cp - 1);
            yPoints[i3] = (int)((double)imgHeight * (this.random.nextDouble() * 0.5 + 0.2));
        }
        int subsections = 6;
        int[] xPointsSpline = new int[(cp - 1) * subsections];
        int[] yPointsSpline = new int[(cp - 1) * subsections];
        for (i = 0; i < cp - 1; ++i) {
            double x0 = i > 0 ? (double)xPoints[i - 1] : (double)(2 * xPoints[i] - xPoints[i + 1]);
            double x1 = xPoints[i];
            double x2 = xPoints[i + 1];
            double x3 = i + 2 < cp ? (double)xPoints[i + 2] : (double)(2 * xPoints[i + 1] - xPoints[i]);
            double y0 = i > 0 ? (double)yPoints[i - 1] : (double)(2 * yPoints[i] - yPoints[i + 1]);
            double y1 = yPoints[i];
            double y2 = yPoints[i + 1];
            double y3 = i + 2 < cp ? (double)yPoints[i + 2] : (double)(2 * yPoints[i + 1] - yPoints[i]);
            for (int j = 0; j < subsections; ++j) {
                xPointsSpline[i * subsections + j] = (int)this.catmullRomSpline(x0, x1, x2, x3, 1.0 / (double)subsections * (double)j);
                yPointsSpline[i * subsections + j] = (int)this.catmullRomSpline(y0, y1, y2, y3, 1.0 / (double)subsections * (double)j);
            }
        }
        for (i = 0; i < xPointsSpline.length - 1; ++i) {
            graphics.setColor(this.drawColor);
            graphics.setStroke(new BasicStroke(0.2f + 2.0f * this.random.nextFloat()));
            graphics.drawLine(xPointsSpline[i], yPointsSpline[i], xPointsSpline[i + 1], yPointsSpline[i + 1]);
        }
    }

    private double hermiteSpline(double x1, double a1, double x2, double a2, double t) {
        double t2 = t * t;
        double t3 = t2 * t;
        double b = -a2 - 2.0 * a1 - 3.0 * x1 + 3.0 * x2;
        double a = a2 + a1 + 2.0 * x1 - 2.0 * x2;
        return a * t3 + b * t2 + a1 * t + x1;
    }

    private double catmullRomSpline(double x0, double x1, double x2, double x3, double t) {
        double a1 = (x2 - x0) / 2.0;
        double a2 = (x3 - x1) / 2.0;
        return this.hermiteSpline(x1, a1, x2, a2, t);
    }

    public Color getRandomColor() {
        int[] c = new int[3];
        int i = this.random.nextInt(c.length);
        for (int fi = 0; fi < c.length; ++fi) {
            c[fi] = fi == i ? this.random.nextInt(71) : this.random.nextInt(256);
        }
        return new Color(c[0], c[1], c[2]);
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(Color bgColor) {
        this.bgColor = bgColor;
    }

    public Color getDrawColor() {
        return this.drawColor;
    }

    public void setDrawColor(Color drawColor) {
        this.drawColor = drawColor;
    }

    public int getArtifactNum() {
        return this.artifactNum;
    }

    public void setArtifactNum(int artifactNum) {
        this.artifactNum = artifactNum;
    }
}

