/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.captcha;

import cn.dreampie.captcha.SimpleBackgroundFactory;
import cn.dreampie.captcha.background.BackgroundFactory;
import cn.dreampie.captcha.color.ColorFactory;
import cn.dreampie.captcha.color.RandomColorFactory;
import cn.dreampie.captcha.filter.predefined.CurvesRippleFilterFactory;
import cn.dreampie.captcha.filter.predefined.DiffuseRippleFilterFactory;
import cn.dreampie.captcha.filter.predefined.DoubleRippleFilterFactory;
import cn.dreampie.captcha.filter.predefined.MarbleRippleFilterFactory;
import cn.dreampie.captcha.filter.predefined.WobbleRippleFilterFactory;
import cn.dreampie.captcha.font.RandomFontFactory;
import cn.dreampie.captcha.service.Captcha;
import cn.dreampie.captcha.service.ConfigurableCaptchaService;
import cn.dreampie.captcha.text.renderer.BestFitTextRenderer;
import cn.dreampie.captcha.text.renderer.TextRenderer;
import cn.dreampie.captcha.word.RandomWordFactory;
import cn.dreampie.encription.EncriptionKit;
import com.jfinal.render.Render;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaptchaRender
extends Render {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private String code = "ABCDEFGHIJKLMNPQRSTUVWXYZ123456789";
    private int font_min_num = 4;
    private int font_max_num = 4;
    private int font_min_size = 20;
    private int font_max_size = 20;
    private double x_amplitude = 1.6;
    private double y_amplitude = 0.8;
    private int top_margin = 1;
    private int bottom_margin = 1;
    private int width = 118;
    private int height = 41;
    private String captchaName = "captcha";
    private ConfigurableCaptchaService configurableCaptchaService = new ConfigurableCaptchaService();
    private ColorFactory colorFactory = null;
    private RandomFontFactory fontFactory = null;
    private RandomWordFactory wordFactory = null;
    private TextRenderer textRenderer = null;
    private BackgroundFactory backgroundFactory = null;
    private FilterFactory filter = null;
    private static Random random = new Random();
    private Color bgColor = null;
    private Color drawColor = new Color(0, 0, 0);
    private Color drawBgColor = new Color(102, 102, 102);
    private boolean randomColor = false;
    private int artifactNum = 50;
    private int lineNum = 0;

    private void initCaptchService() {
        this.colorFactory = this.randomColor ? new RandomColorFactory() : new ColorFactory(){

            public Color getColor(int index) {
                return CaptchaRender.this.drawColor;
            }
        };
        this.configurableCaptchaService.setColorFactory(this.colorFactory);
        this.fontFactory = new RandomFontFactory();
        this.fontFactory.setMaxSize(this.font_max_size);
        this.fontFactory.setMinSize(this.font_min_size);
        this.configurableCaptchaService.setFontFactory(this.fontFactory);
        this.wordFactory = new RandomWordFactory();
        this.wordFactory.setCharacters(this.code);
        this.wordFactory.setMaxLength(this.font_max_num);
        this.wordFactory.setMinLength(this.font_min_num);
        this.configurableCaptchaService.setWordFactory(this.wordFactory);
        if (this.backgroundFactory == null) {
            this.backgroundFactory = new SimpleBackgroundFactory(this.bgColor, this.randomColor ? null : this.drawBgColor, this.artifactNum, this.lineNum);
        }
        this.configurableCaptchaService.setBackgroundFactory(this.backgroundFactory);
        int filterNum = this.filter == null ? random.nextInt(4) : this.filter.value();
        switch (filterNum) {
            case 0: {
                this.configurableCaptchaService.setFilterFactory(new CurvesRippleFilterFactory(this.configurableCaptchaService.getColorFactory()));
                break;
            }
            case 1: {
                this.configurableCaptchaService.setFilterFactory(new MarbleRippleFilterFactory());
                break;
            }
            case 2: {
                this.configurableCaptchaService.setFilterFactory(new DoubleRippleFilterFactory());
                break;
            }
            case 3: {
                this.configurableCaptchaService.setFilterFactory(new WobbleRippleFilterFactory());
                break;
            }
            case 4: {
                this.configurableCaptchaService.setFilterFactory(new DiffuseRippleFilterFactory());
                break;
            }
            default: {
                this.configurableCaptchaService.setFilterFactory(new CurvesRippleFilterFactory(this.configurableCaptchaService.getColorFactory()));
            }
        }
        this.textRenderer = new BestFitTextRenderer();
        this.textRenderer.setBottomMargin(this.bottom_margin);
        this.textRenderer.setTopMargin(this.top_margin);
        this.configurableCaptchaService.setTextRenderer(this.textRenderer);
        this.configurableCaptchaService.setWidth(this.width);
        this.configurableCaptchaService.setHeight(this.height);
    }

    public void render() {
        this.initCaptchService();
        ServletOutputStream outputStream = null;
        Captcha captcha = this.configurableCaptchaService.getCaptcha();
        String captchaCode = captcha.getChallenge();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("captcha:" + captchaCode);
        }
        HttpSession session = this.request.getSession();
        session.setAttribute(this.captchaName, (Object)EncriptionKit.encrypt((String)captchaCode.toLowerCase()));
        session.setAttribute(this.captchaName + "_time", (Object)new Date().getTime());
        BufferedImage bufferedImage = captcha.getImage();
        try {
            outputStream = this.response.getOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "png", (OutputStream)outputStream);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String getCaptchaName() {
        return this.captchaName;
    }

    public void setCaptchaName(String captchaName) {
        this.captchaName = captchaName;
    }

    public BackgroundFactory getBackgroundFactory() {
        return this.backgroundFactory;
    }

    public void setBackgroundFactory(BackgroundFactory backgroundFactory) {
        this.backgroundFactory = backgroundFactory;
    }

    public Color getDrawColor() {
        return this.drawColor;
    }

    public void setDrawColor(Color drawColor) {
        this.drawColor = drawColor;
    }

    public Color getDrawBgColor() {
        return this.drawBgColor;
    }

    public void setDrawBgColor(Color drawBgColor) {
        this.drawBgColor = drawBgColor;
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(Color bgColor) {
        this.bgColor = bgColor;
    }

    public void setFontNum(int font_min_num, int font_max_num) {
        this.font_min_num = font_min_num;
        this.font_max_num = font_max_num;
    }

    public void setFontSize(int font_min_size, int font_max_size) {
        this.font_min_size = font_min_size;
        this.font_max_size = font_max_size;
    }

    public void setFontMargin(int top_margin, int bottom_margin) {
        this.top_margin = top_margin;
        this.bottom_margin = bottom_margin;
    }

    public void setImgSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void setArtifactNum(int artifactNum) {
        this.artifactNum = artifactNum;
    }

    public void setLineNum(int lineNum) {
        this.lineNum = lineNum;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setFilter(FilterFactory filter) {
        this.filter = filter;
    }

    public void setRandomColor(boolean randomColor) {
        this.randomColor = randomColor;
    }

    public static void main(String[] args) {
        int imgWidth = 400;
        int imgHeight = 300;
        File file = new File("/home/ice/\u56fe\u7247/test.png");
        BufferedImage image = new BufferedImage(imgWidth, imgHeight, 2);
        SimpleBackgroundFactory bf = new SimpleBackgroundFactory(new Color(255, 255, 0, 100));
        bf.fillBackground(image);
        try {
            ImageIO.write((RenderedImage)image, "png", file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FilterFactory {
        Curves(0),
        Marble(1),
        Double(2),
        Wobble(3),
        Diffuse(4);

        private int value;

        private FilterFactory(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }
    }
}

