/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Stack;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class StAXUtils {
    private static Stack xmlOutputFactoryPool = new Stack();
    private static Stack xmlInputFactoryPool = new Stack();

    public static synchronized XMLInputFactory getXMLInputFactory() {
        if (!xmlInputFactoryPool.empty()) {
            return (XMLInputFactory)xmlInputFactoryPool.pop();
        }
        return XMLInputFactory.newInstance();
    }

    public static synchronized void releaseXMLInputFactory(XMLInputFactory factory) {
        xmlInputFactoryPool.push(factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLStreamReader createXMLStreamReader(InputStream in, String encoding) throws XMLStreamException {
        XMLInputFactory inputFactory = StAXUtils.getXMLInputFactory();
        try {
            XMLStreamReader xMLStreamReader = inputFactory.createXMLStreamReader(in, encoding);
            return xMLStreamReader;
        }
        finally {
            StAXUtils.releaseXMLInputFactory(inputFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLStreamReader createXMLStreamReader(InputStream in) throws XMLStreamException {
        XMLInputFactory inputFactory = StAXUtils.getXMLInputFactory();
        try {
            XMLStreamReader xMLStreamReader = inputFactory.createXMLStreamReader(in);
            return xMLStreamReader;
        }
        finally {
            StAXUtils.releaseXMLInputFactory(inputFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLStreamReader createXMLStreamReader(Reader in) throws XMLStreamException {
        XMLInputFactory inputFactory = StAXUtils.getXMLInputFactory();
        try {
            XMLStreamReader xMLStreamReader = inputFactory.createXMLStreamReader(in);
            return xMLStreamReader;
        }
        finally {
            StAXUtils.releaseXMLInputFactory(inputFactory);
        }
    }

    public static synchronized XMLOutputFactory getXMLOutputFactory() {
        if (!xmlOutputFactoryPool.empty()) {
            return (XMLOutputFactory)xmlOutputFactoryPool.pop();
        }
        return XMLOutputFactory.newInstance();
    }

    public static synchronized void releaseXMLOutputFactory(XMLOutputFactory factory) {
        xmlOutputFactoryPool.push(factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLStreamWriter createXMLStreamWriter(OutputStream out) throws XMLStreamException {
        XMLOutputFactory outputFactory = StAXUtils.getXMLOutputFactory();
        try {
            XMLStreamWriter xMLStreamWriter = outputFactory.createXMLStreamWriter(out);
            return xMLStreamWriter;
        }
        finally {
            StAXUtils.releaseXMLOutputFactory(outputFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLStreamWriter createXMLStreamWriter(Writer out) throws XMLStreamException {
        XMLOutputFactory outputFactory = StAXUtils.getXMLOutputFactory();
        try {
            XMLStreamWriter xMLStreamWriter = outputFactory.createXMLStreamWriter(out);
            return xMLStreamWriter;
        }
        finally {
            StAXUtils.releaseXMLOutputFactory(outputFactory);
        }
    }

    public static void reset() {
        xmlOutputFactoryPool.removeAllElements();
        xmlInputFactoryPool.removeAllElements();
    }
}

