/*
 * Decompiled with CFR 0.152.
 */
package sk.seges.acris.bpm.client.engine;

import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.impl.bpmn.Condition;

public class JSCondition
implements Condition {
    private static final String END = "}";
    private static final String BEGIN = "${";
    private final String expression;

    public JSCondition(String expression) {
        this.expression = expression;
    }

    @Override
    public boolean evaluate(DelegateExecution execution) {
        String jsExpression = this.expression;
        int index = this.expression.indexOf(BEGIN);
        while (index != -1) {
            int endIndex = this.expression.indexOf(END, index);
            if (endIndex == -1) {
                throw new ActivitiException("Expression variable not closed with a bracket = " + this.expression);
            }
            String variable = this.expression.substring(index + BEGIN.length(), endIndex);
            Object value = execution.getVariable(variable);
            jsExpression = this.expression.substring(0, index);
            jsExpression = value instanceof String ? jsExpression + "\"" + value + "\"" : jsExpression + value;
            jsExpression = jsExpression + this.expression.substring(endIndex + END.length());
            index = this.expression.indexOf(BEGIN, index + BEGIN.length());
        }
        boolean result = this.evaluate(jsExpression);
        return result;
    }

    private native boolean evaluate(String var1);
}

