/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.pvm.runtime;

import java.util.List;
import java.util.logging.Logger;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.ScopeImpl;
import org.activiti.engine.impl.pvm.process.TransitionImpl;
import org.activiti.engine.impl.pvm.runtime.AtomicOperation;
import org.activiti.engine.impl.pvm.runtime.InterpretableExecution;

public class AtomicOperationTransitionDestroyScope
implements AtomicOperation {
    private static Logger log = Logger.getLogger(AtomicOperationTransitionDestroyScope.class.getName());

    @Override
    public void execute(InterpretableExecution execution) {
        InterpretableExecution propagatingExecution = null;
        ActivityImpl activity = (ActivityImpl)execution.getActivity();
        if (activity.isScope()) {
            InterpretableExecution parentScopeInstance = null;
            if (execution.isConcurrent() && !execution.isScope()) {
                InterpretableExecution concurrentRoot = (InterpretableExecution)execution.getParent();
                parentScopeInstance = (InterpretableExecution)execution.getParent().getParent();
                log.fine("moving concurrent " + execution + " one scope up under " + parentScopeInstance);
                List<? extends ActivityExecution> parentScopeInstanceExecutions = parentScopeInstance.getExecutions();
                List<? extends ActivityExecution> concurrentRootExecutions = concurrentRoot.getExecutions();
                if (parentScopeInstanceExecutions.size() == 1) {
                    ((InterpretableExecution)parentScopeInstanceExecutions.get(0)).setConcurrent(true);
                }
                concurrentRootExecutions.remove(execution);
                parentScopeInstanceExecutions.add(execution);
                execution.setParent(parentScopeInstance);
                execution.setActivity(activity);
                propagatingExecution = execution;
                if (concurrentRootExecutions.size() == 1) {
                    InterpretableExecution lastConcurrent = (InterpretableExecution)concurrentRootExecutions.get(0);
                    if (lastConcurrent.isScope()) {
                        lastConcurrent.setConcurrent(false);
                    } else {
                        log.fine("merging last concurrent " + lastConcurrent + " into concurrent root " + concurrentRoot);
                        concurrentRoot.setActivity((ActivityImpl)lastConcurrent.getActivity());
                        concurrentRoot.setActive(lastConcurrent.isActive());
                        lastConcurrent.setReplacedBy(concurrentRoot);
                        lastConcurrent.remove();
                    }
                }
            } else if (execution.isConcurrent() && execution.isScope()) {
                log.fine("scoped concurrent " + execution + " becomes concurrent and remains under " + execution.getParent());
                execution.destroy();
                propagatingExecution = execution;
            } else {
                propagatingExecution = (InterpretableExecution)execution.getParent();
                propagatingExecution.setActivity((ActivityImpl)execution.getActivity());
                propagatingExecution.setTransition(execution.getTransition());
                propagatingExecution.setActive(true);
                log.fine("destroy scope: scoped " + execution + " continues as parent scope " + propagatingExecution);
                execution.destroy();
                execution.remove();
            }
        } else {
            propagatingExecution = execution;
        }
        ScopeImpl nextOuterScopeElement = activity.getParent();
        TransitionImpl transition = propagatingExecution.getTransition();
        ActivityImpl destination = transition.getDestination();
        if (this.transitionLeavesNextOuterScope(nextOuterScopeElement, destination)) {
            propagatingExecution.setActivity((ActivityImpl)nextOuterScopeElement);
            propagatingExecution.performOperation(TRANSITION_NOTIFY_LISTENER_END);
        } else {
            propagatingExecution.performOperation(TRANSITION_NOTIFY_LISTENER_TAKE);
        }
    }

    public boolean transitionLeavesNextOuterScope(ScopeImpl nextScopeElement, ActivityImpl destination) {
        return !nextScopeElement.contains(destination);
    }
}

