/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.pvm.runtime;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.activiti.engine.impl.pvm.delegate.SubProcessActivityBehavior;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.ScopeImpl;
import org.activiti.engine.impl.pvm.runtime.AbstractEventAtomicOperation;
import org.activiti.engine.impl.pvm.runtime.InterpretableExecution;

public class AtomicOperationProcessEnd
extends AbstractEventAtomicOperation {
    private static Logger log = Logger.getLogger(AtomicOperationProcessEnd.class.getName());

    @Override
    protected ScopeImpl getScope(InterpretableExecution execution) {
        return execution.getProcessDefinition();
    }

    @Override
    protected String getEventName() {
        return "end";
    }

    @Override
    protected void eventNotificationsCompleted(InterpretableExecution execution) {
        execution.destroy();
        execution.remove();
        InterpretableExecution superExecution = execution.getSuperExecution();
        if (superExecution != null) {
            superExecution.setSubProcessInstance(null);
            ActivityImpl activity = (ActivityImpl)superExecution.getActivity();
            SubProcessActivityBehavior subProcessActivityBehavior = (SubProcessActivityBehavior)activity.getActivityBehavior();
            try {
                subProcessActivityBehavior.completed(superExecution);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Error while completing sub process of execution " + execution, e);
            }
        }
    }
}

