/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.pvm.runtime;

import org.activiti.engine.impl.pvm.delegate.ActivityBehavior;
import org.activiti.engine.impl.pvm.delegate.CompositeActivityBehavior;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.ScopeImpl;
import org.activiti.engine.impl.pvm.runtime.AbstractEventAtomicOperation;
import org.activiti.engine.impl.pvm.runtime.InterpretableExecution;

public class AtomicOperationActivityEnd
extends AbstractEventAtomicOperation {
    @Override
    protected ScopeImpl getScope(InterpretableExecution execution) {
        return (ScopeImpl)((Object)execution.getActivity());
    }

    @Override
    protected String getEventName() {
        return "end";
    }

    @Override
    protected void eventNotificationsCompleted(InterpretableExecution execution) {
        ActivityImpl activity = (ActivityImpl)execution.getActivity();
        ActivityImpl parentActivity = activity.getParentActivity();
        if (parentActivity != null && !parentActivity.isScope()) {
            execution.setActivity(parentActivity);
            execution.performOperation(ACTIVITY_END);
        } else if (execution.isProcessInstance()) {
            execution.performOperation(PROCESS_END);
        } else if (execution.isScope()) {
            ActivityBehavior parentActivityBehavior;
            ActivityBehavior activityBehavior = parentActivityBehavior = parentActivity != null ? parentActivity.getActivityBehavior() : null;
            if (parentActivityBehavior instanceof CompositeActivityBehavior) {
                CompositeActivityBehavior compositeActivityBehavior = (CompositeActivityBehavior)parentActivity.getActivityBehavior();
                execution.setActivity(parentActivity);
                compositeActivityBehavior.lastExecutionEnded(execution);
            } else {
                InterpretableExecution parentScopeExecution = (InterpretableExecution)execution.getParent();
                execution.destroy();
                execution.remove();
                parentScopeExecution.setActivity(parentActivity);
                parentScopeExecution.performOperation(ACTIVITY_END);
            }
        } else {
            execution.remove();
            InterpretableExecution concurrentRoot = (InterpretableExecution)execution.getParent();
            if (concurrentRoot.getExecutions().size() == 1) {
                InterpretableExecution lastConcurrent = (InterpretableExecution)concurrentRoot.getExecutions().get(0);
                if (!lastConcurrent.isScope()) {
                    concurrentRoot.setActivity((ActivityImpl)lastConcurrent.getActivity());
                    lastConcurrent.setReplacedBy(concurrentRoot);
                    lastConcurrent.remove();
                } else {
                    lastConcurrent.setConcurrent(false);
                }
            }
        }
    }

    protected boolean isExecutionAloneInParent(InterpretableExecution execution) {
        ScopeImpl parentScope = (ScopeImpl)execution.getActivity().getParent();
        for (InterpretableExecution interpretableExecution : execution.getParent().getExecutions()) {
            if (interpretableExecution == execution || !parentScope.contains((ActivityImpl)interpretableExecution.getActivity())) continue;
            return false;
        }
        return true;
    }
}

