/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.pvm.process;

import java.util.ArrayList;
import java.util.List;
import org.activiti.engine.impl.pvm.PvmProcessDefinition;
import org.activiti.engine.impl.pvm.PvmProcessInstance;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.ScopeImpl;
import org.activiti.engine.impl.pvm.runtime.ExecutionImpl;
import org.activiti.engine.impl.pvm.runtime.InterpretableExecution;

public class ProcessDefinitionImpl
extends ScopeImpl
implements PvmProcessDefinition {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected ActivityImpl initial;
    protected List<ActivityImpl> initialActivityStack;

    public ProcessDefinitionImpl(String id) {
        super(id, null);
        this.processDefinition = this;
    }

    @Override
    public PvmProcessInstance createProcessInstance() {
        InterpretableExecution processInstance = this.newProcessInstance();
        processInstance.setProcessDefinition(this);
        processInstance.setProcessInstance(processInstance);
        processInstance.initialize();
        InterpretableExecution scopeInstance = processInstance;
        List<ActivityImpl> initialActivities = this.getInitialActivityStack();
        for (ActivityImpl initialActivity : initialActivities) {
            if (!initialActivity.isScope()) continue;
            scopeInstance = (InterpretableExecution)scopeInstance.createExecution();
            scopeInstance.setActivity(initialActivity);
            if (!initialActivity.isScope()) continue;
            scopeInstance.initialize();
        }
        scopeInstance.setActivity(this.initial);
        return processInstance;
    }

    public synchronized List<ActivityImpl> getInitialActivityStack() {
        if (this.initialActivityStack == null) {
            this.initialActivityStack = new ArrayList<ActivityImpl>();
            for (ActivityImpl activity = this.initial; activity != null; activity = activity.getParentActivity()) {
                this.initialActivityStack.add(0, activity);
            }
        }
        return this.initialActivityStack;
    }

    protected InterpretableExecution newProcessInstance() {
        return new ExecutionImpl();
    }

    @Override
    public String getDiagramResourceName() {
        return null;
    }

    @Override
    public ActivityImpl getInitial() {
        return this.initial;
    }

    public void setInitial(ActivityImpl initial) {
        this.initial = initial;
    }

    public String toString() {
        return "ProcessDefinition(" + this.id + ")";
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

