/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.extensions.processor.js.AbstractLinterProcessor;
import ro.isdc.wro.extensions.processor.js.JsLintProcessor;
import ro.isdc.wro.extensions.processor.support.linter.LinterError;
import ro.isdc.wro.extensions.processor.support.linter.LinterException;
import ro.isdc.wro.extensions.support.lint.LintReport;
import ro.isdc.wro.extensions.support.lint.ReportXmlFormatter;
import ro.isdc.wro.extensions.support.lint.ResourceLintReport;
import ro.isdc.wro.maven.plugin.AbstractLinterMojo;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsLintMojo
extends AbstractLinterMojo<LinterError> {
    private File reportFile;
    private String reportFormat = ReportXmlFormatter.FormatterType.JSLINT.getFormat();

    @Override
    protected ResourcePreProcessor createResourceProcessor() {
        AbstractLinterProcessor processor = new JsLintProcessor(){

            public void process(Resource resource, Reader reader, Writer writer) throws IOException {
                JsLintMojo.this.getLog().info((CharSequence)("processing resource: " + resource));
                if (resource != null) {
                    JsLintMojo.this.getLog().info((CharSequence)("processing resource: " + resource.getUri()));
                }
                super.process(resource, reader, (Writer)new StringWriter());
            }

            protected void onException(WroRuntimeException e) {
                JsLintMojo.this.onException((Exception)e);
            }

            protected void onLinterException(LinterException e, Resource resource) {
                String errorMessage = String.format("%s errors found while processing resource: %s. Errors are: %s", e.getErrors().size(), resource, e.getErrors());
                JsLintMojo.this.getLog().error((CharSequence)errorMessage);
                JsLintMojo.this.addReport(ResourceLintReport.create((String)resource.getUri(), (Collection)e.getErrors()));
                if (!JsLintMojo.this.isFailNever()) {
                    throw new WroRuntimeException("Errors found when validating resource: " + resource);
                }
            }
        }.setOptionsAsString(this.getOptions());
        return processor;
    }

    @Override
    protected ReportXmlFormatter createXmlFormatter(LintReport<LinterError> lintReport, ReportXmlFormatter.FormatterType type) {
        return ReportXmlFormatter.createForLinterError(lintReport, (ReportXmlFormatter.FormatterType)type);
    }

    @Override
    protected File getReportFile() {
        return this.reportFile;
    }

    @Override
    protected String getReportFormat() {
        return this.reportFormat;
    }

    void setReportFile(File reportFile) {
        this.reportFile = reportFile;
    }

    void setReportFormat(String reportFormat) {
        this.reportFormat = reportFormat;
    }

    @Override
    void onException(Exception e) {
    }
}

