/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.sonatype.plexus.build.incremental.BuildContext;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.extensions.manager.standalone.ExtensionsStandaloneManagerFactory;
import ro.isdc.wro.manager.WroManager;
import ro.isdc.wro.manager.factory.WroManagerFactory;
import ro.isdc.wro.manager.factory.standalone.StandaloneContext;
import ro.isdc.wro.manager.factory.standalone.StandaloneContextAware;
import ro.isdc.wro.maven.plugin.support.ExtraConfigFileAware;
import ro.isdc.wro.model.WroModel;
import ro.isdc.wro.model.WroModelInspector;
import ro.isdc.wro.model.group.Group;
import ro.isdc.wro.model.group.processor.InjectorBuilder;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.locator.factory.UriLocatorFactory;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.model.resource.processor.decorator.ExceptionHandlingProcessorDecorator;
import ro.isdc.wro.model.resource.processor.impl.css.AbstractCssImportPreProcessor;
import ro.isdc.wro.model.resource.processor.impl.css.CssImportPreProcessor;
import ro.isdc.wro.model.resource.support.hash.HashStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWro4jMojo
extends AbstractMojo {
    private File wroFile;
    private File contextFolder;
    private boolean minimize;
    private boolean ignoreMissingResources;
    private String targetGroups;
    private MavenProject mavenProject;
    private String wroManagerFactory;
    private WroManagerFactory managerFactory;
    private File extraConfigFile;
    private BuildContext buildContext;

    public final void execute() throws MojoExecutionException {
        this.validate();
        this.getLog().info((CharSequence)"Executing the mojo: ");
        this.getLog().info((CharSequence)("Wro4j Model path: " + this.wroFile.getPath()));
        this.getLog().info((CharSequence)("targetGroups: " + this.getTargetGroups()));
        this.getLog().info((CharSequence)("minimize: " + this.isMinimize()));
        this.getLog().info((CharSequence)("ignoreMissingResources: " + this.isIgnoreMissingResources()));
        this.getLog().debug((CharSequence)("wroManagerFactory: " + this.wroManagerFactory));
        this.getLog().debug((CharSequence)("extraConfig: " + this.extraConfigFile));
        this.extendPluginClasspath();
        Context.set((Context)Context.standaloneContext());
        try {
            this.onBeforeExecute();
            this.doExecute();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Exception occured while processing: " + e.getMessage(), e);
        }
        finally {
            this.onAfterExecute();
        }
    }

    protected void onBeforeExecute() {
    }

    protected void onAfterExecute() {
    }

    private StandaloneContext createStandaloneContext() {
        StandaloneContext runContext = new StandaloneContext();
        runContext.setContextFolder(this.getContextFolder());
        runContext.setMinimize(this.isMinimize());
        runContext.setWroFile(this.getWroFile());
        runContext.setIgnoreMissingResources(this.isIgnoreMissingResources());
        return runContext;
    }

    protected abstract void doExecute() throws Exception;

    protected WroManagerFactory getManagerFactory() {
        if (this.managerFactory == null) {
            try {
                this.managerFactory = this.newWroManagerFactory();
            }
            catch (MojoExecutionException e) {
                throw WroRuntimeException.wrap((Exception)((Object)e));
            }
            if (this.managerFactory instanceof StandaloneContextAware) {
                ((StandaloneContextAware)this.managerFactory).initialize(this.createStandaloneContext());
            }
        }
        return this.managerFactory;
    }

    protected WroManagerFactory newWroManagerFactory() throws MojoExecutionException {
        Object factory = null;
        factory = this.wroManagerFactory != null ? this.createCustomManagerFactory() : new ExtensionsStandaloneManagerFactory();
        this.getLog().info((CharSequence)("wroManagerFactory class: " + factory.getClass().getName()));
        if (factory instanceof ExtraConfigFileAware) {
            if (this.extraConfigFile == null) {
                throw new MojoExecutionException("The " + factory.getClass() + " requires a valid extraConfigFile!");
            }
            this.getLog().debug((CharSequence)("Using extraConfigFile: " + this.extraConfigFile.getAbsolutePath()));
            ((ExtraConfigFileAware)factory).setExtraConfigFile(this.extraConfigFile);
        }
        return factory;
    }

    private WroManagerFactory createCustomManagerFactory() throws MojoExecutionException {
        WroManagerFactory managerFactory;
        try {
            Class<?> wroManagerFactoryClass = Thread.currentThread().getContextClassLoader().loadClass(this.wroManagerFactory.trim());
            managerFactory = (WroManagerFactory)wroManagerFactoryClass.newInstance();
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Cannot instantiate wroManagerFactoryClass", (Throwable)e);
            throw new MojoExecutionException("Invalid wroManagerFactoryClass, called: " + this.wroManagerFactory, e);
        }
        return managerFactory;
    }

    protected final List<String> getTargetGroupsAsList() throws Exception {
        List<String> result = null;
        result = this.isIncrementalBuild() ? this.getIncrementalGroupNames() : (this.getTargetGroups() == null ? this.getAllModelGroupNames() : Arrays.asList(this.getTargetGroups().split(",")));
        this.persistResourceFingerprints(result);
        this.getLog().info((CharSequence)("The following groups will be processed: " + result));
        return result;
    }

    private void persistResourceFingerprints(List<String> groupNames) {
        if (this.buildContext != null) {
            WroModelInspector modelInspector = new WroModelInspector(this.getModel());
            WroManager manager = this.getWroManager();
            HashStrategy hashStrategy = manager.getHashStrategy();
            UriLocatorFactory locatorFactory = manager.getUriLocatorFactory();
            for (String groupName : groupNames) {
                Group group = modelInspector.getGroupByName(groupName);
                if (group == null) continue;
                for (Resource resource : group.getResources()) {
                    try {
                        String fingerprint = hashStrategy.getHash(locatorFactory.locate(resource.getUri()));
                        this.buildContext.setValue(resource.getUri(), (Object)fingerprint);
                    }
                    catch (IOException e) {
                        this.getLog().debug((CharSequence)("could not check fingerprint of resource: " + resource));
                    }
                }
            }
        }
    }

    private ResourcePreProcessor createCssImportProcessor(Resource resource, final AtomicBoolean changeDetected) {
        AbstractCssImportPreProcessor cssImportProcessor = new AbstractCssImportPreProcessor(){

            protected void onImportDetected(String importedUri) {
                AbstractWro4jMojo.this.getLog().debug((CharSequence)("Found @import " + importedUri));
                boolean isImportChanged = AbstractWro4jMojo.this.isResourceChanged(Resource.create((String)importedUri, (ResourceType)ResourceType.CSS));
                AbstractWro4jMojo.this.getLog().debug((CharSequence)("\tisImportChanged: " + isImportChanged));
                if (isImportChanged) {
                    changeDetected.set(true);
                    throw new WroRuntimeException("Change detected. No need to continue processing");
                }
            }

            protected String doTransform(String cssContent, List<Resource> foundImports) throws IOException {
                return "";
            }

            public String toString() {
                return CssImportPreProcessor.class.getSimpleName();
            }
        };
        ExceptionHandlingProcessorDecorator processor = new ExceptionHandlingProcessorDecorator(cssImportProcessor){

            protected boolean isIgnoreFailingProcessor() {
                return true;
            }
        };
        InjectorBuilder.create((WroManagerFactory)this.getManagerFactory()).build().inject((Object)processor);
        return processor;
    }

    private List<String> getIncrementalGroupNames() throws Exception {
        ArrayList<String> changedGroupNames = new ArrayList<String>();
        block0: for (Group group : this.getModel().getGroups()) {
            for (Resource resource : group.getResources()) {
                this.getLog().debug((CharSequence)("checking delta for resource: " + resource));
                if (!this.isResourceChanged(resource)) continue;
                this.getLog().debug((CharSequence)("detected change for resource: " + resource + " and group: " + group.getName()));
                changedGroupNames.add(group.getName());
                continue block0;
            }
        }
        return changedGroupNames;
    }

    private boolean isResourceChanged(Resource resource) {
        WroManager manager = this.getWroManager();
        HashStrategy hashStrategy = manager.getHashStrategy();
        UriLocatorFactory locatorFactory = manager.getUriLocatorFactory();
        AtomicBoolean changeDetected = new AtomicBoolean(false);
        try {
            String fingerprint = hashStrategy.getHash(locatorFactory.locate(resource.getUri()));
            String previousFingerprint = this.buildContext != null ? String.valueOf(this.buildContext.getValue(resource.getUri())) : null;
            this.getLog().debug((CharSequence)("fingerprint <current, prev>: <" + fingerprint + ", " + previousFingerprint + ">"));
            changeDetected.set(fingerprint != null && !fingerprint.equals(previousFingerprint));
            if (!changeDetected.get() && resource.getType() == ResourceType.CSS) {
                InputStreamReader reader = new InputStreamReader(locatorFactory.locate(resource.getUri()));
                this.getLog().debug((CharSequence)("Check @import directive from " + resource));
                this.createCssImportProcessor(resource, changeDetected).process(resource, (Reader)reader, (Writer)new StringWriter());
            }
            return changeDetected.get();
        }
        catch (IOException e) {
            this.getLog().debug((CharSequence)("failed to check for delta resource: " + resource));
            return false;
        }
    }

    protected final boolean isIncrementalBuild() {
        return this.buildContext != null && this.buildContext.isIncremental();
    }

    private List<String> getAllModelGroupNames() {
        return new WroModelInspector(this.getModel()).getGroupNames();
    }

    private WroModel getModel() {
        return (WroModel)this.getWroManager().getModelFactory().create();
    }

    private WroManager getWroManager() {
        try {
            return (WroManager)this.getManagerFactory().create();
        }
        catch (Exception e) {
            throw WroRuntimeException.wrap((Exception)e);
        }
    }

    protected void validate() throws MojoExecutionException {
        if (this.wroFile == null) {
            throw new MojoExecutionException("contextFolder was not set!");
        }
        if (this.contextFolder == null) {
            throw new MojoExecutionException("contextFolder was not set!");
        }
    }

    protected final void extendPluginClasspath() throws MojoExecutionException {
        ArrayList<String> classpathElements = new ArrayList<String>();
        try {
            classpathElements.addAll(this.mavenProject.getRuntimeClasspathElements());
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Could not get compile classpath elements", (Exception)((Object)e));
        }
        ClassLoader classLoader = this.createClassLoader(classpathElements);
        Thread.currentThread().setContextClassLoader(classLoader);
    }

    private ClassLoader createClassLoader(List<String> classpathElements) {
        this.getLog().debug((CharSequence)"Classpath elements:");
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            for (String element : classpathElements) {
                File elementFile = new File(element);
                this.getLog().debug((CharSequence)("Adding element to plugin classpath: " + elementFile.getPath()));
                urls.add(elementFile.toURI().toURL());
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Error retreiving URL for artifact", (Throwable)e);
            throw new RuntimeException(e);
        }
        return new URLClassLoader(urls.toArray(new URL[0]), Thread.currentThread().getContextClassLoader());
    }

    void setContextFolder(File contextFolder) {
        this.contextFolder = contextFolder;
    }

    void setWroFile(File wroFile) {
        this.wroFile = wroFile;
    }

    File getWroFile() {
        return this.wroFile;
    }

    File getContextFolder() {
        return this.contextFolder;
    }

    void setMinimize(boolean minimize) {
        this.minimize = minimize;
    }

    void setIgnoreMissingResources(boolean ignoreMissingResources) {
        this.ignoreMissingResources = ignoreMissingResources;
    }

    boolean isMinimize() {
        return this.minimize;
    }

    boolean isIgnoreMissingResources() {
        return this.ignoreMissingResources;
    }

    void setMavenProject(MavenProject mavenProject) {
        this.mavenProject = mavenProject;
    }

    String getTargetGroups() {
        return this.targetGroups;
    }

    void setTargetGroups(String targetGroups) {
        this.targetGroups = targetGroups;
    }

    void setWroManagerFactory(String wroManagerFactory) {
        this.wroManagerFactory = wroManagerFactory;
    }

    void setExtraConfigFile(File extraConfigFile) {
        this.extraConfigFile = extraConfigFile;
    }

    void setBuildContext(BuildContext buildContext) {
        this.buildContext = buildContext;
    }
}

