/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.processor.impl.css;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.util.WroUtil;

@SupportedResourceType(value=ResourceType.CSS)
public class CssVariablesProcessor
implements ResourcePreProcessor,
ResourcePostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(CssVariablesProcessor.class);
    public static final String ALIAS = "cssVariables";
    private static final Pattern PATTERN_VARIABLES_DEFINITION = Pattern.compile(WroUtil.loadRegexpWithKey("cssVariables.definition"));
    private static final Pattern PATTERN_VARIABLES_BODY = Pattern.compile(WroUtil.loadRegexpWithKey("cssVariables.body"));
    private static final Pattern PATTERN_VARIABLE_HOLDER = Pattern.compile(WroUtil.loadRegexpWithKey("cssVariables.holder"));

    private Map<String, String> extractVariables(String variablesBody) {
        HashMap<String, String> map = new HashMap<String, String>();
        Matcher m = PATTERN_VARIABLES_BODY.matcher(variablesBody);
        LOG.debug("parsing variables body");
        while (m.find()) {
            String key = m.group(1);
            String value = m.group(2);
            if (map.containsKey(key)) {
                LOG.warn("A duplicate variable name found with name: {} and value: {}.", (Object)key, (Object)value);
            }
            map.put(key, value);
        }
        return map;
    }

    @Override
    public void process(Reader reader, Writer writer) throws IOException {
        this.process(null, reader, writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        try {
            String css = IOUtils.toString((Reader)reader);
            String result = this.parseCss(css);
            writer.write(result);
        }
        finally {
            reader.close();
            writer.close();
        }
    }

    private String parseCss(String css) {
        HashMap<String, String> map = new HashMap<String, String>();
        StringBuffer sb = new StringBuffer();
        Matcher m = PATTERN_VARIABLES_DEFINITION.matcher(css);
        while (m.find()) {
            String variablesBody = m.group(1);
            map.putAll(this.extractVariables(variablesBody));
            m.appendReplacement(sb, "");
        }
        m.appendTail(sb);
        return this.replaceVariables(sb.toString(), map);
    }

    private String replaceVariables(String css, Map<String, String> variables) {
        StringBuffer sb = new StringBuffer();
        Matcher m = PATTERN_VARIABLE_HOLDER.matcher(css);
        while (m.find()) {
            String oldMatch = m.group();
            String variableName = m.group(1);
            String variableValue = variables.get(variableName);
            if (variableValue != null) {
                String newReplacement = oldMatch.replace(oldMatch, variableValue);
                m.appendReplacement(sb, newReplacement.trim());
                continue;
            }
            LOG.warn("No variable with name " + variableName + " was found!");
        }
        m.appendTail(sb);
        return sb.toString();
    }
}

