/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.processor.impl.css;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.regex.Matcher;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.config.ReadOnlyContext;
import ro.isdc.wro.http.handler.ResourceProxyRequestHandler;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;
import ro.isdc.wro.model.resource.locator.UrlUriLocator;
import ro.isdc.wro.model.resource.processor.ImportAware;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.model.resource.processor.support.CssUrlInspector;
import ro.isdc.wro.model.resource.processor.support.DataUriGenerator;
import ro.isdc.wro.util.WroUtil;

@SupportedResourceType(value=ResourceType.CSS)
public abstract class AbstractCssUrlRewritingProcessor
implements ResourcePreProcessor,
ResourcePostProcessor,
ImportAware {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCssUrlRewritingProcessor.class);
    @Inject
    private ReadOnlyContext context;

    @Override
    public void process(Reader reader, Writer writer) throws IOException {
        throw new WroRuntimeException("This processor: " + this.getClass().getSimpleName() + " cannot work as a postProcessor!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void process(Resource resource, Reader reader, Writer writer) throws IOException {
        LOG.debug("Applying {} processor", (Object)this.getClass().getSimpleName());
        try {
            String cssUri = resource != null ? resource.getUri() : "";
            LOG.debug("cssUri: {}", (Object)cssUri);
            String css = IOUtils.toString((Reader)reader);
            String result = this.newCssUrlInspector().findAndReplace(css, this.createUrlItemHandler(cssUri));
            writer.write(result);
            this.onProcessCompleted();
        }
        finally {
            reader.close();
            writer.close();
        }
    }

    private CssUrlInspector.ItemHandler createUrlItemHandler(final String cssUri) {
        return new CssUrlInspector.ItemHandler(){

            @Override
            public String replace(String originalDeclaration, String originalUrl) {
                Validate.notNull((Object)originalUrl);
                String replacement = originalDeclaration;
                if (AbstractCssUrlRewritingProcessor.this.isReplaceNeeded(originalUrl)) {
                    String modifiedUrl = AbstractCssUrlRewritingProcessor.this.replaceImageUrl(cssUri.trim(), WroUtil.cleanImageUrl(originalUrl));
                    LOG.debug("replaced old Url: [{}] with: [{}].", (Object)originalUrl, (Object)modifiedUrl);
                    String modifiedDeclaration = Matcher.quoteReplacement(originalDeclaration.replace(originalUrl, modifiedUrl));
                    AbstractCssUrlRewritingProcessor.this.onUrlReplaced(modifiedUrl);
                    replacement = AbstractCssUrlRewritingProcessor.this.replaceDeclaration(originalDeclaration.trim(), modifiedDeclaration);
                }
                return replacement;
            }
        };
    }

    protected CssUrlInspector newCssUrlInspector() {
        return new CssUrlInspector();
    }

    protected void onProcessCompleted() {
    }

    protected String replaceDeclaration(String originalDeclaration, String modifiedDeclaration) {
        return modifiedDeclaration;
    }

    protected void onUrlReplaced(String replacedUrl) {
    }

    protected abstract String replaceImageUrl(String var1, String var2);

    protected boolean isReplaceNeeded(String url) {
        return !UrlUriLocator.isValid(url) && !DataUriGenerator.isDataUri(url.trim());
    }

    protected String getUrlPrefix() {
        return ResourceProxyRequestHandler.createProxyPath(this.context.getRequest().getRequestURI(), "");
    }

    @Override
    public boolean isImportAware() {
        return true;
    }
}

