/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.factory;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.model.WroModel;
import ro.isdc.wro.model.WroModelInspector;
import ro.isdc.wro.model.factory.AbstractWroModelFactory;
import ro.isdc.wro.model.group.Group;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.group.RecursiveGroupDefinitionException;
import ro.isdc.wro.model.group.processor.Injector;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.locator.factory.UriLocatorFactory;
import ro.isdc.wro.util.StopWatch;

public class XmlModelFactory
extends AbstractWroModelFactory {
    private static final Logger LOG = LoggerFactory.getLogger(XmlModelFactory.class);
    public static final String ALIAS = "xml";
    private static final String DEFAULT_FILE_NAME = "wro.xml";
    private static final String XML_SCHEMA_FILE = "wro.xsd";
    protected static final String TAG_GROUP = "group";
    protected static final String TAG_IMPORT = "import";
    protected static final String TAG_CSS = "css";
    protected static final String TAG_JS = "js";
    protected static final String TAG_GROUP_REF = "group-ref";
    protected static final String ATTR_GROUP_NAME = "name";
    protected static final String ATTR_GROUP_ABSTRACT = "abstract";
    protected static final String ATTR_MINIMIZE = "minimize";
    private final Map<String, Element> allGroupElements = new HashMap<String, Element>();
    private final Collection<String> groupsInProcess = new HashSet<String>();
    @Inject
    private UriLocatorFactory locatorFactory;
    @Inject
    private Injector injector;
    private final Set<String> processedImports = new HashSet<String>();
    private boolean validateXml = true;
    private WroModel model;

    public XmlModelFactory() {
    }

    private XmlModelFactory(Set<String> processedImports) {
        Validate.notNull(processedImports);
        this.processedImports.addAll(processedImports);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized WroModel create() {
        this.model = new WroModel();
        StopWatch stopWatch = new StopWatch("Create Wro Model from XML");
        try {
            stopWatch.start("createDocument");
            Document document = this.createDocument();
            stopWatch.stop();
            stopWatch.start("processGroups");
            this.processGroups(document);
            stopWatch.stop();
            stopWatch.start("processImports");
            this.processImports(document);
            stopWatch.stop();
            stopWatch.start("createModel");
            this.parseGroups();
            stopWatch.stop();
            WroModel wroModel = this.model;
            return wroModel;
        }
        finally {
            this.processedImports.clear();
            LOG.debug(stopWatch.prettyPrint());
        }
    }

    private Document createDocument() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            Document document = factory.newDocumentBuilder().parse((InputStream)new AutoCloseInputStream(this.getModelResourceAsStream()));
            document.getDocumentElement().normalize();
            if (this.isValidateXml()) {
                this.validate(document);
            }
            return document;
        }
        catch (Exception e) {
            throw new WroRuntimeException("Cannot build model from XML: " + e.getMessage(), e);
        }
    }

    private void validate(Document document) throws IOException, SAXException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = factory.newSchema(new StreamSource(this.getSchemaStream()));
        schema.newValidator().validate(new DOMSource(document));
    }

    private InputStream getSchemaStream() throws IOException {
        return new AutoCloseInputStream(WroRuntimeException.class.getResourceAsStream(XML_SCHEMA_FILE));
    }

    private void processGroups(Document document) {
        NodeList groupNodeList = document.getElementsByTagName(TAG_GROUP);
        for (int i = 0; i < groupNodeList.getLength(); ++i) {
            Element groupElement = (Element)groupNodeList.item(i);
            String name = groupElement.getAttribute(ATTR_GROUP_NAME);
            this.allGroupElements.put(name, groupElement);
        }
    }

    private void processImports(Document document) {
        NodeList importsList = document.getElementsByTagName(TAG_IMPORT);
        LOG.debug("number of imports: {}", (Object)importsList.getLength());
        for (int i = 0; i < importsList.getLength(); ++i) {
            Element element = (Element)importsList.item(i);
            String name = element.getTextContent();
            LOG.debug("processing import: {}", (Object)name);
            Validate.notNull((Object)this.locatorFactory, (String)"The Locator cannot be null!", (Object[])new Object[0]);
            if (this.processedImports.contains(name)) {
                String message = "Recursive import detected: " + name;
                LOG.error(message);
                throw new RecursiveGroupDefinitionException(message);
            }
            this.processedImports.add(name);
            this.model.merge(this.createImportedModel(name));
        }
    }

    private WroModel createImportedModel(final String modelLocation) {
        XmlModelFactory importedModelFactory = new XmlModelFactory(this.processedImports){

            @Override
            protected InputStream getModelResourceAsStream() throws IOException {
                LOG.debug("build model from import: {}", (Object)modelLocation);
                return new AutoCloseInputStream(XmlModelFactory.this.locatorFactory.locate(modelLocation));
            }
        };
        this.injector.inject(importedModelFactory);
        try {
            return importedModelFactory.create();
        }
        catch (WroRuntimeException e) {
            LOG.error("Detected invalid model import from location {}", (Object)modelLocation);
            throw e;
        }
    }

    private void parseGroups() {
        for (Element element : this.allGroupElements.values()) {
            this.parseGroup(element);
        }
    }

    private Collection<Resource> parseGroup(Element element) {
        boolean isAbstractGroup;
        String name = element.getAttribute(ATTR_GROUP_NAME);
        String isAbstractAsString = element.getAttribute(ATTR_GROUP_ABSTRACT);
        boolean bl = isAbstractGroup = StringUtils.isNotEmpty((CharSequence)isAbstractAsString) && Boolean.valueOf(isAbstractAsString) != false;
        if (this.groupsInProcess.contains(name)) {
            throw new RecursiveGroupDefinitionException("Infinite Recursion detected for the group: " + name + ". Recursion path: " + this.groupsInProcess);
        }
        LOG.debug("\tadding group: {}", (Object)name);
        this.groupsInProcess.add(name);
        Group parsedGroup = new WroModelInspector(this.model).getGroupByName(name);
        if (parsedGroup != null) {
            this.groupsInProcess.remove(name);
            return parsedGroup.getResources();
        }
        Group group = this.createGroup(element);
        this.groupsInProcess.remove(name);
        if (!isAbstractGroup) {
            this.model.addGroup(group);
        }
        return group.getResources();
    }

    protected Group createGroup(Element element) {
        String name = element.getAttribute(ATTR_GROUP_NAME);
        Group group = new Group(name);
        ArrayList<Resource> resources = new ArrayList<Resource>();
        NodeList resourceNodeList = element.getChildNodes();
        for (int i = 0; i < resourceNodeList.getLength(); ++i) {
            Node node = resourceNodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element resourceElement = (Element)node;
            this.parseResource(resourceElement, resources);
        }
        group.setResources(resources);
        return group;
    }

    private void parseResource(Element resourceElement, Collection<Resource> resources) {
        String tagName = resourceElement.getTagName();
        String uri = resourceElement.getTextContent();
        if (TAG_GROUP_REF.equals(tagName)) {
            resources.addAll(this.getResourcesForGroup(uri));
        }
        if (this.getResourceType(resourceElement) != null) {
            Resource resource = this.createResource(resourceElement);
            LOG.debug("\t\tadding resource: {}", (Object)resource);
            resources.add(resource);
        }
    }

    protected final ResourceType getResourceType(Element resourceElement) {
        ResourceType type = null;
        String tagName = resourceElement.getTagName();
        if (TAG_JS.equals(tagName)) {
            type = ResourceType.JS;
        } else if (TAG_CSS.equals(tagName)) {
            type = ResourceType.CSS;
        }
        return type;
    }

    protected Resource createResource(Element resourceElement) {
        String uri = resourceElement.getTextContent();
        String minimizeAsString = resourceElement.getAttribute(ATTR_MINIMIZE);
        boolean minimize = StringUtils.isEmpty((CharSequence)minimizeAsString) || Boolean.valueOf(minimizeAsString) != false;
        Resource resource = Resource.create(uri, this.getResourceType(resourceElement));
        resource.setMinimize(minimize);
        return resource;
    }

    private Collection<Resource> getResourcesForGroup(String groupName) {
        WroModelInspector modelInspector = new WroModelInspector(this.model);
        Group foundGroup = modelInspector.getGroupByName(groupName);
        if (foundGroup == null) {
            Element groupElement = this.allGroupElements.get(groupName);
            if (groupElement == null) {
                throw new WroRuntimeException("Invalid group-ref: " + groupName);
            }
            return this.parseGroup(groupElement);
        }
        return foundGroup.getResources();
    }

    @Override
    protected String getDefaultModelFilename() {
        return DEFAULT_FILE_NAME;
    }

    private boolean isValidateXml() {
        return this.validateXml;
    }

    public XmlModelFactory setValidateXml(boolean validateXml) {
        this.validateXml = validateXml;
        return this;
    }
}

