/*
 * Decompiled with CFR 0.152.
 */
package com.p6spy.engine.spy;

import com.p6spy.engine.common.P6Util;
import com.p6spy.engine.logging.P6LogFactory;
import com.p6spy.engine.spy.P6Factory;
import com.p6spy.engine.spy.P6ModuleManager;
import com.p6spy.engine.spy.P6SpyFactory;
import com.p6spy.engine.spy.P6SpyLoadableOptions;
import com.p6spy.engine.spy.P6SpyOptionsMBean;
import com.p6spy.engine.spy.appender.FileLogger;
import com.p6spy.engine.spy.appender.MessageFormattingStrategy;
import com.p6spy.engine.spy.appender.P6Logger;
import com.p6spy.engine.spy.appender.SingleLineFormat;
import com.p6spy.engine.spy.option.P6OptionsRepository;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.StandardMBean;

public class P6SpyOptions
extends StandardMBean
implements P6SpyLoadableOptions {
    public static final String AUTOFLUSH = "autoflush";
    public static final String DRIVERLIST = "driverlist";
    public static final String LOGFILE = "logfile";
    public static final String LOG_MESSAGE_FORMAT = "logMessageFormat";
    public static final String APPEND = "append";
    public static final String DATEFORMAT = "dateformat";
    public static final String APPENDER = "appender";
    public static final String MODULELIST = "modulelist";
    public static final String STACKTRACE = "stacktrace";
    public static final String STACKTRACECLASS = "stacktraceclass";
    public static final String RELOADPROPERTIES = "reloadproperties";
    public static final String RELOADPROPERTIESINTERVAL = "reloadpropertiesinterval";
    public static final String JNDICONTEXTFACTORY = "jndicontextfactory";
    public static final String JNDICONTEXTPROVIDERURL = "jndicontextproviderurl";
    public static final String JNDICONTEXTCUSTOM = "jndicontextcustom";
    public static final String REALDATASOURCE = "realdatasource";
    public static final String REALDATASOURCECLASS = "realdatasourceclass";
    public static final String REALDATASOURCEPROPERTIES = "realdatasourceproperties";
    public static final String CUSTOM_LOG_MESSAGE_FORMAT = "customLogMessageFormat";
    public static final String DATABASE_DIALECT_DATE_FORMAT = "databaseDialectDateFormat";
    public static final String DATABASE_DIALECT_TIMESTAMP_FORMAT = "databaseDialectTimestampFormat";
    public static final String DATABASE_DIALECT_BOOLEAN_FORMAT = "databaseDialectBooleanFormat";
    public static final String JMX = "jmx";
    public static final String JMX_PREFIX = "jmxPrefix";
    public static final String DRIVER_NAMES = "driverNames";
    public static final String MODULE_FACTORIES = "moduleFactories";
    public static final String MODULE_NAMES = "moduleNames";
    public static final String LOG_MESSAGE_FORMAT_INSTANCE = "logMessageFormatInstance";
    public static final String APPENDER_INSTANCE = "appenderInstance";
    protected static final Map<String, String> defaults = new HashMap<String, String>();
    private final P6OptionsRepository optionsRepository;

    public P6SpyOptions(P6OptionsRepository optionsRepository) {
        super(P6SpyOptionsMBean.class, false);
        this.optionsRepository = optionsRepository;
    }

    @Override
    public void load(Map<String, String> options) {
        this.setLogMessageFormat(options.get(LOG_MESSAGE_FORMAT));
        this.setLogfile(options.get(LOGFILE));
        this.setAppend(options.get(APPEND));
        this.setDateformat(options.get(DATEFORMAT));
        this.setAppender(options.get(APPENDER));
        this.setModulelist(options.get(MODULELIST));
        this.setDriverlist(options.get(DRIVERLIST));
        this.setStackTrace(options.get(STACKTRACE));
        this.setStackTraceClass(options.get(STACKTRACECLASS));
        this.setAutoflush(options.get(AUTOFLUSH));
        this.setReloadProperties(options.get(RELOADPROPERTIES));
        this.setReloadPropertiesInterval(options.get(RELOADPROPERTIESINTERVAL));
        this.setJNDIContextFactory(options.get(JNDICONTEXTFACTORY));
        this.setJNDIContextProviderURL(options.get(JNDICONTEXTPROVIDERURL));
        this.setJNDIContextCustom(options.get(JNDICONTEXTCUSTOM));
        this.setRealDataSource(options.get(REALDATASOURCE));
        this.setRealDataSourceClass(options.get(REALDATASOURCECLASS));
        this.setRealDataSourceProperties(options.get(REALDATASOURCEPROPERTIES));
        this.setDatabaseDialectDateFormat(options.get(DATABASE_DIALECT_DATE_FORMAT));
        this.setDatabaseDialectTimestampFormat(options.get(DATABASE_DIALECT_TIMESTAMP_FORMAT));
        this.setDatabaseDialectBooleanFormat(options.get(DATABASE_DIALECT_BOOLEAN_FORMAT));
        this.setCustomLogMessageFormat(options.get(CUSTOM_LOG_MESSAGE_FORMAT));
        this.setJmx(options.get(JMX));
        this.setJmxPrefix(options.get(JMX_PREFIX));
    }

    public static P6SpyLoadableOptions getActiveInstance() {
        return P6ModuleManager.getInstance().getOptions(P6SpyOptions.class);
    }

    @Override
    public void reload() {
        P6ModuleManager.getInstance().reload();
    }

    @Override
    public Set<P6Factory> getModuleFactories() {
        return this.optionsRepository.getSet(P6Factory.class, MODULE_FACTORIES);
    }

    @Override
    public void setAutoflush(String autoflush) {
        this.optionsRepository.set(Boolean.class, AUTOFLUSH, autoflush);
    }

    @Override
    public void setAutoflush(boolean autoflush) {
        this.optionsRepository.set(Boolean.class, AUTOFLUSH, autoflush);
    }

    @Override
    public boolean getAutoflush() {
        return this.optionsRepository.get(Boolean.class, AUTOFLUSH);
    }

    @Override
    public String getDriverlist() {
        return this.optionsRepository.get(String.class, DRIVERLIST);
    }

    @Override
    public void setDriverlist(String driverlist) {
        this.optionsRepository.setSet(String.class, DRIVER_NAMES, driverlist);
        this.optionsRepository.set(String.class, DRIVERLIST, P6Util.joinNullSafe(this.optionsRepository.getSet(String.class, DRIVER_NAMES), ","));
    }

    @Override
    public boolean getReloadProperties() {
        return this.optionsRepository.get(Boolean.class, RELOADPROPERTIES);
    }

    @Override
    public void setReloadProperties(String reloadproperties) {
        this.optionsRepository.set(Boolean.class, RELOADPROPERTIES, reloadproperties);
    }

    @Override
    public void setReloadProperties(boolean reloadproperties) {
        this.optionsRepository.set(Boolean.class, RELOADPROPERTIES, reloadproperties);
    }

    @Override
    public long getReloadPropertiesInterval() {
        return this.optionsRepository.get(Long.class, RELOADPROPERTIESINTERVAL);
    }

    @Override
    public void setReloadPropertiesInterval(String reloadpropertiesinterval) {
        this.optionsRepository.set(Long.class, RELOADPROPERTIESINTERVAL, reloadpropertiesinterval);
    }

    @Override
    public void setReloadPropertiesInterval(long reloadpropertiesinterval) {
        this.optionsRepository.set(Long.class, RELOADPROPERTIESINTERVAL, reloadpropertiesinterval);
    }

    @Override
    public void setJNDIContextFactory(String jndicontextfactory) {
        this.optionsRepository.set(String.class, JNDICONTEXTFACTORY, jndicontextfactory);
    }

    @Override
    public void unSetJNDIContextFactory() {
        this.optionsRepository.setOrUnSet(String.class, JNDICONTEXTFACTORY, null, defaults.get(JNDICONTEXTFACTORY));
    }

    @Override
    public String getJNDIContextFactory() {
        return this.optionsRepository.get(String.class, JNDICONTEXTFACTORY);
    }

    @Override
    public void unSetJNDIContextProviderURL() {
        this.optionsRepository.setOrUnSet(String.class, JNDICONTEXTPROVIDERURL, null, defaults.get(JNDICONTEXTPROVIDERURL));
    }

    @Override
    public void setJNDIContextProviderURL(String jndicontextproviderurl) {
        this.optionsRepository.set(String.class, JNDICONTEXTPROVIDERURL, jndicontextproviderurl);
    }

    @Override
    public String getJNDIContextProviderURL() {
        return this.optionsRepository.get(String.class, JNDICONTEXTPROVIDERURL);
    }

    @Override
    public void setJNDIContextCustom(String jndicontextcustom) {
        this.optionsRepository.set(String.class, JNDICONTEXTCUSTOM, jndicontextcustom);
    }

    @Override
    public void unSetJNDIContextCustom() {
        this.optionsRepository.setOrUnSet(String.class, JNDICONTEXTCUSTOM, null, defaults.get(JNDICONTEXTCUSTOM));
    }

    @Override
    public String getJNDIContextCustom() {
        return this.optionsRepository.get(String.class, JNDICONTEXTCUSTOM);
    }

    @Override
    public void setRealDataSource(String realdatasource) {
        this.optionsRepository.set(String.class, REALDATASOURCE, realdatasource);
    }

    @Override
    public void unSetRealDataSource() {
        this.optionsRepository.setOrUnSet(String.class, REALDATASOURCE, null, defaults.get(REALDATASOURCE));
    }

    @Override
    public String getRealDataSource() {
        return this.optionsRepository.get(String.class, REALDATASOURCE);
    }

    @Override
    public void setRealDataSourceClass(String realdatasourceclass) {
        this.optionsRepository.set(String.class, REALDATASOURCECLASS, realdatasourceclass);
    }

    @Override
    public void unSetRealDataSourceClass() {
        this.optionsRepository.setOrUnSet(String.class, REALDATASOURCECLASS, null, defaults.get(REALDATASOURCECLASS));
    }

    @Override
    public String getRealDataSourceClass() {
        return this.optionsRepository.get(String.class, REALDATASOURCECLASS);
    }

    @Override
    public void setRealDataSourceProperties(String realdatasourceproperties) {
        this.optionsRepository.set(String.class, REALDATASOURCEPROPERTIES, realdatasourceproperties);
    }

    @Override
    public void unSetRealDataSourceProperties() {
        this.optionsRepository.setOrUnSet(String.class, REALDATASOURCEPROPERTIES, null, defaults.get(REALDATASOURCEPROPERTIES));
    }

    @Override
    public String getRealDataSourceProperties() {
        return this.optionsRepository.get(String.class, REALDATASOURCEPROPERTIES);
    }

    @Override
    public Set<String> getDriverNames() {
        return this.optionsRepository.getSet(String.class, DRIVER_NAMES);
    }

    @Override
    public String getDatabaseDialectDateFormat() {
        return this.optionsRepository.get(String.class, DATABASE_DIALECT_DATE_FORMAT);
    }

    @Override
    public void setDatabaseDialectDateFormat(String databaseDialectDateFormat) {
        this.optionsRepository.set(String.class, DATABASE_DIALECT_DATE_FORMAT, databaseDialectDateFormat);
    }

    @Override
    public String getDatabaseDialectTimestampFormat() {
        return this.optionsRepository.get(String.class, DATABASE_DIALECT_TIMESTAMP_FORMAT);
    }

    @Override
    public void setDatabaseDialectTimestampFormat(String databaseDialectTimestampFormat) {
        this.optionsRepository.set(String.class, DATABASE_DIALECT_TIMESTAMP_FORMAT, databaseDialectTimestampFormat);
    }

    @Override
    public String getDatabaseDialectBooleanFormat() {
        return this.optionsRepository.get(String.class, DATABASE_DIALECT_BOOLEAN_FORMAT);
    }

    @Override
    public void setDatabaseDialectBooleanFormat(String databaseDialectBooleanFormat) {
        this.optionsRepository.set(String.class, DATABASE_DIALECT_BOOLEAN_FORMAT, databaseDialectBooleanFormat);
    }

    @Override
    public String getCustomLogMessageFormat() {
        return this.optionsRepository.get(String.class, CUSTOM_LOG_MESSAGE_FORMAT);
    }

    @Override
    public void setCustomLogMessageFormat(String customLogMessageFormat) {
        this.optionsRepository.set(String.class, CUSTOM_LOG_MESSAGE_FORMAT, customLogMessageFormat);
    }

    @Override
    public String getModulelist() {
        return this.optionsRepository.get(String.class, MODULELIST);
    }

    @Override
    public void setModulelist(String modulelist) {
        this.optionsRepository.setSet(String.class, MODULE_NAMES, modulelist);
        this.optionsRepository.set(String.class, MODULELIST, P6Util.joinNullSafe(this.optionsRepository.getSet(String.class, MODULE_NAMES), ","));
        this.optionsRepository.setSet(P6Factory.class, MODULE_FACTORIES, modulelist);
    }

    @Override
    public Set<String> getModuleNames() {
        return this.optionsRepository.getSet(String.class, MODULE_NAMES);
    }

    @Override
    public void setAppend(boolean append) {
        this.optionsRepository.set(Boolean.class, APPEND, append);
    }

    @Override
    public boolean getAppend() {
        return this.optionsRepository.get(Boolean.class, APPEND);
    }

    @Override
    public String getAppender() {
        return this.optionsRepository.get(String.class, APPENDER);
    }

    @Override
    public P6Logger getAppenderInstance() {
        return this.optionsRepository.get(P6Logger.class, APPENDER_INSTANCE);
    }

    @Override
    public void setAppender(String className) {
        this.optionsRepository.set(String.class, APPENDER, className);
        this.optionsRepository.set(P6Logger.class, APPENDER_INSTANCE, className);
    }

    @Override
    public void setDateformat(String dateformat) {
        this.optionsRepository.set(String.class, DATEFORMAT, dateformat);
    }

    @Override
    public String getDateformat() {
        return this.optionsRepository.get(String.class, DATEFORMAT);
    }

    @Override
    public boolean getStackTrace() {
        return this.optionsRepository.get(Boolean.class, STACKTRACE);
    }

    @Override
    public void setStackTrace(boolean stacktrace) {
        this.optionsRepository.set(Boolean.class, STACKTRACE, stacktrace);
    }

    @Override
    public void setStackTrace(String stacktrace) {
        this.optionsRepository.set(Boolean.class, STACKTRACE, stacktrace);
    }

    @Override
    public String getStackTraceClass() {
        return this.optionsRepository.get(String.class, STACKTRACECLASS);
    }

    @Override
    public void setStackTraceClass(String stacktraceclass) {
        this.optionsRepository.set(String.class, STACKTRACECLASS, stacktraceclass);
    }

    @Override
    public void setLogfile(String logfile) {
        this.optionsRepository.set(String.class, LOGFILE, logfile);
    }

    @Override
    public String getLogfile() {
        return this.optionsRepository.get(String.class, LOGFILE);
    }

    @Override
    public void setAppend(String append) {
        this.optionsRepository.set(Boolean.class, APPEND, append);
    }

    @Override
    public String getLogMessageFormat() {
        return this.optionsRepository.get(String.class, LOG_MESSAGE_FORMAT);
    }

    @Override
    public void setLogMessageFormat(String logMessageFormat) {
        this.optionsRepository.set(String.class, LOG_MESSAGE_FORMAT, logMessageFormat);
        this.optionsRepository.set(MessageFormattingStrategy.class, LOG_MESSAGE_FORMAT_INSTANCE, logMessageFormat);
    }

    @Override
    public MessageFormattingStrategy getLogMessageFormatInstance() {
        return this.optionsRepository.get(MessageFormattingStrategy.class, LOG_MESSAGE_FORMAT_INSTANCE);
    }

    @Override
    public Map<String, String> getDefaults() {
        return defaults;
    }

    @Override
    public boolean getJmx() {
        return this.optionsRepository.get(Boolean.class, JMX);
    }

    @Override
    public void setJmx(String string) {
        this.optionsRepository.set(Boolean.class, JMX, string);
    }

    @Override
    public void setJmx(boolean string) {
        this.optionsRepository.set(Boolean.class, JMX, string);
    }

    @Override
    public String getJmxPrefix() {
        return this.optionsRepository.get(String.class, JMX_PREFIX);
    }

    @Override
    public void setJmxPrefix(String jmxPrefix) {
        this.optionsRepository.set(String.class, JMX_PREFIX, jmxPrefix);
    }

    static {
        defaults.put(LOG_MESSAGE_FORMAT, SingleLineFormat.class.getName());
        defaults.put(LOGFILE, "spy.log");
        defaults.put(APPEND, Boolean.TRUE.toString());
        defaults.put(APPENDER, FileLogger.class.getName());
        defaults.put(MODULELIST, P6SpyFactory.class.getName() + "," + P6LogFactory.class.getName());
        defaults.put(STACKTRACE, Boolean.FALSE.toString());
        defaults.put(AUTOFLUSH, Boolean.FALSE.toString());
        defaults.put(RELOADPROPERTIES, Boolean.FALSE.toString());
        defaults.put(RELOADPROPERTIESINTERVAL, Long.toString(60L));
        defaults.put(DATABASE_DIALECT_DATE_FORMAT, "yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        defaults.put(DATABASE_DIALECT_TIMESTAMP_FORMAT, "yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        defaults.put(DATABASE_DIALECT_BOOLEAN_FORMAT, "boolean");
        defaults.put(CUSTOM_LOG_MESSAGE_FORMAT, String.format("%s|%s|%s|connection%s|%s", "%(currentTime)", "%(executionTime)", "%(category)", "%(connectionId)", "%(sqlSingleLine)"));
        defaults.put(JMX, Boolean.TRUE.toString());
    }
}

