/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import java.lang.reflect.Method;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Library;
import org.zkoss.zk.ui.UiException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MiscUtil {
    public static String toSimpleMethodSignature(Method method) {
        StringBuilder sb = new StringBuilder();
        sb.append(method.getName() + "(");
        Class<?>[] params = method.getParameterTypes();
        for (int j = 0; j < params.length; ++j) {
            sb.append(MiscUtil.getTypeName(params[j]));
            if (j >= params.length - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    static String getTypeName(Class type) {
        if (type.isArray()) {
            try {
                Class<?> cl = type;
                int dimensions = 0;
                while (cl.isArray()) {
                    ++dimensions;
                    cl = cl.getComponentType();
                }
                StringBuilder sb = new StringBuilder();
                sb.append(cl.getName());
                for (int i = 0; i < dimensions; ++i) {
                    sb.append("[]");
                }
                return sb.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return type.getName();
    }

    public static <T> T newInstanceFromProperty(String key, String def, Class<T> type) {
        String clz = Library.getProperty((String)key, (String)def);
        if (clz != null) {
            Object v;
            try {
                v = Classes.newInstanceByThread((String)clz);
            }
            catch (Exception ex) {
                throw UiException.Aide.wrap((Throwable)ex);
            }
            if (!type.isAssignableFrom(v.getClass())) {
                throw new UiException(type + " must be implemented by " + v);
            }
            return (T)v;
        }
        return null;
    }
}

