/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.converter;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.ParseException;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Converter;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;

public class FormatedNumberConverter
implements Converter,
Serializable {
    private static final long serialVersionUID = 1463169907348730644L;

    public Object coerceToUi(Object val, Component comp, BindContext ctx) {
        String format = (String)ctx.getConverterArg("format");
        if (format == null) {
            throw new NullPointerException("format attribute not found");
        }
        Number number = (Number)val;
        return number == null ? null : new DecimalFormat(format).format(number);
    }

    public Object coerceToBean(Object val, Component comp, BindContext ctx) {
        String format = (String)ctx.getConverterArg("format");
        if (format == null) {
            throw new NullPointerException("format attribute not found");
        }
        String number = (String)val;
        try {
            return number == null ? (Number)null : (Number)new DecimalFormat(format).parse(number);
        }
        catch (ParseException e) {
            throw UiException.Aide.wrap((Throwable)e);
        }
    }
}

