/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.html;

import java.util.HashSet;
import java.util.Set;
import org.zkoss.xml.XMLs;

public class HTMLs {
    private static final Set<String> _txtstyles;
    private static final Set<String> _orphans;

    public static final void appendAttribute(StringBuffer sb, String name, String val) {
        if (val != null && val.length() != 0) {
            sb.append(' ').append(name).append("=\"").append(XMLs.encodeAttribute(val)).append('\"');
        }
    }

    public static final void appendAttribute(StringBuffer sb, String name, String val, boolean emptyIgnored) {
        if (!emptyIgnored || val != null && val.length() != 0) {
            sb.append(' ').append(name).append("=\"").append(val != null ? XMLs.encodeAttribute(val) : null).append('\"');
        }
    }

    public static final void appendAttribute(StringBuffer sb, String name, int val) {
        sb.append(' ').append(name).append("=\"").append(val).append('\"');
    }

    public static final void appendAttribute(StringBuffer sb, String name, long val) {
        sb.append(' ').append(name).append("=\"").append(val).append('\"');
    }

    public static final void appendAttribute(StringBuffer sb, String name, double val) {
        sb.append(' ').append(name).append("=\"").append(val).append('\"');
    }

    public static final void appendAttribute(StringBuffer sb, String name, short val) {
        sb.append(' ').append(name).append("=\"").append(val).append('\"');
    }

    public static final void appendAttribute(StringBuffer sb, String name, boolean val) {
        sb.append(' ').append(name).append("=\"").append(val).append('\"');
    }

    public static final void appendStyle(StringBuffer sb, String name, String val) {
        if (val != null && val.length() != 0) {
            sb.append(name).append(':').append(val).append(';');
        }
    }

    public static final int getSubstyleIndex(String style, String substyle) {
        if (style == null || substyle == null) {
            throw new IllegalArgumentException("null");
        }
        if (substyle.length() == 0) {
            throw new IllegalArgumentException("empty substyle");
        }
        int j = 0;
        int len = style.length();
        while (true) {
            String nm;
            int l;
            int k = -1;
            for (l = j; l < len; ++l) {
                char cc = style.charAt(l);
                if (k < 0 && cc == ':') {
                    k = l;
                    continue;
                }
                if (cc == ';') break;
            }
            if ((nm = (k >= 0 ? style.substring(j, k) : style.substring(j, l)).trim()).equals(substyle)) {
                return j;
            }
            if (l >= len) {
                return -1;
            }
            j = l + 1;
        }
    }

    public static final String getSubstyleValue(String style, int j) {
        int l;
        int len = style.length();
        int k = -1;
        for (l = j; l < len; ++l) {
            char cc = style.charAt(l);
            if (k < 0 && cc == ':') {
                k = l;
                continue;
            }
            if (cc == ';') break;
        }
        return k < 0 ? "" : style.substring(k + 1, l).trim();
    }

    public static final String getTextRelevantStyle(String style) {
        if (style == null) {
            return null;
        }
        if (style.length() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(64);
        int j = 0;
        int len = style.length();
        while (true) {
            String nm;
            int l;
            int k = -1;
            for (l = j; l < len; ++l) {
                char cc = style.charAt(l);
                if (k < 0 && cc == ':') {
                    k = l;
                    continue;
                }
                if (cc == ';') break;
            }
            if ((nm = (k >= 0 ? style.substring(j, k) : style.substring(j, l)).trim()).startsWith("font") || nm.startsWith("text") || _txtstyles.contains(nm)) {
                sb.append(l < len ? style.substring(j, l + 1) : style.substring(j));
            }
            if (l >= len) {
                return sb.toString();
            }
            j = l + 1;
        }
    }

    public static final boolean isOrphanTag(String tagname) {
        return _orphans.contains(tagname.toLowerCase());
    }

    static {
        String[] txts = new String[]{"color", "background-color", "background", "white-space"};
        _txtstyles = new HashSet<String>();
        int j = txts.length;
        while (--j >= 0) {
            _txtstyles.add(txts[j]);
        }
        _orphans = new HashSet<String>(29);
        String[] orphans = new String[]{"area", "base", "basefont", "bgsound", "br", "col", "embed", "hr", "img", "input", "isindex", "keygen", "link", "meta", "plaintext", "spacer", "wbr"};
        j = orphans.length;
        while (--j >= 0) {
            _orphans.add(orphans[j]);
        }
    }
}

