/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PrimitiveListAttributeDefinition;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public final class StringListAttributeDefinition
extends PrimitiveListAttributeDefinition {
    private StringListAttributeDefinition(Builder builder) {
        super(builder, ModelType.STRING);
    }

    public List<String> unwrap(ExpressionResolver context, ModelNode model) throws OperationFailedException {
        ModelNode value = this.resolveModelAttribute(context, model);
        if (value.isDefined()) {
            return StringListAttributeDefinition.unwrapValue(context, value);
        }
        return Collections.emptyList();
    }

    public static List<String> unwrapValue(ExpressionResolver context, ModelNode model) throws OperationFailedException {
        if (!model.isDefined()) {
            return Collections.emptyList();
        }
        LinkedList<String> result = new LinkedList<String>();
        for (ModelNode p : model.asList()) {
            result.add(context.resolveExpressions(p).asString());
        }
        return result;
    }

    @Override
    public void addCapabilityRequirements(OperationContext context, Resource resource, ModelNode attributeValue) {
        this.handleCapabilityRequirements(context, resource, attributeValue, false);
    }

    @Override
    public void removeCapabilityRequirements(OperationContext context, Resource resource, ModelNode attributeValue) {
        this.handleCapabilityRequirements(context, resource, attributeValue, true);
    }

    private void handleCapabilityRequirements(OperationContext context, Resource resource, ModelNode attributeValue, boolean remove) {
        if (this.referenceRecorder != null && attributeValue.isDefined()) {
            List valueList = attributeValue.asList();
            String[] attributeValues = new String[valueList.size()];
            int position = 0;
            for (ModelNode current : valueList) {
                if (!current.isDefined() || current.getType().equals((Object)ModelType.EXPRESSION)) {
                    return;
                }
                attributeValues[position++] = current.asString();
            }
            if (remove) {
                this.referenceRecorder.removeCapabilityRequirements(context, resource, this.getName(), attributeValues);
            } else {
                this.referenceRecorder.addCapabilityRequirements(context, resource, this.getName(), attributeValues);
            }
        }
    }

    public static class Builder
    extends ListAttributeDefinition.Builder<Builder, StringListAttributeDefinition> {
        public static final Builder of(String name) {
            return new Builder(name);
        }

        public Builder(String name) {
            super(name);
            this.parser = AttributeParser.STRING_LIST;
            this.attributeMarshaller = AttributeMarshaller.STRING_LIST;
            this.setElementValidator(new ModelTypeValidator(ModelType.STRING));
        }

        public Builder(StringListAttributeDefinition basic) {
            super(basic);
            this.parser = AttributeParser.STRING_LIST;
            this.attributeMarshaller = AttributeMarshaller.STRING_LIST;
        }

        @Override
        public StringListAttributeDefinition build() {
            return new StringListAttributeDefinition(this);
        }
    }
}

