/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.threadpool;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.voovan.tools.TEnv;
import org.voovan.tools.TProperties;
import org.voovan.tools.threadpool.DefaultThreadFactory;
import org.voovan.tools.threadpool.ThreadPoolTask;

public class ThreadPool {
    private static int cpuCoreCount;
    protected static int MIN_POOL_SIZE;
    protected static int MAX_POOL_SIZE;
    protected static int STATUS_INTERVAL;
    protected static int minPoolTimes;
    protected static int maxPoolTimes;
    protected static ConcurrentHashMap<String, ThreadPoolExecutor> THREAD_POOL_HANDLER;

    public static int getMinPoolSize() {
        MIN_POOL_SIZE = (minPoolTimes == 0 ? 1 : minPoolTimes) * cpuCoreCount;
        MIN_POOL_SIZE = MIN_POOL_SIZE < 8 ? 8 : MIN_POOL_SIZE;
        return MIN_POOL_SIZE;
    }

    public static int getMaxPoolSize() {
        if (minPoolTimes > maxPoolTimes) {
            maxPoolTimes = minPoolTimes;
        }
        MAX_POOL_SIZE = (maxPoolTimes == 0 ? 1 : maxPoolTimes) * cpuCoreCount;
        MAX_POOL_SIZE = MAX_POOL_SIZE < 8 ? 8 : MAX_POOL_SIZE;
        return MAX_POOL_SIZE;
    }

    public static int getStatusInterval() {
        STATUS_INTERVAL = TProperties.getInt("framework", "ThreadPoolStatusInterval");
        return STATUS_INTERVAL;
    }

    private ThreadPool() {
    }

    private static ThreadPoolExecutor createThreadPool(String poolName) {
        System.out.println("[THREAD_POOL] Min size: " + minPoolTimes + "/" + MIN_POOL_SIZE);
        System.out.println("[THREAD_POOL] Max size: " + maxPoolTimes + "/" + MAX_POOL_SIZE);
        ThreadPoolExecutor threadPoolInstance = ThreadPool.createThreadPool(poolName, MIN_POOL_SIZE, MAX_POOL_SIZE, 60000);
        if (STATUS_INTERVAL > 0) {
            Timer timer = new Timer("VOOVAN@THREAD_POOL_TIMER", true);
            ThreadPoolTask threadPoolTask = new ThreadPoolTask(threadPoolInstance);
            timer.schedule((TimerTask)threadPoolTask, 1L, 1000L);
        }
        return threadPoolInstance;
    }

    public static ThreadPoolExecutor createThreadPool(String poolName, int mimPoolSize, int maxPoolSize, int threadTimeout) {
        return ThreadPool.createThreadPool(poolName, mimPoolSize, maxPoolSize, threadTimeout, true, 5);
    }

    public static ThreadPoolExecutor createThreadPool(String poolName, int mimPoolSize, int maxPoolSize, int threadTimeout, boolean daemon, int priority) {
        ThreadPoolExecutor threadPoolInstance = THREAD_POOL_HANDLER.get(poolName);
        if (threadPoolInstance == null) {
            threadPoolInstance = new ThreadPoolExecutor(mimPoolSize, maxPoolSize, (long)threadTimeout, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(cpuCoreCount * 2000), new DefaultThreadFactory(poolName, daemon, priority));
            threadPoolInstance.allowCoreThreadTimeOut(true);
            THREAD_POOL_HANDLER.put(poolName, threadPoolInstance);
            ThreadPoolExecutor finalThreadPoolInstance = threadPoolInstance;
            TEnv.addShutDownHook(() -> {
                finalThreadPoolInstance.shutdown();
                return true;
            });
        }
        return threadPoolInstance;
    }

    public static ThreadPoolExecutor getNewThreadPool(String name) {
        return ThreadPool.createThreadPool(name);
    }

    static {
        MIN_POOL_SIZE = cpuCoreCount = Runtime.getRuntime().availableProcessors();
        MAX_POOL_SIZE = cpuCoreCount;
        STATUS_INTERVAL = 5000;
        minPoolTimes = TProperties.getInt("framework", "ThreadPoolMinSize");
        maxPoolTimes = TProperties.getInt("framework", "ThreadPoolMaxSize");
        THREAD_POOL_HANDLER = new ConcurrentHashMap();
        ThreadPool.getMinPoolSize();
        ThreadPool.getMaxPoolSize();
        ThreadPool.getStatusInterval();
    }
}

