/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.serialize;

import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.voovan.tools.TProperties;
import org.voovan.tools.log.Logger;
import org.voovan.tools.reflect.TReflect;
import org.voovan.tools.serialize.Serialize;

public class TSerialize {
    public static Serialize SERIALIZE;
    static ConcurrentHashMap<Class, String> CLASS_AND_SIMPLE_NAME;
    static ConcurrentHashMap<String, Class> SIMPLE_NAME_AND_CLASS;
    static ConcurrentHashMap<Class, Function<?, ?>> CLASS_SERIALIZE_METHOD;
    static ConcurrentHashMap<Class, Function<?, ?>> CLASS_UNSERIALIZE_METHOD;

    public static byte[] serialize(Object object) {
        return object == null ? null : SERIALIZE.serialize(object);
    }

    public static Object unserialize(byte[] bytes) {
        return bytes == null ? null : SERIALIZE.unserialize(bytes);
    }

    public static void registerClassWithSimpleName(String simpleName, Class clazz) {
        if (SIMPLE_NAME_AND_CLASS.contains(simpleName)) {
            throw new RuntimeException("simple name is exists");
        }
        CLASS_AND_SIMPLE_NAME.put(clazz, simpleName);
        SIMPLE_NAME_AND_CLASS.put(simpleName, clazz);
    }

    protected static String getSimpleNameByClass(Class clazz) {
        String className = CLASS_AND_SIMPLE_NAME.get(clazz);
        if (className == null) {
            className = TReflect.getClassName(clazz);
        }
        return className;
    }

    protected static Class getClassBySimpleName(String className) throws ClassNotFoundException {
        Class clazz = SIMPLE_NAME_AND_CLASS.get(className);
        if (clazz == null) {
            clazz = TReflect.getClassByName(className);
        }
        return clazz;
    }

    static {
        String serializeType = TProperties.getString("framework", "SerializeType").trim();
        if ("JSON".equalsIgnoreCase(serializeType.trim())) {
            serializeType = "org.voovan.tools.serialize.DefaultJSONSerialize";
        } else if ("JDK".equalsIgnoreCase(serializeType.trim())) {
            serializeType = "org.voovan.tools.serialize.DefaultJDKSerialize";
        } else if ("ProtoStuff".equalsIgnoreCase(serializeType.trim())) {
            serializeType = "org.voovan.tools.serialize.ProtoStuffSerialize";
        } else if (serializeType == null) {
            serializeType = "org.voovan.tools.serialize.DefaultJDKSerialize";
        }
        try {
            Class<?> serializeClazz = Class.forName(serializeType);
            TReflect.isImpByInterface(serializeClazz, Serialize.class);
            SERIALIZE = (Serialize)TReflect.newInstance(serializeClazz, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
        Logger.simple("[SYSTEM] serialize type: " + serializeType);
        CLASS_AND_SIMPLE_NAME = new ConcurrentHashMap();
        SIMPLE_NAME_AND_CLASS = new ConcurrentHashMap();
        CLASS_SERIALIZE_METHOD = new ConcurrentHashMap();
        CLASS_UNSERIALIZE_METHOD = new ConcurrentHashMap();
        CLASS_AND_SIMPLE_NAME.put(Integer.TYPE, "0");
        CLASS_AND_SIMPLE_NAME.put(Integer.class, "0");
        CLASS_AND_SIMPLE_NAME.put(Byte.TYPE, "1");
        CLASS_AND_SIMPLE_NAME.put(Byte.class, "1");
        CLASS_AND_SIMPLE_NAME.put(Short.TYPE, "2");
        CLASS_AND_SIMPLE_NAME.put(Short.class, "2");
        CLASS_AND_SIMPLE_NAME.put(Long.TYPE, "3");
        CLASS_AND_SIMPLE_NAME.put(Long.class, "3");
        CLASS_AND_SIMPLE_NAME.put(Float.TYPE, "4");
        CLASS_AND_SIMPLE_NAME.put(Float.class, "4");
        CLASS_AND_SIMPLE_NAME.put(Double.TYPE, "5");
        CLASS_AND_SIMPLE_NAME.put(Double.class, "5");
        CLASS_AND_SIMPLE_NAME.put(Character.TYPE, "6");
        CLASS_AND_SIMPLE_NAME.put(Character.class, "6");
        CLASS_AND_SIMPLE_NAME.put(Boolean.TYPE, "7");
        CLASS_AND_SIMPLE_NAME.put(Boolean.class, "7");
        CLASS_AND_SIMPLE_NAME.put(String.class, "8");
        CLASS_AND_SIMPLE_NAME.put(byte[].class, "9");
        SIMPLE_NAME_AND_CLASS.put("0", Integer.TYPE);
        SIMPLE_NAME_AND_CLASS.put("0", Integer.class);
        SIMPLE_NAME_AND_CLASS.put("1", Byte.TYPE);
        SIMPLE_NAME_AND_CLASS.put("1", Byte.class);
        SIMPLE_NAME_AND_CLASS.put("2", Short.TYPE);
        SIMPLE_NAME_AND_CLASS.put("2", Short.class);
        SIMPLE_NAME_AND_CLASS.put("3", Long.TYPE);
        SIMPLE_NAME_AND_CLASS.put("3", Long.class);
        SIMPLE_NAME_AND_CLASS.put("4", Float.TYPE);
        SIMPLE_NAME_AND_CLASS.put("4", Float.class);
        SIMPLE_NAME_AND_CLASS.put("5", Double.TYPE);
        SIMPLE_NAME_AND_CLASS.put("5", Double.class);
        SIMPLE_NAME_AND_CLASS.put("6", Character.TYPE);
        SIMPLE_NAME_AND_CLASS.put("6", Character.class);
        SIMPLE_NAME_AND_CLASS.put("7", Boolean.TYPE);
        SIMPLE_NAME_AND_CLASS.put("7", Boolean.class);
        SIMPLE_NAME_AND_CLASS.put("8", String.class);
        SIMPLE_NAME_AND_CLASS.put("9", byte[].class);
    }
}

