/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.serialize;

import io.protostuff.LinkedBuffer;
import io.protostuff.ProtostuffIOUtil;
import io.protostuff.Schema;
import io.protostuff.runtime.RuntimeSchema;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.voovan.tools.TByte;
import org.voovan.tools.collection.ObjectThreadPool;
import org.voovan.tools.reflect.TReflect;
import org.voovan.tools.serialize.Serialize;
import org.voovan.tools.serialize.TSerialize;

public class ProtoStuffSerialize
implements Serialize {
    ObjectThreadPool<LinkedBuffer> objectThreadPool = new ObjectThreadPool(128);
    Map<Class, Schema> SCHEMAS = new ConcurrentHashMap<Class, Schema>();

    public Schema getSchema(Class clazz) {
        Schema schema = this.SCHEMAS.get(clazz);
        if (schema == null) {
            schema = RuntimeSchema.getSchema((Class)clazz);
        }
        return schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] serialize(Object obj) {
        byte[] buf = null;
        buf = TByte.toBytes(obj);
        if (buf == null) {
            Schema schema = this.getSchema(obj.getClass());
            LinkedBuffer buffer = this.objectThreadPool.get(() -> LinkedBuffer.allocate((int)512));
            try {
                buf = ProtostuffIOUtil.toByteArray((Object)obj, (Schema)schema, (LinkedBuffer)buffer);
            }
            finally {
                buffer.clear();
            }
        }
        byte[] type = (TSerialize.getSimpleNameByClass(obj.getClass()) + "\u0000").getBytes();
        buf = TByte.byteArrayConcat(type, type.length, buf, buf.length);
        return buf;
    }

    @Override
    public <T> T unserialize(byte[] bytes) {
        byte[] type = new byte[512];
        int index = 0;
        for (index = 0; index < type.length && bytes[index] != 0; ++index) {
            type[index] = bytes[index];
        }
        try {
            String className = new String(type, 0, index, Charset.defaultCharset());
            Class innerClazz = TSerialize.getClassBySimpleName(className);
            byte[] valueBytes = Arrays.copyOfRange(bytes, index + 1, bytes.length);
            Object obj = TByte.toObject(valueBytes, innerClazz);
            if (obj == null) {
                Schema schema = this.getSchema(innerClazz);
                obj = TReflect.newInstance(innerClazz, new Object[0]);
                ProtostuffIOUtil.mergeFrom((byte[])valueBytes, (int)0, (int)valueBytes.length, (Object)obj, (Schema)schema);
            }
            return (T)obj;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

