/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.serialize;

import java.util.List;
import java.util.Map;
import org.voovan.tools.TObject;
import org.voovan.tools.json.JSON;
import org.voovan.tools.json.JSONPath;
import org.voovan.tools.log.Logger;
import org.voovan.tools.reflect.TReflect;
import org.voovan.tools.serialize.Serialize;
import org.voovan.tools.serialize.TSerialize;

public class DefaultJSONSerialize
implements Serialize {
    @Override
    public byte[] serialize(Object obj) {
        try {
            Class<?> clazz = obj.getClass();
            Class[] genericClazzs = TReflect.getGenericClass(obj);
            return JSON.toJSON(TObject.asMap("T", TSerialize.getSimpleNameByClass(clazz), "G", genericClazzs, "V", obj)).getBytes();
        }
        catch (Exception e) {
            Logger.error("TSerialize.serializeJDK error: ", e);
            return null;
        }
    }

    @Override
    public <T> T unserialize(byte[] bytes) {
        try {
            Class mainClazz = null;
            JSONPath jsonPath = new JSONPath(new String(bytes));
            mainClazz = TSerialize.getClassBySimpleName(jsonPath.value("/T", String.class));
            List<String> genericClazzStrs = jsonPath.listObject("/G", String.class);
            Class[] genericClazzs = new Class[genericClazzStrs.size()];
            for (int i = 0; i < genericClazzStrs.size(); ++i) {
                genericClazzs[i] = TSerialize.getClassBySimpleName(genericClazzStrs.get(i));
            }
            Class[] classArray = genericClazzs = genericClazzs.length == 0 ? null : genericClazzs;
            if (mainClazz == null || TReflect.isSystemType(mainClazz)) {
                return (T)jsonPath.value("/V", genericClazzs);
            }
            Object obj = TReflect.getObjectFromMap(mainClazz, (Map)jsonPath.mapObject("/V", genericClazzs), true);
            return obj;
        }
        catch (Exception e) {
            Logger.error("TSerialize.serializeJDK error: ", e);
            return null;
        }
    }
}

