/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.log;

import org.voovan.tools.TEnv;
import org.voovan.tools.TFile;
import org.voovan.tools.TObject;
import org.voovan.tools.TString;
import org.voovan.tools.log.Formater;
import org.voovan.tools.log.Message;

public class Logger {
    private static Formater formater = Formater.newInstance();
    private static boolean enable = true;

    public static boolean isEnable() {
        return enable;
    }

    public static void setEnable(boolean enable) {
        Logger.enable = enable;
    }

    public static void stopLoggerThread() {
    }

    public static boolean isLogLevel(String logLevel) {
        if (formater.getLogLevel().contains("ALL")) {
            return true;
        }
        return formater.getLogLevel().contains(logLevel);
    }

    public static void custom(String logLevel, Object msg, Throwable e) {
        if (!Logger.isEnable()) {
            return;
        }
        try {
            msg = Logger.buildMessage(msg, e);
            Message message = Message.newInstance(logLevel, msg.toString());
            formater.writeFormatedLog(message);
        }
        catch (Exception oe) {
            Logger.simple("Logger system error:" + oe.getMessage() + "\r\n");
            Logger.simple(TEnv.getStackElementsMessage(oe.getStackTrace()));
            Logger.simple("Output message is: " + msg);
        }
    }

    public static void custom(String logLevel, Object msg) {
        Logger.custom(logLevel, msg, null);
    }

    public static void custom(String logLevel, Exception e) {
        Logger.custom(logLevel, null, e);
    }

    public static void customf(String logLevel, String msg, Throwable e, Object ... args) {
        if (!Logger.isEnable()) {
            return;
        }
        Logger.custom(logLevel, TString.tokenReplace(msg, args), e);
    }

    public static void customf(String logLevel, String msg, Object ... args) {
        Logger.customf(logLevel, msg, args, null);
    }

    public static void info(Object msg) {
        Logger.custom("INFO", msg);
    }

    public static void infof(String msg, Object ... args) {
        Logger.customf("INFO", msg, args);
    }

    public static void fremawork(Object msg) {
        Logger.custom("FRAMEWORK", msg);
    }

    public static void fremaworkf(String msg, Object ... args) {
        Logger.customf("FRAMEWORK", msg, args);
    }

    public static void sql(Object msg) {
        Logger.custom("SQL", msg);
    }

    public static void sqlf(String msg, Object ... args) {
        Logger.customf("SQL", msg, args);
    }

    public static void debug(Object msg) {
        Logger.custom("DEBUG", msg);
    }

    public static void debugf(String msg, Object ... args) {
        Logger.customf("DEBUG", msg, args);
    }

    public static void warn(Object msg) {
        Logger.custom("WARN", msg);
    }

    public static void warnf(String msg, Object ... args) {
        Logger.customf("WARN", msg, args);
    }

    public static void warn(Exception e) {
        Logger.custom("WARN", null, e);
    }

    public static void warn(Object msg, Throwable e) {
        Logger.custom("WARN", msg, e);
    }

    public static void warnf(String msg, Throwable e, Object ... args) {
        Logger.customf("WARN", msg, e, args);
    }

    public static void error(Object msg) {
        Logger.custom("ERROR", msg);
    }

    public static void errorf(String msg, Object ... args) {
        Logger.customf("ERROR", msg, args);
    }

    public static void error(Exception e) {
        Logger.custom("ERROR", e);
    }

    public static void error(Object msg, Throwable e) {
        Logger.custom("ERROR", msg, e);
    }

    public static void errorf(String msg, Throwable e, Object ... args) {
        Logger.customf("ERROR", msg, e, args);
    }

    public static void fatal(Object msg) {
        Logger.custom("FATAL", msg);
    }

    public static void fatalf(String msg, Object ... args) {
        Logger.customf("FATAL", msg, args);
    }

    public static void fatal(Throwable e) {
        Logger.custom("FATAL", e);
    }

    public static void fatal(Object msg, Throwable e) {
        Logger.custom("FATAL", msg, e);
    }

    public static void fatalf(String msg, Throwable e, Object ... args) {
        Logger.customf("FATAL", msg, e, args);
    }

    public static void simple(Object msg) {
        Logger.custom("SIMPLE", msg);
    }

    public static void simplef(String msg, Object ... args) {
        Logger.customf("SIMPLE", msg, args);
    }

    private static String buildMessage(Object msg, Throwable exception) {
        msg = TObject.nullDefault(msg, "");
        String stackMessage = "";
        if (exception == null) {
            return msg.toString();
        }
        do {
            stackMessage = stackMessage + exception.getClass().getCanonicalName() + ": " + exception.getMessage() + TFile.getLineSeparator() + TString.indent(TEnv.getStackElementsMessage(exception.getStackTrace()), 8) + TFile.getLineSeparator();
        } while ((exception = exception.getCause()) != null);
        return (msg.toString().isEmpty() ? "" : msg + " => ") + stackMessage;
    }

    private static String buildMessage(Object msg) {
        return Logger.buildMessage(msg, null);
    }
}

