/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.json;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.voovan.tools.TObject;
import org.voovan.tools.TString;
import org.voovan.tools.json.JSON;
import org.voovan.tools.reflect.TReflect;

public class JSONPath {
    private Object parsedObj;

    public JSONPath(String jsonStr) {
        Object result = JSON.parse(jsonStr);
        if (result instanceof List) {
            this.parsedObj = (List)result;
        } else if (result instanceof Map) {
            this.parsedObj = (Map)result;
        }
    }

    public Object value(String pathQry) throws ReflectiveOperationException {
        Object currentPathObject = this.parsedObj;
        String[] pathElems = pathQry.split("/");
        ArrayList result = new ArrayList();
        for (String pathElem : pathElems) {
            if ((pathElem = pathElem.trim()).isEmpty()) continue;
            if (pathElem.indexOf("[") > -1 && pathElem.indexOf("]") > -1) {
                String[] pathElemSegms = pathElem.trim().split("\\[");
                for (int i = 0; i < pathElemSegms.length; ++i) {
                    String pathElemSegm = pathElemSegms[i];
                    if (pathElemSegm.isEmpty()) continue;
                    if (pathElemSegm.endsWith("]")) {
                        int index = Integer.parseInt(TString.removeSuffix(pathElemSegms[i]));
                        currentPathObject = ((List)currentPathObject).get(index);
                        continue;
                    }
                    currentPathObject = (List)((Map)currentPathObject).get(pathElemSegms[i]);
                }
                continue;
            }
            currentPathObject = ((Map)currentPathObject).get(pathElem);
        }
        return currentPathObject;
    }

    public Object value(String pathQry, Object defaultValue) throws ReflectiveOperationException {
        return TObject.nullDefault(this.value(pathQry), defaultValue);
    }

    public <T> T value(String pathQry, Class<T> clazz) throws ParseException, ReflectiveOperationException {
        Object value = this.value(pathQry);
        if (value == null) {
            return null;
        }
        if (TReflect.isSystemType(clazz)) {
            return (T)value;
        }
        Object obj = TReflect.getObjectFromMap(clazz, (Map)value, true);
        return obj;
    }

    public <T> T value(String pathQry, Class<T> clazz, T defaultValue) throws ParseException, ReflectiveOperationException {
        return TObject.nullDefault(this.value(pathQry, clazz), defaultValue);
    }

    public <T> T mapObject(String pathQry, Class[] genericType) throws ParseException, ReflectiveOperationException {
        ArrayList resultList = new ArrayList();
        Map mapValue = this.value(pathQry, Map.class);
        if (mapValue == null) {
            return null;
        }
        return TReflect.getObjectFromMap(Map.class, mapValue, genericType, false);
    }

    public <T> Object mapObject(String pathQry, Class[] genericType, T defaultValue) throws ParseException, ReflectiveOperationException {
        return TObject.nullDefault(this.mapObject(pathQry, genericType), defaultValue);
    }

    public <T> List<T> listObject(String pathQry, Class<T> elemClazz) throws ParseException, ReflectiveOperationException {
        ArrayList resultList = new ArrayList();
        List listObjects = this.value(pathQry, List.class, TObject.asList(new Object[0]));
        if (listObjects == null) {
            return null;
        }
        Map map = null;
        for (Object value : listObjects) {
            map = value instanceof Map ? (Map)value : TObject.asMap("", value);
            Object obj = TReflect.getObjectFromMap(elemClazz, map, true);
            resultList.add(obj);
        }
        return resultList;
    }

    public <T> List<T> listObject(String pathQry, Class<T> elemClazz, List<T> defaultValue) throws ParseException, ReflectiveOperationException {
        List<T> result = this.listObject(pathQry, elemClazz);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public <T> List<T> mapToListObject(String pathQry, String keyFieldName, Class<?> elemClazz) throws ParseException, ReflectiveOperationException {
        ArrayList resultList = new ArrayList();
        Map mapValue = this.value(pathQry, Map.class);
        if (mapValue == null) {
            return null;
        }
        Map map = null;
        for (Map.Entry entry : mapValue.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            map = value instanceof Map ? (Map)value : TObject.asMap("", value);
            map.put(keyFieldName, key);
            Object obj = TReflect.getObjectFromMap(elemClazz, map, true);
            resultList.add(obj);
        }
        return resultList;
    }

    public <T> List<T> mapToListObject(String pathQry, String keyFieldName, Class<?> elemClazz, List<T> defaultValue) throws ParseException, ReflectiveOperationException {
        List<T> result = this.mapToListObject(pathQry, keyFieldName, elemClazz);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public static JSONPath newInstance(String jsonStr) {
        return new JSONPath(jsonStr);
    }
}

