/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.json;

import java.lang.reflect.Type;
import java.text.ParseException;
import java.util.function.Supplier;
import org.voovan.tools.FastThreadLocal;
import org.voovan.tools.TProperties;
import org.voovan.tools.TString;
import org.voovan.tools.json.JSONDecode;
import org.voovan.tools.json.JSONEncode;
import org.voovan.tools.log.Logger;
import org.voovan.tools.reflect.TReflect;

public class JSON {
    public static final String JSON_CONVERT_ESCAPE_CHAR = TProperties.getString("framework", "JSONConvertEscapeChar");
    private static FastThreadLocal<Boolean> convertEscapeChar = FastThreadLocal.withInitial(new Supplier<Boolean>(){

        @Override
        public Boolean get() {
            boolean isEscapeChare = true;
            if ("true".equalsIgnoreCase(JSON_CONVERT_ESCAPE_CHAR.trim())) {
                isEscapeChare = true;
            }
            isEscapeChare = "false".equalsIgnoreCase(JSON_CONVERT_ESCAPE_CHAR.trim()) ? false : false;
            return isEscapeChare;
        }
    });

    public static boolean isConvertEscapeChar() {
        return convertEscapeChar.get();
    }

    public static void setConvertEscapeChar(boolean convertEscapeChar) {
        JSON.convertEscapeChar.set(convertEscapeChar);
    }

    public static String toJSON(Object object) {
        return JSON.toJSON(object, convertEscapeChar.get(), false);
    }

    public static String toJSON(Object object, boolean allField) {
        return JSON.toJSON(object, convertEscapeChar.get(), allField);
    }

    public static String toJSON(Object object, boolean convertEscapeChar, boolean allField) {
        String jsonString = null;
        try {
            boolean oldConvertEscapeChar = JSON.isConvertEscapeChar();
            JSON.setConvertEscapeChar(convertEscapeChar);
            jsonString = allField ? JSONEncode.fromObject(TReflect.getMapfromObject(object, allField), allField) : JSONEncode.fromObject(object, false);
            if (jsonString.startsWith("\"") && jsonString.endsWith("\"")) {
                jsonString = TString.removeSuffix(jsonString);
                jsonString = TString.removePrefix(jsonString);
            }
            JSON.setConvertEscapeChar(oldConvertEscapeChar);
        }
        catch (ReflectiveOperationException e) {
            Logger.error("Reflective Operation failed", e);
        }
        return jsonString;
    }

    public static <T> T toObject(String jsonStr, Type type, boolean ignoreCase) {
        T valueObject = null;
        try {
            valueObject = JSONDecode.fromJSON(jsonStr, type, ignoreCase);
        }
        catch (ReflectiveOperationException | ParseException e) {
            Logger.error("Reflective Operation failed", e);
        }
        return valueObject;
    }

    public static <T> T toObject(String jsonStr, Type type) {
        return JSON.toObject(jsonStr, type, false);
    }

    public static Object parse(String jsonStr) {
        Object parseObject = null;
        parseObject = JSONDecode.parse(jsonStr);
        return parseObject;
    }

    public static String formatJson(String jsonStr) {
        if (TString.isNullOrEmpty(jsonStr)) {
            return "";
        }
        StringBuilder jsongStrBuild = new StringBuilder();
        char prevChar = '\u0000';
        char current = '\u0000';
        int indent = 0;
        boolean inStr = false;
        for (int i = 0; i < jsonStr.length(); ++i) {
            prevChar = current;
            current = jsonStr.charAt(i);
            if (current == '\"' && prevChar != '\\') {
                boolean bl = inStr = !inStr;
            }
            if (inStr) {
                jsongStrBuild.append(current);
                continue;
            }
            if (current == '[' || current == '{') {
                jsongStrBuild.append(current);
                jsongStrBuild.append('\n');
                JSON.addIndentByNum(jsongStrBuild, ++indent);
                continue;
            }
            if (current == ']' || current == '}') {
                jsongStrBuild.append('\n');
                JSON.addIndentByNum(jsongStrBuild, --indent);
                jsongStrBuild.append(current);
                continue;
            }
            if (current == ',') {
                jsongStrBuild.append(current);
                jsongStrBuild.append('\n');
                JSON.addIndentByNum(jsongStrBuild, indent);
                continue;
            }
            jsongStrBuild.append(current);
        }
        return jsongStrBuild.toString();
    }

    private static void addIndentByNum(StringBuilder str, int indent) {
        for (int i = 0; i < indent; ++i) {
            str.append('\t');
        }
    }

    public static String removeNullNode(String jsonStr) {
        jsonStr = TString.fastReplaceAll(jsonStr, "\\\"\\w+?\\\":null", "");
        jsonStr = TString.fastReplaceAll(jsonStr, "null", "");
        return JSON.fixJSON(jsonStr);
    }

    protected static String fixJSON(String jsonStr) {
        while (TString.regexMatch(jsonStr, ",[\\s\\r\\n]*,") > 0) {
            jsonStr = TString.fastReplaceAll(jsonStr, ",[\\s\\r\\n]*,", ",");
        }
        jsonStr = TString.fastReplaceAll(jsonStr, "(?:[\\{])[\\s\\r\\n]*,", "{");
        jsonStr = TString.fastReplaceAll(jsonStr, "(?:[\\[])[\\s\\r\\n]*,", "[");
        jsonStr = TString.fastReplaceAll(jsonStr, ",[\\s\\r\\n]*(?:[\\}])", "}");
        jsonStr = TString.fastReplaceAll(jsonStr, ",[\\s\\r\\n]*(?:[\\]])", "]");
        return jsonStr;
    }

    public static boolean isJSONMap(String jsonStr) {
        return TString.regexMatch(jsonStr, "^\\s*\\{[\\s\\S]*\\}\\s*$") > 0;
    }

    public static boolean isJSONList(String jsonStr) {
        return TString.regexMatch(jsonStr, "^\\s*\\[[\\s\\S]*\\]\\s*$") > 0;
    }

    public static boolean isJSON(String jsonStr) {
        return JSON.isJSONMap(jsonStr) || JSON.isJSONList(jsonStr);
    }
}

