/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.hotswap;

import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.UnmodifiableClassException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.voovan.Global;
import org.voovan.tools.TEnv;
import org.voovan.tools.TObject;
import org.voovan.tools.hashwheeltimer.HashWheelTask;
import org.voovan.tools.log.Logger;

public class Hotswaper {
    private List<ClassFileInfo> classFileInfos;
    private List<String> excludePackages;
    private int reloadIntervals;
    private HashWheelTask reloadTask;

    public Hotswaper() throws IOException, AgentInitializationException, AgentLoadException, AttachNotSupportedException {
        this.init(null);
    }

    public Hotswaper(String agentJarPath) throws IOException, AttachNotSupportedException, AgentLoadException, AgentInitializationException {
        this.init(new File(agentJarPath));
    }

    private void init(File agentJar) throws AgentInitializationException, AgentLoadException, AttachNotSupportedException, IOException {
        this.reloadIntervals = 5;
        this.classFileInfos = new ArrayList<ClassFileInfo>();
        this.excludePackages = TObject.asList("java.", "sun.", "javax.", "com.sun", "com.oracle");
        TEnv.agentAttach(null);
        if (TEnv.instrumentation == null) {
            throw new AgentInitializationException("instrumentation is not inited");
        }
        this.loadCustomClass();
    }

    private void loadCustomClass() {
        for (Class clazz : TEnv.instrumentation.getAllLoadedClasses()) {
            if (this.isExcludeClass(clazz)) continue;
            ClassFileInfo classFileInfo = new ClassFileInfo(clazz, true);
            this.classFileInfos.add(classFileInfo);
        }
    }

    private boolean isExcludeClass(Class clazz) {
        try {
            String packageName = clazz.getPackage().getName();
            if (clazz.isPrimitive()) {
                return true;
            }
            if (clazz.isMemberClass()) {
                return true;
            }
            if (clazz.getProtectionDomain().getCodeSource() == null) {
                return true;
            }
            if (packageName == null) {
                return true;
            }
            for (String excludePackage : this.excludePackages) {
                if (!packageName.startsWith(excludePackage)) continue;
                return true;
            }
            for (ClassFileInfo classFileInfo : this.classFileInfos) {
                if (classFileInfo.getClazz() != clazz) continue;
                return true;
            }
            return false;
        }
        catch (Throwable e) {
            return true;
        }
    }

    private List<ClassFileInfo> fileWatcher() {
        this.loadCustomClass();
        ArrayList<ClassFileInfo> changedFiles = new ArrayList<ClassFileInfo>();
        for (ClassFileInfo classFileInfo : this.classFileInfos) {
            if (!classFileInfo.isChanged()) continue;
            changedFiles.add(classFileInfo);
        }
        return changedFiles;
    }

    public static void reloadClass(Map<Class, byte[]> clazzDefines) throws UnmodifiableClassException, ClassNotFoundException {
        ArrayList<ClassDefinition> classDefinitions = new ArrayList<ClassDefinition>();
        for (Map.Entry<Class, byte[]> clazzDefine : clazzDefines.entrySet()) {
            Class clazz = clazzDefine.getKey();
            byte[] classBytes = clazzDefine.getValue();
            ClassDefinition classDefinition = new ClassDefinition(clazz, classBytes);
            Logger.info("[HOTSWAP] class:" + clazz + " will reload.");
            classDefinitions.add(classDefinition);
        }
        TEnv.instrumentation.redefineClasses(classDefinitions.toArray(new ClassDefinition[0]));
    }

    public void reloadClass(List<ClassFileInfo> changedFiles) throws UnmodifiableClassException, ClassNotFoundException {
        HashMap<Class, byte[]> classDefines = new HashMap<Class, byte[]>();
        for (ClassFileInfo classFileInfo : changedFiles) {
            classDefines.put(classFileInfo.getClazz(), classFileInfo.getBytes());
        }
        Hotswaper.reloadClass(classDefines);
    }

    public int getReloadIntervals() {
        return this.reloadIntervals;
    }

    public void autoReload(int intervals) throws UnmodifiableClassException, ClassNotFoundException {
        this.reloadIntervals = intervals;
        this.cancelAutoReload();
        Logger.info("[HOTSWAP] Start auto reload and hotswap every " + intervals + " seconds");
        this.reloadTask = new HashWheelTask(){

            @Override
            public void run() {
                try {
                    List changedFiles = Hotswaper.this.fileWatcher();
                    Hotswaper.this.reloadClass(changedFiles);
                }
                catch (ClassNotFoundException | UnmodifiableClassException e) {
                    e.printStackTrace();
                }
            }
        };
        Global.getHashWheelTimer().addTask(this.reloadTask, intervals, true);
    }

    public void cancelAutoReload() {
        if (this.reloadTask != null) {
            this.reloadTask.cancel();
        }
    }

    public List<ClassFileInfo> getClassFileInfos() {
        return this.classFileInfos;
    }

    public void setClassFileInfos(List<ClassFileInfo> classFileInfos) {
        this.classFileInfos = classFileInfos;
    }

    public class ClassFileInfo {
        private Class clazz;
        private long lastModified;

        public ClassFileInfo(Class clazz, boolean isAutoChek) {
            this.clazz = clazz;
            if (isAutoChek) {
                this.lastModified = TEnv.getClassModifyTime(clazz);
            }
        }

        public boolean isChanged() {
            long currentModified = TEnv.getClassModifyTime(this.clazz);
            if (currentModified < 0L) {
                return false;
            }
            if (currentModified != this.lastModified) {
                this.lastModified = currentModified;
                return true;
            }
            return false;
        }

        public byte[] getBytes() {
            return TEnv.loadClassBytes(this.clazz);
        }

        public Class getClazz() {
            return this.clazz;
        }

        public void setClazz(Class clazz) {
            this.clazz = clazz;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public void setLastModified(long lastModified) {
            this.lastModified = lastModified;
        }

        public String toString() {
            return this.clazz.getCanonicalName();
        }

        public boolean equals(ClassFileInfo classFileInfo) {
            return classFileInfo.getClazz() == this.clazz;
        }
    }
}

