/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.hashwheeltimer;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.voovan.tools.collection.MultiMap;
import org.voovan.tools.hashwheeltimer.HashWheelTask;

public class HashWheel {
    private MultiMap<Integer, HashWheelTask> wheel;
    private int size = 0;
    private int currentSlot = 0;
    private ReentrantLock lock;

    public HashWheel(int size) {
        this.size = size;
        this.wheel = new MultiMap();
        this.lock = new ReentrantLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addTask(HashWheelTask task, int interval, boolean asynchronous) {
        this.lock.lock();
        try {
            if (interval <= 0) {
                boolean bl = false;
                return bl;
            }
            HashWheel innerHashWheel = this;
            int nextSlot = this.currentSlot + interval;
            int skipSlot = interval / this.size;
            int targetSlot = nextSlot % this.size;
            if (interval % this.size == 0 && skipSlot > 0 && task.getDoCount() != 0L) {
                --skipSlot;
            }
            this.wheel.putValue(targetSlot, task);
            task.init(skipSlot, interval, asynchronous, innerHashWheel, targetSlot);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean addTask(HashWheelTask task, int interval) {
        return this.addTask(task, task.getInterval(), false);
    }

    private boolean addTask(HashWheelTask task) {
        return this.addTask(task, task.getInterval(), task.isAsynchronous());
    }

    public boolean removeTask(HashWheelTask task) {
        return this.wheel.removeValue((Integer)task.getSlot(), task);
    }

    public void clear() {
        this.wheel.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Tick() {
        this.lock.lock();
        try {
            List tasks;
            if (this.currentSlot == this.size) {
                this.currentSlot = 0;
            }
            if ((tasks = (List)this.wheel.get(this.currentSlot)) != null) {
                ArrayList tmpList = new ArrayList();
                tmpList.addAll(tasks);
                for (HashWheelTask task : tmpList) {
                    if (task == null) {
                        tasks.remove(task);
                        continue;
                    }
                    if (!task.doTask()) continue;
                    this.removeTask(task);
                    if (task.isCancel()) continue;
                    this.addTask(task);
                }
            }
            ++this.currentSlot;
        }
        finally {
            this.lock.unlock();
        }
    }
}

