/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.compiler;

import java.net.URL;
import java.net.URLClassLoader;
import org.voovan.tools.compiler.sandbox.SandboxControler;
import org.voovan.tools.compiler.sandbox.SandboxSecurity;

public class DynamicClassLoader
extends URLClassLoader {
    private SandboxControler sandboxControler;
    private SandboxSecurity sandboxSecurity;

    public DynamicClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
        SandboxControler sandboxControler = new SandboxControler();
        sandboxControler.loadConfig();
        this.sandboxSecurity = new SandboxSecurity(sandboxControler);
        System.setSecurityManager(this.sandboxSecurity);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            this.sandboxSecurity.checkLoadClass(name);
            return super.loadClass(name, resolve);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public SandboxControler getSandboxControler() {
        return this.sandboxControler;
    }

    public void setSandboxControler(SandboxControler sandboxControler) {
        this.sandboxControler = sandboxControler;
    }

    public SandboxSecurity getSandboxSecurity() {
        return this.sandboxSecurity;
    }

    public void setSandboxSecurity(SandboxSecurity sandboxSecurity) {
        this.sandboxSecurity = sandboxSecurity;
    }
}

