/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.collection;

import java.io.Closeable;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.Options;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.Transaction;
import org.rocksdb.TransactionDB;
import org.rocksdb.TransactionDBOptions;
import org.rocksdb.TransactionLogIterator;
import org.rocksdb.TransactionOptions;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;
import org.voovan.tools.TByte;
import org.voovan.tools.TFile;
import org.voovan.tools.Varint;
import org.voovan.tools.exception.ParseException;
import org.voovan.tools.exception.RocksMapException;
import org.voovan.tools.log.Logger;
import org.voovan.tools.serialize.TSerialize;

public class RocksMap<K, V>
implements SortedMap<K, V>,
Closeable {
    private static byte[] DATA_BYTES;
    private static Map<String, RocksDB> ROCKSDB_MAP;
    private static Map<RocksDB, List<ColumnFamilyHandle>> CF_HANDLE_MAP;
    private static ColumnFamilyDescriptor DEFAULE_CF_DESCRIPTOR;
    private static String DEFAULT_DB_PATH;
    private static String DEFAULT_WAL_PATH;
    public DBOptions dbOptions;
    public ReadOptions readOptions;
    public WriteOptions writeOptions;
    public ColumnFamilyOptions columnFamilyOptions;
    private RocksDB rocksDB;
    private ColumnFamilyDescriptor dataColumnFamilyDescriptor;
    private ColumnFamilyHandle dataColumnFamilyHandle;
    private ThreadLocal<Transaction> threadLocalTransaction = new ThreadLocal();
    private String dbname;
    private String columnFamilyName;
    private Boolean readOnly;
    private int transactionLockTimeout = 5000;
    private int savePointCount = 0;
    public static ThreadLocal<WriteBatch> THREAD_LOCAL_WRITE_BATCH;

    public static String getDefaultDbPath() {
        return DEFAULT_DB_PATH;
    }

    public static void setDefaultDbPath(String defaultDbPath) {
        DEFAULT_DB_PATH = defaultDbPath.endsWith(File.separator) ? defaultDbPath : defaultDbPath + File.separator;
    }

    public static String getDefaultWalPath() {
        return DEFAULT_WAL_PATH;
    }

    public static void setDefaultWalPath(String defaultWalPath) {
        DEFAULT_WAL_PATH = defaultWalPath.endsWith(File.separator) ? defaultWalPath : defaultWalPath + File.separator;
    }

    private static ColumnFamilyHandle getColumnFamilyHandler(RocksDB rocksDB, String cfName) {
        try {
            for (ColumnFamilyHandle columnFamilyHandle : CF_HANDLE_MAP.get(rocksDB)) {
                if (!Arrays.equals(columnFamilyHandle.getName(), cfName.getBytes())) continue;
                return columnFamilyHandle;
            }
            return null;
        }
        catch (RocksDBException e) {
            throw new RocksMapException("getColumnFamilyHandler failed", e);
        }
    }

    public RocksMap() {
        this(null, null, null, null, null, null, null);
    }

    public RocksMap(String columnFamilyName) {
        this(null, columnFamilyName, null, null, null, null, null);
    }

    public RocksMap(String dbname, String columnFamilyName) {
        this(dbname, columnFamilyName, null, null, null, null, null);
    }

    public RocksMap(boolean readOnly) {
        this(null, null, null, null, null, null, readOnly);
    }

    public RocksMap(String columnFamilyName, boolean readOnly) {
        this(null, columnFamilyName, null, null, null, null, readOnly);
    }

    public RocksMap(String dbname, String columnFamilyName, boolean readOnly) {
        this(dbname, columnFamilyName, null, null, null, null, readOnly);
    }

    public RocksMap(String dbname, String columnFamilyName, ColumnFamilyOptions columnFamilyOptions, DBOptions dbOptions, ReadOptions readOptions, WriteOptions writeOptions, Boolean readOnly) {
        this.dbname = dbname == null ? "voovan_default" : dbname;
        this.columnFamilyName = columnFamilyName == null ? "voovan_default" : columnFamilyName;
        this.readOptions = readOptions == null ? new ReadOptions() : readOptions;
        this.writeOptions = writeOptions == null ? new WriteOptions() : writeOptions;
        this.columnFamilyOptions = columnFamilyOptions == null ? new ColumnFamilyOptions() : columnFamilyOptions;
        this.readOnly = readOnly == null ? false : readOnly;
        Options options = new Options();
        options.setCreateIfMissing(true);
        options.setCreateMissingColumnFamilies(true);
        this.dbOptions = dbOptions == null ? new DBOptions(options) : dbOptions;
        this.dbOptions.useDirectIoForFlushAndCompaction();
        this.dbOptions.setWalDir(DEFAULT_WAL_PATH + this.dbname);
        TFile.mkdir(DEFAULT_DB_PATH + this.dbname + "/");
        TFile.mkdir(this.dbOptions.walDir());
        this.rocksDB = ROCKSDB_MAP.get(this.dbname);
        try {
            if (this.rocksDB == null || this.readOnly.booleanValue()) {
                ArrayList<ColumnFamilyDescriptor> DEFAULT_CF_DESCRIPTOR_LIST = new ArrayList<ColumnFamilyDescriptor>();
                List columnFamilyNameBytes = RocksDB.listColumnFamilies((Options)new Options(), (String)(DEFAULT_DB_PATH + this.dbname + "/"));
                if (columnFamilyNameBytes.size() > 0) {
                    for (byte[] columnFamilyNameByte : columnFamilyNameBytes) {
                        ColumnFamilyDescriptor columnFamilyDescriptor = new ColumnFamilyDescriptor(columnFamilyNameByte, this.columnFamilyOptions);
                        if (Arrays.equals(this.columnFamilyName.getBytes(), columnFamilyNameByte)) {
                            this.dataColumnFamilyDescriptor = columnFamilyDescriptor;
                        }
                        DEFAULT_CF_DESCRIPTOR_LIST.add(columnFamilyDescriptor);
                    }
                }
                if (DEFAULT_CF_DESCRIPTOR_LIST.size() == 0) {
                    DEFAULT_CF_DESCRIPTOR_LIST.add(DEFAULE_CF_DESCRIPTOR);
                }
                ArrayList columnFamilyHandleList = new ArrayList();
                if (this.readOnly.booleanValue()) {
                    this.rocksDB = TransactionDB.openReadOnly((DBOptions)this.dbOptions, (String)(DEFAULT_DB_PATH + this.dbname + "/"), DEFAULT_CF_DESCRIPTOR_LIST, columnFamilyHandleList);
                } else {
                    this.rocksDB = TransactionDB.open((DBOptions)this.dbOptions, (TransactionDBOptions)new TransactionDBOptions(), (String)(DEFAULT_DB_PATH + this.dbname + "/"), DEFAULT_CF_DESCRIPTOR_LIST, columnFamilyHandleList);
                    ROCKSDB_MAP.put(this.dbname, this.rocksDB);
                }
                CF_HANDLE_MAP.put(this.rocksDB, columnFamilyHandleList);
            }
            this.choseColumnFamily(this.columnFamilyName);
        }
        catch (RocksDBException e) {
            throw new RocksMapException("RocksMap initilize failed", e);
        }
    }

    private RocksMap(RocksMap<K, V> rocksMap, String columnFamilyName, boolean useSameTransaction) {
        this.dbOptions = rocksMap.dbOptions;
        this.readOptions = rocksMap.readOptions;
        this.writeOptions = rocksMap.writeOptions;
        this.columnFamilyOptions = rocksMap.columnFamilyOptions;
        this.rocksDB = rocksMap.rocksDB;
        this.threadLocalTransaction = useSameTransaction ? rocksMap.threadLocalTransaction : ThreadLocal.withInitial(() -> this.createTransaction(-1L, false, false));
        this.dbname = rocksMap.dbname;
        this.columnFamilyName = columnFamilyName;
        this.readOnly = rocksMap.readOnly;
        this.transactionLockTimeout = rocksMap.transactionLockTimeout;
        this.savePointCount = rocksMap.savePointCount;
        this.choseColumnFamily(columnFamilyName);
    }

    public Long getLastSequence() {
        return this.rocksDB.getLatestSequenceNumber();
    }

    public List<LogRecord> getLogsSince(Long sequenceNumber, boolean withSerial) {
        return this.getLogsBetween(sequenceNumber, null, null, withSerial);
    }

    public List<LogRecord> getLogsSince(Long startSequence, BiFunction<Integer, Integer, Boolean> filter, boolean withSerial) {
        return this.getLogsBetween(startSequence, null, filter, withSerial);
    }

    public List<LogRecord> getLogsSince(Long startSequence, Long endSequence, boolean withSerial) {
        return this.getLogsBetween(startSequence, endSequence, null, withSerial);
    }

    public List<LogRecord> getLogsBetween(Long startSequence, Long endSequence, BiFunction<Integer, Integer, Boolean> filter, boolean withSerial) {
        try {
            TransactionLogIterator transactionLogIterator = this.rocksDB.getUpdatesSince(startSequence.longValue());
            ArrayList<LogRecord> logRecords = new ArrayList<LogRecord>();
            while (transactionLogIterator.isValid()) {
                TransactionLogIterator.BatchResult batchResult = transactionLogIterator.getBatch();
                if (endSequence != null && batchResult.sequenceNumber() > endSequence) break;
                List<LogRecord> logRecordBySeq = LogRecord.parse(ByteBuffer.wrap(batchResult.writeBatch().data()), filter, withSerial);
                logRecords.addAll(logRecordBySeq);
                transactionLogIterator.next();
            }
            transactionLogIterator.close();
            return logRecords;
        }
        catch (RocksDBException e) {
            throw new RocksMapException("getUpdatesSince failed", e);
        }
    }

    public RocksMap<K, V> share(String cfName) {
        return new RocksMap<K, V>(this, cfName, true);
    }

    public RocksDB getRocksDB() {
        return this.rocksDB;
    }

    public int getColumnFamilyId(String cfName) {
        ColumnFamilyHandle columnFamilyHandle = RocksMap.getColumnFamilyHandler(this.rocksDB, cfName);
        if (columnFamilyHandle != null) {
            return columnFamilyHandle.getID();
        }
        throw new RocksMapException("ColumnFamily [" + cfName + "] not found.");
    }

    public RocksMap<K, V> choseColumnFamily(String cfName) {
        try {
            this.dataColumnFamilyHandle = RocksMap.getColumnFamilyHandler(this.rocksDB, cfName);
            if (this.dataColumnFamilyHandle == null) {
                this.dataColumnFamilyDescriptor = new ColumnFamilyDescriptor(cfName.getBytes(), this.columnFamilyOptions);
                this.dataColumnFamilyHandle = this.rocksDB.createColumnFamily(this.dataColumnFamilyDescriptor);
                CF_HANDLE_MAP.get(this.rocksDB).add(this.dataColumnFamilyHandle);
            } else {
                this.dataColumnFamilyDescriptor = new ColumnFamilyDescriptor(this.dataColumnFamilyHandle.getName(), this.columnFamilyOptions);
            }
            this.columnFamilyName = cfName;
            return this;
        }
        catch (RocksDBException e) {
            throw new RocksMapException("RocksMap initilize failed", e);
        }
    }

    public int getTransactionLockTimeout() {
        return this.transactionLockTimeout;
    }

    public void setTransactionLockTimeout(int transactionLockTimeout) {
        this.transactionLockTimeout = transactionLockTimeout;
    }

    public boolean withTransaction(Function<RocksMap, Boolean> transFunction) {
        RocksMap<K, V> transactionRocksMap = new RocksMap<K, V>(this, this.columnFamilyName, false);
        try {
            transactionRocksMap.beginTransaction();
            if (transFunction.apply(transactionRocksMap).booleanValue()) {
                transactionRocksMap.commit();
                return true;
            }
            transactionRocksMap.rollback();
            return false;
        }
        catch (Exception e) {
            transactionRocksMap.rollback();
            throw new RocksMapException("withTransaction failed", e);
        }
    }

    public void beginTransaction() {
        this.beginTransaction(-1L, false, false);
    }

    public void beginTransaction(long expire, boolean deadlockDetect, boolean withSnapShot) {
        Transaction transaction = this.threadLocalTransaction.get();
        if (transaction == null) {
            transaction = this.createTransaction(expire, deadlockDetect, withSnapShot);
            this.threadLocalTransaction.set(transaction);
        } else {
            this.savePoint();
        }
    }

    private Transaction createTransaction(long expire, boolean deadlockDetect, boolean withSnapShot) {
        if (this.readOnly.booleanValue()) {
            throw new RocksMapException("RocksMap Not supported operation in read only mode");
        }
        TransactionOptions transactionOptions = new TransactionOptions();
        transactionOptions.setExpiration(expire);
        transactionOptions.setDeadlockDetect(deadlockDetect);
        transactionOptions.setSetSnapshot(withSnapShot);
        transactionOptions.setLockTimeout((long)this.transactionLockTimeout);
        return ((TransactionDB)this.rocksDB).beginTransaction(this.writeOptions, transactionOptions);
    }

    private Transaction getTransaction() {
        Transaction transaction = this.threadLocalTransaction.get();
        if (transaction == null) {
            throw new RocksMapException("RocksMap is not in transaction model");
        }
        return transaction;
    }

    private void savePoint() {
        Transaction transaction = this.getTransaction();
        try {
            transaction.setSavePoint();
            ++this.savePointCount;
        }
        catch (RocksDBException e) {
            throw new RocksMapException("commit failed", e);
        }
    }

    private void rollbackSavePoint() {
        Transaction transaction = this.getTransaction();
        try {
            transaction.rollbackToSavePoint();
            --this.savePointCount;
        }
        catch (RocksDBException e) {
            throw new RocksMapException("commit failed", e);
        }
    }

    public void commit() {
        Transaction transaction = this.getTransaction();
        this.commit(transaction);
        this.threadLocalTransaction.set(null);
    }

    private void commit(Transaction transaction) {
        try {
            if (transaction == null) {
                throw new RocksMapException("RocksMap is not in transaction model");
            }
            transaction.commit();
        }
        catch (RocksDBException e) {
            throw new RocksMapException("RocksMap commit failed", e);
        }
    }

    public void rollback() {
        Transaction transaction = this.getTransaction();
        if (this.savePointCount != 0) {
            this.rollbackSavePoint();
        } else {
            this.rollback(transaction);
            this.threadLocalTransaction.set(null);
        }
    }

    private void rollback(Transaction transaction) {
        try {
            if (transaction == null) {
                throw new RocksMapException("RocksMap is not in transaction model");
            }
            transaction.rollback();
        }
        catch (RocksDBException e) {
            throw new RocksMapException("RocksMap rollback failed", e);
        }
    }

    @Override
    public Comparator<? super K> comparator() {
        return null;
    }

    private RocksIterator getIterator() {
        Transaction transaction = this.threadLocalTransaction.get();
        if (transaction != null) {
            return transaction.getIterator(this.readOptions, this.dataColumnFamilyHandle);
        }
        return this.rocksDB.newIterator(this.dataColumnFamilyHandle, this.readOptions);
    }

    @Override
    public SortedMap<K, V> subMap(K fromKey, K toKey) {
        TreeMap<Object, Object> subMap = new TreeMap<Object, Object>();
        RocksIterator iterator = this.getIterator();
        byte[] fromKeyBytes = TSerialize.serialize(fromKey);
        byte[] toKeyBytes = TSerialize.serialize(toKey);
        if (fromKeyBytes == null) {
            iterator.seekToFirst();
        } else {
            iterator.seek(fromKeyBytes);
        }
        while (iterator.isValid()) {
            byte[] key = iterator.key();
            if (toKey != null && Arrays.equals(toKeyBytes, key)) break;
            subMap.put(TSerialize.unserialize(iterator.key()), TSerialize.unserialize(iterator.value()));
            iterator.next();
        }
        return subMap;
    }

    @Override
    public SortedMap<K, V> tailMap(K fromKey) {
        if (fromKey == null) {
            return null;
        }
        return this.subMap(fromKey, null);
    }

    @Override
    public SortedMap<K, V> headMap(K toKey) {
        if (toKey == null) {
            return null;
        }
        return this.subMap(null, toKey);
    }

    @Override
    public K firstKey() {
        RocksIterator iterator = this.getIterator();
        iterator.seekToFirst();
        if (iterator.isValid()) {
            return (K)TSerialize.unserialize(iterator.key());
        }
        return null;
    }

    @Override
    public K lastKey() {
        RocksIterator iterator = this.getIterator();
        iterator.seekToLast();
        if (iterator.isValid()) {
            return (K)TSerialize.unserialize(iterator.key());
        }
        return null;
    }

    @Override
    public int size() {
        int count = 0;
        RocksIterator iterator = null;
        Transaction transaction = this.threadLocalTransaction.get();
        iterator = transaction != null ? transaction.getIterator(this.readOptions, this.dataColumnFamilyHandle) : this.rocksDB.newIterator(this.dataColumnFamilyHandle, this.readOptions);
        iterator.seekToFirst();
        while (iterator.isValid()) {
            iterator.next();
            ++count;
        }
        return count;
    }

    @Override
    public boolean isEmpty() {
        try (RocksIterator iterator = this.getIterator();){
            iterator.seekToFirst();
            boolean bl = !iterator.isValid();
            return bl;
        }
    }

    @Override
    public boolean containsKey(Object key) {
        byte[] values = null;
        try {
            Transaction transaction = this.threadLocalTransaction.get();
            values = transaction != null ? transaction.get(this.dataColumnFamilyHandle, this.readOptions, TSerialize.serialize(key)) : this.rocksDB.get(this.dataColumnFamilyHandle, TSerialize.serialize(key));
        }
        catch (RocksDBException e) {
            throw new RocksMapException("RocksMap containsKey " + key + " failed", e);
        }
        return values != null;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    public V lock(Object key) {
        this.getTransaction();
        return this.getForUpdate(key, true);
    }

    public V getForUpdate(Object key, boolean exclusive) {
        Transaction transaction = this.getTransaction();
        try {
            byte[] values = transaction.getForUpdate(this.readOptions, this.dataColumnFamilyHandle, TSerialize.serialize(key), exclusive);
            return (V)(values == null ? null : TSerialize.unserialize(values));
        }
        catch (RocksDBException e) {
            throw new RocksMapException("RocksMap getForUpdate " + key + " failed", e);
        }
    }

    private byte[] get(byte[] keyBytes) {
        try {
            byte[] values = null;
            Transaction transaction = this.threadLocalTransaction.get();
            values = transaction != null ? transaction.get(this.dataColumnFamilyHandle, this.readOptions, keyBytes) : this.rocksDB.get(this.dataColumnFamilyHandle, this.readOptions, keyBytes);
            return values;
        }
        catch (RocksDBException e) {
            throw new RocksMapException("RocksMap get failed", e);
        }
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        byte[] values = this.get(TSerialize.serialize(key));
        return (V)(values == null ? null : TSerialize.unserialize(values));
    }

    @Override
    private void put(byte[] keyBytes, byte[] valueBytes) {
        try {
            Transaction transaction = this.threadLocalTransaction.get();
            if (transaction != null) {
                transaction.put(this.dataColumnFamilyHandle, keyBytes, valueBytes);
            } else {
                this.rocksDB.put(this.dataColumnFamilyHandle, keyBytes, valueBytes);
            }
        }
        catch (RocksDBException e) {
            throw new RocksMapException("RocksMap commit failed", e);
        }
    }

    @Override
    public Object put(Object key, Object value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        this.put(TSerialize.serialize(key), TSerialize.serialize(value));
        return value;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        byte[] keyBytes = TSerialize.serialize(key);
        byte[] valueBytes = TSerialize.serialize(value);
        Transaction innerTransaction = this.createTransaction(-1L, false, false);
        try {
            byte[] oldValueBytes = innerTransaction.getForUpdate(this.readOptions, this.dataColumnFamilyHandle, keyBytes, true);
            if (oldValueBytes == null) {
                innerTransaction.setSnapshotOnNextOperation();
                innerTransaction.put(this.dataColumnFamilyHandle, keyBytes, valueBytes);
                V v = null;
                return v;
            }
            Object object = TSerialize.unserialize(oldValueBytes);
            return (V)object;
        }
        catch (RocksDBException e) {
            this.rollback(innerTransaction);
            throw new RocksMapException("RocksMap putIfAbsent error", e);
        }
        finally {
            this.commit(innerTransaction);
        }
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        byte[] keyBytes = TSerialize.serialize(key);
        byte[] newValueBytes = TSerialize.serialize(newValue);
        byte[] oldValueBytes = TSerialize.serialize(oldValue);
        Transaction innerTransaction = this.createTransaction(-1L, false, false);
        try {
            byte[] oldDbValueBytes = innerTransaction.getForUpdate(this.readOptions, this.dataColumnFamilyHandle, keyBytes, true);
            if (oldDbValueBytes != null && Arrays.equals(oldDbValueBytes, oldValueBytes)) {
                innerTransaction.put(this.dataColumnFamilyHandle, keyBytes, newValueBytes);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (RocksDBException e) {
            this.rollback(innerTransaction);
            throw new RocksMapException("RocksMap replace error: ", e);
        }
        finally {
            this.commit(innerTransaction);
        }
    }

    public V remove(Object key, boolean isRetVal) {
        if (key == null) {
            throw new NullPointerException();
        }
        try {
            V value = null;
            if (isRetVal) {
                value = this.get(key);
            }
            if (!isRetVal || value != null) {
                Transaction transaction = this.threadLocalTransaction.get();
                if (transaction != null) {
                    transaction.delete(this.dataColumnFamilyHandle, TSerialize.serialize(key));
                } else {
                    this.rocksDB.delete(this.dataColumnFamilyHandle, TSerialize.serialize(key));
                }
            }
            return value;
        }
        catch (RocksDBException e) {
            throw new RocksMapException("RocksMap remove " + key + " failed", e);
        }
    }

    @Override
    public V remove(Object key) {
        return this.remove(key, true);
    }

    public void removeAll(K[] keys) {
        if (keys == null) {
            throw new NullPointerException();
        }
        WriteBatch writeBatch = THREAD_LOCAL_WRITE_BATCH.get();
        for (K key : keys) {
            if (key == null) continue;
            try {
                writeBatch.delete(this.dataColumnFamilyHandle, TSerialize.serialize(key));
            }
            catch (RocksDBException e) {
                throw new RocksMapException("RocksMap removeAll " + key + " failed", e);
            }
        }
        try {
            this.rocksDB.write(this.writeOptions, writeBatch);
        }
        catch (RocksDBException e) {
            throw new RocksMapException("RocksMap removeAll write failed", e);
        }
        writeBatch.clear();
    }

    public void removeRange(K fromKey, K toKey) {
        try {
            this.rocksDB.deleteRange(this.dataColumnFamilyHandle, this.writeOptions, TSerialize.serialize(fromKey), TSerialize.serialize(toKey));
        }
        catch (RocksDBException e) {
            throw new RocksMapException("RocksMap removeAll failed", e);
        }
    }

    @Override
    public void putAll(Map m) {
        try {
            WriteBatch writeBatch = THREAD_LOCAL_WRITE_BATCH.get();
            for (Map.Entry entry : m.entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                writeBatch.put(this.dataColumnFamilyHandle, TSerialize.serialize(key), TSerialize.serialize(value));
            }
            this.rocksDB.write(this.writeOptions, writeBatch);
            writeBatch.clear();
        }
        catch (RocksDBException e) {
            throw new RocksMapException("RocksMap putAll failed", e);
        }
    }

    public void flush() {
        try {
            this.rocksDB.compactRange(this.dataColumnFamilyHandle);
        }
        catch (RocksDBException e) {
            throw new RocksMapException("RocksMap flush failed", e);
        }
    }

    @Override
    public void clear() {
        if (this.readOnly.booleanValue()) {
            Logger.error("Clear failed, ", new RocksDBException("Not supported operation in read only mode"));
            return;
        }
        try {
            this.drop();
            this.dataColumnFamilyHandle = this.rocksDB.createColumnFamily(this.dataColumnFamilyDescriptor);
            CF_HANDLE_MAP.get(this.rocksDB).add(this.dataColumnFamilyHandle);
            this.dataColumnFamilyHandle = RocksMap.getColumnFamilyHandler(this.rocksDB, this.columnFamilyName);
        }
        catch (RocksDBException e) {
            throw new RocksMapException("RocksMap clear failed", e);
        }
    }

    public void drop() {
        try {
            this.rocksDB.dropColumnFamily(this.dataColumnFamilyHandle);
            CF_HANDLE_MAP.get(this.rocksDB).remove(this.dataColumnFamilyHandle);
        }
        catch (RocksDBException e) {
            throw new RocksMapException("RocksMap drop failed", e);
        }
    }

    @Override
    public Set keySet() {
        TreeSet<Object> keySet = new TreeSet<Object>();
        RocksIterator iterator = null;
        Transaction transaction = this.threadLocalTransaction.get();
        iterator = transaction != null ? transaction.getIterator(this.readOptions, this.dataColumnFamilyHandle) : this.rocksDB.newIterator(this.dataColumnFamilyHandle, this.readOptions);
        iterator.seekToFirst();
        while (iterator.isValid()) {
            Object k = TSerialize.unserialize(iterator.key());
            keySet.add(k);
            iterator.next();
        }
        return keySet;
    }

    @Override
    public Collection values() {
        ArrayList<Object> values = new ArrayList<Object>();
        RocksIterator iterator = null;
        Transaction transaction = this.threadLocalTransaction.get();
        iterator = transaction != null ? transaction.getIterator(this.readOptions, this.dataColumnFamilyHandle) : this.rocksDB.newIterator(this.dataColumnFamilyHandle, this.readOptions);
        iterator.seekToFirst();
        while (iterator.isValid()) {
            Object value = TSerialize.unserialize(iterator.value());
            values.add(value);
            iterator.next();
        }
        return values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        TreeMap<Object, Object> entryMap = new TreeMap<Object, Object>();
        RocksIterator iterator = this.getIterator();
        iterator.seekToFirst();
        while (iterator.isValid()) {
            entryMap.put(TSerialize.unserialize(iterator.key()), TSerialize.unserialize(iterator.value()));
            iterator.next();
        }
        return entryMap.entrySet();
    }

    public Map<K, V> startWith(K key) {
        byte[] iteratorkeyBytes;
        byte[] keyBytes = TSerialize.serialize(key);
        TreeMap<Object, Object> entryMap = new TreeMap<Object, Object>();
        RocksIterator iterator = this.getIterator();
        iterator.seek(keyBytes);
        while (iterator.isValid() && TByte.byteArrayStartWith(iteratorkeyBytes = iterator.key(), keyBytes)) {
            entryMap.put(TSerialize.unserialize(iteratorkeyBytes), TSerialize.unserialize(iterator.value()));
            iterator.next();
        }
        return entryMap;
    }

    @Override
    public void close() {
        Transaction transaction = this.threadLocalTransaction.get();
        if (transaction != null) {
            try {
                transaction.rollback();
            }
            catch (RocksDBException e) {
                throw new RocksMapException("RocksMap rollback on close failed", e);
            }
        }
        this.dataColumnFamilyHandle.close();
    }

    public RocksMapIterator iterator(K fromKey, K toKey, int size) {
        return new RocksMapIterator(this, fromKey, toKey, size);
    }

    public RocksMapIterator iterator(K fromKey, K toKey) {
        return new RocksMapIterator(this, fromKey, toKey, 0);
    }

    public RocksMapIterator iterator(int size) {
        return new RocksMapIterator(this, null, null, size);
    }

    public RocksMapIterator iterator() {
        return new RocksMapIterator(this, null, null, 0);
    }

    static {
        RocksDB.loadLibrary();
        DATA_BYTES = "data".getBytes();
        ROCKSDB_MAP = new ConcurrentHashMap<String, RocksDB>();
        CF_HANDLE_MAP = new ConcurrentHashMap<RocksDB, List<ColumnFamilyHandle>>();
        DEFAULE_CF_DESCRIPTOR = new ColumnFamilyDescriptor(RocksDB.DEFAULT_COLUMN_FAMILY);
        DEFAULT_DB_PATH = ".rocksdb" + File.separator;
        DEFAULT_WAL_PATH = DEFAULT_DB_PATH + ".wal" + File.separator;
        THREAD_LOCAL_WRITE_BATCH = ThreadLocal.withInitial(() -> new WriteBatch());
    }

    public static class LogRecord {
        public static int TYPE_DELETION = 0;
        public static int TYPE_VALUE = 1;
        public static int TYPE_MERGE = 2;
        public static int TYPE_LOGDATA = 3;
        public static int TYPE_COLUMNFAMILY_DELETION = 4;
        public static int TYPE_COLUMNFAMILY_VALUE = 5;
        public static int TYPE_COLUMNFAMILY_MERGE = 6;
        public static int TYPE_SINGLE_DELETION = 7;
        public static int TYPE_COLUMNFAMILY_SINGLE_DELETION = 8;
        public static int TYPE_BEGIN_PREPARE_XID = 9;
        public static int TYPE_END_PREPARE_XID = 10;
        public static int TYPE_COMMIT_XID = 11;
        public static int TYPE_ROLLBACK_XID = 12;
        public static int TYPE_NOOP = 13;
        public static int TYPE_COLUMNFAMILY_RANGE_DELETION = 14;
        public static int TYPE_RANGE_DELETION = 15;
        public static int TYPE_COLUMNFAMILY_BLOB_INDEX = 16;
        public static int TYPE_BLOB_INDEX = 17;
        public static int TYPE_BEGIN_PERSISTED_PREPARE_XID = 18;
        public static int TYPE_BEGIN_UNPREPARE_XID = 19;
        public static int[] TYPE_ELEMENT_COUNT = new int[]{1, 2, 2, 0, 1, 2, 2, 1, 1, 1, 0, 1, 1, 0, 2, 0, 0, 2, 1, 1};
        private long sequence;
        private int type;
        private int columnFamilyId = 0;
        private ArrayList<Object> chunks;

        private LogRecord(long sequence, int type, int columnFamilyId) {
            this.sequence = sequence;
            this.type = type;
            this.columnFamilyId = columnFamilyId;
            this.chunks = new ArrayList();
        }

        public long getSequence() {
            return this.sequence;
        }

        private void setSequence(long sequence) {
            this.sequence = sequence;
        }

        public int getType() {
            return this.type;
        }

        private void setType(int type) {
            this.type = type;
        }

        public int getColumnFamilyId() {
            return this.columnFamilyId;
        }

        private void setColumnFamilyId(int columnFamilyId) {
            this.columnFamilyId = columnFamilyId;
        }

        public ArrayList<Object> getChunks() {
            return this.chunks;
        }

        public static List<LogRecord> parse(ByteBuffer byteBuffer, boolean withSerial) {
            return LogRecord.parse(byteBuffer, null, withSerial);
        }

        public static List<LogRecord> parse(ByteBuffer byteBuffer, BiFunction<Integer, Integer, Boolean> filter, boolean withSerial) {
            ByteOrder originByteOrder = byteBuffer.order();
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            if (byteBuffer.remaining() < 13) {
                throw new ParseException("not a correct recorder");
            }
            Long sequence = byteBuffer.getLong();
            int recordCount = byteBuffer.getInt();
            ArrayList<LogRecord> logRecords = new ArrayList<LogRecord>();
            int count = 0;
            while (byteBuffer.hasRemaining()) {
                LogRecord logRecord = LogRecord.parseOperation(byteBuffer, sequence, filter, withSerial);
                if (logRecord != null) {
                    logRecords.add(logRecord);
                }
                ++count;
            }
            byteBuffer.order(originByteOrder);
            return logRecords;
        }

        public static LogRecord parseOperation(ByteBuffer byteBuffer, long sequence, boolean withSerial) {
            return LogRecord.parseOperation(byteBuffer, sequence, withSerial);
        }

        public static LogRecord parseOperation(ByteBuffer byteBuffer, long sequence, BiFunction<Integer, Integer, Boolean> filter, boolean withSerial) {
            byte type = byteBuffer.get();
            if (type == TYPE_NOOP) {
                if (byteBuffer.hasRemaining()) {
                    type = byteBuffer.get();
                } else {
                    return null;
                }
            }
            byte columnFamilyId = 0;
            if (type == TYPE_COLUMNFAMILY_DELETION || type == TYPE_COLUMNFAMILY_VALUE || type == TYPE_COLUMNFAMILY_MERGE || type == TYPE_COLUMNFAMILY_SINGLE_DELETION) {
                columnFamilyId = byteBuffer.get();
            }
            LogRecord logRecord = null;
            if (type < TYPE_ELEMENT_COUNT.length) {
                boolean isEnable;
                boolean bl = isEnable = filter == null || filter.apply(Integer.valueOf(columnFamilyId), Integer.valueOf(type)) != false;
                if (isEnable) {
                    logRecord = new LogRecord(sequence, type, columnFamilyId);
                }
                for (int i = 0; i < TYPE_ELEMENT_COUNT[type] && byteBuffer.hasRemaining(); ++i) {
                    int chunkSize = Varint.varintToInt(byteBuffer);
                    if (isEnable) {
                        byte[] chunkBytes = new byte[chunkSize];
                        byteBuffer.get(chunkBytes);
                        Object chunk = chunkBytes;
                        chunk = withSerial ? (Object)TSerialize.unserialize(chunkBytes) : chunkBytes;
                        logRecord.getChunks().add(chunk);
                        continue;
                    }
                    byteBuffer.position(byteBuffer.position() + chunkSize);
                }
            }
            return logRecord;
        }
    }

    public class RocksMapIterator<Entry>
    implements Iterator<Entry> {
        private RocksMap rocksMap;
        private RocksIterator iterator;
        private byte[] fromKeyBytes;
        private byte[] toKeyBytes;
        private int size;
        private int count = 0;

        protected RocksMapIterator(RocksMap rocksMap, K fromKey, K toKey, int size) {
            this.rocksMap = rocksMap;
            this.iterator = rocksMap.getIterator();
            this.fromKeyBytes = TSerialize.serialize(fromKey);
            this.toKeyBytes = TSerialize.serialize(toKey);
            this.size = size;
            if (this.fromKeyBytes == null) {
                this.iterator.seekToFirst();
            } else {
                this.iterator.seek(this.fromKeyBytes);
            }
        }

        @Override
        public boolean hasNext() {
            try {
                if (this.toKeyBytes == null) {
                    boolean bl = this.iterator.isValid();
                    return bl;
                }
                boolean bl = !TByte.byteArrayStartWith(this.iterator.key(), this.toKeyBytes);
                return bl;
            }
            finally {
                if (this.size != 0 && this.count > this.size - 1) {
                    return false;
                }
            }
        }

        public K key() {
            return TSerialize.unserialize(this.iterator.key());
        }

        public V value() {
            return TSerialize.unserialize(this.iterator.value());
        }

        public void directNext() {
            this.iterator.next();
            if (this.hasNext()) {
                Object key = TSerialize.unserialize(this.iterator.key());
                Object value = TSerialize.unserialize(this.iterator.value());
                ++this.count;
            }
        }

        @Override
        public Entry next() {
            this.iterator.next();
            if (this.hasNext()) {
                Object key = TSerialize.unserialize(this.iterator.key());
                Object value = TSerialize.unserialize(this.iterator.value());
                ++this.count;
                return (Entry)new RocksMapEntry<Object, Object>(key, value);
            }
            return null;
        }

        @Override
        public void remove() {
            try {
                this.rocksMap.rocksDB.delete(this.rocksMap.dataColumnFamilyHandle, this.iterator.key());
            }
            catch (RocksDBException e) {
                throw new RocksMapException("RocksMapIterator remove failed", e);
            }
        }

        @Override
        public void forEachRemaining(Consumer<? super Entry> action) {
            throw new UnsupportedOperationException();
        }
    }

    public class RocksMapEntry<K, V>
    implements Map.Entry<K, V> {
        private K k;
        private V v;

        protected RocksMapEntry(K k, V v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public K getKey() {
            return this.k;
        }

        @Override
        public V getValue() {
            return this.v;
        }

        @Override
        public V setValue(V value) {
            return this.v;
        }
    }
}

