/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.collection;

import java.nio.BufferOverflowException;

public class RingBuffer<T> {
    public static final int DEFAULT_SIZE = 128;
    public Object[] elements;
    private volatile int readPositon = 0;
    private volatile int writePositon = 0;
    private volatile int capacity;

    public RingBuffer() {
        this(128);
    }

    public RingBuffer(int capacity) {
        this.elements = new Object[capacity - 1];
        this.capacity = capacity - 1;
    }

    public int getReadPositon() {
        return this.readPositon;
    }

    public int getWritePositon() {
        return this.writePositon;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void skip(int offset) {
        if (this.remaining() < offset || offset < 0) {
            throw new BufferOverflowException();
        }
        this.readPositon = (this.readPositon + offset) % this.capacity;
    }

    private Boolean isEmpty() {
        return this.readPositon == this.writePositon;
    }

    private Boolean isFull() {
        return (this.writePositon + 1) % this.capacity == this.readPositon;
    }

    public void clear() {
        this.readPositon = 0;
        this.writePositon = 0;
    }

    public T get(int offset) {
        if (offset < this.remaining()) {
            int realOffset = (this.readPositon + offset) % this.capacity;
            return (T)this.elements[realOffset];
        }
        throw new IndexOutOfBoundsException();
    }

    public int get(T[] t, int offset, int length) {
        if (length > this.remaining()) {
            length = this.remaining();
        }
        for (int i = offset; i < offset + length; ++i) {
            t[i] = this.get(i);
        }
        return length;
    }

    public Object[] toArray() {
        return this.elements;
    }

    public T pop() {
        if (this.isEmpty().booleanValue()) {
            return null;
        }
        Object t = this.elements[this.readPositon];
        this.readPositon = (this.readPositon + 1) % this.capacity;
        return (T)t;
    }

    public boolean push(T t) {
        if (this.isFull().booleanValue()) {
            return false;
        }
        this.elements[this.writePositon] = t;
        this.writePositon = (this.writePositon + 1) % this.capacity;
        return true;
    }

    public int push(T[] ts, int offset, int length) {
        if (length > this.avaliable()) {
            return 0;
        }
        for (int i = 0; i < length; ++i) {
            if (!this.push(ts[offset + i])) continue;
            length = i;
            break;
        }
        return length;
    }

    public int remaining() {
        if (this.writePositon == this.readPositon) {
            return 0;
        }
        if (this.writePositon < this.readPositon) {
            return this.capacity - this.readPositon + this.writePositon;
        }
        return this.writePositon - this.readPositon;
    }

    public int avaliable() {
        return this.capacity - this.remaining() - 1;
    }

    public int pop(T[] ts, int offset, int length) {
        if (length > this.remaining()) {
            length = this.remaining();
        }
        for (int i = offset; i < offset + length; ++i) {
            ts[i] = this.pop();
        }
        return length;
    }

    public String toString() {
        return "readPositon=" + this.readPositon + ", writePositon=" + this.writePositon + ", capacity=" + this.capacity + ", remaining=" + this.remaining() + ", avaliable=" + this.avaliable();
    }
}

